package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectBriefPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectBriefQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectBriefService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectBriefVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 项目汇报管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Api(tags = "项目汇报管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectBrief")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.PMS_PROJECT_BRIEF)
public class PmsProjectBriefController {

    private final PmsProjectBriefService pmsProjectBriefService;

    /**
     * 项目汇报管理-获取项目汇报的信息
     *
     * @param projectId 项目主键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryBriefInfo")
    @UdcNameClass
    @ApiOperation("项目汇报管理-获取项目汇报的信息")
    public TwOutputUtil<PmsProjectBriefVO> queryBriefInfo(Long projectId) {
        return TwOutputUtil.ok(pmsProjectBriefService.queryBriefInfo(projectId));
    }

    /**
     * 项目汇报管理-手动汇报 新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目汇报管理-新增或修改")
    public TwOutputUtil<PmsProjectBriefVO> insertOrUpdate(@RequestBody PmsProjectBriefPayload payload) {
        return TwOutputUtil.ok(pmsProjectBriefService.insertOrUpdate(payload));
    }


    /**
     * 项目汇报管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/byKey/{key}")
    @UdcNameClass
    @ApiOperation("项目汇报管理-主键查询")
    public TwOutputUtil<PmsProjectBriefVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectBriefService.queryByKey(key));
    }

    // /**
    //  * 项目汇报管理-分页
    //  * TODO 后续权限测试没问题，删除此接口
    //  *
    //  * @param query 查询
    //  * @return {@link TwOutputUtil}
    //  */
    // @GetMapping("/paging")
    // @UdcNameClass
    // @ApiOperation("项目汇报管理-分页")
    // public TwOutputUtil<PagingVO<PmsProjectBriefVO>> paging(PmsProjectBriefQuery query) {
    //     return TwOutputUtil.ok(pmsProjectBriefService.queryPaging(query));
    // }

    /**
     * （权限内）项目汇报管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}<{@link PagingVO}<{@link PmsProjectBriefVO}>>
     */
    // @GetMapping("/pagingPermission")
    @PostMapping("/paging")
    @UdcNameClass
    @ApiOperation("（权限内）项目汇报管理-分页")
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.PMS_PROJECT_BRIEF_PAGE, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<PmsProjectBriefVO>> pagingPermission(@RequestBody PmsProjectBriefQuery query) {
        return TwOutputUtil.ok(pmsProjectBriefService.queryPagingPermission(query));
    }

    /**
     * 项目汇报管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("项目汇报管理-查询列表")
    public TwOutputUtil<List<PmsProjectBriefVO>> queryList(PmsProjectBriefQuery query) {
        return TwOutputUtil.ok(pmsProjectBriefService.queryListDynamic(query));
    }

    /**
     * 项目汇报管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目汇报管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectBriefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @PostMapping("/batchExport")
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.PMS_PROJECT_BRIEF_PAGE, type = FunctionTypeEnum.BUTTON)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public void batchExport(HttpServletResponse response, @RequestBody PmsProjectBriefQuery query) {
        pmsProjectBriefService.downloadBatch(response, query);
    }
}

