package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 项目模板活动
 *
 * @author xxb
 * @date 2023-08-03
 */
@Entity
@Table(name = "pms_project_template_act", indexes = {
        @Index(name = "template_index", columnList = "template_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_template_act", comment = "项目模板活动")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectTemplateActDO extends BaseModel implements Serializable  {
    /** 模板Id */
    @Comment("模板Id")
    @Column(name = "template_id")
    private Long templateId;
    /** 活动编号 */
    @Comment("活动编号")
    @Column()
    private String actCode;
    /** 活动名称 */
    @Comment("活动名称")
    @Column()
    private String actName;
    /** 规划天数 */
    @Comment("规划天数")
    @Column()
    private BigDecimal plannedDays;
    /** 规划当量 */
    @Comment("规划当量")
    @Column()
    private BigDecimal planningEquivalent;
    /** 里程碑标记 1是 0不是 */
    @Comment("里程碑标记 1是 0不是")
    @Column()
    private Integer milestoneFlag;
    /** 阶段标记 1是 0不是 */
    @Comment("阶段标记 1是 0不是")
    @Column()
    private Integer actStageFlag;

    /** 序号 */
    @Comment("序号")
    @Column()
    private Integer sortNo;

    public void copy(PmsProjectTemplateActDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
