package com.elitesland.tw.tw5.server.prd.pms.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectActivityQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateActService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityProcessVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateActVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectActivityConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectActivityDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectActivityProcessDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectActivityDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectActivityProcessRepo;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectActivityRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 项目活动
 *
 * @author xxb
 * @date 2023-08-17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectActivityServiceImpl extends BaseServiceImpl implements PmsProjectActivityService {

    private final PmsProjectActivityRepo pmsProjectActivityRepo;
    private final PmsProjectActivityDAO pmsProjectActivityDAO;

    private final ConReceivablePlanService conReceivablePlanService;

    private final PmsProjectActivityProcessDAO pmsProjectActivityProcessDAO;

    private final PmsProjectDAO pmsProjectDAO;

    private final WorkflowUtil workflowUtil;

    private final PmsProjectActivityProcessRepo pmsProjectActivityProcessRepo;
    private final PrdSystemRoleService roleService;

    private final PmsProjectTemplateActService pmsProjectTemplateActService;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;

    private static String sheetName = "活动管理导入模板";

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<PmsProjectActivityVO> queryListDynamic(PmsProjectActivityQuery query) {
        Long projId = query.getProjId();
        if (ObjectUtils.isEmpty(projId)) {
            throw TwException.error("", "项目ID不能为空 !");
        }
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(projId);
        if (ObjectUtils.isEmpty(pmsProjectVO)) {
            throw TwException.error("", "项目不存在 !");
        }
        //初始化活动标记
        Boolean initActivity = true;
        List<PmsProjectActivityVO> activityVOS = pmsProjectActivityDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(activityVOS)) {
            if (query.getInitFlag() != null && query.getInitFlag() == 1) {
                //TODO 需校验是否可以初始化
                pmsProjectActivityDAO.deleteSoftByProjectId(projId);
            } else {
                initActivity = false;
                addPlanData(pmsProjectVO, activityVOS);
            }
        }
        if (initActivity) {
            //需要初始化数据
            List<PmsProjectTemplateActVO> actVOS = pmsProjectTemplateActService.queryByTemplateId(pmsProjectVO.getProjTempId());
            //阶段活动
            List<PmsProjectTemplateActVO> collect = actVOS.stream().filter(vo -> vo.getActStageFlag() != null && vo.getActStageFlag().intValue() == 1).collect(Collectors.toList());
            List<PmsProjectActivityDO> activityDOS = new ArrayList<>();
            actVOS.forEach(actVO -> {
                PmsProjectActivityDO pmsProjectActivityDO = new PmsProjectActivityDO();
                pmsProjectActivityDO.setProjId(projId);
                pmsProjectActivityDO.setActNo(actVO.getActCode());
                pmsProjectActivityDO.setActName(actVO.getActName());
                pmsProjectActivityDO.setMilestoneFlag(actVO.getMilestoneFlag());
                pmsProjectActivityDO.setPhaseFlag(actVO.getActStageFlag());
                pmsProjectActivityDO.setFromtmplFlag(1);
                pmsProjectActivityDO.setSortNo(actVO.getSortNo());
                pmsProjectActivityDO.setWorkbenchFlag(1);
                pmsProjectActivityDO.setRemark(actVO.getRemark());
                if (actVO.getActStageFlag() == null || actVO.getActStageFlag().intValue() == 0) {
                    //活动赋值上级id
                    Optional<PmsProjectTemplateActVO> first = collect.stream().filter(vo -> actVO.getActCode().startsWith(vo.getActCode())).findFirst();
                    if (first.isPresent()) {
                        pmsProjectActivityDO.setParentNo(first.get().getActCode());
                    } else {
                        throw TwException.error("", "该项目模板中对应的活动编号【" + actVO.getActCode() + "】，不存在对应的阶段，请检查项目模板配置");
                    }
                }
                activityDOS.add(pmsProjectActivityDO);
            });
            if (activityDOS.size() > 0) {
                List<PmsProjectActivityDO> pmsProjectActivityDOS = pmsProjectActivityDAO.saveAll(activityDOS);
                activityVOS = PmsProjectActivityConvert.INSTANCE.toVoList(pmsProjectActivityDOS);
                //开启事务执行修改
                transactionUtilService.executeWithRunnable(() -> {
                    List<PmsProjectActivityDO> newDOS = new ArrayList<>();
                    pmsProjectActivityDOS.forEach(activityDO -> {
                        if (activityDO.getPhaseFlag() == null || activityDO.getPhaseFlag().intValue() == 0) {
                            //只有活动需要赋值父阶段id
                            PmsProjectActivityDO pmsProjectActivityDO = pmsProjectActivityDOS.stream().filter(phaseDO -> phaseDO.getActNo().equals(activityDO.getParentNo())).findFirst().get();
                            activityDO.setParentId(pmsProjectActivityDO.getId());
                            newDOS.add(activityDO);
                        }
                    });
                    if (newDOS.size() > 0) {
                        //更新上级id操作
                        pmsProjectActivityDAO.saveAll(newDOS);
                    }
                });
            }
        }

        return activityVOS;
    }

    /**
     * 添加收款计划相关信息
     *
     * @param pmsProjectVO
     * @param activityVOS
     */
    void addPlanData(PmsProjectVO pmsProjectVO, List<PmsProjectActivityVO> activityVOS) {
        if (!ObjectUtils.isEmpty(pmsProjectVO.getContractId())) {
            List<ConReceivablePlanVO> planVOList = conReceivablePlanService.queryBySaleConId(pmsProjectVO.getContractId());
            if (!ObjectUtils.isEmpty(planVOList)) {
                // 作废的收款阶段不需要关联阶段活动
                planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty(v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
            }
            if (!ObjectUtils.isEmpty(planVOList)) {
                Map<Long, ConReceivablePlanVO> planInfo = planVOList.stream().collect(Collectors.toMap(ConReceivablePlanVO::getId, Function.identity()));
                activityVOS.forEach(v -> {
                    if (!ObjectUtils.isEmpty(v.getReceivePlanId())) {
                        ConReceivablePlanVO planVO = planInfo.get(v.getReceivePlanId());
                        if (!ObjectUtils.isEmpty(planVO)) {
                            v.setReceivePlanDesc(planVO.getReceStage());
                            v.setReceRatio(planVO.getReceRatio());
                            v.setReceAmt(planVO.getReceAmt());
                            v.setReceStatus(planVO.getReceStatus());
                            v.setExpectReceDate(planVO.getExpectReceDate());
                            // 判断收款的预计收款日期在不在阶段的起止日期内
                            if (v.getExpectReceDate() != null && v.getExpectReceDate().isAfter(v.getStartDate()) && v.getExpectReceDate().isBefore(v.getEndDate())) {
                                v.setExpectReceDateFlag(1);
                            } else {
                                v.setExpectReceDateFlag(0);
                            }
                        }
                    }
                });
            }
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectActivityVO insertOrUpdate(PmsProjectActivityPayload payload) {
        // 数据验证
        checkData(payload);
        if (ObjectUtils.isEmpty(payload.getFromtmplFlag())) {
            payload.setFromtmplFlag(0);
        }
        if (ObjectUtils.isEmpty(payload.getWorkbenchFlag())) {
            payload.setWorkbenchFlag(1);
        }
        PmsProjectActivityDO entityDo = PmsProjectActivityConvert.INSTANCE.toDo(payload);
        return PmsProjectActivityConvert.INSTANCE.toVo(pmsProjectActivityRepo.save(entityDo));
    }

    /**
     * 验证数据
     *
     * @param payload
     */
    private void checkData(PmsProjectActivityPayload payload) {
        if (ObjectUtils.isEmpty(payload.getProjId())) {
            throw TwException.error("", "项目id不能为空 !");
        }
        if (ObjectUtils.isEmpty(payload.getActNo()) || ObjectUtils.isEmpty(payload.getActName())) {
            throw TwException.error("", "活动编号和名称不能为空 !");
        }
        if (!ObjectUtils.isEmpty(payload.getPhaseFlag()) && 1 == payload.getPhaseFlag().intValue()) {
            if (ObjectUtils.isEmpty(payload.getStartDate()) || ObjectUtils.isEmpty(payload.getEndDate())) {
                throw TwException.error("", "阶段活动的起止日期不能为空 !");
            }
        }
        if (!ObjectUtils.isEmpty(payload.getStartDate()) && !ObjectUtils.isEmpty(payload.getEndDate())) {
            if (payload.getStartDate().isAfter(payload.getEndDate())) {
                throw TwException.error("", "开始日期不能晚于结束日期 !");
            }
        }
        List<PmsProjectActivityVO> list = pmsProjectActivityDAO.queryByProjId(payload.getProjId());
        Optional<PmsProjectActivityVO> first = list.stream().filter(vo -> vo.getActNo().equals(payload.getActNo())).findFirst();
        if (first.isPresent()) {
            if (ObjectUtils.isEmpty(payload.getId())) {
                throw TwException.error("", "项目活动编号不可重复 !");
            }
            if (first.get().getId().longValue() != payload.getId().longValue()) {
                throw TwException.error("", "项目活动编号不可重复 !");
            }
        }
        if (payload.getPhaseFlag() == null || payload.getPhaseFlag().intValue() == 0) {
            //只有活动需要赋值父阶段id
            Optional<PmsProjectActivityVO> first0 = list.stream().filter(vo -> payload.getActNo().startsWith(vo.getActNo())).findFirst();
            if (first.isPresent()) {
                payload.setParentNo(first0.get().getActNo());
                payload.setParentId(first0.get().getId());
            } else {
                throw TwException.error("", "该活动编号【" + payload.getActNo() + "】，不存在对应的阶段");
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            // 拨付中和拨付成功的阶段活动，在活动管理中是不可删除的
            List<PmsProjectActivityVO> activityVOS = pmsProjectActivityDAO.queryByKeys(keys);
            List<PmsProjectActivityVO> collect = activityVOS.stream().filter(vo -> vo.getPhaseFlag() != null && vo.getPhaseFlag().intValue() == 1
                    && vo.getPlanEqva() != null && vo.getPlanEqva().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(collect)) {
                throw TwException.error("", "该阶段已做预算，不可删除");
            }
            pmsProjectActivityDAO.deleteSoft(keys);
        }
    }

    @Override
    public String getActivityStatus(Long projId) {
        PmsProjectActivityQuery query = new PmsProjectActivityQuery();
        query.setProjId(projId);
        long count = pmsProjectActivityDAO.count(query);
        if (count > 0) {
            return "APPROVED";
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void importFile(MultipartFile file, Long projId) {
        if (file == null) {
            throw TwException.error("", "上传文件异常");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            throw TwException.error("", "表结构错误");
        }
        List<PmsProjectActivityVO> fromDb = pmsProjectActivityDAO.queryByProjId(projId);
        int dataStartRow = 2;
        List<PmsProjectActivityDO> activityDOS = new ArrayList<>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);

            String actNo = ExcelUtil.getCellFormatValue(row.getCell(0));
            String actName = ExcelUtil.getCellFormatValue(row.getCell(1));
            if (!StringUtils.hasText(actNo) || !StringUtils.hasText(actName)) {
                break;
            }
            PmsProjectActivityDO pmsProjectActivityDO = new PmsProjectActivityDO();
            Optional<PmsProjectActivityVO> first = fromDb.stream().filter(db -> db.getActNo().equals(actNo)).findFirst();
            if (first.isPresent()) {
                //如果系统已存在该编号数据，直接更新
                pmsProjectActivityDO.setId(first.get().getId());
            }
            pmsProjectActivityDO.setProjId(projId);
            pmsProjectActivityDO.setFromtmplFlag(0);
            pmsProjectActivityDO.setWorkbenchFlag(1);
            pmsProjectActivityDO.setActNo(actNo);
            pmsProjectActivityDO.setActName(actName);
            String typeDesc = ExcelUtil.getCellFormatValue(row.getCell(2));
            if ("里程碑".equals(typeDesc)) {
                pmsProjectActivityDO.setMilestoneFlag(1);
            }
            if ("阶段".equals(typeDesc)) {
                pmsProjectActivityDO.setPhaseFlag(1);
            }
            Date startDate = row.getCell(3).getDateCellValue();
            if (startDate != null) {
                pmsProjectActivityDO.setStartDate(startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            Date endDate = row.getCell(4).getDateCellValue();
            if (endDate != null) {
                pmsProjectActivityDO.setEndDate(endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            pmsProjectActivityDO.setRemark(ExcelUtil.getCellFormatValue(row.getCell(5)));

            activityDOS.add(pmsProjectActivityDO);
        }
        if (!ObjectUtils.isEmpty(activityDOS)) {
            //需要更新的数据
            List<PmsProjectActivityDO> updateDOS = new ArrayList<>();
            //阶段活动
            List<PmsProjectActivityDO> collect = activityDOS.stream().filter(vo -> vo.getPhaseFlag() != null && vo.getPhaseFlag().intValue() == 1).collect(Collectors.toList());
            activityDOS.forEach(activityDO -> {
                //处理活动的上级阶段
                if (activityDO.getPhaseFlag() == null || activityDO.getPhaseFlag().intValue() == 0) {
                    //活动赋值上级id
                    Optional<PmsProjectActivityDO> first = collect.stream().filter(vo -> activityDO.getActNo().startsWith(vo.getActNo())).findFirst();
                    if (first.isPresent()) {
                        PmsProjectActivityDO pmsProjectActivityDO = first.get();
                        activityDO.setParentNo(pmsProjectActivityDO.getActNo());
                        if (pmsProjectActivityDO.getId() != null) {
                            activityDO.setParentId(pmsProjectActivityDO.getId());
                        } else {
                            updateDOS.add(activityDO);
                        }
                    } else {
                        Optional<PmsProjectActivityVO> first1 = fromDb.stream().filter(vo ->
                                vo.getPhaseFlag() != null && vo.getPhaseFlag().intValue() == 1 &&
                                        activityDO.getActNo().startsWith(vo.getActNo())
                        ).findFirst();
                        if (first1.isPresent()) {
                            activityDO.setParentNo(first1.get().getActNo());
                            activityDO.setParentId(first1.get().getId());
                        } else {
                            throw TwException.error("", "该活动编号【" + activityDO.getActNo() + "】，不存在对应的阶段");
                        }
                    }
                }
            });
            List<PmsProjectActivityDO> pmsProjectActivityDOS = pmsProjectActivityDAO.saveAll(activityDOS);
            if (updateDOS.size() > 0) {
                //开启事务执行修改
                transactionUtilService.executeWithRunnable(() -> {
                    updateDOS.forEach(activityDO -> {
                        PmsProjectActivityDO pmsProjectActivityDO = pmsProjectActivityDOS.stream().filter(phaseDO -> phaseDO.getActNo().equals(activityDO.getParentNo())).findFirst().get();
                        activityDO.setParentId(pmsProjectActivityDO.getId());
                    });
                    //更新上级id操作
                    pmsProjectActivityDAO.saveAll(updateDOS);
                });
            }
        }
    }


    @Override
    public void downloadFile(HttpServletResponse response) {
        ClassPathResource classPathResource = new ClassPathResource("template/pmsProjActivityTemplate.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            String fileName = "活动管理导入模板-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //////////////////////////////////////////////////////////////////////////////////////
    @Override
    public PagingVO<PmsProjectActivityVO> queryPaging(PmsProjectActivityQuery query) {
        if (ObjectUtils.isEmpty(query.getProjId())) {
            throw TwException.error("", "项目ID不能为空 !");
        }
        return pmsProjectActivityDAO.queryPaging(query);
    }

    @Override
    public long countListDynamic(PmsProjectActivityQuery query) {
        return pmsProjectActivityDAO.count(query);
    }


    @Override
    public List<PmsProjectActivityVO> listForTimesheet(PmsProjectActivityQuery query) {
        Long projId = query.getProjId();
        if (ObjectUtils.isEmpty(projId)) {
            throw TwException.error("", "项目ID不能为空 !");
        }
        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(projId);
        if (ObjectUtils.isEmpty(pmsProjectVO)) {
            throw TwException.error("", "项目不存在 !");
        }
        // 阶段
        query.setPhaseFlag(1);
        List<PmsProjectActivityVO> activityVOS = pmsProjectActivityDAO.queryListDynamic(query);
        // if (!ObjectUtils.isEmpty(activityVOS)) {
        //     activityVOS.forEach(v -> transferData(v, null));
        // }
        return activityVOS;
    }

    @Override
    public List<PmsProjectActivityVO> queryActiveList(Long projId, int phaseFlag) {
        List<PmsProjectActivityVO> list = new ArrayList<>();
        //去活动变更表里 找 最大版本，已经激活的数据
        List<PmsProjectActivityProcessVO> processDOList = pmsProjectActivityProcessDAO.queryByProjId(projId);
        if (!ObjectUtils.isEmpty(processDOList)) {
            //查询版本最大
            PmsProjectActivityProcessVO maxData = processDOList.stream().filter(v -> WorkFlowStatusEnum.APPROVED.getCode().equals(v.getActivityStatus())).max(Comparator.comparing(PmsProjectActivityProcessVO::getDataVersion)).get();
            if (maxData != null) {
                String changeContent = maxData.getChangeContent();
                if (!ObjectUtils.isEmpty(changeContent)) {
                    list = JSON.parseArray(changeContent, PmsProjectActivityVO.class);
                } else {
                    // 匹配最新的 活动相关预算数据
                    PmsProjectActivityQuery activityQuery = new PmsProjectActivityQuery();
                    activityQuery.setProjId(projId);
                    activityQuery.setPhaseFlag(phaseFlag);
                    return queryListDynamic(activityQuery);
                }
            }
        }
        if (!ObjectUtils.isEmpty(list)) {
            List<PmsProjectActivityVO> activityVOS = list.stream().filter(v -> !ObjectUtils.isEmpty(v.getPhaseFlag()) && phaseFlag == v.getPhaseFlag().intValue()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(activityVOS)) {
                // 匹配最新的 活动相关预算数据
                PmsProjectActivityQuery activityQuery = new PmsProjectActivityQuery();
                activityQuery.setProjId(projId);
                activityQuery.setPhaseFlag(phaseFlag);
                activityQuery.setIds(activityVOS.stream().map(v -> v.getId()).collect(Collectors.toList()));
                return queryListDynamic(activityQuery);
            }
        } else {

        }
        return new ArrayList<>();
    }

    @Override
    public List<PmsProjectActivityVO> querySimpleActiveList(Long projId) {
        PmsProjectActivityQuery activityQuery = new PmsProjectActivityQuery();
        activityQuery.setProjId(projId);
        List<PmsProjectActivityVO> list = pmsProjectActivityDAO.queryListDynamic(activityQuery);
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(v -> {
                if (ObjectUtils.isEmpty(v.getUsedEqva())) {
                    v.setUsedEqva(BigDecimal.ZERO);
                }
                if (ObjectUtils.isEmpty(v.getOccupyEqva())) {
                    v.setOccupyEqva(BigDecimal.ZERO);
                }
            });
        }
        return list;
    }

    @Override
    public PmsProjectActivityVO queryByKey(Long key) {
        return pmsProjectActivityDAO.queryByKey(key);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectActivityPayload payload) {

        long result = pmsProjectActivityDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchUpdate(List<PmsProjectActivityPayload> activityPayloads) {
        List<PmsProjectActivityDO> activityDOS = new ArrayList<>();
        for (PmsProjectActivityPayload payload : activityPayloads) {
            PmsProjectActivityDO entity = PmsProjectActivityConvert.INSTANCE.toDo(payload);
            activityDOS.add(entity);
        }
        if (!ObjectUtils.isEmpty(activityDOS)) {
            pmsProjectActivityRepo.saveAll(activityDOS);
        }
    }
//
//    @Override
//    public void batchUpdateSortNo(List<PmsProjectActivityPayload> payloads) {
//        // 数据验证
//        List<Long> ids = new ArrayList<>();
//        Map<Long, Integer> info = new HashMap<>();
//        payloads.forEach(payload -> {
//            Long id = payload.getId();
//            if (ObjectUtils.isEmpty(id)) {
//                throw TwException.error("", "主键不能为空 !");
//            }
//            Integer sortNo = payload.getSortNo();
//            if (ObjectUtils.isEmpty(sortNo)) {
//                throw TwException.error("", "序号不能为空 !");
//            }
//            ids.add(id);
//            info.put(id, sortNo);
//        });
//        List<PmsProjectActivityDO> activityDOS = new ArrayList<>();
//        List<PmsProjectActivityVO> list = pmsProjectActivityDAO.queryByKeys(ids);
//        for (PmsProjectActivityVO vo : list) {
//            PmsProjectActivityDO entity = PmsProjectActivityConvert.INSTANCE.toEntity(vo);
//            entity.setSortNo(info.get(vo.getId()));
//            activityDOS.add(entity);
//        }
//        if (!ObjectUtils.isEmpty(activityDOS)) {
//            pmsProjectActivityRepo.saveAll(activityDOS);
//        }
//    }


//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void submit(Long projId) {
//        PmsProjectActivityProcessVO maxData = getMaxDataVersionData(projId);
//        String status = null;
//        //如果最新 一条记录  发起过流程 但状态是新建 则不需要重复提流程
//        Boolean creatProcInstIdFlag = true;
//        if (!ObjectUtils.isEmpty(maxData)) {
//            status = maxData.getActivityStatus();
//            if (!ObjectUtils.isEmpty(maxData.getProcInstId()) && WorkFlowStatusEnum.CREATE_WORK.getCode().equals(status)) {
//                creatProcInstIdFlag = false;
//            }
////            if (!GlobalUtil.getLoginUserId().equals(maxData.getCreateUserId())) {
////                throw TwException.error("", "提交过数据驳回或撤回后仅发起人可操作");
////            }
//        }
//        if (creatProcInstIdFlag) {
//            if (WorkFlowStatusEnum.APPROVING_WORK.getCode().equals(status) || WorkFlowStatusEnum.REJECTED_WORK.getCode().equals(status)) {
//                throw TwException.error("", "流程 审批中 时，以及审批 被驳回 时，活动管理页不允许再次提交数据");
//            }
//
//            PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(projId);
//            if (ObjectUtils.isEmpty(pmsProjectVO)) {
//                throw TwException.error("", "项目不存在 !");
//            }
////            if (ObjectUtils.isEmpty(pmsProjectVO.getPmoResId())) {
////                throw TwException.error("", "pmo资源负责人 不能为空 !");
////            }
//            if (ObjectUtils.isEmpty(pmsProjectVO.getDeliUserId())) {
//                throw TwException.error("", "交付负责人 不能为空 !");
//            }
//
//            List<PmsProjectActivityVO> activityVOS = pmsProjectActivityDAO.queryByProjId(projId);
//            if (ObjectUtils.isEmpty(activityVOS)) {
//                throw TwException.error("", "活动数据不可为空 !");
//            }
//            Optional<PmsProjectActivityVO> optional = activityVOS.stream().filter(v -> v.getSortNo().intValue() == 1).findFirst();
//            if (!optional.isPresent()) {
//                throw TwException.error("", "第一条活动必须是阶段 !");
//            } else {
//                PmsProjectActivityVO vo = optional.get();
//                if (ObjectUtils.isEmpty(vo.getPhaseFlag()) || 1 != vo.getPhaseFlag()) {
//                    throw TwException.error("", "第一条活动必须是阶段 !");
//                }
//            }
//            for (PmsProjectActivityVO pmsProjectActivityVO : activityVOS) {
//                if (!ObjectUtils.isEmpty(pmsProjectActivityVO.getPhaseFlag()) && 1 == pmsProjectActivityVO.getPhaseFlag().intValue()) {
//                    if (ObjectUtils.isEmpty(pmsProjectActivityVO.getStartDate()) || ObjectUtils.isEmpty(pmsProjectActivityVO.getEndDate())) {
//                        throw TwException.error("", "阶段活动的起止日期不能为空 !");
//                    }
//                }
//            }
//
//            // 校验是否所有收款计划均被阶段关联并且被唯一关联  内部项目不需要 按活动阶段拨付 所以不需要判断此逻辑
//            // 是否属于外部项目标记
//            String platType = pmsProjectVO.getPlatType();
//            final boolean outerProjectFlag = SaleConEnum.INTERNAL.getCode().equals(platType) ||
//                    SaleConEnum.EXTERNAL.getCode().equals(platType) ||
//                    SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(platType);
//            if (outerProjectFlag && !ObjectUtils.isEmpty(pmsProjectVO.getContractId())) {
//                List<ConReceivablePlanVO> planVOList = conReceivablePlanService.queryBySaleConId(pmsProjectVO.getContractId());
//                if (!ObjectUtils.isEmpty(planVOList)) {
//                    // 作废的收款阶段不需要关联阶段活动
//                    planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty(v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
//                    if (!ObjectUtils.isEmpty(planVOList)) {
//                        // 判断 计划是否全部关联 且 不重复关联
//                        // 先判断是否有重复
//                        List<Long> hasPlan = activityVOS.stream().filter(v -> !ObjectUtils.isEmpty(v.getPhaseFlag()) && 1 == v.getPhaseFlag().intValue() && !ObjectUtils.isEmpty(v.getReceivePlanId())).map(v -> v.getReceivePlanId()).collect(Collectors.toList());
//                        List<Long> distinctPlan = hasPlan.stream().distinct().collect(Collectors.toList());
//                        if (distinctPlan.size() != hasPlan.size()) {
//                            throw TwException.error("", "所有收款阶段必须被阶段活动关联，且被唯一关联!");
//                        }
//                        boolean isRepeat = planVOList.size() != distinctPlan.size();
//                        if (isRepeat) {
//                            throw TwException.error("", "所有收款阶段必须被阶段活动关联，且被唯一关联 !");
//                        }
//                    }
//                }
//            }
//            // 发起流程
//            int dataVersion = 1;
//            // 判断是首次提交 还是变更
//            if (ObjectUtils.isEmpty(maxData)) {
//                //如果是第一次触发此流程（相当于没变更过），变更前的活动数据就是从模版中获取的活动数据
//                List<PmsProjectActivityVO> preActivityVOS = new ArrayList<>();
//                List<PmsProjectTemplateActVO> templateActVOS = pmsProjectTemplateActService.queryByTemplateId(pmsProjectVO.getProjTempId());
//                for (PmsProjectTemplateActVO actVO : templateActVOS) {
//                    PmsProjectActivityVO activityVO = new PmsProjectActivityVO();
//                    activityVO.setActNo(actVO.getActCode());
//                    activityVO.setActName(actVO.getActName());
//                    activityVO.setMilestoneFlag(actVO.getMilestoneFlag());
//                    activityVO.setPhaseFlag(actVO.getActStageFlag());
//                    activityVO.setFromtmplFlag(1);
//                    activityVO.setSortNo(actVO.getSortNo());
//                    activityVO.setWorkbenchFlag(1);
//                    activityVO.setRemark(actVO.getRemark());
//                    preActivityVOS.add(activityVO);
//                }
//                procStart(pmsProjectVO, dataVersion, JSON.toJSONString(preActivityVOS));
//            } else {
//                //查询版本最大
//                dataVersion = maxData.getDataVersion() + 1;
//                procStart(pmsProjectVO, dataVersion, maxData.getChangeContent());
//            }
//        } else {
//            PmsProjectActivityProcessDO processDO = new PmsProjectActivityProcessDO();
//            processDO.setId(maxData.getId());
//            processDO.setActivityStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//            pmsProjectActivityProcessDAO.updateWorkFlow(processDO);
//        }
//    }

//    @Override
//    public String getActivityStatus(Long projId) {
//        PmsProjectActivityProcessVO maxData = getMaxDataVersionData(projId);
//        if (!ObjectUtils.isEmpty(maxData)) {
//            return maxData.getActivityStatus();
//        }
//        return null;
//    }

//    /**
//     * 获取最大版本的 值
//     *
//     * @return
//     */
//    private PmsProjectActivityProcessVO getMaxDataVersionData(Long projId) {
//        List<PmsProjectActivityProcessVO> processDOList = pmsProjectActivityProcessDAO.queryByProjId(projId);
//        if (!ObjectUtils.isEmpty(processDOList)) {
//            //查询版本最大
//            PmsProjectActivityProcessVO maxData = processDOList.stream().max(Comparator.comparing(PmsProjectActivityProcessVO::getDataVersion)).get();
//            return maxData;
//        }
//        return null;
//    }

//    @Override
//    public PmsProjectActivityProcessVO byActivityProcessID(Long activityProcessID) {
//        PmsProjectActivityProcessVO vo = pmsProjectActivityProcessDAO.queryByKey(activityProcessID);
//        if (ObjectUtils.isEmpty(vo)) {
//            throw TwException.error("", "变更流程不存在 !");
//        }
//        // 项目基本信息
//        PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(vo.getProjId());
//        if (ObjectUtils.isEmpty(pmsProjectVO)) {
//            throw TwException.error("", "项目不存在 !");
//        }
//        vo.setProjNo(pmsProjectVO.getProjNo());
//        vo.setProjName(pmsProjectVO.getProjName());
//        vo.setContractId(pmsProjectVO.getContractId());
//        vo.setPlatType(pmsProjectVO.getPlatType());
//        vo.setWorkType(pmsProjectVO.getWorkType());
//        if (!ObjectUtils.isEmpty(pmsProjectVO.getPmResId())) {
//            vo.setPmResName(cacheUtil.getUserName(pmsProjectVO.getPmResId()));
//        }
//        if (!ObjectUtils.isEmpty(pmsProjectVO.getSaleManUserId())) {
//            vo.setSaleManUserName(cacheUtil.getUserName(pmsProjectVO.getSaleManUserId()));
//        }
//
//        //收款计划
//        List<ConReceivablePlanVO> planVOList = conReceivablePlanService.queryBySaleConId(pmsProjectVO.getContractId());
//        if (!ObjectUtils.isEmpty(planVOList)) {
//            // 作废的收款阶段不需要关联阶段活动
//            planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty(v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
//        }
//        vo.setPlanVOS(planVOList);
//        Map<Long, String> planInfo = planVOList.stream().collect(Collectors.toMap(ConReceivablePlanVO::getId, ConReceivablePlanVO::getReceStage));
//
//        //变更前的活动管理
//        if (!ObjectUtils.isEmpty(vo.getPreChangeContent()) && !"[]".equals(vo.getPreChangeContent())) {
//            List<PmsProjectActivityVO> preActivityVOS = JSON.parseArray(vo.getPreChangeContent(), PmsProjectActivityVO.class);
//            preActivityVOS.forEach(v -> transferData(v, planInfo));
//            vo.setPreActivityVOS(preActivityVOS);
//        }
//
//        //变更后的活动管理
//        List<PmsProjectActivityVO> activityVOS = pmsProjectActivityDAO.queryByProjId(pmsProjectVO.getId());
//        activityVOS.forEach(v -> transferData(v, planInfo));
//        vo.setActivityVOS(activityVOS);
//
//        return vo;
//    }


//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void taskCreated(TaskCreatedPayload payload) {
//        log.info("任务创建后回调参数: {}", payload);
//        // 业务key
//        String businessKey = payload.getBusinessKey();
//        // 当前流程 审批类型
//        CommentInfo commentInfo = payload.getCommentInfo();
//        if (!ObjectUtils.isEmpty(commentInfo)) {
//            ActionType actionType = commentInfo.getType();
//            //下一个节点
//            String nextTaskKey = payload.getTaskKey();
//
//            String activityStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
//            switch (actionType) {
//                case REJECTED:
//                    // 如果驳回到提交人 则将单据状态变为新建状态
//                    if (!"Activity_0gmk4xa".equals(nextTaskKey) && !"Activity_07jhdog".equals(nextTaskKey)) {
//                        activityStatus = WorkFlowStatusEnum.CREATE_WORK.getCode();
//                    }
//                    break;
//                case REVOKE:
//                    // 如果REVOKE 则将单据状态变为新建状态
//                    activityStatus = WorkFlowStatusEnum.CREATE_WORK.getCode();
//                    break;
//            }
//
//            if (!ObjectUtils.isEmpty(activityStatus)) {
//                PmsProjectActivityProcessDO processDO = new PmsProjectActivityProcessDO();
//                processDO.setId(Long.parseLong(businessKey));
//                processDO.setActivityStatus(activityStatus);
//                pmsProjectActivityProcessDAO.updateWorkFlow(processDO);
//            }
//        }
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void updateAllocate(Long activityId, BigDecimal allocateEqva, BigDecimal allocateCost, String
//            allocateStatus) {
//        PmsProjectActivityPayload activityPayload = new PmsProjectActivityPayload();
//        activityPayload.setId(activityId);
//        activityPayload.setAllocateCost(allocateCost);
//        activityPayload.setAllocateEqva(allocateEqva);
//        activityPayload.setAllocateStatus(allocateStatus);
//        pmsProjectActivityDAO.updateByKeyDynamic(activityPayload);
//    }


//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void updateAllocateStatus(List<Long> activityIds, String status) {
//        pmsProjectActivityDAO.updateStatus(activityIds, status);
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void processStatusChange(ProcessStatusChangePayload payload) {
//        log.info("流程状态变化回调参数:{}", payload);
//        String businessKey = payload.getBusinessKey();
//        ProcInstStatus procInstStatus = payload.getProcInstStatus();
//        //根据业务key查询当前业务对象
//
//        PmsProjectActivityProcessVO processVO = pmsProjectActivityProcessDAO.queryByKey(Long.valueOf(businessKey));
//
//        if (processVO != null) {
//            PmsProjectActivityProcessDO processDO = new PmsProjectActivityProcessDO();
//            processDO.setId(Long.parseLong(businessKey));
//
//            switch (procInstStatus) {
//                case NOTSUBMIT://创建人提交节点
//                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    processDO.setActivityStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    processDO.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
//                    break;
//                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
//                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    processDO.setActivityStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    break;
//                case INVALID://作废 先删除流程再删除单据
//                    //一般情况将单据状态变成"作废" ，或直接删除单据
//                    processDO.setDeleteFlag(1);
//                    processDO.setActivityStatus(WorkFlowStatusEnum.INVALID.getCode());
//                    processDO.setProcInstStatus(ProcInstStatus.INVALID);
//                    break;
//                case REJECTED://审批人拒绝，回到第一个节点
//                    //将单据状态变为新建状态
//                    processDO.setActivityStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    processDO.setProcInstStatus(ProcInstStatus.REJECTED);
//                    break;
//                case APPROVED:
//                    //一般情况将单据状态变成"激活"
//                    processDO.setActivityStatus(WorkFlowStatusEnum.APPROVED.getCode());
//                    processDO.setProcInstStatus(ProcInstStatus.APPROVED);
//                    processDO.setApprovedTime(LocalDateTime.now());
//
//                    List<PmsProjectActivityVO> activityVOS = pmsProjectActivityDAO.queryByProjId(processVO.getProjId());
//                    processDO.setChangeContent(JSON.toJSONString(activityVOS));
//
//                    break;
//                case APPROVING:
//                    break;
//            }
//            pmsProjectActivityProcessDAO.updateWorkFlow(processDO);
//        }
//    }


    /**
     * 启动派发流程
     *
     * @param pmsProjectVO
     */
//    private void procStart(PmsProjectVO pmsProjectVO, int dataVersion, String preChangeContent) {
//        // 先生成 id
//        PmsProjectActivityProcessDO processDO = new PmsProjectActivityProcessDO();
//        processDO.setProjId(pmsProjectVO.getId());
//        processDO.setDataVersion(dataVersion);
//        processDO.setPreChangeContent(preChangeContent);
//        processDO = pmsProjectActivityProcessRepo.save(processDO);
//
//        HashMap<String, Object> variables = new HashMap<>();
//        List<Long> userIds = roleService.queryUserIdByRoleCode(RoleEnum.PLAT_PMO_AID.getCode());
//        if (ObjectUtils.isEmpty(userIds)) {
//            throw TwException.error("", "公司PMO助理审批角色人员不存在");
//        }
//        // 公司PMO助理
//        variables.put("Activity_0gmk4xa", CollUtil.newArrayList(userIds));
//        // 交付负责人
//        variables.put("Activity_07jhdog", CollUtil.newArrayList(pmsProjectVO.getDeliUserId()));
//
//        //流程实例名称 P02.活动管理审批-项目名称
//        String procInstName = "P02.活动管理审批" + "-" + pmsProjectVO.getProjName();
//        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                PmsProcDefKey.PMS_PROJECT_ACTIVITY.name(),
//                procInstName,
//                processDO.getId() + "",
//                variables)
//        );
//        //流程启动成功后，回写业务表数据
//        processDO.setProcInstId(processInfo.getProcInstId());
//        processDO.setProcInstStatus(ProcInstStatus.APPROVING);
//        processDO.setSubmitTime(LocalDateTime.now());
//        processDO.setProcDefKey(PmsProcDefKey.PMS_PROJECT_ACTIVITY.name());
//        processDO.setActivityStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//        pmsProjectActivityProcessDAO.updateWorkFlow(processDO);
//    }


}
