package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.tw.tw5.api.bank.callback.cmb.CmbCallBackPayload;
import com.elitesland.tw.tw5.api.bank.callback.cmb.TwBankCmbCallBackService;
import com.elitesland.tw.tw5.api.bank.constants.TwBankConstant;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.my.payload.TMoneyTransferPayload;
import com.elitesland.tw.tw5.api.prd.my.service.TMoneyTransferService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentSlipService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;

/**
 * 招商银行 银企直连回调
 *
 * @author duwh
 * @date 2023/11/10
 */
@Slf4j
@RestController
@RequestMapping(TwBankConstant.TW_BANK_SERVER + TwBankConstant.CMB_BANK + TwBankConstant.CALLBACK)
@RequiredArgsConstructor
public class BankCallBackController implements TwBankCmbCallBackService {
    private final PaymentSlipService paymentSlipService;
    private final AccReimService accReimService;

    private final TMoneyTransferService tMoneyTransferService;

    /**
     * 对私付款回调
     *
     * @param payload 有效载荷
     * @return {@link ApiResult}<{@link Long}>
     */
    @Override
    @PostMapping(TwBankConstant.CMB_PAY_RESULT_PRIVATE_PATH)
    public ApiResult<String> payResultPrivate(@RequestBody CmbCallBackPayload payload) {
        log.info("银企直连对私付款回调信息 is {}", JSON.toJSONString(payload));
        if (!StringUtils.hasText(payload.getDocType())) {
            return ApiResult.fail("docType调用为空");
        }
        String payState = payload.getPayState();
        String payStatus = "";
        switch (payState) {
            case "5":
                payStatus = PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode();
                break;
            case "6":
                payStatus = PurchasePaymentEnum.PayStatusEnum.FAIL.getCode();
                break;
            case "7":
                payStatus = PurchasePaymentEnum.PayStatusEnum.PAYRETRUN.getCode();
                break;
            default:
                break;
        }
        if (!ObjectUtils.isEmpty(payStatus)) {
            if (PurchasePaymentEnum.BankDocType.PAY.getCode().equals(payload.getDocType())) {
                PaymentSlipPayload paymentSlipPayload = new PaymentSlipPayload();
                paymentSlipPayload.setId(Long.valueOf(payload.getDocId()));
                // 成功
                if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(payStatus)) {
                    //2024-5-29更改已付款为付款待记账
                    //paymentSlipPayload.setState(PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode());
                    paymentSlipPayload.setState(PurchasePaymentEnum.PaymentSlipStatus.PAYMENT_ACCOUNT.getCode());
                    paymentSlipPayload.setActualDate(LocalDate.now());
                    // 付款成功 根据付款记录单去看是否是全部付款完成 然后关闭合同
                    //paymentSlipService.dealPaymentData(Collections.singletonList(Long.valueOf(payload.getDocId())));
                }
                paymentSlipPayload.setPayStatus(payStatus);
                paymentSlipPayload.setPayTime(LocalDateTime.now());
                paymentSlipService.updateBankCallBack(paymentSlipPayload);
                return ApiResult.ok(PurchasePaymentEnum.BankDocType.PAY.getCode());
            }
            if (PurchasePaymentEnum.BankDocType.REIM.getCode().equals(payload.getDocType())) {
                AccReimPayload reimPayload = new AccReimPayload();
                reimPayload.setId(Long.valueOf(payload.getDocId()));
                if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(payStatus)) {
                    reimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_PAYMENT_CHARGE.getCode());
                }
                reimPayload.setPayStatus(payStatus);
                reimPayload.setPayDate(LocalDateTime.now());
                accReimService.updatePayStatus(reimPayload);
                return ApiResult.ok(PurchasePaymentEnum.BankDocType.REIM.getCode());
            }
            // 资金划拨
            if (PurchasePaymentEnum.BankDocType.TRAN.getCode().equals(payload.getDocType())) {
                TMoneyTransferPayload transferPayload = new TMoneyTransferPayload();
                transferPayload.setId(Long.valueOf(payload.getDocId()));
                transferPayload.setPayStatus(payStatus);
                transferPayload.setPayTime(LocalDateTime.now());
                tMoneyTransferService.updateByKeyDynamic(transferPayload);
                return ApiResult.ok(PurchasePaymentEnum.BankDocType.TRAN.getCode());
            }

        }
        return ApiResult.fail("docType不存在");
    }

    /**
     * 对公付款结果回调
     *
     * @param payload 有效载荷
     * @return {@link ApiResult}<{@link Long}>
     */
    @Override
    @PostMapping(TwBankConstant.CMB_PAY_RESULT_PUBLIC_PATH)
    public ApiResult<String> payResultPublic(@RequestBody CmbCallBackPayload payload) {
        log.info("银企直连对公付款回调信息 is {}", JSON.toJSONString(payload));
        if (!StringUtils.hasText(payload.getDocType())) {
            return ApiResult.fail("docType调用为空");
        }
        String payState = payload.getPayState();
        String payStatus = "";
        switch (payState) {
            case "5":
                payStatus = "S";
                break;
            case "6":
                payStatus = "F";

                break;
            case "7":
                payStatus = "G";
                break;
            default:
                break;
        }
        if (!ObjectUtils.isEmpty(payStatus)) {
            if (PurchasePaymentEnum.BankDocType.PAY.getCode().equals(payload.getDocType())) {
                PaymentSlipPayload paymentSlipPayload = new PaymentSlipPayload();
                paymentSlipPayload.setId(Long.valueOf(payload.getDocId()));
                // 成功
                if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(payStatus)) {
                    //paymentSlipPayload.setState(PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode());
                    paymentSlipPayload.setState(PurchasePaymentEnum.PaymentSlipStatus.PAYMENT_ACCOUNT.getCode());
                    // 付款成功 根据付款记录单去看是否是全部付款完成 然后关闭合同
                    //paymentSlipService.dealPaymentData(Arrays.asList(Long.valueOf(payload.getDocId())));
                }
                paymentSlipPayload.setPayStatus(payStatus);
                paymentSlipPayload.setPayTime(LocalDateTime.now());
                paymentSlipService.updateBankCallBack(paymentSlipPayload);
                return ApiResult.ok(PurchasePaymentEnum.BankDocType.PAY.getCode());
            }
            if (PurchasePaymentEnum.BankDocType.REIM.getCode().equals(payload.getDocType())) {
                AccReimPayload reimPayload = new AccReimPayload();
                reimPayload.setId(Long.valueOf(payload.getDocId()));
                if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(payStatus)) {
                    reimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_PAYMENT_CHARGE.getCode());
                }
                reimPayload.setPayStatus(payStatus);
                accReimService.updatePayStatus(reimPayload);
                return ApiResult.ok(PurchasePaymentEnum.BankDocType.REIM.getCode());
            }
            // 资金划拨
            if (PurchasePaymentEnum.BankDocType.TRAN.getCode().equals(payload.getDocType())) {
                TMoneyTransferPayload transferPayload = new TMoneyTransferPayload();
                transferPayload.setId(Long.valueOf(payload.getDocId()));
                transferPayload.setPayStatus(payStatus);
                transferPayload.setPayTime(LocalDateTime.now());
                tMoneyTransferService.updateByKeyDynamic(transferPayload);
                return ApiResult.ok(PurchasePaymentEnum.BankDocType.TRAN.getCode());
            }

        }
        return ApiResult.fail("docType不存在");
    }

}
