package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentPlanReferPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PaymentPlanReferQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentPlanReferService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PaymentPlanReferVO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PaymentPlanReferConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PaymentPlanReferDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PaymentPlanReferDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PaymentPlanReferRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 付款计划参考
 *
 * @author likunpeng
 * @date 2023-11-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PaymentPlanReferServiceImpl extends BaseServiceImpl implements PaymentPlanReferService {

    private final PaymentPlanReferRepo paymentPlanReferRepo;
    private final PaymentPlanReferDAO paymentPlanReferDAO;

    @Override
    public PagingVO<PaymentPlanReferVO> queryPaging(PaymentPlanReferQuery query){
        return paymentPlanReferDAO.queryPaging(query);
    }

    @Override
    public List<PaymentPlanReferVO> queryListDynamic(PaymentPlanReferQuery query){
        return paymentPlanReferDAO.queryListDynamic(query);
    }

    @Override
    public PaymentPlanReferVO queryByKey(Long key) {
        PaymentPlanReferDO entity = paymentPlanReferRepo.findById(key).orElseGet(PaymentPlanReferDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PaymentPlanReferVO vo = PaymentPlanReferConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PaymentPlanReferVO insert(PaymentPlanReferPayload payload) {
        PaymentPlanReferDO entityDo = PaymentPlanReferConvert.INSTANCE.toDo(payload);
        return PaymentPlanReferConvert.INSTANCE.toVo(paymentPlanReferRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PaymentPlanReferVO update(PaymentPlanReferPayload payload) {
        PaymentPlanReferDO entity = paymentPlanReferRepo.findById(payload.getId()).orElseGet(PaymentPlanReferDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PaymentPlanReferDO entityDo = PaymentPlanReferConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PaymentPlanReferConvert.INSTANCE.toVo(paymentPlanReferRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PaymentPlanReferPayload payload) {
        PaymentPlanReferDO entity = paymentPlanReferRepo.findById(payload.getId()).orElseGet(PaymentPlanReferDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = paymentPlanReferDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            paymentPlanReferDAO.deleteSoft(keys);
        }
    }

    @Override
    public void saveAll(List<PaymentPlanReferPayload> paymentPlanReferPayloads) {
        paymentPlanReferRepo.saveAll(PaymentPlanReferConvert.INSTANCE.toDoList(paymentPlanReferPayloads));
    }

    @Override
    public void deleteByPaymentId(Long id) {
        paymentPlanReferDAO.deleteByPaymentId(id);
    }

    @Override
    public List<PaymentPlanReferVO> queryListByPaymentApplyId(Long paymentApplyId) {
        return paymentPlanReferDAO.queryListByPaymentApplyId(paymentApplyId);
    }

}
