package com.elitesland.tw.tw5.server.prd.purchase.workflow;

import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractManagerPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "PURCAHSE_CONTRACT" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class PurchaseContractCallBackController implements WorkflowCallBack {

    private final PurchaseContractManagerService service;


    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PurchaseContractManagerPayload purchaseContractManagerPayload = new PurchaseContractManagerPayload();
        purchaseContractManagerPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        PurchaseContractManagerVO purchaseContractManagerVO = service.queryByKey(Long.valueOf(businessKey));
        if (purchaseContractManagerVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT -> {
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.CREATE.getCode());
                }
                case INTERRUPT -> {
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.CREATE.getCode());
                    purchaseContractManagerPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                }
                case INVALID -> {
                    service.deleteSoft(Collections.singletonList(purchaseContractManagerPayload.getId()));
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.INVALID);
                }
                case REJECTED -> {
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.REJECT.getCode());
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                }
                case APPROVED -> {
                    // 判断是否有盖章附件，如果没有，不让通过
                    if (!StringUtils.hasText(purchaseContractManagerVO.getStampFileCodes())) {
                        throw TwException.error("", "请上传盖章附件");
                    }
                    // 设置已归档标志
                    purchaseContractManagerPayload.setFilingFlag(1);
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    purchaseContractManagerPayload.setApprovedTime(LocalDateTime.now());
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.NOT_ACTIVE.getCode());
                }
                case APPROVING -> {
                    purchaseContractManagerPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    purchaseContractManagerPayload.setContractStatus(PurchaseContractStatusEnum.APPROVING.getCode());
                }
            }
            service.updateByKeyDynamic(purchaseContractManagerPayload);
        }
        return WorkflowResult.success(null);
    }
}
