package com.elitesland.tw.tw5.server.prd.salecon.controller;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

import org.apache.kafka.common.protocol.types.Field;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * ConInvSettingController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Api(tags = "ConInvSettingController")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/conInvSetting")
@Slf4j
public class ConInvSettingController {

private final ConInvSettingService conInvSettingService;


    /**
     * ConInvSettingController-新增前置校验
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/insertCheck")
    @UdcNameClass
    @ApiOperation("ConInvSettingController-新增前置校验")
    public TwOutputUtil<Integer> insertCheck(@RequestBody ConInvSettingPayload payload){
        return TwOutputUtil.ok(conInvSettingService.insertCheck(payload));
    }

    /**
     * ConInvSettingController-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @UdcNameClass
    @ApiOperation("ConInvSettingController-新增")
    public TwOutputUtil<ConInvSettingVO> insert(@RequestBody ConInvSettingPayload payload){
         return TwOutputUtil.ok(conInvSettingService.insert(payload));
    }

    /**
     * ConInvSettingController-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @UdcNameClass
    @ApiOperation("ConInvSettingController-更新")
    public TwOutputUtil<ConInvSettingVO> update(@RequestBody ConInvSettingPayload payload){
        return TwOutputUtil.ok(conInvSettingService.update(payload));
    }

    /**
     * ConInvSettingController-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("ConInvSettingController-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ConInvSettingPayload payload){
        return TwOutputUtil.ok(conInvSettingService.updateByKeyDynamic(payload));
    }

    /**
     * ConInvSettingController-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("ConInvSettingController-主键查询")
    public TwOutputUtil<ConInvSettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conInvSettingService.queryByKey(key));
    }

    /**
     * ConInvSettingController-部门年度查询
     *
     * @param invOuId 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{invOuId}/{invYear}")
    @UdcNameClass
    @ApiOperation("ConInvSettingController-部门年度查询")
    public TwOutputUtil<ConInvSettingVO> queryByInvOuIdAndYear(@PathVariable Long invOuId,@PathVariable Integer invYear) {
        return TwOutputUtil.ok(conInvSettingService.queryByInvOuIdAndYear(invOuId,invYear));
    }

    /**
     * ConInvSettingController-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("ConInvSettingController-分页")
    public TwOutputUtil<PagingVO<ConInvSettingVO>> paging(ConInvSettingQuery query) {
        return TwOutputUtil.ok(conInvSettingService.queryPaging(query));
    }

    /**
     * ConInvSettingController-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("ConInvSettingController-查询列表")
    public TwOutputUtil<List<ConInvSettingVO>> queryList(ConInvSettingQuery query) {
        return TwOutputUtil.ok(conInvSettingService.queryListDynamic(query));
    }

    /**
     * ConInvSettingController-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("ConInvSettingController-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         conInvSettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

