package com.elitesland.tw.tw5.server.prd.salecon.controller;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingTypePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingTypeQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingTypeService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingTypeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * ConInvSettingTypeController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Api(tags = "ConInvSettingTypeController")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/conInvSettingType")
@Slf4j
public class ConInvSettingTypeController {

private final ConInvSettingTypeService conInvSettingTypeService;

    /**
     * ConInvSettingTypeController-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("ConInvSettingTypeController-新增")
    public TwOutputUtil<ConInvSettingTypeVO> insert(@RequestBody ConInvSettingTypePayload payload){
         return TwOutputUtil.ok(conInvSettingTypeService.insert(payload));
    }

    /**
     * ConInvSettingTypeController-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("ConInvSettingTypeController-更新")
    public TwOutputUtil<ConInvSettingTypeVO> update(@RequestBody ConInvSettingTypePayload payload){
        return TwOutputUtil.ok(conInvSettingTypeService.update(payload));
    }

    /**
     * ConInvSettingTypeController-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("ConInvSettingTypeController-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ConInvSettingTypePayload payload){
        return TwOutputUtil.ok(conInvSettingTypeService.updateByKeyDynamic(payload));
    }

    /**
     * ConInvSettingTypeController-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("ConInvSettingTypeController-主键查询")
    public TwOutputUtil<ConInvSettingTypeVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conInvSettingTypeService.queryByKey(key));
    }

    /**
     * ConInvSettingTypeController-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("ConInvSettingTypeController-分页")
    public TwOutputUtil<PagingVO<ConInvSettingTypeVO>> paging(ConInvSettingTypeQuery query) {
        return TwOutputUtil.ok(conInvSettingTypeService.queryPaging(query));
    }

    /**
     * ConInvSettingTypeController-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("ConInvSettingTypeController-查询列表")
    public TwOutputUtil<List<ConInvSettingTypeVO>> queryList(ConInvSettingTypeQuery query) {
        return TwOutputUtil.ok(conInvSettingTypeService.queryListDynamic(query));
    }

    /**
     * ConInvSettingTypeController-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("ConInvSettingTypeController-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         conInvSettingTypeService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

