package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConExecConditionPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConExecConditionQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPersonPlanDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConExecConditionDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConExecConditionDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConExecConditionRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 销售合同执行情况管理
 *
 * @author sunxw
 * @date 2023-11-24
 */
@Repository
@RequiredArgsConstructor
public class SaleConExecConditionDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final SaleConExecConditionRepo repo;
    private final QSaleConExecConditionDO qdo = QSaleConExecConditionDO.saleConExecConditionDO;
    private final QSaleConContractDO qSaleConContractDO = QSaleConContractDO.saleConContractDO;
    private final QCrmOpportunityDO qdoOppo = QCrmOpportunityDO.crmOpportunityDO;

    private final QPrjProjectDO qdoProj = QPrjProjectDO.prjProjectDO;
    private final QPrdOrgOrganizationDO qPrdOrgOrganizationDO = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPersonPlanDO personPlanDO = QPersonPlanDO.personPlanDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<SaleConExecConditionVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(SaleConExecConditionVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 合同ID
                qdo.contractId,
                // 签单金额
                qdo.signAmt,
                // 税率
                qdo.taxRate,
                // 销售费用
                qdo.saleExpense,
                // 项目费用
                qdo.projExpense,
                // 合同采购金额
                qdo.purchaseAmt,
                // 过单毛利
                qdo.overOrderGross,
                // 部门毛利
                qdo.buGross,
                // 有效合同金额
                qdo.effectConAmt,
                // 核算有效金额
                qdo.calcEffectAmt,
                // 合同价格评级
                qdo.conPriceLevel,
                // 项目计算当量
                qdo.calcProjEquiv,
                // 项目计算核定当量
                qdo.calcCheckProjEquiv,
                // 最经济交付当量
                qdo.economicEquiv,
                // 项目执行当量
                qdo.projExecEquiv,
                // 统计日期
                qdo.statisticDate,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                //合同字段
                //子合同编号
                qSaleConContractDO.code,
                // 子合同名称
                qSaleConContractDO.name,
                // 合同状态
                qSaleConContractDO.status,
                // 客户id
                qSaleConContractDO.custId,
                // 关联商机
                qSaleConContractDO.oppoId,
                qdoProj.projectName.as("oppoName"),
                // 含税金额
                qSaleConContractDO.amt,
                // 税率
                qSaleConContractDO.taxRate.as("conTaxRate"),
                // 销售负责人
                qSaleConContractDO.saleManUserId
        )).from(qdo).leftJoin(qSaleConContractDO).on(qSaleConContractDO.id.eq(qdo.contractId))
                .leftJoin(qdoOppo).on(qSaleConContractDO.oppoId.longValue().eq(qdoOppo.id.longValue()).and(qdoOppo.deleteFlag.eq(0)))
                .leftJoin(qdoProj).on(qdoOppo.projectId.longValue().eq(qdoProj.id.longValue()).and(qdoProj.projectType.eq("opportunity")));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<SaleConExecConditionVO> getJpaQueryWhere(SaleConExecConditionQuery query) {
        JPAQuery<SaleConExecConditionVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(SaleConExecConditionQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(SaleConExecConditionQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 合同ID 精确 */
        if (!ObjectUtils.isEmpty(query.getContractId())) {
            list.add(qdo.contractId.eq(query.getContractId()));
        }
        /** 签单金额 精确 */
        if (!ObjectUtils.isEmpty(query.getSignAmt())) {
            list.add(qdo.signAmt.eq(query.getSignAmt()));
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 销售费用 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleExpense())) {
            list.add(qdo.saleExpense.eq(query.getSaleExpense()));
        }
        /** 项目费用 精确 */
        if (!ObjectUtils.isEmpty(query.getProjExpense())) {
            list.add(qdo.projExpense.eq(query.getProjExpense()));
        }
        /** 合同采购金额 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseAmt())) {
            list.add(qdo.purchaseAmt.eq(query.getPurchaseAmt()));
        }
        /** 过单毛利 精确 */
        if (!ObjectUtils.isEmpty(query.getOverOrderGross())) {
            list.add(qdo.overOrderGross.eq(query.getOverOrderGross()));
        }
        /** 部门毛利 精确 */
        if (!ObjectUtils.isEmpty(query.getBuGross())) {
            list.add(qdo.buGross.eq(query.getBuGross()));
        }
        /** 有效合同金额 精确 */
        if (!ObjectUtils.isEmpty(query.getEffectConAmt())) {
            list.add(qdo.effectConAmt.eq(query.getEffectConAmt()));
        }
        /** 核算有效金额 精确 */
        if (!ObjectUtils.isEmpty(query.getCalcEffectAmt())) {
            list.add(qdo.calcEffectAmt.eq(query.getCalcEffectAmt()));
        }
        /** 合同价格评级 精确 */
        if (!ObjectUtils.isEmpty(query.getConPriceLevel())) {
            list.add(qdo.conPriceLevel.eq(query.getConPriceLevel()));
        }
        /** 项目计算当量 精确 */
        if (!ObjectUtils.isEmpty(query.getCalcProjEquiv())) {
            list.add(qdo.calcProjEquiv.eq(query.getCalcProjEquiv()));
        }
        /** 项目计算核定当量 精确 */
        if (!ObjectUtils.isEmpty(query.getCalcCheckProjEquiv())) {
            list.add(qdo.calcCheckProjEquiv.eq(query.getCalcCheckProjEquiv()));
        }
        /** 最经济交付当量 精确 */
        if (!ObjectUtils.isEmpty(query.getEconomicEquiv())) {
            list.add(qdo.economicEquiv.eq(query.getEconomicEquiv()));
        }
        /** 项目执行当量 精确 */
        if (!ObjectUtils.isEmpty(query.getProjExecEquiv())) {
            list.add(qdo.projExecEquiv.eq(query.getProjExecEquiv()));
        }
        /** 统计日期 精确 */
        if (!ObjectUtils.isEmpty(query.getStatisticDate())) {
            list.add(qdo.statisticDate.eq(query.getStatisticDate()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        /** 工作待办标志 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkAgentFlag())) {
            list.add(qdo.workAgentFlag.eq(query.getWorkAgentFlag()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public SaleConExecConditionVO queryByKey(Long id) {
        JPAQuery<SaleConExecConditionVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param contractId 主键
     * @return 结果
     */
    public SaleConExecConditionVO queryByContractId(Long contractId) {
        JPAQuery<SaleConExecConditionVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.contractId.eq(contractId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<SaleConExecConditionVO> queryListDynamic(SaleConExecConditionQuery query) {
        JPAQuery<SaleConExecConditionVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<SaleConExecConditionVO> queryPaging(SaleConExecConditionQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<SaleConExecConditionVO> jpaQuery = getJpaQueryWhere(query);
        List<SaleConExecConditionVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<SaleConExecConditionVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public SaleConExecConditionDO save(SaleConExecConditionDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<SaleConExecConditionDO> saveAll(List<SaleConExecConditionDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(SaleConExecConditionPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 合同ID
        if (payload.getContractId() != null) {
            update.set(qdo.contractId, payload.getContractId());
        }
        // 签单金额
        if (payload.getSignAmt() != null) {
            update.set(qdo.signAmt, payload.getSignAmt());
        }
        // 税率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 销售费用
        if (payload.getSaleExpense() != null) {
            update.set(qdo.saleExpense, payload.getSaleExpense());
        }
        // 项目费用
        if (payload.getProjExpense() != null) {
            update.set(qdo.projExpense, payload.getProjExpense());
        }
        // 合同采购金额
        if (payload.getPurchaseAmt() != null) {
            update.set(qdo.purchaseAmt, payload.getPurchaseAmt());
        }
        // 过单毛利
        if (payload.getOverOrderGross() != null) {
            update.set(qdo.overOrderGross, payload.getOverOrderGross());
        }
        // 部门毛利
        if (payload.getBuGross() != null) {
            update.set(qdo.buGross, payload.getBuGross());
        }
        // 有效合同金额
        if (payload.getEffectConAmt() != null) {
            update.set(qdo.effectConAmt, payload.getEffectConAmt());
        }
        // 核算有效金额
        if (payload.getCalcEffectAmt() != null) {
            update.set(qdo.calcEffectAmt, payload.getCalcEffectAmt());
        }
        // 合同价格评级
        if (payload.getConPriceLevel() != null) {
            update.set(qdo.conPriceLevel, payload.getConPriceLevel());
        }
        // 项目计算当量
        if (payload.getCalcProjEquiv() != null) {
            update.set(qdo.calcProjEquiv, payload.getCalcProjEquiv());
        }
        // 项目计算核定当量
        if (payload.getCalcCheckProjEquiv() != null) {
            update.set(qdo.calcCheckProjEquiv, payload.getCalcCheckProjEquiv());
        }
        // 最经济交付当量
        if (payload.getEconomicEquiv() != null) {
            update.set(qdo.economicEquiv, payload.getEconomicEquiv());
        }
        // 项目执行当量
        if (payload.getProjExecEquiv() != null) {
            update.set(qdo.projExecEquiv, payload.getProjExecEquiv());
        }
        // 统计日期
        if (payload.getStatisticDate() != null) {
            update.set(qdo.statisticDate, payload.getStatisticDate());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 合同预算工作代办
        if (payload.getWorkAgentFlag() != null) {
            update.set(qdo.workAgentFlag, payload.getWorkAgentFlag());
        }
        // 标志位
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 合同ID
            if (nullFields.contains("contractId")) {
                update.setNull(qdo.contractId);
            }
            // 签单金额
            if (nullFields.contains("signAmt")) {
                update.setNull(qdo.signAmt);
            }
            // 税率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 销售费用
            if (nullFields.contains("saleExpense")) {
                update.setNull(qdo.saleExpense);
            }
            // 项目费用
            if (nullFields.contains("projExpense")) {
                update.setNull(qdo.projExpense);
            }
            // 合同采购金额
            if (nullFields.contains("purchaseAmt")) {
                update.setNull(qdo.purchaseAmt);
            }
            // 过单毛利
            if (nullFields.contains("overOrderGross")) {
                update.setNull(qdo.overOrderGross);
            }
            // 部门毛利
            if (nullFields.contains("buGross")) {
                update.setNull(qdo.buGross);
            }
            // 有效合同金额
            if (nullFields.contains("effectConAmt")) {
                update.setNull(qdo.effectConAmt);
            }
            // 核算有效金额
            if (nullFields.contains("calcEffectAmt")) {
                update.setNull(qdo.calcEffectAmt);
            }
            // 合同价格评级
            if (nullFields.contains("conPriceLevel")) {
                update.setNull(qdo.conPriceLevel);
            }
            // 项目计算当量
            if (nullFields.contains("calcProjEquiv")) {
                update.setNull(qdo.calcProjEquiv);
            }
            // 项目计算核定当量
            if (nullFields.contains("calcCheckProjEquiv")) {
                update.setNull(qdo.calcCheckProjEquiv);
            }
            // 最经济交付当量
            if (nullFields.contains("economicEquiv")) {
                update.setNull(qdo.economicEquiv);
            }
            // 项目执行当量
            if (nullFields.contains("projExecEquiv")) {
                update.setNull(qdo.projExecEquiv);
            }
            // 统计日期
            if (nullFields.contains("statisticDate")) {
                update.setNull(qdo.statisticDate);
            } // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 合同预算工作代办
            if (nullFields.contains("workAgentFlag")) {
                update.setNull(qdo.workAgentFlag);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }


    /**
     * 合同预算工作代办查询
     *
     * @param
     * @return
     */
    public PagingVO<SaleConExecConditionVO> queryWorkAgentFlagPaging(SaleConExecConditionQuery query){

        long total = queryWorkAgentFlagCount(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<SaleConExecConditionVO> jpaQuery = jpaQueryFactory.select(Projections.bean(SaleConExecConditionVO.class,
                        qdo.id,
                        // 合同ID
                        qdo.contractId,
                        //合同字段
                        //子合同编号
                        qSaleConContractDO.code,
                        // 子合同名称
                        qSaleConContractDO.name.as("objName"),
                        // 含税金额
                        qSaleConContractDO.amt,
                        // 销售负责人
                        qSaleConContractDO.saleManUserId,
                        //流程id
                        qdo.procInstId,
                        personPlanDO.planType,
                        personPlanDO.createUserId,
                        personPlanDO.modifyTime
                )).from(qdo).leftJoin(qSaleConContractDO).on(qSaleConContractDO.id.eq(qdo.contractId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qSaleConContractDO.deliBuId))
                .leftJoin(personPlanDO).on(qdo.id.eq(personPlanDO.objId).and(personPlanDO.deleteFlag.eq(0)).and(personPlanDO.planType.eq(PersonPlanTypeEnum.BUDGET.getCode())));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdo.workAgentFlag.eq(true));
        jpaQuery.where(qPrdOrgOrganizationDO.manageId.eq(query.getLoginUserId()));
        jpaQuery.where(qSaleConContractDO.deleteFlag.eq(0));
        jpaQuery.where(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        List<SaleConExecConditionVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<SaleConExecConditionVO>builder().records(result).total(total).build();
    }

    /**
     * 合同预算工作代办查询-count
     *
     * @param
     * @return
     */
    public long queryWorkAgentFlagCount(SaleConExecConditionQuery query){
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(qSaleConContractDO).on(qSaleConContractDO.id.eq(qdo.contractId))
                .leftJoin(qPrdOrgOrganizationDO).on(qPrdOrgOrganizationDO.id.eq(qSaleConContractDO.deliBuId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdo.workAgentFlag.eq(true));
        jpaQuery.where(qPrdOrgOrganizationDO.manageId.eq(query.getLoginUserId()));
        jpaQuery.where(qSaleConContractDO.deleteFlag.eq(0));
        jpaQuery.where(qPrdOrgOrganizationDO.deleteFlag.eq(0));
        long total = jpaQuery.fetchOne();
        return total;
    }

}

