package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * ConInvSettingTypeController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Entity
@Table(name = "con_inv_setting_type", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_inv_setting_type", comment = "ConInvSettingTypeController")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConInvSettingTypeDO extends BaseModel implements Serializable  {
    /** 开票类型：1 开票 0 退票 */
    @Comment("开票类型：1 开票 0 退票")
    @Column()
    private Integer invOrRefund;
    /** 发票类型 */
    @Comment("发票类型")
    @Column()
    private String invType;
    /** 是否开票:1 是；0 否 */
    @Comment("是否开票:1 是；0 否")
    @Column()
    private Integer invFlag;
    /** 邮件通知:1 是；0 否 */
    @Comment("邮件通知:1 是；0 否")
    @Column()
    private Integer emailFlag;

    /** 开票配置主表id */
    @Comment("开票配置主表id")
    @Column()
    private Long invSettingId;

    public void copy(ConInvSettingTypeDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
