package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 合同收款
 *
 * @author lemon
 * @date 2023-08-31
 */
@Entity
@Table(name = "con_receivable", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_receivable", comment = "合同收款")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConReceivableDO extends BaseModel implements Serializable  {
    /** 收款批次号 */
    @Comment("收款批次号")
    @Column()
    private String recvNo;
    /** 收款类别 发票收款/预收款 */
    @Comment("收款类别 发票收款/预收款")
    @Column()
    private String recvClass;
    /** 来源ID */
    @Comment("来源ID")
    @Column()
    private Long sourceId;
    /** 收款金额 */
    @Comment("收款金额")
    @Column()
    private BigDecimal recvAmt;
    /** 收款日期 */
    @Comment("收款日期")
    @Column()
    private LocalDate recvDate;
    /** 银行账号 */
    @Comment("银行账号")
    @Column()
    private String accountNo;
    /** 总账日期 */
    @Comment("总账日期")
    @Column()
    private LocalDate ledgerDate;
    /** 4.0id */
    @Comment("4.0id")
    @Column()
    private Long conReceivableIdV4;

    public void copy(ConReceivableDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
