package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 销售合同
 *
 * @author danting
 * @date 2023-03-30
 */
@Entity
@Table(name = "sale_con_contract", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sale_con_contract", comment = "销售合同")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class SaleConContractDO extends BaseModel implements Serializable {
    /**
     * 合同编号
     */
    @Comment("合同编号")
    @Column()
    private String code;
    /**
     * 合同名称
     */
    @FieldUpdateLog(fieldName = "合同名称")
    @FieldCreateLog(fieldName = "合同名称")
    @Comment("合同名称")
    @Column()
    private String name;
    /**
     * 合同状态
     */
    @FieldUpdateLog(fieldName = "合同状态",selectionKey = "salecon:status")
    @FieldCreateLog(fieldName = "合同状态",selectionKey = "salecon:status")
    @Comment("合同状态")
    @Column()
    private String status;
//    /**
//     * 签约公司ID
//     */
//    @FieldUpdateLog(fieldName = "签约公司ID")
//    @FieldCreateLog(fieldName = "签约公司ID")
//    @Comment("签约公司ID")
//    @Column()
//    private Long ouId;

    /**
     * 签约公司ID
     */
    @FieldUpdateLog(fieldName = "签约公司ID")
    @FieldCreateLog(fieldName = "签约公司ID")
    @Comment("签约公司ID")
    @Column()
    private Long ouBookId;
    /**
     * 参考合同号
     */
    @FieldUpdateLog(fieldName = "参考合同号")
    @FieldCreateLog(fieldName = "参考合同号")
    @Comment("参考合同号")
    @Column()
    private String referCode;
    /**
     * 商机ID
     */
    @FieldUpdateLog(fieldName = "商机ID")
    @FieldCreateLog(fieldName = "商机ID")
    @Comment("商机ID")
    @Column()
    private Long oppoId;
    /**
     * 客户ID
     */
    @FieldUpdateLog(fieldName = "客户ID")
    @FieldCreateLog(fieldName = "客户ID")
    @Comment("客户ID")
    @Column()
    private Long custId;

//    /**
//     * 业务伙伴ID
//     */
//    @FieldUpdateLog(fieldName = "业务伙伴ID")
//    @FieldCreateLog(fieldName = "业务伙伴ID")
//    @Comment("业务伙伴ID")
//    @Column()
//    private Long partnerId;
    /**
     * 签约时客户名称
     */
    @Comment("签约时客户名称")
    @Column()
    private String custName;
    /**
     * 关联合同ID
     */
    @FieldUpdateLog(fieldName = "关联合同ID")
    @FieldCreateLog(fieldName = "关联合同ID")
    @Comment("关联合同ID")
    @Column()
    private Long relatedContractId;
    /**
     * 新客户标志，0：新客户，1：老客户
     */
    @Comment("新客户标志，0：新客户，1：老客户")
    @Column()
    private Long custFlag;
    /**
     * 签订日期
     */
    @FieldUpdateLog(fieldName = "签订日期")
    @FieldCreateLog(fieldName = "签订日期")
    @Comment("签订日期")
    @Column()
    private LocalDate signDate;
    /**
     * 特别关注点
     */
    @FieldUpdateLog(fieldName = "特别关注点")
    @FieldCreateLog(fieldName = "特别关注点")
    @Comment("特别关注点")
    @Column()
    private String specialConcerned;
    /**
     * 币种
     */
    @FieldUpdateLog(fieldName = "币种",selectionKey = "SYSTEM_BASIC:CURRENCY")
    @FieldCreateLog(fieldName = "币种",selectionKey = "SYSTEM_BASIC:CURRENCY")
    @Comment("币种")
    @Column()
    private String currCode;
    /**
     * 关闭原因
     */
    @FieldUpdateLog(fieldName = "关闭原因",selectionKey = "salecon:close_cause")
    @FieldCreateLog(fieldName = "关闭原因",selectionKey = "salecon:close_cause")
    @Comment("关闭原因")
    @Column()
    private String closeReason;
    /**
     * 关闭时间
     */
    @Comment("关闭时间")
    @Column()
    private LocalDate closeDate;
    /**
     * 客户项目
     */
    @FieldUpdateLog(fieldName = "客户项目")
    @FieldCreateLog(fieldName = "客户项目")
    @Comment("客户项目")
    @Column()
    private String custProj;
    /**
     * 销售内容
     */
    @FieldUpdateLog(fieldName = "销售内容")
    @FieldCreateLog(fieldName = "销售内容")
    @Comment("销售内容")
    @Column()
    private String saleContent;
    /**
     * 产品大类
     */
    @FieldUpdateLog(fieldName = "产品大类",selectionKey = "con:sales_class")
    @FieldCreateLog(fieldName = "产品大类",selectionKey = "con:sales_class")
    @Comment("产品大类")
    @Column()
    private String productClass;
    /**
     * 产品小类
     */
    @FieldUpdateLog(fieldName = "产品小类")
    @FieldCreateLog(fieldName = "产品小类")
    @Comment("产品小类")
    @Column()
    private String productSubClass;
    /**
     * 交付地点
     */
    @FieldUpdateLog(fieldName = "交付地点")
    @FieldCreateLog(fieldName = "交付地点")
    @Comment("交付地点")
    @Column()
    private String deliveryAddress;
    /**
     * 财务期间ID
     */
//    @FieldUpdateLog(fieldName = "财务期间ID")
//    @FieldCreateLog(fieldName = "财务期间ID")
    @Comment("财务期间ID")
    @Column()
    private Long finPeriodId;
    /**
     * 合同总金额
     */
    @FieldUpdateLog(fieldName = "合同总金额")
    @FieldCreateLog(fieldName = "合同总金额")
    @Comment("合同总金额")
    @Column()
    private BigDecimal amt;
    /**
     * 其它费用
     */
    @FieldUpdateLog(fieldName = "其他费用")
    @FieldCreateLog(fieldName = "其他费用")
    @Comment("其它费用")
    @Column()
    private BigDecimal extraAmt;
    /**
     * 有效合同金额
     */
    @FieldUpdateLog(fieldName = "有效合同金额")
    @FieldCreateLog(fieldName = "有效合同金额")
    @Comment("有效合同金额")
    @Column()
    private BigDecimal effectiveAmt;
    /**
     * 毛利
     */
    @FieldUpdateLog(fieldName = "毛利")
    @FieldCreateLog(fieldName = "毛利")
    @Comment("毛利")
    @Column()
    private BigDecimal grossProfit;
    /**
     * 销售区域BU_ID
     */
    @FieldUpdateLog(fieldName = "销售区域BU",selectionKey = "BU")
    @FieldCreateLog(fieldName = "销售区域BU",selectionKey = "BU")
    @Comment("销售区域BU_ID")
    @Column()
    private Long regionBuId;
    /**
     * 销售区域负责人
     */
    @FieldUpdateLog(fieldName = "销售区域负责人",selectionKey = "USER")
    @FieldCreateLog(fieldName = "销售区域负责人",selectionKey = "USER")
    @Comment("销售区域负责人")
    @Column()
    private Long regionUserId;
    /**
     * 签单BU_ID
     */
    @FieldUpdateLog(fieldName = "签单BU",selectionKey = "BU")
    @FieldCreateLog(fieldName = "签单BU",selectionKey = "BU")
    @Comment("签单BU_ID")
    @Column()
    private Long signBuId;
    /**
     * 副签单BU_ID
     */
    @FieldUpdateLog(fieldName = "副签单BU",selectionKey = "BU")
    @FieldCreateLog(fieldName = "副签单BU",selectionKey = "BU")
    @Comment("副签单BU_ID")
    @Column()
    private Long coSignBuId;
    /**
     * 副签单负责人ID
     */
    @FieldUpdateLog(fieldName = "副签单负责人ID",selectionKey = "USER")
    @FieldCreateLog(fieldName = "副签单负责人ID",selectionKey = "USER")
    @Comment("副签单负责人ID")
    @Column()
    private Long coSignUserId;
    /**
     * 主交付BU_ID
     */
    @FieldUpdateLog(fieldName = "主交付BU",selectionKey = "BU")
    @FieldCreateLog(fieldName = "主交付BU",selectionKey = "BU")
    @Comment("主交付BU_ID")
    @Column()
    private Long deliBuId;
    /**
     * 交付用户id
     */
    @FieldUpdateLog(fieldName = "交付负责人",selectionKey = "USER")
    @FieldCreateLog(fieldName = "交付负责人",selectionKey = "USER")
    @Comment("交付用户id")
    @Column()
    private Long deliUserId;
    /**
     * 副交付BU_ID
     */
    @FieldUpdateLog(fieldName = "副交付BU",selectionKey = "BU")
    @FieldCreateLog(fieldName = "副交付BU",selectionKey = "BU")
    @Comment("副交付BU_ID")
    @Column()
    private Long codeliBuId;
    /**
     * 副交付用户id
     */
    @FieldUpdateLog(fieldName = "副交付负责人",selectionKey = "USER")
    @FieldCreateLog(fieldName = "副交付负责人",selectionKey = "USER")
    @Comment("副交付用户id")
    @Column()
    private Long codeliUserId;
    /**
     * 平台合同类型
     */
    @FieldUpdateLog(fieldName = "平台合同类型",selectionKey = "salecon:plat_type")
    @FieldCreateLog(fieldName = "平台合同类型",selectionKey = "salecon:plat_type")
    @Comment("平台合同类型")
    @Column()
    private String platType;
    /**
     * 主合同类型
     */
    @FieldUpdateLog(fieldName = "主合同类型",selectionKey = "salecon:mainType")
    @FieldCreateLog(fieldName = "主合同类型",selectionKey = "salecon:mainType")
    @Comment("主合同类型")
    @Column()
    private String mainType;
    /**
     * PMO用户ID
     */
    @FieldUpdateLog(fieldName = "PMO",selectionKey = "USER")
    @FieldCreateLog(fieldName = "PMO",selectionKey = "USER")
    @Comment("PMO用户ID")
    @Column()
    private Long pmoUserId;
    /**
     * 来源类型
     */
    @FieldUpdateLog(fieldName = "来源类型",selectionKey = "salecon:source_type")
    @FieldCreateLog(fieldName = "来源类型",selectionKey = "salecon:source_type")
    @Comment("来源类型")
    @Column()
    private String sourceType;
    /**
     * 外部来源
     */
    @FieldUpdateLog(fieldName = "外部来源")
    @FieldCreateLog(fieldName = "外部来源")
    @Comment("外部来源")
    @Column()
    private String externalIden;
    /**
     * 外部来源人
     */
    @FieldUpdateLog(fieldName = "外部来源人")
    @FieldCreateLog(fieldName = "外部来源人")
    @Comment("外部来源人")
    @Column()
    private String externalName;
    /**
     * 外部来源电话
     */
    @FieldUpdateLog(fieldName = "外部来源电话")
    @FieldCreateLog(fieldName = "外部来源电话")
    @Comment("外部来源电话")
    @Column()
    private String externalPhone;
    /**
     * 内部来源BU_ID
     */
    @FieldUpdateLog(fieldName = "内部来源BU",selectionKey = "BU")
    @FieldCreateLog(fieldName = "内部来源BU",selectionKey = "BU")
    @Comment("内部来源BU_ID")
    @Column()
    private Long internalBuId;
    /**
     * 利益承诺
     */
    @FieldUpdateLog(fieldName = "利益承诺")
    @FieldCreateLog(fieldName = "利益承诺")
    @Comment("利益承诺")
    @Column()
    private String profitDesc;
    /**
     * 税率
     */
    @FieldUpdateLog(fieldName = "税率",selectionKey = "SYSTEM_BASIC:TAX")
    @FieldCreateLog(fieldName = "税率",selectionKey = "SYSTEM_BASIC:TAX")
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;
    /**
     * 销售负责人ID
     */
    @FieldUpdateLog(fieldName = "销售负责人",selectionKey = "USER")
    @FieldCreateLog(fieldName = "销售负责人",selectionKey = "USER")
    @Comment("销售负责人ID")
    @Column()
    private Long saleManUserId;
    /**
     * 内部来源人
     */
    @FieldUpdateLog(fieldName = "内部来源人",selectionKey = "USER")
    @FieldCreateLog(fieldName = "内部来源人",selectionKey = "USER")
    @Comment("内部来源用户ID")
    @Column()
    private Long internalUserId;
    /**
     * 合同开始日期
     */
    @FieldUpdateLog(fieldName = "合同开始日期")
    @FieldCreateLog(fieldName = "合同开始日期")
    @Comment("合同开始日期")
    @Column()
    private LocalDate startDate;
    /**
     * 合同结束日期
     */
    @FieldUpdateLog(fieldName = "合同结束日期")
    @FieldCreateLog(fieldName = "合同结束日期")
    @Comment("合同结束日期")
    @Column()
    private LocalDate endDate;
    /**
     * 纸质合同状态描述
     */
    @Comment("纸质合同状态描述")
    @Column()
    private String paperDesc;
    /**
     * 纸质合同状态
     */
    @FieldUpdateLog(fieldName = "纸质合同状态",selectionKey = "salecon:paper_status")
    @FieldCreateLog(fieldName = "纸质合同状态",selectionKey = "salecon:paper_status")
    @Comment("纸质合同状态")
    @Column()
    private String paperStatus;
    /**
     * 合同激活时间
     */
    @Comment("合同激活时间")
    @Column()
    private LocalDate acitveDate;
    /**
     * 产品
     */
    @FieldUpdateLog(fieldName = "产品")
    @FieldCreateLog(fieldName = "产品")
    @Comment("产品")
    @Column()
    private Long product;
    /**
     * 简要说明
     */
    @FieldUpdateLog(fieldName = "简要说明")
    @FieldCreateLog(fieldName = "简要说明")
    @Comment("简要说明")
    @Column()
    private String briefDesc;
    /**
     * 工作类型
     */
    @FieldUpdateLog(fieldName = "工作类型",selectionKey = "salecon:work_type")
    @FieldCreateLog(fieldName = "工作类型",selectionKey = "salecon:work_type")
    @Comment("工作类型")
    @Column()
    private String workType;
    /**
     * 促销类型
     */
    @FieldUpdateLog(fieldName = "促销类型",selectionKey = "salecon:promotional_code")
    @FieldCreateLog(fieldName = "促销类型",selectionKey = "salecon:promotional_code")
    @Comment("促销类型")
    @Column()
    private String promotionType;
    /**
     * 范围性质
     */
    @FieldUpdateLog(fieldName = "范围性质",selectionKey = "salecon:range_property")
    @FieldCreateLog(fieldName = "范围性质",selectionKey = "salecon:range_property")
    @Comment("范围性质")
    @Column()
    private String rangeProp;
    /**
     * 半开口说明
     */
    @FieldUpdateLog(fieldName = "半开口说明")
    @FieldCreateLog(fieldName = "半开口说明")
    @Comment("半开口说明")
    @Column()
    private String halfOpenDesc;
    /**
     * 供应主体类别
     */
    @FieldUpdateLog(fieldName = "供应主题类别",selectionKey = "salecon:supplier")
    @FieldCreateLog(fieldName = "供应主题类别",selectionKey = "salecon:supplier")
    @Comment("供应主体类别")
    @Column()
    private String supplierType;
    /**
     * 提成类别
     */
    @FieldUpdateLog(fieldName = "提成类别",selectionKey = "salecon:project_type")
    @FieldCreateLog(fieldName = "提成类别",selectionKey = "salecon:project_type")
    @Comment("提成类别")
    @Column()
    private String commissionType;
    /**
     * 交易方式
     */
    @FieldUpdateLog(fieldName = "交易方式",selectionKey = "salecon:trading_method")
    @FieldCreateLog(fieldName = "交易方式",selectionKey = "salecon:trading_method")
    @Comment("交易方式")
    @Column()
    private String transactionMethod;
    /**
     * 交易性质
     */
    @FieldUpdateLog(fieldName = "交易性质",selectionKey = "salecon:trade_quality")
    @FieldCreateLog(fieldName = "交易性质",selectionKey = "salecon:trade_quality")
    @Comment("交易性质")
    @Column()
    private String transactionNature;
    /**
     * 需求类别
     */
    @FieldUpdateLog(fieldName = "需求类别",selectionKey = "salecon:demand_type")
    @FieldCreateLog(fieldName = "需求类别",selectionKey = "salecon:demand_type")
    @Comment("需求类别")
    @Column()
    private String demandType;
    /**
     * 销售分类
     */
    @FieldUpdateLog(fieldName = "销售分类",selectionKey = "salecon:sales_type")
    @FieldCreateLog(fieldName = "销售分类",selectionKey = "salecon:sales_type")
    @Comment("销售分类")
    @Column()
    private String saleClass;
    /**
     * 客户承担差旅费
     */
    @FieldUpdateLog(fieldName = "客户承担差旅费",selectionKey = "salecon:cust_bear")
    @FieldCreateLog(fieldName = "客户承担差旅费",selectionKey = "salecon:cust_bear")
    @Comment("客户承担差旅费")
    @Column()
    private String custBarExpense;
    /**
     * 报销政策说明
     */
    @FieldUpdateLog(fieldName = "报销政策说明")
    @FieldCreateLog(fieldName = "报销政策说明")
    @Comment("报销政策说明")
    @Column()
    private String reimbursementDesc;
    /**
     * 估算当量
     */
    @FieldUpdateLog(fieldName = "估算当量")
    @FieldCreateLog(fieldName = "估算当量")
    @Comment("估算当量")
    @Column()
    private BigDecimal ratedEqva;
    /**
     * 估算费用
     */
    @FieldUpdateLog(fieldName = "估算费用")
    @FieldCreateLog(fieldName = "估算费用")
    @Comment("估算费用")
    @Column()
    private BigDecimal ratedExpense;
    /**
     * 合同打印方
     */
    @FieldUpdateLog(fieldName = "合同打印方",selectionKey = "salecon:printed_by")
    @FieldCreateLog(fieldName = "合同打印方",selectionKey = "salecon:printed_by")
    @Comment("合同打印方")
    @Column()
    private String contractPrinter;
    /**
     * 打印份数
     */
    @FieldUpdateLog(fieldName = "打印份数")
    @FieldCreateLog(fieldName = "打印份数")
    @Comment("打印份数")
    @Column()
    private Long printCount;
    /**
     * 盖章类型
     */
    @FieldUpdateLog(fieldName = "盖章类型",selectionKey = "salecon:stamp_type")
    @FieldCreateLog(fieldName = "盖章类型",selectionKey = "salecon:stamp_type")
    @Comment("盖章类型")
    @Column()
    private String sealType;
    /**
     * 和发票一起邮寄，0：是，1：否
     */
    @FieldUpdateLog(fieldName = "和发票一起邮寄")
    @FieldCreateLog(fieldName = "和发票一起邮寄")
    @Comment("和发票一起邮寄，0：是，1：否")
    @Column()
    private Integer sendWithInvoiceFlag;
    /**
     * 邮寄地址
     */
    @FieldUpdateLog(fieldName = "邮寄地址")
    @FieldCreateLog(fieldName = "邮寄地址")
    @Comment("邮寄地址")
    @Column()
    private String mailingAddress;
    /**
     * 主合同ID
     */
    @FieldUpdateLog(fieldName = "主合同ID")
    @FieldCreateLog(fieldName = "主合同ID")
    @Comment("主合同ID")
    @Column()
    private Long parentId;

    /**
     * 合同附件
     */
    @FieldUpdateLog(fieldName = "附件")
    @FieldCreateLog(fieldName = "附件")
    @Comment("合同附件")
    @Column()
    private String fileCodes;

    private String folderId;

    /**
     * sow附件
     */
    @FieldUpdateLog(fieldName = "sow附件")
    @FieldCreateLog(fieldName = "sow附件")
    @Comment("sow附件")
    @Column()
    private String sowFileCodes;

    /**
     * 估算申请单附件
     */
    @FieldUpdateLog(fieldName = "估算申请单附件")
    @FieldCreateLog(fieldName = "估算申请单附件")
    @Comment("估算申请单附件")
    @Column()
    private String assessFileCodes;

    /**
     * 合同关闭附件
     */
    @FieldUpdateLog(fieldName = "合同关闭附件")
    @FieldCreateLog(fieldName = "合同关闭附件")
    @Comment("合同关闭附件")
    @Column()
    private String closeFileCodes;
    /**
     * 售前bu
     */
    @FieldUpdateLog(fieldName = "售前BU",selectionKey = "BU")
    @FieldCreateLog(fieldName = "售前BU",selectionKey = "BU")
    @Comment("售前bu")
    @Column()
    private Long preSaleBuId;

    /**
     * 售前负责人
     */
    @FieldUpdateLog(fieldName = "售前负责人",selectionKey = "USER")
    @FieldCreateLog(fieldName = "售前负责人",selectionKey = "USER")
    @Comment("售前负责人")
    @Column()
    private Long preSaleUserId;

    /**
     * 合同归档标志 0：未归档,1:归档
     */
    @Comment("合同归档标志")
    @Column(nullable = false, columnDefinition = "tinyint(4) DEFAULT '0'")
    private Integer filingFlag;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("财务核算毛利率")
    @Column()
    private BigDecimal finGross;

    @Comment("财务核定额定当量")
    @Column()
    private BigDecimal finRatedEqva;

    @Comment("系统核算毛利率")
    @Column()
    private BigDecimal sysGross;

    @Comment("合同IDv4")
    @Column()
    private Long contractIdV4;

    @Comment("净Rate")
    @Column()
    private BigDecimal netRate;

    @Comment("额定费用")
    @Column()
    private BigDecimal ratedCost;

    @Comment("变更标志")
    @Column()
    private Integer changeFlag;

    @Comment("jde同步状态")
    @Column()
    private String jdeStatus;

    @Comment("jde失败原因")
    @Column()
    private String jdeFailReason;

    @Comment("合同收回时间")
    @Column()
    private LocalDateTime receiveTime;

    @Comment("是否有代理费 1是  0否")
    @Column()
    private Integer agentFlag;
    @Comment("代理费比例")
    @Column()
    private BigDecimal agentProportion;
    @Comment("代理费金额")
    @Column()
    private BigDecimal agentAmt;
    @Comment("拓展")
    @Column()
    private String ext1;
    @Comment("拓展")
    @Column()
    private String ext2;
    @Comment("拓展")
    @Column()
    private String ext3;
    @Comment("拓展")
    @Column()
    private String ext4;
    @Comment("拓展")
    @Column()
    private String ext5;
    public void copy(SaleConContractDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
