package com.elitesland.tw.tw5.server.prd.salecon.service;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConPurchaseDemandDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandDVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConPurchaseDemandDConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConPurchaseDemandDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConPurchaseDemandDDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConPurchaseDemandDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConPurchaseDemandRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购需求处理明细
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConPurchaseDemandDServiceImpl extends BaseServiceImpl implements ConPurchaseDemandDService {

    private final ConPurchaseDemandDRepo conPurchaseDemandDRepo;
    private final ConPurchaseDemandRepo conPurchaseDemandRepo;
    private final ConPurchaseDemandDDAO conPurchaseDemandDDAO;
    private final CacheUtil cacheUtil;
    // private final SaleConContractService conContractService;
    private final PrdProductClassRepo productClassRepo;
    // private final PrdAbRepo prdAbRepo;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final UdcUtil udcUtil;

    @Override
    public PagingVO<ConPurchaseDemandDVO> paging(ConPurchaseDemandDQuery query) {
        Page<ConPurchaseDemandDDO> page = conPurchaseDemandDRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(ConPurchaseDemandDConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<ConPurchaseDemandDVO> queryPaging(ConPurchaseDemandDQuery query) {
        SaleConContractQuery saleConContractQuery = new SaleConContractQuery();
        //获取合同权限
        SaleConContractService conContractService = SpringUtil.getBean(SaleConContractService.class);
        conContractService.getPermissionParams(saleConContractQuery);
        List<Long> orgIdsByPermission = saleConContractQuery.getOrgIdsByPermission();
        List<Long> userIdsByPermission = saleConContractQuery.getUserIdsByPermission();
        query.setOrgIdsByPermission(orgIdsByPermission);
        query.setUserIdsByPermission(userIdsByPermission);
        PagingVO<ConPurchaseDemandDVO> conPurchaseDemandDVOPagingVO = conPurchaseDemandDDAO.queryPaging(query);
        // 翻译
//        conPurchaseDemandDVOPagingVO.stream().forEach(this::transfer);
        this.transferList(conPurchaseDemandDVOPagingVO.getRecords());
        return conPurchaseDemandDVOPagingVO;
    }

    @Override
    public List<ConPurchaseDemandDVO> queryList(ConPurchaseDemandDQuery query) {
        List<ConPurchaseDemandDVO> dvoList = ConPurchaseDemandDConvert.INSTANCE.toVoList(
                conPurchaseDemandDRepo.findAll(
                        (root, criteriaQuery, criteriaBuilder)
                                -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                        , query.getPageRequest().getSort()
                )
        );
        // 翻译
        dvoList.forEach(this::transfer);
        return dvoList;
    }

    @Override
    public List<ConPurchaseDemandDVO> queryListDynamic(ConPurchaseDemandDQuery query) {
        List<ConPurchaseDemandDVO> dvoList = conPurchaseDemandDDAO.queryListDynamic(query);
        // 翻译
        dvoList.forEach(this::transfer);
        return dvoList;
    }

    @Override
    public ConPurchaseDemandDVO queryByKey(Long key) {
        ConPurchaseDemandDDO entity = conPurchaseDemandDRepo.findById(key).orElseGet(ConPurchaseDemandDDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConPurchaseDemandDVO vo = ConPurchaseDemandDConvert.INSTANCE.toVo(entity);
        //翻译
        transfer(vo);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConPurchaseDemandDVO insert(ConPurchaseDemandDPayload payload) {
        ConPurchaseDemandDDO entityDo = ConPurchaseDemandDConvert.INSTANCE.toDo(payload);
        entityDo.setDemandStatus("CREATE");
        //计算金额
        countMoney(entityDo);
        // 为了同步任务需要更新采购需求主表的更新时间
        conPurchaseDemandRepo.updateRemark(entityDo.getPurDemandId());
        return ConPurchaseDemandDConvert.INSTANCE.toVo(conPurchaseDemandDRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConPurchaseDemandDVO update(ConPurchaseDemandDPayload payload) {
//        if (("handled").equals(payload.getDemandStatus())) {
//            throw TwException.error("","已处理的需求明细不可再修改！");
//        }
        ConPurchaseDemandDDO entity = conPurchaseDemandDRepo.findById(payload.getId()).orElseGet(ConPurchaseDemandDDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConPurchaseDemandDDO entityDo = ConPurchaseDemandDConvert.INSTANCE.toDo(payload);
        //计算金额
        countMoney(entityDo);
        entity.copy(entityDo);
        // 为了同步任务需要更新采购需求主表的更新时间
        conPurchaseDemandRepo.updateRemark(entityDo.getPurDemandId());
        return ConPurchaseDemandDConvert.INSTANCE.toVo(conPurchaseDemandDRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conPurchaseDemandDDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<ConPurchaseDemandDVO> queryByPurDemandId(Long purDemandId) {
        List<ConPurchaseDemandDVO> dvoList = conPurchaseDemandDDAO.queryByPurDemandId(purDemandId);
        // 翻译
        dvoList.forEach(this::transfer);
        return dvoList;
    }

    @Override
    public void downloadPurDemand(HttpServletResponse response, ConPurchaseDemandDQuery query) {
        try {

//            List<OrderItem> orderItems = new ArrayList<>();
//            OrderItem openseaId = OrderItem.desc("opensea_id");
//            orderItems.add(openseaId);
//            query.setOrders(orderItems);
            log.info("=============================开始查询=======================================");
            PagingVO<ConPurchaseDemandDVO> paging = queryPaging(query);
            log.info("=============================结束查询=======================================");
            List<ConPurchaseDemandDVO> records = paging.getRecords();
            download(udcUtil.translateList(records), response);
//            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(List<ConPurchaseDemandDVO> records, HttpServletResponse response) throws IOException {
        int order = 1;
        //定义文件名称
        String sheetName = "采购需求数据";
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), ConPurchaseDemandDVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, ConPurchaseDemandDVO.class, null);
        //写入
        sheet.doWrite(records);
    }

    /**
     * 计算金额
     *
     * @param entityDo
     * @return
     */
    public ConPurchaseDemandDDO countMoney(ConPurchaseDemandDDO entityDo) {
        Integer demandNum = entityDo.getDemandNum();    //数量
        if (demandNum == null) {
            demandNum = 0;
        }
        BigDecimal num = new BigDecimal(demandNum.toString());  //数量
        BigDecimal taxPrice = entityDo.getTaxPrice() == null ? BigDecimal.ZERO : entityDo.getTaxPrice();   //含税单价
        BigDecimal taxRate = entityDo.getTaxRate() == null ? BigDecimal.ZERO : entityDo.getTaxRate();   //税率
        //含税总额 = 数量 * 含税单价
        BigDecimal taxAmt = num.multiply(taxPrice);
        //不含税总额 = 含税总金额 / (1 + 税率)
        BigDecimal notTaxAmt = taxAmt.divide(BigDecimal.ONE.add(taxRate), 3, BigDecimal.ROUND_DOWN);
        entityDo.setTaxAmt(taxAmt);
        entityDo.setNotTaxAmt(notTaxAmt);
        return entityDo;
    }

    private void transfer(ConPurchaseDemandDVO vo) {
        Map<Long, String> productClassMap = productClassRepo.findAll().stream().collect(Collectors.toMap(PrdProductClassDO::getId, PrdProductClassDO::getClassName, (key1, key2) -> key2));
//        Map<Long, String> supplierMap = prdAbRepo.findAll().stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getBookName() == null ? "" : n.getBookName(), (key1, key2) -> key2));
//        Map<Long, String> supplierNoMap = prdAbRepo.findAll().stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getBookNo() == null ? "" : n.getBookNo(), (key1, key2) -> key2));

        List<BusinessCustomerSimpleVO> businessCustomerSimpleVOS = businessCustomerInfoService.listSimple(BusinessPartnerIdentityEnum.SUPPLIER.getCode(), null);
        Map<Long, String> supplierMap = businessCustomerSimpleVOS.stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getCustomerName() == null ? "" : n.getCustomerName(), (key1, key2) -> key2));
        // Map<Long, String> supplierNoMap = businessCustomerSimpleVOS.stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getBusinessPartnerNo() == null ? "" : n.getBusinessPartnerNo(), (key1, key2) -> key2));

        Long main = vo.getProductClassId(); //获取大类
        Long sub = vo.getProductSubClassId(); //获取小类
        vo.setProductClass(productClassMap.get(main));
        vo.setProductSubClass(productClassMap.get(sub));
        Long supplierId = vo.getSupplierId();
        vo.setSupplierName(supplierMap.get(supplierId));
//        if (supplierNoMap.get(supplierId) != null) {
//            vo.setSupplierId(Long.parseLong(supplierNoMap.get(supplierId)));
//        }

//        if (!ObjectUtils.isEmpty(main) || !ObjectUtils.isEmpty(sub)) {
//        //翻译采购小类
//        switch (main) {
//            case "01"-> vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.DEVELOPMENT.getCode(),sub));
//            case "02"-> vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SOFTWAREMA.getCode(),sub));
//            case "03"-> vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.HARDWARE.getCode(),sub));
//            case "04"-> vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.IMPLEMENT.getCode(),sub));
//            case "05"-> vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.OPERATIONS.getCode(),sub));
//            case "06"-> vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SOFTWARE.getCode(),sub));
//            case "51"-> vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SYNTHESIS.getCode(),sub));
//            }
//        }
    }

    /**
     * 翻译列表
     *
     * @param voList 要翻译的列表
     */
    private void transferList(List<ConPurchaseDemandDVO> voList) {
        Map<Long, String> productClassMap = productClassRepo.findAll().stream().collect(Collectors.toMap(PrdProductClassDO::getId, PrdProductClassDO::getClassName, (key1, key2) -> key2));
//        Map<Long, String> supplierMap = prdAbRepo.findAll().stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getBookName() == null ? "" : n.getBookName(), (key1, key2) -> key2));
//        Map<Long, String> supplierNoMap = prdAbRepo.findAll().stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getBookNo() == null ? "" : n.getBookNo(), (key1, key2) -> key2));
        List<BusinessCustomerSimpleVO> businessCustomerSimpleVOS = businessCustomerInfoService.listSimple(BusinessPartnerIdentityEnum.SUPPLIER.getCode(), null);
        Map<Long, String> supplierMap = businessCustomerSimpleVOS.stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getCustomerName() == null ? "" : n.getCustomerName(), (key1, key2) -> key2));
        Map<Long, String> supplierNoMap = businessCustomerSimpleVOS.stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getBusinessPartnerNo() == null ? "" : n.getBusinessPartnerNo(), (key1, key2) -> key2));

        voList.forEach(conPurchaseDemandDVO -> {
            conPurchaseDemandDVO.setProductClass(productClassMap.get(conPurchaseDemandDVO.getProductClassId()));
            conPurchaseDemandDVO.setProductSubClass(productClassMap.get(conPurchaseDemandDVO.getProductSubClassId()));
            Long supplierId = conPurchaseDemandDVO.getSupplierId();
            conPurchaseDemandDVO.setSupplierName(supplierMap.get(supplierId));
            if (supplierNoMap.get(supplierId) != null) {
                conPurchaseDemandDVO.setSupplierId(Long.parseLong(supplierNoMap.get(supplierId)));
            }
        });
    }

}
