package com.elitesland.tw.tw5.server.prd.salecon.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConPurchaseDemandQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractManagerRepo;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConPurchaseDemandConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConPurchaseDemandDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConPurchaseDemandDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConPurchaseDemandDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConPurchaseDemandRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 采购需求处理
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConPurchaseDemandServiceImpl extends BaseServiceImpl implements ConPurchaseDemandService {

    private final ConPurchaseDemandRepo conPurchaseDemandRepo;
    private final ConPurchaseDemandDAO conPurchaseDemandDAO;
    private final ConPurchaseDemandDService purDemandDService;

 //   private SaleConContractService saleConContractService;

    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final ConPurchaseDemandDRepo conPurchaseDemandDRepo;
    private final PrdProductRepo prdProductRepo;
    private final PrdProductClassRepo prdProductClassRepo;
    private final SaleConContractDAO saleConContractDAO;
    private final SaleConContractRepo saleConContractRepo;
    private final PrdOrgEmployeeService employeeService;
    private final PurchaseContractManagerRepo purchaseContractManagerRepo;
    // private final PrdAbRepo prdAbRepo;

//    @Value("${tw4.url}")
//    private String tw4_url;

    @Value("${tw4.sale.contractProcurDemand}")
    private String contractProcurDemand;

    @Override
    public PagingVO<ConPurchaseDemandVO> paging(ConPurchaseDemandQuery query) {
        Page<ConPurchaseDemandDO> page = conPurchaseDemandRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(ConPurchaseDemandConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<ConPurchaseDemandVO> queryPaging(ConPurchaseDemandQuery query) {
        return conPurchaseDemandDAO.queryPaging(query);
    }

    @Override
    public List<ConPurchaseDemandVO> queryList(ConPurchaseDemandQuery query) {
        return ConPurchaseDemandConvert.INSTANCE.toVoList(
                conPurchaseDemandRepo.findAll(
                        (root, criteriaQuery, criteriaBuilder)
                                -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                        , query.getPageRequest().getSort()
                )
        );
    }

    @Override
    public List<ConPurchaseDemandVO> queryListDynamic(ConPurchaseDemandQuery query) {
        return conPurchaseDemandDAO.queryListDynamic(query);
    }

    @Override
    public ConPurchaseDemandVO queryByKey(Long key) {
        ConPurchaseDemandDO entity = conPurchaseDemandRepo.findById(key).orElseGet(ConPurchaseDemandDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConPurchaseDemandVO vo = ConPurchaseDemandConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConPurchaseDemandVO insert(ConPurchaseDemandPayload payload) {
        ConPurchaseDemandDO entityDo = ConPurchaseDemandConvert.INSTANCE.toDo(payload);
        String code = generateSeqNum("CON_PUR_DEMAND");
        entityDo.setCode(code);
        ConPurchaseDemandDO save = conPurchaseDemandRepo.save(entityDo);
        BigDecimal demandTotalAmt = BigDecimal.ZERO;    //需求总金额
        // 新增明细
        payload.setId(save.getId());
        List<ConPurchaseDemandDVO> conPurchaseDemandDVOS = insertOrUpdateDemandD(payload);
        for (ConPurchaseDemandDVO conPurchaseDemandDVO : conPurchaseDemandDVOS) {
            if (conPurchaseDemandDVO.getNotTaxAmt() != null) {
                demandTotalAmt = demandTotalAmt.add(conPurchaseDemandDVO.getNotTaxAmt());
            }
        }
        // 判断需求总金额是否发生了变化 -- 发生变化就修改子合同的有效合同金额
        if (demandTotalAmt.compareTo(BigDecimal.ZERO) != 0) {
            SaleConContractService saleConContractService = SpringUtil.getBean(SaleConContractService.class);
            // 查询所对应的子合同
            SaleConContractVO saleConContractVO = saleConContractService.queryByKey(payload.getSaleConId());
//            BigDecimal effectiveAmt = ObjectUtils.isEmpty(saleConContractVO.getEffectiveAmt()) ? BigDecimal.ZERO : saleConContractVO.getEffectiveAmt(); //子合同有效合同金额
//            BigDecimal newEffectiveAmt = effectiveAmt.subtract(demandTotalAmt);

            BigDecimal newEffectiveAmt = saleConContractVO.getNotTaxAmt().subtract(demandTotalAmt).subtract(saleConContractVO.getExtraAmt());
            BigDecimal sysGross = this.calcSysGross(saleConContractVO, demandTotalAmt);
            //修改子合同有效合同金额与系统毛利率
            conPurchaseDemandDAO.updateSubConEffectiveAmt(newEffectiveAmt, payload.getSaleConId(), sysGross);
        }
        return ConPurchaseDemandConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConPurchaseDemandVO update(ConPurchaseDemandPayload payload) {
        ConPurchaseDemandDO entity = conPurchaseDemandRepo.findById(payload.getId()).orElseGet(ConPurchaseDemandDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BigDecimal demandTotalAmt = BigDecimal.ZERO;    //需求总金额
        // 修改明细
        List<ConPurchaseDemandDVO> conPurchaseDemandDVOS = insertOrUpdateDemandD(payload);
        for (ConPurchaseDemandDVO conPurchaseDemandDVO : conPurchaseDemandDVOS) {
            if (conPurchaseDemandDVO.getNotTaxAmt() != null) {
                demandTotalAmt = demandTotalAmt.add(conPurchaseDemandDVO.getNotTaxAmt());
            }
        }
        ConPurchaseDemandDO entityDo = ConPurchaseDemandConvert.INSTANCE.toDo(payload);
        SaleConContractService saleConContractService = SpringUtil.getBean(SaleConContractService.class);
        // 查询所对应的子合同
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(payload.getSaleConId());
        BigDecimal effectiveAmt = saleConContractVO.getEffectiveAmt(); //子合同有效合同金额
//        BigDecimal oldDemandTotalAmt = entityDo.getDemandTotalAmt() == null ? BigDecimal.ZERO : entityDo.getDemandTotalAmt();
//        BigDecimal newEffectiveAmt = effectiveAmt.subtract(demandTotalAmt).add(oldDemandTotalAmt);
        BigDecimal newEffectiveAmt = saleConContractVO.getNotTaxAmt().subtract(demandTotalAmt).subtract(saleConContractVO.getExtraAmt());

        //重新计算系统毛利率  系统核算毛利率=(不含税金额 - 相关项目采购(不含税额) - 估算当量*2000 - 估算费用)/不含税金额
        BigDecimal sysGross = this.calcSysGross(saleConContractVO, demandTotalAmt);
        //修改子合同有效合同金额与系统毛利率
        conPurchaseDemandDAO.updateSubConEffectiveAmt(newEffectiveAmt, payload.getSaleConId(), sysGross);
        entityDo.setDemandTotalAmt(demandTotalAmt);
        entity.copy(entityDo);
        return ConPurchaseDemandConvert.INSTANCE.toVo(conPurchaseDemandRepo.save(entity));
    }

    /**
     * 计算系统毛利率
     *
     * @param saleConContractVO
     * @param demandTotalAmt
     * @return
     */
    private BigDecimal calcSysGross(SaleConContractVO saleConContractVO, BigDecimal demandTotalAmt) {
        BigDecimal sysGross = null;
//        if (!ObjectUtils.isEmpty(saleConContractVO.getSysGross())) {
            BigDecimal ratedEqva = ObjectUtils.isEmpty(saleConContractVO.getRatedEqva()) ? BigDecimal.ZERO : saleConContractVO.getRatedEqva();
            BigDecimal ratedEqvaAmt = new BigDecimal(2000).multiply(ratedEqva);
            BigDecimal ratedExpense = ObjectUtils.isEmpty(saleConContractVO.getRatedExpense()) ? BigDecimal.ZERO : saleConContractVO.getRatedExpense();
            BigDecimal notTaxAmt = saleConContractVO.getNotTaxAmt();
            notTaxAmt = notTaxAmt.subtract(demandTotalAmt).subtract(ratedEqvaAmt).subtract(ratedExpense);
            sysGross = notTaxAmt.divide(saleConContractVO.getNotTaxAmt(), 4, RoundingMode.HALF_UP);
//        }
        return sysGross;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conPurchaseDemandDAO.deleteSoft(keys);
        }
    }

    @Override
    public ConPurchaseDemandVO queryBySaleConId(Long saleConId) {
        ConPurchaseDemandVO vo = conPurchaseDemandDAO.queryBySaleConId(saleConId);
        if (vo == null) {
            return null;
        }
        //根据需求id查询需求详情列表
        List<ConPurchaseDemandDVO> dvoList = purDemandDService.queryByPurDemandId(vo.getId());
        vo.setConPurchaseDemandDVOS(dvoList);
//        BigDecimal demandTotalAmt = BigDecimal.ZERO;
//        for (ConPurchaseDemandDVO dvo : dvoList) {
//            if (dvo.getTaxAmt() != null) {
//                demandTotalAmt = demandTotalAmt.add(dvo.getTaxAmt());
//
//            }
//        }
//        //设置需求总金额
//        vo.setDemandTotalAmt(demandTotalAmt);
        return vo;
    }

//    @Override
//    public void syncPurcDemandTo4(String param) {
//        String syncType = "purc_demand_to4";
//        LocalDateTime syncTime;
//        if (StringUtils.hasText(param)) {
//            syncTime = LocalDateTime.parse(param);
//        } else {
//            syncTime = daoLog.queryOrgSyncLog(syncType);
//            if (syncTime == null) {
//                syncTime = LocalDateTime.of(2023, 7, 1, 0, 0);
//            } else {
//                //将同步时间提前10秒，防止拉数据遗漏
//                syncTime = syncTime.minusSeconds(120);
//            }
//        }
//        XxlJobLogger.log("采购需求同步到4.0开始...");
//        XxlJobLogger.log("syncPurcDemandTo4 localDateTime：" + syncTime);
//
//        // 查询待同步数据
//        String format = DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss");
//        List<ConPurchaseDemandDO> querySyncDatas = conPurchaseDemandRepo.findByModifyTimeStart(format);
//
//        // 同步内容
//        String syncData = "";
//        LocalDateTime syncNow = LocalDateTime.now();
//        if (!ObjectUtils.isEmpty(querySyncDatas)) {
//            Map<Long, Long> V5ToV4ProductIdMap = prdProductRepo.findAll().stream().collect(Collectors.toMap(PrdProductDO::getId, e -> e.getProductIdV4() == null ? -999L : e.getProductIdV4(), (key1, key2) -> key2));
//            Map<Long, Long> V5ToV4ProductClassMap = prdProductClassRepo.findAll().stream().collect(Collectors.toMap(PrdProductClassDO::getId, e -> e.getProductClassIdV4() == null ? -999L : e.getProductClassIdV4(), (key1, key2) -> key2));
//            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
//            Map<Long, Long> v4AndV5PurMap;
//            if (purchaseContractManagerRepo.findAll() != null) {
//                v4AndV5PurMap = purchaseContractManagerRepo.findAll().stream().collect(Collectors.toMap(PurchaseContractManagerDO::getId, e -> e.getPurchaseContractIdV4() == null ? -999L : e.getPurchaseContractIdV4(), (key1, key2) -> key2));
//            } else {
//                v4AndV5PurMap = null;
//            }
//
//            Map<String, PrdAbDO> abMap = prdAbRepo.findAll().stream().collect(Collectors.toMap(PrdAbDO::getBookNo, e -> e, (k1, k2) -> k1));
//
//            // 组装同步的数据
//            List<TwProcurDemandEntity> copy = new ArrayList<>();
//            for (ConPurchaseDemandDO tempDo : querySyncDatas) {
//                TwProcurDemandEntity e = new TwProcurDemandEntity();
//                // 查询需求明细表
//                List<ConPurchaseDemandDDO> conPurchaseDemandDVOS = conPurchaseDemandDRepo.findConPurchaseDDOByID(tempDo.getId());
//                if (!ObjectUtils.isEmpty(conPurchaseDemandDVOS)) {
//                    // 转换时间
//                    if (conPurchaseDemandDVOS.get(0).getDemandDate() != null) {
//                        LocalDate date = conPurchaseDemandDVOS.get(0).getDemandDate();
//                        Instant instant = date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
//                        e.setDemandData(DateUtil.format(Date.from(instant), "yyyy-MM-dd HH:mm:ss"));
//                    }
//                    e.setEdemandResId(v4AndV5UserIds.get(conPurchaseDemandDVOS.get(0).getDemandDirectorUserId()));
//                    e.setDemandStatus(conPurchaseDemandDVOS.get(0).getDemandStatus());
//                    e.setDemandRem(conPurchaseDemandDVOS.get(0).getRemark());
//                    // 明细表
//                    List<TwProcurDemandDView> detail = new ArrayList<>();
//                    conPurchaseDemandDVOS.stream().forEach(item -> {
//                        TwProcurDemandDView view = new TwProcurDemandDView();
//                        view.setDemandDIdV5(item.getId());
//                        view.setDemandDIdV4(item.getDemandDetailIdV4());
//                        PrdAbDO prdAbDO = abMap.get(item.getSupplierId() + "");
//                        if (prdAbDO != null) {
//                            view.setSupplierId(prdAbDO.getBookIdV4());
//                        }
//                        view.setDemandSaid(item.getDemandSaid());
//                        view.setBuProdId(V5ToV4ProductIdMap.get(item.getProductId()));
//                        view.setClassId(V5ToV4ProductClassMap.get(item.getProductClassId()));
//                        view.setSubClassId(V5ToV4ProductClassMap.get(item.getProductSubClassId()));
//                        if (item.getDemandNum() != null) {
//                            view.setDemandNum(new BigDecimal(item.getDemandNum()));
//                        }
//                        view.setTaxPrice(item.getTaxPrice());
//                        view.setSymbol(item.getSymbol());
//                        if (item.getTaxRate() != null) {
//                            view.setTaxRate(item.getTaxRate().multiply(new BigDecimal(100)));
//                        }
//                        view.setTaxAmt(item.getTaxAmt());
//                        view.setTaxNotamt(item.getNotTaxAmt());
//                        if (!ObjectUtils.isEmpty(v4AndV5PurMap)) {
//                            view.setPurContractId(v4AndV5PurMap.get(item.getPurContractId()));
//                        }
//                        view.setDelFlag(item.getDeleteFlag());
//                        detail.add(view);
//                    });
//                    e.setProcurDemandDViews(detail);
//                }
//                e.setContractId(tempDo.getSaleConId());
//                e.setDemandNo(tempDo.getCode());
//                e.setDemandIdV5(tempDo.getId());
//                e.setDemandIdV4(tempDo.getPurDemandIdV4());
//                e.setDemandTotalAmo(tempDo.getDemandTotalAmt());
//                e.setDelFlag(tempDo.getDeleteFlag() == 0 ? false : true);
//                // 查询需求类别
//                SaleConContractVO saleConContractVO = saleConContractDAO.queryByKey(tempDo.getSaleConId());
//                if (saleConContractVO != null) {
//                    e.setDemandType(saleConContractVO.getDemandType());
//                }
//                copy.add(e);
//            }
//            // 循环调用同步新增接口
//            if (!ObjectUtils.isEmpty(copy)) {
//                int failNum = 0;
//                for (TwProcurDemandEntity temDo : copy) {
//                    LocalDateTime syncStartTime = LocalDateTime.now();
//                    try {
////                        Map<String, Object> map = BeanUtil.beanToMap(temDo);
////                        String resultMain = httpUtil.sendPost(tw4_url + contractProcurDemand, map);
////                        Map<String, Object> data = (Map) JSON.parse(resultMain);
//                        Map<String, Object> data = new HashMap<>();
//                        if (!(data.get("ok") + "").equals("true")) {
//                            throw new Exception();
//                        }
//                    } catch (Exception e) {
//                        XxlJobLogger.log("采购需求" + temDo.getDemandIdV5() + "同步异常......" + e);
//                        LocalDateTime syncEndTime = LocalDateTime.now();
//                        this.saveSyncLog(syncType + "_exception", "采购需求id" + temDo.getDemandIdV5() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e, null);
//                        failNum++;
//                        //更新该条合同的更新时间，下一次处理;
//                        conPurchaseDemandRepo.updateRemark(temDo.getDemandIdV5());
//                    }
//                }
//                syncData = "更新了" + (copy.size() - failNum) + "数据,有" + failNum + "条数据更新失败！";
//            } else {
//                syncData = "采购需求数据未变化";
//            }
//        } else {
//            syncData = "采购需求数据未变化";
//        }
//        // 记录同步日志
//        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
//        XxlJobLogger.log("同步采购需求结束..." + logDO);
//    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        return logDO;
    }

    /**
     * 新增或者修改明细判断
     *
     * @param payload
     */
    private List<ConPurchaseDemandDVO> insertOrUpdateDemandD(ConPurchaseDemandPayload payload) {

        List<ConPurchaseDemandDPayload> purDemandDPayloadList = payload.getPurDemandDPayloadList();
        //新增或者修改后的VO列表
        List<ConPurchaseDemandDVO> conPurchaseDemandDVOS = new ArrayList<>();
        Optional.ofNullable(purDemandDPayloadList).ifPresent(list -> {
            for (ConPurchaseDemandDPayload demandDPayload : list) {
                demandDPayload.setPurDemandId(payload.getId());
                if (ObjectUtils.isEmpty(demandDPayload.getId()) || demandDPayload.getId() < 0) {
                    ConPurchaseDemandDVO insert = purDemandDService.insert(demandDPayload);
                    conPurchaseDemandDVOS.add(insert);
                } else {
                    ConPurchaseDemandDVO update = purDemandDService.update(demandDPayload);
                    conPurchaseDemandDVOS.add(update);
                }
            }
        });
        return conPurchaseDemandDVOS;
    }
}
