package com.elitesland.tw.tw5.server.prd.system.constant;

import lombok.Getter;

/**
 * 系统设置项枚举
 *
 * @author likunpeng
 * @date 2023/12/20
 */
public enum SystemSettingsItemEnum {

    SYS_WARM_RECV_DT_LT("SYS_WARM_RECV_DT_LT", "系统自动提醒临近收款计划的提前天数"),
    MAX_RECV_DT_DELAYDAYS("MAX_RECV_DT_DELAYDAYS", "收款计划预计收款日期调整最大天数(未开票)"),
    MAX_RECV_DT_DELAYDAYS_2("MAX_RECV_DT_DELAYDAYS_2", "收款计划预计收款日期调整最大天数(已开票)"),
    MAX_CHAGE_RECE_DATE("MAX_CHAGE_RECE_DATE", "调整合同收款日期最大次数"),
    prj_member_init_task("prj_member_init_task", "项目成员自动初始化任务包"),
    ;

    @Getter
    private final String code;
    @Getter
    private final String desc;

    SystemSettingsItemEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
