package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_system_tag", indexes = {@Index(name = "function_index", columnList = "function_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_system_tag", comment = "系统标签表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemTagDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Comment("功能ID")
    @Column(name = "function_id")
    private Long functionId;

    @Comment("标签KEY")
    @Column()
    private String tagKey;

    @Comment("标签名称")
    @Column()
    private String tagName;

    @Comment("标签内容国际化")
    @Column()
    private String tagNameLocale;

    @Comment("标签颜色")
    @Column()
    private String tagColor;

    @Comment("场景编号")
    @Column()
    private String sceneNo;

    @Comment("启用状态")
    @Column()
    private Boolean enabled;

    @Comment("排序号")
    @Column()
    private Integer sortIndex;


    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;
    private String extString6;
    private String extString7;
    private String extString8;
    private String extString9;
    private String extString10;
}
