package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionSpecialPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionSpecialQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFunctionSpecialService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFunctionSpecialConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFunctionSpecialDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionSpecialDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 标准样例service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemFunctionSpecialServiceImpl implements PrdSystemFunctionSpecialService {
    private final PrdSystemFunctionSpecialDAO dao;
    private final CacheUtil cacheUtil;

    @Transactional
    @Override
    public PrdSystemFunctionSpecialVO insert(PrdSystemFunctionSpecialPayload payload) {
        payload.setSpecialUrl(payload.getSpecialUrl().trim().toLowerCase());

        PrdSystemFunctionSpecialVO vo = dao.specialInspect(payload.getSpecialUrl());
        if (vo == null) {
            PrdSystemFunctionSpecialDO ado = PrdSystemFunctionSpecialConvert.INSTANCE.toDo(payload);
            dao.save(ado);
            cacheUtil.loadSystemFunctionSpecialCache();
            return PrdSystemFunctionSpecialConvert.INSTANCE.toVo(ado);
        } else {
            throw TwException.error("", "后端接口不可重复");
        }
    }

    @Transactional
    @Override
    public Long update(PrdSystemFunctionSpecialPayload payload) {
        payload.setSpecialUrl(payload.getSpecialUrl().trim().toLowerCase());

        PrdSystemFunctionSpecialVO vo = dao.specialInspect(payload.getSpecialUrl());
        if (vo == null) {
            dao.updateByKeyDynamic(payload);
            cacheUtil.loadSystemFunctionSpecialCache();
            return 0L;
        } else {
            if (payload.getId().equals(vo.getId())) {
                dao.updateByKeyDynamic(payload);
                cacheUtil.loadSystemFunctionSpecialCache();
                return 0L;
            }
        }
        throw TwException.error("", "后端接口不可重复");
    }

    @Transactional
    @Override
    public boolean delete(List<Long> keys) {
        dao.delete(keys);
        cacheUtil.loadSystemFunctionSpecialCache();
        return true;
    }

    @Override
    public PagingVO<PrdSystemFunctionSpecialVO> paging(PrdSystemFunctionSpecialQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public PrdSystemFunctionSpecialVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    public List<PrdSystemFunctionSpecialVO> queryList(PrdSystemFunctionSpecialQuery query) {


        return dao.queryListDynamic(query);
    }
}
