package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdTemporaryStoragePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdTemporaryStorageQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdTemporaryStorageService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdTemporaryStorageVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdTemporaryStorageConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdTemporaryStorageDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdTemporaryStorageDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/7/1 - 16:51
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdTemporaryStorageServiceImpl implements PrdTemporaryStorageService {
    private final PrdTemporaryStorageDAO dao;

    @Override
    public PrdTemporaryStorageVO saveOne(PrdTemporaryStoragePayload payload) {
        PrdTemporaryStorageDO ado = PrdTemporaryStorageConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        return PrdTemporaryStorageConvert.INSTANCE.toVo(ado);
    }

    @Override
    public void dynamicUpdate(PrdTemporaryStoragePayload payload) {
        //执行更新
        dao.updateByKeyDynamic(payload);
    }

    @Override
    public List<PrdTemporaryStorageVO> queryList(PrdTemporaryStorageQuery query) {
        Specification<PrdTemporaryStorageDO> spec = dao.getSpec(query);
        List<PrdTemporaryStorageDO> all = dao.findAll(spec);
        return all.stream().map(e -> PrdTemporaryStorageConvert.INSTANCE.toVo(e)).collect(Collectors.toList());
    }

    @Override
    public Object paging(PrdTemporaryStorageQuery query) {
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
        query.setCreateUserId(userId);
        Specification<PrdTemporaryStorageDO> spec = dao.getSpec(query);
        Page<PrdTemporaryStorageDO> all = dao.findAll(spec, query.getPageRequest());
        List<PrdTemporaryStorageDO> content = all.getContent();
        List<PrdTemporaryStorageVO> collect = content.stream().map(e -> PrdTemporaryStorageConvert.INSTANCE.toVo(e)).collect(Collectors.toList());
        //类型转化
        all.getTotalPages();
        PagingVO pagingVO = new PagingVO<>(all.getTotalElements(), collect);
        return pagingVO;
    }

    @Override
    public PrdTemporaryStorageVO queryDetail(Long id) {
        PrdTemporaryStorageDO detail = dao.queryById(id);
        PrdTemporaryStorageVO temporaryStorageVO = PrdTemporaryStorageConvert.INSTANCE.toVo(detail);
        return temporaryStorageVO;
    }

    @Override
    public void deleteTemporaryStorageSoft(List<Long> storageIds) {
        dao.deleteSoft(storageIds);
    }
}
