package com.elitesland.tw.tw5.server.provider.event.support;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serial;
import java.io.Serializable;
import java.time.Duration;

/**
 * 事件的属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/14
 */
@Data
@ConfigurationProperties(prefix = "elitesland.project.tw.event")
public class EventProperties implements Serializable {
    @Serial
    private static final long serialVersionUID = -3705492478112130871L;

    /**
     * 是否启用事件处理
     */
    private Boolean enabled = true;

    /**
     * 处理失败后的重试次数
     */
    private Integer retryTimes = 3;

    /**
     * 失败后下次重试的时间间隔
     */
    private Duration retryInterval = Duration.ofSeconds(5);

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Duration getRetryInterval() {
        return retryInterval;
    }

    public void setRetryInterval(Duration retryInterval) {
        this.retryInterval = retryInterval;
    }
}
