package com.elitesland.tw.tw5.server.udc;

import lombok.Getter;

/**
 * udc枚举类型
 *
 * @author duwh
 * @date 2022/11/16
 */
public enum UdcTypeEnum {

    USER("USER", "用户翻译"),
    BU("BU", "部门翻译"),
    /**
     * 业务伙伴翻译-需要传bookId
     * 翻译支持：内部公司、供应商、客户、合作伙伴
     */
    BOOK("BOOK", "业务伙伴翻译-需要传bookId"),
    OPENSEA("OPENSEA","公海翻译"),
    OFFSHORE("OFFSHORE","公海翻译")
    ;

    @Getter
    private String code;
    /**
     * 描述
     */
    @Getter
    private String desc;

    UdcTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
