/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmTripTicketPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmTripTicketQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmTripTicketService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.inv.common.InvoiceReimStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/ACC_TRIP_TICKET/callBack"})
@Transactional
public class AccReimTripTicketCallbackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(AccReimTripTicketCallbackController.class);
    private final AccReimService accReimService;
    private final InvInvoiceService invInvoiceService;
    private final AdmTripTicketService admTripTicketService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        Long reimId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        AccReimPayload accReimPayload = new AccReimPayload();
        accReimPayload.setId(reimId);
        AccReimVO accReimVO = this.accReimService.queryOneByKey(reimId);
        if (!ObjectUtils.isEmpty((Object)accReimVO)) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    accReimPayload.setApprStatus(ProcInstStatus.NOTSUBMIT.name());
                    break;
                }
                case INTERRUPT: {
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    break;
                }
                case INVALID: {
                    accReimPayload.setApprStatus(ProcInstStatus.INVALID.name());
                    accReimPayload.setDeleteFlag(Integer.valueOf(1));
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    break;
                }
                case REJECTED: {
                    accReimPayload.setApprStatus(ProcInstStatus.REJECTED.name());
                    break;
                }
                case APPROVED: {
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVED.name());
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.APPROVED.getCode());
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_PAYMENT.getCode());
                    this.tripTicketRelease(reimId);
                    break;
                }
                case APPROVING: {
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVING.name());
                }
            }
            this.accReimService.partialUpdate(accReimPayload);
        }
        return WorkflowResult.success(null);
    }

    private void tripTicketRelease(Long key) {
        String reimedStatus = "REIMED";
        AdmTripTicketQuery query = new AdmTripTicketQuery();
        query.setReimId(key);
        List admTripTicketVOS = this.admTripTicketService.queryListDynamic(query);
        if (ObjectUtils.isEmpty((Object)admTripTicketVOS)) {
            return;
        }
        List<Long> ticketIds = admTripTicketVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        ticketIds.forEach(ticketId -> {
            AdmTripTicketPayload payload = new AdmTripTicketPayload();
            payload.setId(ticketId);
            payload.setReimbursementStatus("REIMED");
            this.admTripTicketService.updateByKeyDynamic(payload);
        });
    }

    public AccReimTripTicketCallbackController(AccReimService accReimService, InvInvoiceService invInvoiceService, AdmTripTicketService admTripTicketService) {
        this.accReimService = accReimService;
        this.invInvoiceService = invInvoiceService;
        this.admTripTicketService = admTripTicketService;
    }
}

