/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccBudgetItemPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBudgetItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccBudgetItemService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccBudgetItemConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccBudgetItemDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccBudgetItemDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccBudgetItemRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AccBudgetItemServiceImpl
extends BaseServiceImpl
implements AccBudgetItemService {
    private static final Logger log = LoggerFactory.getLogger(AccBudgetItemServiceImpl.class);
    private final AccBudgetItemRepo accBudgetItemRepo;
    private final AccBudgetItemDAO accBudgetItemDAO;
    private final ExcelUtil excelUtil;
    private final UdcUtil udcUtil;
    private final TransactionUtilService transactionUtilService;

    public PagingVO<AccBudgetItemVO> queryPaging(AccBudgetItemQuery query) {
        return this.accBudgetItemDAO.queryPaging(query);
    }

    public List<AccBudgetItemVO> queryListDynamic(AccBudgetItemQuery query) {
        return this.accBudgetItemDAO.queryListDynamic(query);
    }

    public AccBudgetItemVO queryByKey(Long key) {
        return this.accBudgetItemDAO.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public AccBudgetItemVO insert(AccBudgetItemPayload payload) {
        this.checkData(payload);
        List<Long> ids = this.accBudgetItemDAO.queryByCodeAndName(payload.getBudgetCode(), payload.getBudgetName());
        if (ObjectUtils.isEmpty(ids)) {
            if (!StringUtils.hasText((String)payload.getBudgetStatus())) {
                payload.setBudgetStatus("ACTIVE");
            }
            payload.setBudgetLevel(Integer.valueOf(1));
            if (!ObjectUtils.isEmpty((Object)payload.getParentId())) {
                AccBudgetItemVO accBudgetItemVO = this.accBudgetItemDAO.queryByKey(payload.getParentId());
                payload.setBudgetLevel(Integer.valueOf(accBudgetItemVO.getBudgetLevel() + 1));
            }
            AccBudgetItemDO entityDo = AccBudgetItemConvert.INSTANCE.toDo(payload);
            return AccBudgetItemConvert.INSTANCE.toVo((AccBudgetItemDO)this.accBudgetItemRepo.save(entityDo));
        }
        throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
    }

    void checkData(AccBudgetItemPayload payload) {
        if (!StringUtils.hasText((String)payload.getBudgetCode()) || !StringUtils.hasText((String)payload.getBudgetName())) {
            throw TwException.error("", "\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccBudgetItemPayload payload) {
        List<Long> ids = this.accBudgetItemDAO.queryByCodeAndName(payload.getBudgetCode(), payload.getBudgetName());
        if (ObjectUtils.isEmpty(ids) || ids.size() == 1 && ids.get(0).equals(payload.getId())) {
            payload.setBudgetLevel(Integer.valueOf(1));
            if (!ObjectUtils.isEmpty((Object)payload.getParentId())) {
                AccBudgetItemVO accBudgetItemVO = this.accBudgetItemDAO.queryByKey(payload.getParentId());
                payload.setBudgetLevel(Integer.valueOf(accBudgetItemVO.getBudgetLevel() + 1));
            }
            long result = this.accBudgetItemDAO.updateByKeyDynamic(payload);
            return result;
        }
        throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accBudgetItemDAO.deleteSoft(keys);
        }
    }

    public void downloadPlus(HttpServletResponse response, AccBudgetItemQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/accBudgetItem.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u79d1\u76ee\u6570\u636e");
            this.excelUtil.generateRangeList(batchProjectSheet, 4, 1, "LOV", 2, "C");
            this.excelUtil.generateRangeList(batchProjectSheet, 9, 1, "LOV", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 3, 1, "\u79d1\u76ee\u6570\u636e", 2, "C");
            String fileName = "\u9884\u7b97\u9879\u76ee\u6570\u636e-" + LocalDate.now();
            Boolean isHave = false;
            if (!StringUtils.hasText((String)query.getDownloadType()) || query.getDownloadType().equals("data")) {
                List accBudgetItemVOS = this.accBudgetItemDAO.queryListDynamic(query);
                if (!ObjectUtils.isEmpty(accBudgetItemVOS)) {
                    accBudgetItemVOS = this.udcUtil.translateList(accBudgetItemVOS);
                    isHave = true;
                    int nextRow = 1;
                    for (AccBudgetItemVO accBudgetItemVO : accBudgetItemVOS) {
                        XSSFRow row = batchProjectSheet.createRow(nextRow);
                        Optional<AccBudgetItemVO> first = accBudgetItemVOS.stream().filter(vo -> vo.getId().equals(accBudgetItemVO.getParentId())).findFirst();
                        if (first.isPresent()) {
                            this.excelUtil.setCellValue((Row)row, 3, first.get().getBudgetName());
                        }
                        this.excelUtil.setCellValue((Row)row, 0, nextRow);
                        this.excelUtil.setCellValue((Row)row, 1, accBudgetItemVO.getBudgetCode());
                        this.excelUtil.setCellValue((Row)row, 2, accBudgetItemVO.getBudgetName());
                        this.excelUtil.setCellValue((Row)row, 4, accBudgetItemVO.getBudgetStatusDesc());
                        this.excelUtil.setCellValue((Row)row, 5, accBudgetItemVO.getBudgetType1());
                        this.excelUtil.setCellValue((Row)row, 6, accBudgetItemVO.getBudgetType2());
                        this.excelUtil.setCellValue((Row)row, 7, accBudgetItemVO.getBudgetType3());
                        this.excelUtil.setCellValue((Row)row, 8, accBudgetItemVO.getDtlAcc());
                        String sumFlag = "\u662f";
                        if (accBudgetItemVO.getSumFlag() == null || accBudgetItemVO.getSumFlag() == 0) {
                            sumFlag = "\u5426";
                        }
                        this.excelUtil.setCellValue((Row)row, 9, sumFlag);
                        this.excelUtil.setCellValue((Row)row, 10, accBudgetItemVO.getLedgerType());
                        this.excelUtil.setCellValue((Row)row, 11, accBudgetItemVO.getRemark());
                        ++nextRow;
                    }
                }
            } else {
                fileName = "\u9884\u7b97\u9879\u76ee\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
            }
            if (!isHave.booleanValue()) {
                this.excelUtil.setColumnFormulas(batchProjectSheet, 12, "VLOOKUP(D:rowNo,B:C,1,FALSE)");
                this.excelUtil.setColumnFormulas(batchProjectSheet, 13, "VLOOKUP(E:rowNo,LOV!C:D,2,FALSE)");
                this.excelUtil.setColumnFormulas(batchProjectSheet, 14, "VLOOKUP(J:rowNo,LOV!A:B,2,FALSE)");
            }
            batchProjectSheet.setColumnHidden(12, true);
            batchProjectSheet.setColumnHidden(13, true);
            batchProjectSheet.setColumnHidden(14, true);
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean batchImport(MultipartFile file) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u79d1\u76ee\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<CallSite> codeNames = new ArrayList<CallSite>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<AccBudgetItemPayload> accBudgetItemPayloads = new ArrayList<AccBudgetItemPayload>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            String sumFlag;
            Row row = sheet.getRow(i);
            String accCode = ExcelUtil.getCellFormatValue(row.getCell(1));
            String accName = ExcelUtil.getCellFormatValue(row.getCell(2));
            if (!StringUtils.hasText((String)accCode) || !StringUtils.hasText((String)accName)) break;
            map.put(accName, accCode);
            String codeStr = "," + accCode + ",";
            String nameStr = "," + accName + ",";
            if (codeNames.contains(codeStr) || codeNames.contains(nameStr)) {
                throw TwException.error("", "\u79d1\u76ee\u7f16\u53f7\u6216\u540d\u79f0\u4e0d\u53ef\u91cd\u590d:\u3010" + accCode + "-" + accName + "\u3011");
            }
            codeNames.add((CallSite)((Object)codeStr));
            codeNames.add((CallSite)((Object)nameStr));
            String upperName = ExcelUtil.getCellFormatValue(row.getCell(3));
            String accType1 = ExcelUtil.getCellFormatValue(row.getCell(5));
            String accType2 = ExcelUtil.getCellFormatValue(row.getCell(6));
            String accType3 = ExcelUtil.getCellFormatValue(row.getCell(7));
            String dtlAcc = ExcelUtil.getCellFormatValue(row.getCell(8));
            String ledgerType = ExcelUtil.getCellFormatValue(row.getCell(10));
            String remark = ExcelUtil.getCellFormatValue(row.getCell(11));
            String upperCode = ExcelUtil.getCellFormatValue(row.getCell(12));
            String accStatus = ExcelUtil.getCellFormatValue(row.getCell(13));
            if (!StringUtils.hasText((String)accStatus)) {
                accStatus = "ACTIVE";
            }
            if (!StringUtils.hasText((String)(sumFlag = ExcelUtil.getCellFormatValue(row.getCell(14))))) {
                sumFlag = "0";
            }
            AccBudgetItemPayload accBudgetItemPayload2 = new AccBudgetItemPayload();
            accBudgetItemPayload2.setBudgetName(accName);
            accBudgetItemPayload2.setBudgetCode(accCode);
            accBudgetItemPayload2.setBudgetStatus(accStatus);
            accBudgetItemPayload2.setParentCode(upperCode);
            accBudgetItemPayload2.setParentName(upperName);
            accBudgetItemPayload2.setBudgetType1(accType1);
            accBudgetItemPayload2.setBudgetType2(accType2);
            accBudgetItemPayload2.setBudgetType3(accType3);
            accBudgetItemPayload2.setLedgerType(ledgerType);
            accBudgetItemPayload2.setDtlAcc(dtlAcc);
            accBudgetItemPayload2.setSumFlag(Integer.valueOf(sumFlag));
            accBudgetItemPayload2.setRemark(remark);
            if (!StringUtils.hasText((String)upperName) && !StringUtils.hasText((String)upperCode)) {
                accBudgetItemPayload2.setBudgetLevel(Integer.valueOf(1));
            }
            accBudgetItemPayloads.add(accBudgetItemPayload2);
        }
        ArrayList<AccBudgetItemDO> accBudgetItemDOs = new ArrayList<AccBudgetItemDO>();
        accBudgetItemPayloads.forEach(accBudgetItemPayload -> {
            String upperName = accBudgetItemPayload.getParentName();
            String upperCode = accBudgetItemPayload.getParentCode();
            if (StringUtils.hasText((String)upperName)) {
                if (!StringUtils.hasText((String)upperCode)) {
                    accBudgetItemPayload.setParentCode((String)map.get(upperName));
                }
                this.setLevel((List<AccBudgetItemPayload>)accBudgetItemPayloads, (AccBudgetItemPayload)accBudgetItemPayload);
            }
            accBudgetItemDOs.add(AccBudgetItemConvert.INSTANCE.toDo((AccBudgetItemPayload)accBudgetItemPayload));
        });
        List<AccBudgetItemDO> accBudgetItemDOS = this.accBudgetItemDAO.saveAll(accBudgetItemDOs);
        ArrayList updataDOs = new ArrayList();
        accBudgetItemDOS.forEach(accBudgetItemDO -> {
            if (StringUtils.hasText((String)accBudgetItemDO.getParentCode())) {
                AccBudgetItemDO updataDO = accBudgetItemDOS.stream().filter(masPayload -> masPayload.getBudgetCode().equals(accBudgetItemDO.getParentCode())).findFirst().get();
                accBudgetItemDO.setParentId(updataDO.getId());
                updataDOs.add(accBudgetItemDO);
            }
        });
        this.transactionUtilService.executeWithRunnable(() -> this.accBudgetItemDAO.saveAll(updataDOs));
        return true;
    }

    void setLevel(List<AccBudgetItemPayload> accBudgetItemPayloads, AccBudgetItemPayload accBudgetItemPayload) {
        Optional<AccBudgetItemPayload> optional = accBudgetItemPayloads.stream().filter(masPayload -> masPayload.getBudgetCode().equals(accBudgetItemPayload.getParentCode())).findFirst();
        if (optional.isPresent()) {
            AccBudgetItemPayload payload = optional.get();
            if (payload.getBudgetLevel() == null) {
                this.setLevel(accBudgetItemPayloads, payload);
            }
            accBudgetItemPayload.setBudgetLevel(Integer.valueOf(payload.getBudgetLevel() + 1));
        } else {
            accBudgetItemPayload.setBudgetLevel(Integer.valueOf(1));
        }
    }

    public AccBudgetItemServiceImpl(AccBudgetItemRepo accBudgetItemRepo, AccBudgetItemDAO accBudgetItemDAO, ExcelUtil excelUtil, UdcUtil udcUtil, TransactionUtilService transactionUtilService) {
        this.accBudgetItemRepo = accBudgetItemRepo;
        this.accBudgetItemDAO = accBudgetItemDAO;
        this.excelUtil = excelUtil;
        this.udcUtil = udcUtil;
        this.transactionUtilService = transactionUtilService;
    }
}

