/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.bank.feign.payload.PayListPayload;
import com.elitesland.tw.tw5.api.bank.feign.payload.PayPayload;
import com.elitesland.tw.tw5.api.bank.feign.service.TwBankPayService;
import com.elitesland.tw.tw5.api.bank.vo.BkPayDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimDetailMealPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimJdePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayBatchPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourcePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceRecordPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTaxPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccFinancialSubjectQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimDetailMealQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimPayBatchQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSourceConfigQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSourceRecordQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTripStdQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccFinancialSubjectService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimDetailMealService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimPayBatchService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimRuleService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingContinuousService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingLimitService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingOverdueService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingTitleService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSourceConfigService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSourceRecordService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimTaxService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimTripStdService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccFinancialSubjectVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailMealVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimExportVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimPayBatchVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimPrintDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimPrintVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingContinuousVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingLimitVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingTitleVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSourceConfigVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSourceRecordVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTripStdVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmTripTicketPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmTripTicketQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmTripTicketService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyVO;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyVO;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoicePayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.BkPayDetailRecordPayload;
import com.elitesland.tw.tw5.api.prd.pay.payload.TDocHistPayload;
import com.elitesland.tw.tw5.api.prd.pay.service.BkPayDetailRecordService;
import com.elitesland.tw.tw5.api.prd.pay.service.TDocHistService;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConDService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinPeriodQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFinPeriodService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinPeriodVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccBudgetEnableStatusEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccPayBatchTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimPayModeEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimTaskKey;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimDetailConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDetailDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimDetailDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.OrgEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConWorkTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.inv.common.InvoiceReimStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@RefreshScope
public class AccReimServiceImpl
extends BaseServiceImpl
implements AccReimService {
    private static final Logger log = LoggerFactory.getLogger(AccReimServiceImpl.class);
    private static String ACCOUNT_SUBJECT_NAME = "\u8d39\u7528";
    private static String BANK_SUBJECT_NAME = "\u94f6\u884c\u5b58\u6b3e-\u62db\u884c";
    @Value(value="${tw5.reim.limitAmt:1000}")
    private BigDecimal reimLimitAmt;
    @Value(value="${tw5.reim.businessLimitAmt:1000}")
    private BigDecimal businessLimitAmt;
    @Value(value="${tw5.reim.trip.breakfastScale:0.2}")
    private BigDecimal breakfastScale;
    @Value(value="${tw5.reim.trip.lunchScale:0.4}")
    private BigDecimal lunchScale;
    @Value(value="${tw5.reim.trip.dinnerScale:0.4}")
    private BigDecimal dinnerScale;
    @Value(value="${tw5.payment.platform:TW5}")
    private String platform;
    @Value(value="${tw5.payment.bank:CMB}")
    private String bank;
    @Value(value="${tw5.payment.secretKey:123456}")
    private String secretKey;
    @Value(value="${tw5.reim.taxAccCode:222100101}")
    private String taxAccCode;
    @Value(value="${tw5.workflow.saleOrgId}")
    private Long saleOrgId;
    private final AccReimRepo repo;
    private final AccReimDAO dao;
    private final AccReimDetailDAO detailDAO;
    private final BudgetService budgetService;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;
    private final PmsProjectService projectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final AccReimPayBatchService reimPayBatchService;
    private final AccReimSourceConfigService reimSourceConfigService;
    private final PrdOrgEmployeeService employeeService;
    private final AccReimTripStdService accReimTripStdService;
    private final AccReimTaxService accReimTaxService;
    private final InvInvoiceService invInvoiceService;
    private final TransactionUtilService transactionUtilService;
    private final ExcelUtil excelUtil;
    private final AdmBusitripApplyService busitripApplyService;
    private final AdmFeeApplyService feeApplyService;
    private final AccReimSourceRecordService reimSourceRecordService;
    private final BudgetCommonService budgetCommonService;
    private final AdmTripTicketService admTripTicketService;
    private final ConEpibolyCostConDService conEpibolyCostConDService;
    private final TDocHistService tDocHistService;
    private final PrdSystemRoleService roleService;
    @Resource
    private TwBankPayService payService;
    private final BookAccountService bookAccountService;
    private final BusinessPartnerService businessPartnerService;
    private final BkPayDetailRecordService bkPayDetailRecordService;
    private final PrdOrgOrganizationService orgOrganizationService;
    private final PrdSystemFinPeriodService finPeriodService;
    private final AccReimRuleService reimRuleService;
    private final AccFinancialSubjectService accFinancialSubjectService;
    private final FileUtil fileUtil;
    private final AccReimSettingOverdueService accReimSettingOverdueService;
    private final AccReimSettingContinuousService accReimSettingContinuousService;
    private final AccReimSettingTitleService accReimSettingTitleService;
    private final AccReimSettingLimitService accReimSettingLimitService;
    private final AccReimDetailMealService accReimDetailMealService;

    @UdcNameClass
    public PagingVO<AccReimVO> queryPaging(AccReimQuery query) {
        PagingVO<AccReimVO> paging = this.dao.queryPaging(query);
        if (!ObjectUtils.isEmpty((Object)paging.getRecords())) {
            List<Long> masIds = paging.getRecords().stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<AccReimDetailVO> detailVOList = this.detailDAO.queryByMasIds(masIds);
            Map<Long, List<AccReimDetailVO>> detailVosGroup = detailVOList.stream().collect(Collectors.groupingBy(AccReimDetailVO::getMasId));
            block0: for (AccReimVO vo : paging.getRecords()) {
                String companyName = this.cacheUtil.getCompanyNameByBookId(vo.getExpenseCompany());
                vo.setExpenseCompanyName(companyName);
                List<AccReimDetailVO> detailVOS = detailVosGroup.get(vo.getId());
                if (ObjectUtils.isEmpty(detailVOS)) {
                    vo.setInvFlag(Boolean.valueOf(false));
                    continue;
                }
                for (AccReimDetailVO dtlVo : detailVOS) {
                    if (!ObjectUtils.isEmpty((Object)dtlVo.getInvoiceNum()) && dtlVo.getInvoiceNum() > 0) continue;
                    vo.setInvFlag(Boolean.valueOf(false));
                    continue block0;
                }
            }
        }
        return paging;
    }

    public List<AccReimVO> queryListDynamic(AccReimQuery query) {
        List<AccReimVO> voList = this.dao.queryListDynamic(query);
        if (ObjectUtils.isEmpty(voList)) {
            log.warn("\u5f53\u524d\u5165\u53c2\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a\uff0c\u5165\u53c2\u4fe1\u606f is {}", (Object)JSON.toJSONString((Object)query));
            return new ArrayList<AccReimVO>();
        }
        List<Long> masIds = voList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<AccReimDetailVO> detailVOList = this.detailDAO.queryByMasIds(masIds);
        Map<Long, List<AccReimDetailVO>> detailVosGroup = detailVOList.stream().collect(Collectors.groupingBy(AccReimDetailVO::getMasId));
        block0: for (AccReimVO vo : voList) {
            String companyName = this.cacheUtil.getCompanyNameByBookId(vo.getExpenseCompany());
            vo.setExpenseCompanyName(companyName);
            List<AccReimDetailVO> detailVOS = detailVosGroup.get(vo.getId());
            if (ObjectUtils.isEmpty(detailVOS)) {
                vo.setInvFlag(Boolean.valueOf(false));
                continue;
            }
            vo.setDetails(detailVOS);
            for (AccReimDetailVO dtlVo : detailVOS) {
                if (!ObjectUtils.isEmpty((Object)dtlVo.getInvoiceNum()) && dtlVo.getInvoiceNum() > 0) continue;
                vo.setInvFlag(Boolean.valueOf(false));
                continue block0;
            }
        }
        return voList;
    }

    @UdcNameClass
    public AccReimVO queryByKey(Long key) {
        BudgetVO budgetVO;
        AccReimVO accReimVO = this.dao.queryByKey(key);
        PrdOrgEmployeeVO employeeVO = this.cacheUtil.getEmployee(accReimVO.getReimUserId());
        if (!ObjectUtils.isEmpty((Object)employeeVO)) {
            if (!ObjectUtils.isEmpty((Object)employeeVO.getExtString5())) {
                String baseCityName = this.cacheUtil.transferSystemSelection("org:employee:serviceaddr", employeeVO.getExtString5());
                accReimVO.setBaseCityName(baseCityName);
            }
            if (!ObjectUtils.isEmpty((Object)employeeVO.getBookId())) {
                accReimVO.setBaseOuName(this.cacheUtil.getCompanyNameByBookId(employeeVO.getBookId()));
            }
            accReimVO.setResNo(employeeVO.getResNo());
        }
        String companyName = this.cacheUtil.getCompanyNameByBookId(accReimVO.getExpenseCompany());
        accReimVO.setExpenseCompanyName(companyName);
        if (!ObjectUtils.isEmpty((Object)accReimVO.getRelatedBudgetId()) && !ObjectUtils.isEmpty((Object)(budgetVO = this.budgetService.queryByKey(accReimVO.getRelatedBudgetId())))) {
            accReimVO.setSubjectTemplId(budgetVO.getSubjectTempId());
        }
        List<AccReimDetailVO> accReimDetailVOS = this.detailDAO.queryByMasId(key);
        for (AccReimDetailVO accReimDetailVO : accReimDetailVOS) {
            if (StringUtils.hasText((String)accReimDetailVO.getCostPayers())) {
                ArrayList<String> userNames = new ArrayList<String>();
                for (String sourceId : accReimDetailVO.getCostPayers().split(",")) {
                    String userName = this.cacheUtil.getUserName(Long.parseLong(sourceId));
                    userNames.add(userName);
                }
                String userName = String.join((CharSequence)",", userNames);
                accReimDetailVO.setCostPayersName(userName);
            }
            if (accReimDetailVO.getBusAccItemCode().equals("1005")) {
                AccReimDetailMealQuery accReimDetailMealQuery = new AccReimDetailMealQuery();
                accReimDetailMealQuery.setReimDetailId(accReimDetailVO.getId());
                List reimDetailMealVOS = this.accReimDetailMealService.queryListDynamic(accReimDetailMealQuery);
                accReimDetailVO.setReimDetailMealVOS(reimDetailMealVOS);
            }
            if (accReimDetailVO.getReimSettingOverdueId() != null) {
                AccReimSettingOverdueVO accReimSettingOverdueVO = this.accReimSettingOverdueService.queryByKey(accReimDetailVO.getReimSettingOverdueId());
                accReimDetailVO.setAccReimSettingOverdueVO(accReimSettingOverdueVO);
            }
            if (accReimDetailVO.getReimSettingContinousId() != null) {
                AccReimSettingContinuousVO accReimSettingContinuousVO = this.accReimSettingContinuousService.queryByKey(accReimDetailVO.getReimSettingContinousId());
                accReimDetailVO.setAccReimSettingContinuousVO(accReimSettingContinuousVO);
            }
            if (accReimDetailVO.getReimSettingLimitId() != null) {
                AccReimSettingLimitVO accReimSettingLimitVO = this.accReimSettingLimitService.queryByKey(accReimDetailVO.getReimSettingLimitId());
                accReimDetailVO.setAccReimSettingLimitVO(accReimSettingLimitVO);
            }
            if (accReimDetailVO.getReimSettingTitleId() == null) continue;
            AccReimSettingTitleVO accReimSettingTitleVO = this.accReimSettingTitleService.queryByKey(accReimDetailVO.getReimSettingTitleId());
            accReimDetailVO.setAccReimSettingTitleVO(accReimSettingTitleVO);
        }
        InvInvoiceQuery invoiceQuery = new InvInvoiceQuery();
        invoiceQuery.setReimId(key);
        List invInvoiceVOS = this.invInvoiceService.queryListDynamic(invoiceQuery);
        Map<Long, List<InvInvoiceVO>> invInvoiceGroup = invInvoiceVOS.stream().collect(Collectors.groupingBy(InvInvoiceVO::getReimDId));
        AccReimSourceRecordQuery sourceRecordQuery = new AccReimSourceRecordQuery();
        sourceRecordQuery.setReimId(key);
        List accReimSourceRecordVOS = this.reimSourceRecordService.queryListDynamic(sourceRecordQuery);
        Map<Long, List<AccReimSourceRecordVO>> sourceRecordGroup = accReimSourceRecordVOS.stream().collect(Collectors.groupingBy(AccReimSourceRecordVO::getReimDtlId));
        if (!ObjectUtils.isEmpty(accReimDetailVOS)) {
            accReimDetailVOS.forEach(detailVO -> {
                List sourceRecords;
                List invDetails = (List)invInvoiceGroup.get(detailVO.getId());
                if (!ObjectUtils.isEmpty((Object)invDetails)) {
                    detailVO.setInvInvoiceList(invDetails);
                }
                if (!ObjectUtils.isEmpty((Object)(sourceRecords = (List)sourceRecordGroup.get(detailVO.getId())))) {
                    detailVO.setSourcePayload(((AccReimSourceRecordVO)sourceRecords.get(0)).getSource());
                }
                BigDecimal taxAmt = ObjectUtils.isEmpty((Object)detailVO.getTaxAmt()) ? BigDecimal.ZERO : detailVO.getTaxAmt();
                BigDecimal noTaxReimAmt = detailVO.getReimAmt().subtract(taxAmt);
                detailVO.setNoTaxReimAmt(noTaxReimAmt);
            });
        }
        accReimVO.setDetails(accReimDetailVOS);
        this.queyDetailExtraHandle(accReimVO);
        return accReimVO;
    }

    public AccReimVO queryOneByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public AccReimVO insert(AccReimPayload payload) {
        this.reimTotalAmtCheck(payload);
        this.reimDocRepeatCheck(payload);
        this.reimRuleService.reimRuleCheck(payload);
        this.expenseClaimBudgetCheckHandle(payload);
        payload.setReimNo(this.generateSeqNum("ACC_REIM_NO", new String[0]));
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            payload.setReimStatus(AccReimDocStatusEnum.PENDING_CHARGE.getCode());
            payload.setApprStatus(ProcInstStatus.APPROVED.name());
            payload.setApplyDate(LocalDate.now());
        } else {
            payload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
        }
        AccReimVO vo = null;
        Long reimId = null;
        try {
            this.transactionUtilService.begin();
            AccReimDO entityDo = AccReimConvert.INSTANCE.payload2Do(payload);
            vo = AccReimConvert.INSTANCE.do2Vo((AccReimDO)this.repo.save(entityDo));
            ArrayList<InvInvoicePayload> invInvoicePayloads = new ArrayList<InvInvoicePayload>();
            reimId = vo.getId();
            payload.setId(reimId);
            this.relateDocHandle(payload);
            if (!ObjectUtils.isEmpty((Object)payload.getDetails())) {
                ArrayList<AccReimTaxPayload> taxPayloadList = new ArrayList<AccReimTaxPayload>();
                for (AccReimDetailPayload dtl : payload.getDetails()) {
                    dtl.setMasId(reimId);
                    AccReimDetailDO newDetail = this.detailDAO.save(AccReimDetailConvert.INSTANCE.payload2Do(dtl));
                    dtl.setId(newDetail.getId());
                    List reimDetailMealPayloads = dtl.getReimDetailMealPayloads();
                    if (!CollectionUtils.isEmpty((Collection)reimDetailMealPayloads)) {
                        for (AccReimDetailMealPayload reimDetailMealPayload : reimDetailMealPayloads) {
                            reimDetailMealPayload.setReimDetailId(dtl.getId());
                        }
                        this.accReimDetailMealService.insertList(dtl.getReimDetailMealPayloads());
                    }
                    if (dtl.getTaxRate() != null && dtl.getTaxRate().compareTo(BigDecimal.ZERO) > 0) {
                        this.buildReimTaxList(reimId, dtl, taxPayloadList);
                    }
                    if (!ObjectUtils.isEmpty((Object)dtl.getInvIdList())) {
                        this.buildInvDocRef(reimId, newDetail.getId(), dtl.getInvIdList(), invInvoicePayloads);
                    }
                    if (ObjectUtils.isEmpty((Object)dtl.getSourcePayload())) continue;
                    AccReimSourceRecordPayload sourceRecordPayload = this.buildSourceRecord(newDetail.getMasId(), newDetail.getId(), dtl.getSourcePayload());
                    this.reimSourceRecordService.insert(sourceRecordPayload);
                }
                if (!ObjectUtils.isEmpty(taxPayloadList)) {
                    this.accReimTaxService.batchInsert(taxPayloadList);
                }
                if (!ObjectUtils.isEmpty(invInvoicePayloads)) {
                    this.invInvoiceService.addRelateReimByIds(invInvoicePayloads);
                }
            }
            this.transactionUtilService.commit();
        }
        catch (Exception e) {
            this.transactionUtilService.rollback();
            throw e;
        }
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            return vo;
        }
        if (Boolean.TRUE.equals(payload.getSubmitFlag())) {
            this.submitFlow(payload);
            this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.APPROVING.getCode());
        }
        return vo;
    }

    @Transactional
    public long partialUpdate(AccReimPayload payload) {
        return this.dao.updateByKeyDynamic(payload);
    }

    @Transactional
    public void updatePayStatus(AccReimPayload payload) {
        this.dao.updatePayStatus(payload);
    }

    @Transactional
    public long updateByKeyDynamic(AccReimPayload payload) {
        AccReimVO oriVo = this.dao.queryByKey(payload.getId());
        if (ObjectUtils.isEmpty((Object)oriVo)) {
            log.warn("\u5f53\u524d\u62a5\u9500\u5355\u4e0d\u5b58\u5728\uff0cid is {}", (Object)payload.getId());
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            log.warn("\u5f53\u524d\u62a5\u9500\u5355\u4e3a\u884c\u653f\u8ba2\u7968\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u505a\u4fee\u6539\u64cd\u4f5c\uff01");
            throw TwException.error("", "\u884c\u653f\u8ba2\u7968\u62a5\u9500\u5355\u4e0d\u5141\u8bb8\u505a\u4fee\u6539\u64cd\u4f5c\uff01");
        }
        if (Boolean.FALSE.equals(payload.getAdvanceModifyFlag()) && !AccReimDocStatusEnum.CREATE.getCode().equals(oriVo.getReimStatus())) {
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u4e0d\u662f\u65b0\u5efa\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u505a\u4fee\u6539\uff01");
        }
        this.reimTotalAmtCheck(payload);
        this.reimDocRepeatCheck(payload);
        this.reimRuleService.reimRuleCheck(payload);
        this.expenseClaimBudgetCheckHandle(payload);
        try {
            this.transactionUtilService.begin();
            this.repo.save(AccReimConvert.INSTANCE.payload2Do(payload));
            this.relateDocRelease(oriVo);
            payload.setUpdateFlag(Boolean.valueOf(true));
            this.relateDocHandle(payload);
            this.invInvoiceService.updateReimStatusByReimId(payload.getId(), InvoiceReimStatusEnum.NEW.getCode());
            Long reimId = payload.getId();
            this.accReimTaxService.delByReimId(reimId);
            if (!ObjectUtils.isEmpty((Object)payload.getDeleteKeys())) {
                this.detailDAO.deleteSoft(payload.getDeleteKeys());
            }
            this.reimSourceRecordService.delByReimId(reimId);
            ArrayList<InvInvoicePayload> invInvoicePayloads = new ArrayList<InvInvoicePayload>();
            if (!ObjectUtils.isEmpty((Object)payload.getDetails())) {
                ArrayList<AccReimTaxPayload> taxPayloadList = new ArrayList<AccReimTaxPayload>();
                for (AccReimDetailPayload dtl : payload.getDetails()) {
                    List reimDetailMealPayloads;
                    if (dtl.getId() <= 0L) {
                        dtl.setMasId(reimId);
                        AccReimDetailDO newDetail = this.detailDAO.save(AccReimDetailConvert.INSTANCE.payload2Do(dtl));
                        dtl.setId(newDetail.getId());
                    } else {
                        this.detailDAO.updateByKeyDynamic(dtl);
                    }
                    if (!ObjectUtils.isEmpty((Object)dtl.getDeleteKeys())) {
                        this.accReimDetailMealService.deleteSoft(dtl.getDeleteKeys());
                    }
                    if (!CollectionUtils.isEmpty((Collection)(reimDetailMealPayloads = dtl.getReimDetailMealPayloads()))) {
                        for (AccReimDetailMealPayload reimDetailMealPayload : reimDetailMealPayloads) {
                            if (reimDetailMealPayload.getId() <= 0L) {
                                reimDetailMealPayload.setReimDetailId(dtl.getId());
                                AccReimDetailMealVO accReimDetailMealVO = this.accReimDetailMealService.insert(reimDetailMealPayload);
                                reimDetailMealPayload.setId(accReimDetailMealVO.getId());
                                continue;
                            }
                            this.accReimDetailMealService.updateByKeyDynamic(reimDetailMealPayload);
                        }
                    }
                    if (dtl.getTaxRate() != null && dtl.getTaxRate().compareTo(BigDecimal.ZERO) > 0) {
                        this.buildReimTaxList(reimId, dtl, taxPayloadList);
                    }
                    if (!ObjectUtils.isEmpty((Object)dtl.getInvIdList())) {
                        this.buildInvDocRef(reimId, dtl.getId(), dtl.getInvIdList(), invInvoicePayloads);
                    }
                    if (ObjectUtils.isEmpty((Object)dtl.getSourcePayload())) continue;
                    AccReimSourceRecordPayload sourceRecordPayload = this.buildSourceRecord(dtl.getMasId(), dtl.getId(), dtl.getSourcePayload());
                    this.reimSourceRecordService.insert(sourceRecordPayload);
                }
                if (!ObjectUtils.isEmpty(taxPayloadList)) {
                    this.accReimTaxService.batchInsert(taxPayloadList);
                }
                if (!ObjectUtils.isEmpty(invInvoicePayloads)) {
                    this.invInvoiceService.addRelateReimByIds(invInvoicePayloads);
                }
            }
            this.transactionUtilService.commit();
        }
        catch (Exception e) {
            this.transactionUtilService.rollback();
            throw e;
        }
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            return 1L;
        }
        if (Boolean.TRUE.equals(payload.getSubmitFlag())) {
            this.submitFlow(payload);
            this.invInvoiceService.updateReimStatusByReimId(payload.getId(), InvoiceReimStatusEnum.APPROVING.getCode());
        }
        return 1L;
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!ObjectUtils.isEmpty(keys)) {
            AccReimQuery query = new AccReimQuery();
            query.setIdList(keys);
            List<AccReimVO> voList = this.dao.queryListDynamic(query);
            if (ObjectUtils.isEmpty(voList)) {
                return;
            }
            List<AccReimDetailVO> detailVOS = this.detailDAO.queryByMasIds(keys);
            Map<Long, List<AccReimDetailVO>> masIdMap = detailVOS.stream().collect(Collectors.groupingBy(AccReimDetailVO::getMasId));
            for (AccReimVO accReimVO : voList) {
                if (!AccReimDocStatusEnum.CREATE.getCode().equalsIgnoreCase(accReimVO.getReimStatus())) {
                    throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u975e\u65b0\u5efa\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
                }
                Long key = accReimVO.getId();
                accReimVO.setDelFlag(Boolean.valueOf(true));
                this.relateDocRelease(accReimVO);
                List<AccReimDetailVO> detailList = masIdMap.get(key);
                if (ObjectUtils.isEmpty(detailList)) continue;
                this.invInvoiceService.updateReimStatusByReimId(key, InvoiceReimStatusEnum.NEW.getCode());
                this.detailDAO.deleteSoftByMasId(key);
                this.accReimTaxService.delByReimId(key);
            }
            this.dao.deleteSoft(keys);
        }
    }

    public AccReimVO queryOneByReimNo(String reimNo) {
        AccReimVO reimVO = this.dao.queryOneByReimNo(reimNo);
        if (ObjectUtils.isEmpty((Object)reimVO)) {
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u4e0d\u5b58\u5728\uff01");
        }
        TaskInfo taskInfo = this.workflowUtil.currentTaskInfo(reimVO.getProcInstId());
        if (ObjectUtils.isEmpty((Object)taskInfo)) {
            throw TwException.error("", "\u6ca1\u6709\u6b63\u5728\u8d70\u6d41\u7a0b\u7684\u62a5\u9500\uff01");
        }
        reimVO.setCurrentTaskKey(taskInfo.getTaskDefKey());
        return reimVO;
    }

    @Transactional
    public void updatePayMode(Long[] keys, String payMode) {
        if (ObjectUtils.isEmpty((Object[])keys)) {
            log.info("\u5f85\u5904\u7406\u652f\u4ed8\u65b9\u5f0f\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        AccReimQuery query = new AccReimQuery();
        query.setIdList(List.of(keys));
        List<AccReimVO> voList = this.dao.queryListDynamic(query);
        String hisType = PurchasePaymentEnum.PayHistType.HISTTYPE6.getDesc();
        String hisDtl = AccReimPayModeEnum.PAY_MODE_2.getCode().equals(payMode) ? PurchasePaymentEnum.PayHistDtl.DTL6.getDesc() : PurchasePaymentEnum.PayHistDtl.DTL7.getDesc();
        ArrayList<TDocHistPayload> tDocHistPayloads = new ArrayList<TDocHistPayload>();
        for (AccReimVO reimVO : voList) {
            if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(reimVO.getPayStatus())) {
                log.warn("\u5f53\u524d\u62a5\u9500\u5355\u5df2\u7ecf\u6210\u529f\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f\u91cd\u65b0\u652f\u4ed8\uff01\u62a5\u9500\u5355\u53f7 is {} ", (Object)reimVO.getReimNo());
                throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\u4e0d\u5141\u8bb8\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f\u91cd\u65b0\u652f\u4ed8\uff01");
            }
            if (PurchasePaymentEnum.PayStatusEnum.PAYIN.getCode().equals(reimVO.getPayStatus())) {
                log.warn("\u652f\u4ed8\u4e2d\u7684\u62a5\u9500\u5355\u4e0d\u5141\u8bb8\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f\uff01\u62a5\u9500\u5355\u53f7 is {} ", (Object)reimVO.getReimNo());
                throw TwException.error("", "\u652f\u4ed8\u4e2d\u7684\u62a5\u9500\u5355\u4e0d\u5141\u8bb8\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f\uff01");
            }
            if (!AccReimDocStatusEnum.PENDING_PAYMENT.getCode().equals(reimVO.getReimStatus())) {
                log.warn("\u62a5\u9500\u5355\u4e0d\u662f\u5df2\u901a\u8fc7\u5f85\u4ed8\u6b3e\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f\uff01\u62a5\u9500\u5355\u53f7 is {} ", (Object)reimVO.getReimNo());
                throw TwException.error("", "\u62a5\u9500\u5355\u4e0d\u662f\u5df2\u901a\u8fc7\u5f85\u4ed8\u6b3e\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f\uff01");
            }
            TDocHistPayload tDocHistPayload = this.buildDocHistory(reimVO, hisType, hisDtl);
            tDocHistPayloads.add(tDocHistPayload);
        }
        this.dao.updatePayMode(keys, payMode);
        if (!ObjectUtils.isEmpty(tDocHistPayloads)) {
            this.tDocHistService.batchInsert(tDocHistPayloads);
        }
    }

    @Transactional
    public AccReimVO finChargeUp(String reimNo) {
        AccReimVO vo = this.dao.queryOneByReimNo(reimNo);
        if (ObjectUtils.isEmpty((Object)vo)) {
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u4e0d\u5b58\u5728");
        }
        if (!AccReimDocStatusEnum.PENDING_RECEIVE.getCode().equals(vo.getReimStatus())) {
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u975e\u5f85\u6536\u5355\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d22\u52a1\u6536\u5355\uff01");
        }
        this.dao.updateFinChargeUp(vo.getId());
        return this.dao.queryByKey(vo.getId());
    }

    @Transactional
    public AccReimJdePayload batchChargeOrPay(List<Long> keys, String batchType, String expenseProofDigest, LocalDate expenseAccountDate, String payMode) {
        if (ObjectUtils.isEmpty(keys)) {
            log.error("\u5f85\u5904\u7406\u8bb0\u8d26/\u4ed8\u6b3e\u6570\u636e\u4e3a\u7a7a");
            throw TwException.error("", "\u5f85\u5904\u7406\u8bb0\u8d26/\u4ed8\u6b3e\u6570\u636e\u4e3a\u7a7a");
        }
        AccReimJdePayload accReimJdePayload = new AccReimJdePayload();
        AccReimQuery query = new AccReimQuery();
        query.setIdList(keys);
        List<AccReimVO> accReimVOS = this.dao.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(accReimVOS)) {
            String batchNo;
            Long finPeriodId = this.getFinPeriod();
            accReimVOS.forEach(vo -> {
                if (!ProcInstStatus.APPROVED.name().equals(vo.getApprStatus())) {
                    throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u5ba1\u6279\u6d41\u7a0b\u672a\u5b8c\u6210\uff0c\u65e0\u6cd5\u8fdb\u884c\u8bb0\u8d26/\u4ed8\u6b3e\u5904\u7406\uff0c\u62a5\u9500\u5355\u53f7\u4e3a:" + vo.getReimNo());
                }
                if (AccPayBatchTypeEnum.CASHIER.getCode().equals(batchType) && !AccReimDocStatusEnum.PENDING_PAYMENT.getCode().equals(vo.getReimStatus())) {
                    throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u4e0d\u662f\u5df2\u901a\u8fc7\u5f85\u4ed8\u6b3e\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u4ed8\u6b3e\u5904\u7406\uff0c\u62a5\u9500\u5355\u53f7\u4e3a:" + vo.getReimNo());
                }
                this.tripTicketRelease((AccReimVO)vo, batchType);
            });
            List<Long> idList = accReimVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            BigDecimal batchTotalAmt = accReimVOS.stream().map(reimVO -> Optional.ofNullable(reimVO.getReimTotalAmt()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
            StringBuilder sb = new StringBuilder().append(accReimVOS.size()).append("\u6761\u62a5\u9500\u5355\uff0c\u62a5\u9500\u603b\u91d1\u989d\uff1a").append(batchTotalAmt).append("\u5143\uff0c\u6279\u91cf\u5904\u7406\u65f6\u95f4\uff1a").append(LocalDateTime.now());
            AccReimPayBatchPayload payload = new AccReimPayBatchPayload();
            if (AccPayBatchTypeEnum.ACCOUNT.getCode().equals(batchType)) {
                batchNo = this.generateSeqNum("ACC_PAY_BATCH_CODE", new String[0]);
            } else {
                int count = accReimVOS.stream().collect(Collectors.groupingBy(AccReimVO::getBatchNo)).size();
                if (count > 1) {
                    throw TwException.error("", "\u8bf7\u9009\u62e9\u540c\u4e00\u6279\u6b21\u53f7\u62a5\u9500\u5355\u8fdb\u884c\u4ed8\u6b3e\u5904\u7406\uff01\uff08\u6279\u6b21\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
                }
                batchNo = accReimVOS.get(0).getBatchNo();
            }
            payload.setBatchNo(batchNo);
            payload.setBatchName(sb.toString());
            payload.setBatchAmt(batchTotalAmt);
            payload.setExportCount(Integer.valueOf(0));
            payload.setBatchQty(Integer.valueOf(accReimVOS.size()));
            payload.setBatchType(batchType);
            payload.setBatchTime(LocalDateTime.now());
            payload.setBatchStatus("0");
            AccReimPayBatchVO insert = this.reimPayBatchService.insert(payload);
            this.dao.updateBatchNo(idList, batchNo, batchType, finPeriodId, expenseAccountDate, payMode);
        }
        return accReimJdePayload;
    }

    @Transactional
    public AccReimSourcePayload calcAmt(String busItemCode, AccReimSourcePayload calcSource) {
        AccReimSourceConfigVO vo;
        AccReimSourceConfigQuery query = new AccReimSourceConfigQuery();
        query.setBusAccItemCodes(busItemCode);
        List accReimSourceConfigVOS = this.reimSourceConfigService.queryListDynamic(query);
        if (ObjectUtils.isEmpty((Object)accReimSourceConfigVOS)) {
            log.warn("\u5f53\u524d\u6838\u7b97\u9879\u76ee\u65e0\u62a5\u9500\u91d1\u989d\u6765\u6e90\u914d\u7f6e\uff0c\u6838\u7b97\u9879\u76eecode is {}", (Object)busItemCode);
        }
        if (0 == (vo = (AccReimSourceConfigVO)accReimSourceConfigVOS.get(0)).getEnableFlag()) {
            log.warn("\u8be5\u6838\u7b97\u9879\u76ee[{}]\u62a5\u9500\u91d1\u989d\u6765\u6e90\u914d\u7f6e {} \u672a\u5f00\u542f", (Object)busItemCode, (Object)vo.getConfigName());
            throw TwException.error("", "\u8be5\u6838\u7b97\u9879\u76ee\u62a5\u9500\u91d1\u989d\u6765\u6e90\u914d\u7f6e\u672a\u5f00\u542f");
        }
        Long userId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeVO prdOrgEmployeeVO = this.employeeService.queryByUserId(userId);
        String jobGrade = prdOrgEmployeeVO.getExtString1();
        AccReimTripStdQuery stdQuery = new AccReimTripStdQuery();
        stdQuery.setJobGrade(jobGrade);
        stdQuery.setFeeType("MEAL");
        List accReimTripStdVOS = this.accReimTripStdService.queryListDynamic(stdQuery);
        if (ObjectUtils.isEmpty((Object)accReimTripStdVOS)) {
            throw TwException.error("", "\u5f53\u524d\u804c\u7ea7\u4e0b\u7684\u9910\u8d39\u989d\u5ea6\u672a\u8bbe\u7f6e\uff0c\u804c\u7ea7 is :" + jobGrade);
        }
        BigDecimal feeAmt = ((AccReimTripStdVO)accReimTripStdVOS.get(0)).getFeeAmt();
        boolean selectedFlag = true;
        for (AccReimSourceDetailPayload detailPayload : calcSource.getDetails()) {
            if (1 == detailPayload.getBreakfastFlag()) {
                detailPayload.setBreakfastFee(feeAmt.multiply(this.breakfastScale));
            }
            if (1 == detailPayload.getLunchFeeFlag()) {
                detailPayload.setLunchFee(feeAmt.multiply(this.lunchScale));
            }
            if (1 != detailPayload.getDinnerFeeFlag()) continue;
            detailPayload.setDinnerFee(feeAmt.multiply(this.dinnerScale));
        }
        return calcSource;
    }

    public void exportChargeDtl(HttpServletResponse response, Long batchId) {
        AccReimPayBatchVO accReimPayBatchVO = this.reimPayBatchService.queryByKey(batchId);
        String userName = this.cacheUtil.getUserName(accReimPayBatchVO.getCreateUserId());
        if (ObjectUtils.isEmpty((Object)accReimPayBatchVO)) {
            throw TwException.error("", "\u5f53\u524d\u8bb0\u8d26\u6279\u6b21\u4e0d\u5b58\u5728" + batchId);
        }
        List<AccReimExportVO> mainData = this.dao.getExportChargeData(accReimPayBatchVO.getBatchNo());
        Set idList = mainData.stream().map(AccReimExportVO::getId).collect(Collectors.toSet());
        List taxData = this.accReimTaxService.getExportTaxData(idList);
        if (!ObjectUtils.isEmpty((Object)taxData)) {
            taxData.forEach(tax -> tax.setTaxFlag(Integer.valueOf(1)));
            mainData.addAll(taxData);
        }
        String childAccountPrefix = "80";
        ClassPathResource classPathResource = new ClassPathResource("template/accReimCharge.xlsx");
        try (InputStream inputStream = classPathResource.getInputStream();){
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u8d22\u52a1\u8bb0\u8d26\u660e\u7ec6");
            if (!ObjectUtils.isEmpty(mainData)) {
                HashMap<Long, List<BusinessPartnerVO>> bookIdMap = new HashMap<Long, List<BusinessPartnerVO>>();
                HashMap<Long, List<PrdOrgOrganizationVO>> orgIdMap = new HashMap<Long, List<PrdOrgOrganizationVO>>();
                HashMap<Long, List<PrdOrgEmployeeVO>> userIdMap = new HashMap<Long, List<PrdOrgEmployeeVO>>();
                HashMap<Long, List<PmsProjectVO>> reasonIdMap = new HashMap<Long, List<PmsProjectVO>>();
                this.chargeExportDataHandle(mainData, bookIdMap, orgIdMap, userIdMap, reasonIdMap, accReimPayBatchVO.getBatchNo());
                String accountType = "A";
                int nextRow = 1;
                for (AccReimExportVO vo : mainData) {
                    BigDecimal adjustAmt;
                    List orgList = (List)orgIdMap.get(vo.getExpenseOrgId());
                    if (ObjectUtils.isEmpty((Object)orgList)) {
                        log.warn("\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0cid is {}", (Object)vo.getExpenseOrgId());
                        continue;
                    }
                    PrdOrgOrganizationVO orgVo = (PrdOrgOrganizationVO)orgList.get(0);
                    List prdOrgEmployeeVOS = (List)userIdMap.get(vo.getReimUserId());
                    if (ObjectUtils.isEmpty((Object)prdOrgEmployeeVOS)) {
                        log.warn("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\uff0cid is {}", (Object)vo.getReimUserId());
                        continue;
                    }
                    PrdOrgEmployeeVO employeeVO = (PrdOrgEmployeeVO)prdOrgEmployeeVOS.get(0);
                    List businessPartnerVOS4Id = (List)bookIdMap.get(vo.getExpenseCompany());
                    if (ObjectUtils.isEmpty((Object)businessPartnerVOS4Id)) {
                        log.warn("\u5f53\u524d\u4e1a\u52a1\u4f19\u4f34\u4e0d\u5b58\u5728\uff0cbookId is {}", (Object)vo.getExpenseCompany());
                        continue;
                    }
                    BusinessPartnerVO businessPartnerVO = (BusinessPartnerVO)businessPartnerVOS4Id.get(0);
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, accReimPayBatchVO.getBatchNo());
                    this.excelUtil.setCellValue((Row)row, 1, vo.getAccName());
                    StringBuilder accountNo = new StringBuilder();
                    if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(vo.getReasonType()) && vo.getTaxFlag() == 0) {
                        List pmsProjectVOS = (List)reasonIdMap.get(vo.getReasonId());
                        vo.setTaxFlag(Integer.valueOf(1));
                        if (!ObjectUtils.isEmpty((Object)pmsProjectVOS)) {
                            PmsProjectVO pmsProjectVO = (PmsProjectVO)pmsProjectVOS.get(0);
                            this.excelUtil.setCellValue((Row)row, 13, this.cacheUtil.getCompanyNameByBookId(pmsProjectVO.getSignBuId()));
                            this.excelUtil.setCellValue((Row)row, 22, pmsProjectVO.getContractNo());
                            if (SaleConWorkTypeEnum.DEVELOP.getCode().equals(pmsProjectVO.getWorkType())) {
                                accountNo.append(pmsProjectVO.getProductNo());
                            } else {
                                accountNo.append(pmsProjectVO.getContractNo());
                            }
                        }
                    } else {
                        accountNo.append(businessPartnerVO.getJdeCompanyNo());
                    }
                    if (1 == vo.getTaxFlag()) {
                        accountNo.append(".");
                    } else {
                        accountNo.append(orgVo.getJdeOrgCode()).append(".");
                    }
                    if (!ObjectUtils.isEmpty((Object)vo.getFinAccSubjCode()) && vo.getFinAccSubjCode().length() >= 4) {
                        String parentCode = vo.getFinAccSubjCode().substring(0, 4);
                        accountNo.append(parentCode);
                        String selfCode = vo.getFinAccSubjCode().substring(4);
                        if (!ObjectUtils.isEmpty((Object)selfCode)) {
                            accountNo.append(".").append(selfCode);
                        }
                    } else {
                        accountNo.append(vo.getFinAccSubjCode());
                    }
                    this.excelUtil.setCellValue((Row)row, 2, accountNo.toString());
                    BigDecimal reimAmt = vo.getReimAmt();
                    BigDecimal bigDecimal = adjustAmt = vo.getAdjustAmt() == null ? reimAmt : vo.getAdjustAmt();
                    if (!ObjectUtils.isEmpty((Object)vo.getTaxAmt())) {
                        adjustAmt = adjustAmt.subtract(vo.getTaxAmt());
                    }
                    this.excelUtil.setCellValue((Row)row, 6, adjustAmt);
                    this.excelUtil.setCellValue((Row)row, 8, "A");
                    String resNo = employeeVO.getResNo();
                    if (ObjectUtils.isEmpty((Object)resNo)) {
                        log.error("\u5f53\u524d\u62a5\u9500\u4eba\u7684\u8d44\u6e90\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7ef4\u62a4\uff01\u5458\u5de5\u59d3\u540d\u4e3a:{}", (Object)employeeVO.getEmployeeName());
                        throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u4eba\u7684\u8d44\u6e90\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7ef4\u62a4\uff01\u5458\u5de5\u59d3\u540d\u4e3a\uff1a" + employeeVO.getEmployeeName());
                    }
                    StringBuilder childAccount = new StringBuilder("80");
                    childAccount.append(resNo, 1, 4).append(resNo.substring(resNo.length() - 3));
                    this.excelUtil.setCellValue((Row)row, 9, childAccount.toString());
                    String reimRemark = ObjectUtils.isEmpty((Object)vo.getDtlReimRemark()) ? "" : vo.getDtlReimRemark();
                    StringBuilder desc = new StringBuilder(reimRemark).append(vo.getExpenseDate());
                    this.excelUtil.setCellValue((Row)row, 12, desc.toString());
                    this.excelUtil.setCellValue((Row)row, 14, vo.getReasonName());
                    this.excelUtil.setCellValue((Row)row, 15, vo.getReimNo());
                    this.excelUtil.setCellValue((Row)row, 16, employeeVO.getEmployeeName());
                    String docTypeDesc = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.ACC_REIM_PROC_KEY.getCode(), vo.getReimDocType());
                    this.excelUtil.setCellValue((Row)row, 17, docTypeDesc);
                    this.excelUtil.setCellValue((Row)row, 18, businessPartnerVO.getPartnerName());
                    String invFlag = vo.getInvoiceNum() > 0 ? "\u662f" : "\u5426";
                    this.excelUtil.setCellValue((Row)row, 19, invFlag);
                    this.excelUtil.setCellValue((Row)row, 20, employeeVO.getOrgName());
                    this.excelUtil.setCellValue((Row)row, 21, orgVo.getOrgName());
                    this.excelUtil.setCellValue((Row)row, 23, userName);
                    this.excelUtil.setCellValue((Row)row, 24, TimeUtil.datetime2String(accReimPayBatchVO.getBatchTime()));
                    ++nextRow;
                }
            }
            LocalDateTime now = LocalDateTime.now();
            AccReimPayBatchPayload payload = new AccReimPayBatchPayload();
            payload.setId(batchId);
            int exportCount = accReimPayBatchVO.getExportCount() + 1;
            payload.setExportCount(Integer.valueOf(exportCount));
            payload.setLastExportTime(now);
            this.reimPayBatchService.updateByKeyDynamic(payload);
            String fileName = "\u8d22\u52a1\u8bb0\u8d26\u660e\u7ec6-" + TimeUtil.datetime2String(now);
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            log.error("\u8bb0\u8d26\u5bfc\u51fa\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f is {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @UdcNameClass
    public void exportPayData(HttpServletResponse response, Long batchId) {
        AccReimPayBatchVO accReimPayBatchVO = this.reimPayBatchService.queryByKey(batchId);
        String userName = this.cacheUtil.getUserName(accReimPayBatchVO.getCreateUserId());
        if (ObjectUtils.isEmpty((Object)accReimPayBatchVO)) {
            throw TwException.error("", "\u5f53\u524d\u8bb0\u8d26\u6279\u6b21\u4e0d\u5b58\u5728" + batchId);
        }
        AccReimQuery query = new AccReimQuery();
        query.setBatchNo(accReimPayBatchVO.getBatchNo());
        List<AccReimVO> accReimVOS = this.dao.queryListDynamic(query);
        ClassPathResource classPathResource = new ClassPathResource("template/accReimPay.xlsx");
        try (InputStream inputStream = classPathResource.getInputStream();){
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u8d22\u52a1\u4ed8\u6b3e\u660e\u7ec6");
            if (!ObjectUtils.isEmpty(accReimVOS)) {
                int nextRow = 1;
                for (AccReimVO vo : accReimVOS) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, vo.getBatchNo());
                    this.excelUtil.setCellValue((Row)row, 1, vo.getReimNo());
                    this.excelUtil.setCellValue((Row)row, 2, this.cacheUtil.getUserName(vo.getReimUserId()));
                    this.excelUtil.setCellValue((Row)row, 3, vo.getReimTotalAmt());
                    this.excelUtil.setCellValue((Row)row, 4, vo.getAccountNo());
                    this.excelUtil.setCellValue((Row)row, 5, userName);
                    this.excelUtil.setCellValue((Row)row, 6, TimeUtil.datetime2String(accReimPayBatchVO.getBatchTime()));
                    ++nextRow;
                }
            }
            LocalDateTime now = LocalDateTime.now();
            AccReimPayBatchPayload payload = new AccReimPayBatchPayload();
            payload.setId(batchId);
            int exportCount = accReimPayBatchVO.getExportCount() + 1;
            payload.setExportCount(Integer.valueOf(exportCount));
            payload.setLastExportTime(now);
            this.reimPayBatchService.updateByKeyDynamic(payload);
            String fileName = "\u8d22\u52a1\u4ed8\u6b3e\u660e\u7ec6-" + TimeUtil.datetime2String(now);
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            log.error("\u8bb0\u8d26\u5bfc\u51fa\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f is {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @Transactional
    public void payBankSubmit(Long[] ids) {
        if (ObjectUtils.isEmpty((Object[])ids)) {
            log.warn("\u7f51\u94f6\u63d0\u4ea4\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        this.checkDuplicateData(ids);
        AccReimQuery query = new AccReimQuery();
        query.setIdList(List.of(ids));
        List<AccReimVO> reimData = this.dao.queryListDynamic(query);
        if (ObjectUtils.isEmpty(reimData)) {
            return;
        }
        Set expenseCompanyIds = reimData.stream().map(AccReimVO::getExpenseCompany).collect(Collectors.toSet());
        if (expenseCompanyIds.size() > 1) {
            throw TwException.error("", "\u4e0d\u5141\u8bb8\u4e0d\u540c\u4ed8\u6b3e\u8d26\u53f7\u7684\u62a5\u9500\u5355\u540c\u65f6\u63d0\u4ea4\uff01");
        }
        BookAccountVO bookAccountVO = this.bookAccountService.queryDefaultByBookId(reimData.get(0).getExpenseCompany());
        if (ObjectUtils.isEmpty((Object)bookAccountVO)) {
            throw TwException.error("", "\u5f53\u524d\u516c\u53f8\u6536\u6b3e\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff01\uff01\uff01" + reimData.get(0).getExpenseCompany());
        }
        PayListPayload payListPayload = new PayListPayload();
        ArrayList<PayPayload> payloadList = new ArrayList<PayPayload>();
        ArrayList<TDocHistPayload> tDocHistPayloads = new ArrayList<TDocHistPayload>();
        payListPayload.setBank(this.bank);
        payListPayload.setPlatform(this.platform);
        payListPayload.setSecretKey(this.secretKey);
        String bthnbr = this.generateSeqNum("BTHNBR", new String[0]);
        LocalDateTime now = LocalDateTime.now();
        String hisType = PurchasePaymentEnum.PayHistType.HISTTYPE4.getDesc();
        String hisDtl = PurchasePaymentEnum.PayHistDtl.DTL4.getDesc();
        BigDecimal currentTotalAmt = reimData.stream().map(reimVO -> Optional.ofNullable(reimVO.getAdjustAmt() == null ? reimVO.getReimTotalAmt() : reimVO.getAdjustAmt()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        int currentTotal = reimData.size();
        for (int i = 0; i < reimData.size(); ++i) {
            AccReimVO reimVO2 = reimData.get(i);
            this.payBackCheck(reimVO2);
            PayPayload payload = new PayPayload();
            payload.setBthnbr(bthnbr);
            payload.setTrxseq(String.valueOf(i + 1));
            this.buildPaymentDetail(reimVO2, bookAccountVO, payload, currentTotalAmt, currentTotal);
            payloadList.add(payload);
            TDocHistPayload tDocHistPayload = this.buildDocHistory(reimVO2, hisType, hisDtl);
            tDocHistPayloads.add(tDocHistPayload);
            AccReimPayload reimPayload = new AccReimPayload();
            reimPayload.setId(reimVO2.getId());
            reimPayload.setBankTime(now);
            reimPayload.setBankFlag(Integer.valueOf(1));
            reimPayload.setPayStatus(PurchasePaymentEnum.PayStatusEnum.PAYIN.getCode());
            this.dao.updateByKeyDynamic(reimPayload);
        }
        this.tDocHistService.batchInsert(tDocHistPayloads);
        payListPayload.setPayPayloadList(payloadList);
        log.info("\u62a5\u9500\u5355\u6279\u6b21\u53f7\u4e3a[{}]\u8bf7\u6c42\u6570\u636e\u4e3a:{}", (Object)bthnbr, (Object)JSONUtil.toJsonStr((Object)payListPayload));
        ApiResult bkApiResult = this.payService.payList(payListPayload);
        log.info("\u62a5\u9500\u5355\u6279\u6b21\u53f7\u4e3a[{}]\u8fd4\u56de\u6570\u636e\u4e3a:{}", (Object)bthnbr, (Object)JSONUtil.toJsonStr((Object)bkApiResult));
        if (bkApiResult.getCode() != 200) {
            log.error("\u62a5\u9500\u5355\u6279\u6b21\u53f7\u4e3a[{}]\u8c03\u7528\u94f6\u4f01\u76f4\u8fde\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606fis:{}", (Object)bthnbr, (Object)bkApiResult.getErrorMsg());
            throw TwException.error("", "\u62a5\u9500\u5355\u6279\u6b21\u53f7\u4e3a\u6279\u6b21\u53f7\u4e3a:" + bthnbr + "\u8c03\u7528\u94f6\u4f01\u76f4\u8054\u5931\u8d25");
        }
        this.batchChargeOrPay(Arrays.asList(ids), AccPayBatchTypeEnum.CASHIER.getCode(), null, null, AccReimPayModeEnum.PAY_MODE_1.getCode());
        if (!ObjectUtils.isEmpty((Object)bkApiResult.getData())) {
            ArrayList payloads = new ArrayList();
            ((List)bkApiResult.getData()).forEach(payDetail -> {
                BkPayDetailRecordPayload recordPayload = this.buildPayDetailRecord((BkPayDetailVO)payDetail);
                payloads.add(recordPayload);
            });
            this.bkPayDetailRecordService.batchInsert(payloads);
        }
    }

    public void updateBankAccount(AccReimPayload payload) {
        AccReimVO reimVO = this.dao.queryByKey(payload.getId());
        if (ObjectUtils.isEmpty((Object)reimVO)) {
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(reimVO.getPayStatus())) {
            log.warn("\u5f53\u524d\u62a5\u9500\u5355\u5df2\u7ecf\u6210\u529f\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8d26\u53f7\u91cd\u65b0\u652f\u4ed8\uff01\u62a5\u9500\u5355\u53f7 is {} ", (Object)reimVO.getReimNo());
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\u4e0d\u5141\u8bb8\u4fee\u6539\u8d26\u53f7\u91cd\u65b0\u652f\u4ed8\uff01");
        }
        if (PurchasePaymentEnum.PayStatusEnum.PAYIN.getCode().equals(reimVO.getPayStatus())) {
            log.warn("\u652f\u4ed8\u4e2d\u7684\u62a5\u9500\u5355\u4e0d\u5141\u8bb8\u4fee\u6539\u8d26\u53f7\uff01\u62a5\u9500\u5355\u53f7 is {} ", (Object)reimVO.getReimNo());
            throw TwException.error("", "\u652f\u4ed8\u4e2d\u7684\u62a5\u9500\u5355\u4e0d\u5141\u8bb8\u4fee\u6539\u8d26\u53f7\uff01");
        }
        this.dao.updateByKeyDynamic(payload);
        String hisType = PurchasePaymentEnum.PayHistType.HISTTYPE2.getDesc();
        String hisDtl = PurchasePaymentEnum.PayHistDtl.DTL2.getDesc();
        TDocHistPayload tDocHistPayload = this.buildDocHistory(reimVO, hisType, hisDtl);
        this.tDocHistService.insert(tDocHistPayload);
    }

    public boolean myReimCheck(Long reimUserId) {
        AccReimQuery query = new AccReimQuery();
        query.setReimUserId(reimUserId);
        ArrayList<String> notReimStatusList = new ArrayList<String>();
        notReimStatusList.add(AccReimDocStatusEnum.CREATE.getCode());
        notReimStatusList.add(AccReimDocStatusEnum.APPLYING.getCode());
        notReimStatusList.add(AccReimDocStatusEnum.FINANCIAL_AUDIT.getCode());
        query.setNotReimStatusList(notReimStatusList);
        return this.dao.count(query) > 0L;
    }

    public PagingVO<AccReimVO> paging2Budget(AccReimQuery query) {
        return this.dao.paging2Budget(query);
    }

    private void reimTotalAmtCheck(AccReimPayload payload) {
        boolean totalAmtCheck;
        BigDecimal totalClaimAmt = BigDecimal.ZERO;
        for (AccReimDetailPayload detail : payload.getDetails()) {
            totalClaimAmt = totalClaimAmt.add(detail.getReimAmt());
        }
        boolean bl = totalAmtCheck = totalClaimAmt.compareTo(payload.getReimTotalAmt()) == 0;
        if (!totalAmtCheck) {
            log.warn("\u62a5\u9500\u660e\u7ec6\u91d1\u989d\u4e4b\u548c\u4e0e\u62a5\u9500\u603b\u989d\u4e0d\u7b49,\u5165\u53c2 is {}", (Object)payload);
            throw TwException.error("", "\u62a5\u9500\u660e\u7ec6\u91d1\u989d\u4e4b\u548c\u4e0e\u62a5\u9500\u603b\u989d\u4e0d\u7b49");
        }
    }

    private void reimDocRepeatCheck(AccReimPayload payload) {
        if (!ObjectUtils.isEmpty((Object)payload.getRelatedDocId())) {
            Long relateDocId = payload.getRelatedDocId();
            if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(payload.getReimDocType())) {
                AdmBusitripApplyVO admBusitripApplyVO = this.busitripApplyService.queryOneByKey(relateDocId);
                if (ObjectUtils.isEmpty((Object)admBusitripApplyVO)) {
                    log.warn("\u5f53\u524d\u51fa\u5dee\u7533\u8bf7\u5355\u4e0d\u5b58\u5728,\u5355\u636e\u53f7 is {}", (Object)payload.getRelatedDocId());
                    throw TwException.error("", "\u5f53\u524d\u51fa\u5dee\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff01");
                }
                if (admBusitripApplyVO.getReimId() != null && !Objects.equals(admBusitripApplyVO.getReimId(), payload.getId())) {
                    log.warn("\u5f53\u524d\u51fa\u5dee\u7533\u8bf7\u5355\u5df2\u88ab\u5176\u4ed6\u62a5\u9500\u5355\u5360\u7528,\u5355\u636e\u53f7 is {}", (Object)payload.getRelatedDocId());
                    throw TwException.error("", "\u5f53\u524d\u51fa\u5dee\u7533\u8bf7\u5355\u5df2\u88ab\u5176\u4ed6\u62a5\u9500\u5355\u5360\u7528\uff0c\u65e0\u6cd5\u518d\u6b21\u53d1\u8d77\uff01");
                }
            }
            if (AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(payload.getReimDocType())) {
                AdmFeeApplyVO admFeeApplyVO = this.feeApplyService.queryOneByKey(relateDocId);
                if (ObjectUtils.isEmpty((Object)admFeeApplyVO)) {
                    log.warn("\u5f53\u524d\u7279\u6b8a\u8d39\u7528\u7533\u8bf7\u5355\u4e0d\u5b58\u5728,\u5355\u636e\u53f7 is {}", (Object)payload.getRelatedDocId());
                    throw TwException.error("", "\u5f53\u524d\u7279\u6b8a\u8d39\u7528\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff01");
                }
                if (!Objects.equals(admFeeApplyVO.getReimId(), payload.getId())) {
                    log.warn("\u5f53\u524d\u7279\u6b8a\u8d39\u7528\u7533\u8bf7\u5355\u5df2\u88ab\u5176\u4ed6\u62a5\u9500\u5355\u5360\u7528,\u5355\u636e\u53f7 is {}", (Object)payload.getRelatedDocId());
                    throw TwException.error("", "\u5f53\u524d\u7279\u6b8a\u8d39\u7528\u7533\u8bf7\u5355\u5df2\u88ab\u5176\u4ed6\u62a5\u9500\u5355\u5360\u7528\uff0c\u65e0\u6cd5\u518d\u6b21\u53d1\u8d77\uff01");
                }
            }
        }
    }

    private void expenseClaimBudgetCheckHandle(AccReimPayload payload) {
        PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection(FunctionSelectionEnum.BUDGET_MODULE_ENABLED.getCode());
        List children = systemSelection.getChildren();
        if (Boolean.TRUE.equals(payload.getSubmitFlag() != false && !ObjectUtils.isEmpty((Object)children) && AccBudgetEnableStatusEnum.OPEN.getCode().equalsIgnoreCase(((PrdSystemSelectionVO)children.get(0)).getSelectionValue()))) {
            this.budgetCommonService.checkBudgetAmt(payload.getReasonId(), payload.getReasonType(), null, payload.getReimTotalAmt(), new Long[]{payload.getId()});
        }
    }

    private void submitFlow(AccReimPayload payload) {
        AccReimDocTypeEnum docTypeEnum = AccReimDocTypeEnum.find(payload.getReimDocType());
        if (ObjectUtils.isEmpty((Object)((Object)docTypeEnum))) {
            throw TwException.error("", "\u5355\u636e\u7c7b\u578b\u6709\u8bef\uff0c\u6839\u636e\u6b64\u5355\u636e\u7c7b\u578b\u672a\u83b7\u53d6\u5230\u6d41\u7a0b\u7684key\uff1b\u5355\u636e\u7c7b\u578b is " + payload.getReimDocType());
        }
        AccReimPayload updatePayload = new AccReimPayload();
        updatePayload.setApprStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        HashMap<String, Object> variables = this.getVariables(payload, docTypeEnum.getCode());
        if (ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            variables.put("finRejectFlag", false);
            String procKey = docTypeEnum.getCode();
            if (AccReimDocTypeEnum.ACC_NOT_TRIP.getCode().equals(payload.getReimDocType())) {
                procKey = AccReimDocTypeEnum.ACC_TRIP.getCode();
            }
            String userName = this.cacheUtil.getUserName(payload.getReimUserId());
            StringBuilder procName = new StringBuilder(docTypeEnum.getFlowCode());
            procName.append(".").append(docTypeEnum.getDesc()).append("-").append(userName).append("-").append(LocalDate.now().toString());
            ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)procKey, (String)procName.toString(), (String)("" + payload.getId()), variables), new Long[0]);
            updatePayload.setProcInstId(processInfo.getProcInstId());
            updatePayload.setProcInstName(procName.toString());
            if (AccReimDocTypeEnum.ACC_SPECIAL.getCode().equals(payload.getReimDocType())) {
                updatePayload.setReimStatus(AccReimDocStatusEnum.PENDING_RECEIVE.getCode());
            } else {
                updatePayload.setReimStatus(AccReimDocStatusEnum.APPLYING.getCode());
            }
            if (ObjectUtils.isEmpty((Object)payload.getApplyDate())) {
                updatePayload.setApplyDate(LocalDate.now());
            }
        } else {
            updatePayload.setReimStatus(AccReimDocStatusEnum.APPLYING.getCode());
            if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(payload.getReimDocType()) || AccReimDocTypeEnum.ACC_NOT_TRIP.getCode().equals(payload.getReimDocType()) || AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(payload.getReimDocType())) {
                boolean result = !ObjectUtils.isEmpty((Object)payload.getFinRejectFlag()) && 1 == payload.getFinRejectFlag();
                variables.put("finRejectFlag", result);
                this.workflowUtil.setVariables(SetVariablesPayload.of((String)payload.getProcInstId(), variables));
                if (result) {
                    updatePayload.setReimStatus(AccReimDocStatusEnum.FINANCIAL_AUDIT.getCode());
                }
            }
            if (AccReimDocTypeEnum.ACC_SPECIAL.getCode().equals(payload.getReimDocType())) {
                updatePayload.setReimStatus(AccReimDocStatusEnum.PENDING_RECEIVE.getCode());
            }
        }
        updatePayload.setId(payload.getId());
        updatePayload.setProcTaskKey(payload.getProcTaskKey());
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateByKeyDynamic(updatePayload));
    }

    private HashMap<String, Object> getVariables(AccReimPayload payload, String procCode) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(procCode) || AccReimDocTypeEnum.ACC_NOT_TRIP.getCode().equals(procCode)) {
            payload.setProcTaskKey(AccReimTaskKey.Activity_0s28lb1.getCode());
            this.setFlowResParent(payload.getReimUserId(), variables, AccReimTaskKey.Activity_0v6bxzy.getCode());
            this.flowReasonTypeCheck(payload, variables);
            this.judgeIsSalePerson(payload, variables);
            this.specialCostCheck(payload, variables);
            this.flowAmtLimitCheck(payload.getReimTotalAmt(), variables);
        }
        if (AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(procCode)) {
            this.setFlowResParent(payload.getReimUserId(), variables, AccReimTaskKey.ACC_OTHERS_Activity_1luosio.getCode());
            PrdOrgOrganizationRefVO orgRef = this.cacheUtil.getBULevel1ByOrgId(payload.getExpenseOrgId());
            if (orgRef == null) {
                throw TwException.error("", "\u8d39\u7528\u627f\u62c5\u4e8b\u4e1a\u90e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0cbuId is  " + payload.getExpenseOrgId());
            }
            variables.put(AccReimTaskKey.ACC_OTHERS_Activity_0yd0oo0.getCode(), Lists.newArrayList((Object[])new Long[]{orgRef.getManageId()}));
            this.flowAmtLimitCheck(payload.getReimTotalAmt(), variables);
        }
        return variables;
    }

    void specialCostCheck(AccReimPayload payload, HashMap<String, Object> variables) {
        Optional<AccReimDetailPayload> first0;
        Boolean isUp = true;
        variables.put("specialCost", true);
        List details = payload.getDetails();
        List<String> codes = Arrays.asList("1047", "1046");
        Optional<AccReimDetailPayload> first = details.stream().filter(detail -> codes.contains(detail.getBusAccItemCode())).findFirst();
        if (!first.isPresent() && !(first0 = details.stream().filter(detail -> "1010".equals(detail.getBusAccItemCode()) && detail.getAdjustAmt().compareTo(this.businessLimitAmt) >= 0).findFirst()).isPresent()) {
            variables.put("specialCost", false);
            isUp = false;
        }
        if (isUp.booleanValue()) {
            payload.setProcTaskKey(AccReimTaskKey.Activity_0lef6bf.getCode());
        }
        variables.put(AccReimTaskKey.Activity_0lef6bf.getCode(), this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ALL_PIC.getCode()));
    }

    void judgeIsSalePerson(AccReimPayload payload, HashMap<String, Object> variables) {
        variables.put(AccReimTaskKey.Activity_13m9opq.getCode(), 0L);
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(payload.getReimUserId());
        variables.put("isSalePerson", false);
        if (StringUtils.hasText((String)userDefaultOrg.getOrganizationType()) && OrgEnum.OrgType.BS.getCode().equals(userDefaultOrg.getOrganizationType())) {
            payload.setProcTaskKey(AccReimTaskKey.Activity_1uie2q6.getCode());
            variables.put("isSalePerson", true);
            variables.put("isSaleManageRes", false);
            variables.put(AccReimTaskKey.Activity_13m9opq.getCode(), Lists.newArrayList((Object[])new Long[]{userDefaultOrg.getManageId()}));
            if (userDefaultOrg.getManageId().equals(payload.getReimUserId())) {
                variables.put("isSaleManageRes", true);
            }
        }
    }

    private void flowReasonTypeCheck(AccReimPayload payload, HashMap<String, Object> variables) {
        PrdOrgOrganizationRefVO orgRef;
        String reasonType = payload.getReasonType();
        Long reasonId = payload.getReasonId();
        variables.put(AccReimTaskKey.Activity_0tuowqd.getCode(), 0L);
        variables.put(AccReimTaskKey.Activity_1a4l4or.getCode(), 0L);
        variables.put(AccReimTaskKey.Activity_11xytgw.getCode(), 0L);
        variables.put(AccReimTaskKey.Activity_1bdkuyf.getCode(), 0L);
        variables.put(AccReimTaskKey.Activity_0s28lb1.getCode(), 0L);
        variables.put("reasonType", reasonType);
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(reasonType)) {
            PmsProjectVO pmsProjectVO = this.projectService.queryByKey(reasonId);
            if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
                throw TwException.error("", "\u5f53\u524d\u9879\u76ee\u6570\u636e\u4e0d\u5b58\u5728,id is " + reasonId);
            }
            variables.put(AccReimTaskKey.Activity_0tuowqd.getCode(), Lists.newArrayList((Object[])new Long[]{pmsProjectVO.getPmResId()}));
            variables.put(AccReimTaskKey.Activity_1a4l4or.getCode(), Lists.newArrayList((Object[])new Long[]{pmsProjectVO.getDeliUserId()}));
        }
        if (PmsReasonTypeEnum.PROJ_OPPO.getCode().equals(reasonType)) {
            CrmOpportunityVO crmOpportunityVO = this.opportunityService.queryByOppoProjId(reasonId);
            if (ObjectUtils.isEmpty((Object)crmOpportunityVO)) {
                throw TwException.error("", "\u5f53\u524d\u552e\u524d\u6570\u636e\u4e0d\u5b58\u5728,id is " + reasonId);
            }
            variables.put(AccReimTaskKey.Activity_11xytgw.getCode(), Lists.newArrayList((Object[])new Long[]{crmOpportunityVO.getPreSaleUserId()}));
            PrdOrgOrganizationVO org = this.cacheUtil.getOrg(payload.getExpenseOrgId());
            variables.put(AccReimTaskKey.Activity_1bdkuyf.getCode(), Lists.newArrayList((Object[])new Long[]{org.getManageId()}));
        }
        if ((orgRef = this.cacheUtil.getBULevel1ByOrgId(payload.getExpenseOrgId())) == null) {
            throw TwException.error("", "\u8d39\u7528\u627f\u62c5\u4e8b\u4e1a\u90e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0cbuId is  " + payload.getExpenseOrgId());
        }
        variables.put(AccReimTaskKey.Activity_0s28lb1.getCode(), Lists.newArrayList((Object[])new Long[]{orgRef.getManageId()}));
    }

    private void setFlowResParent(Long userId, HashMap<String, Object> variables, String flowTaskKey) {
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(userId);
        variables.put("innerResFlag", true);
        if (StringUtils.hasText((String)userDefaultOrg.getExtString6()) && userDefaultOrg.getExtString6().equals("EXTERNAL_RES")) {
            variables.put("innerResFlag", false);
        }
        variables.put("manageResFlag", false);
        if (StringUtils.hasText((String)userDefaultOrg.getExtString2()) && userDefaultOrg.getExtString2().toLowerCase().contains("m")) {
            variables.put("manageResFlag", true);
        }
        variables.put(flowTaskKey, Lists.newArrayList((Object[])new Long[]{userDefaultOrg.getParentId()}));
    }

    private void flowAmtLimitCheck(BigDecimal reimTotalAmt, HashMap<String, Object> variables) {
        if (reimTotalAmt.compareTo(this.reimLimitAmt) > 0) {
            variables.put("limitAmtCheck", true);
        } else {
            variables.put("limitAmtCheck", false);
        }
    }

    private void buildReimTaxList(Long reimId, AccReimDetailPayload dtl, List<AccReimTaxPayload> taxPayloadList) {
        AccReimTaxPayload taxPayload = new AccReimTaxPayload();
        taxPayload.setReimId(reimId);
        taxPayload.setReimDtlId(dtl.getId());
        AccFinancialSubjectQuery query = new AccFinancialSubjectQuery();
        query.setAccCode(this.taxAccCode);
        List accFinancialSubjectVOS = this.accFinancialSubjectService.queryListDynamic(query);
        if (ObjectUtils.isEmpty((Object)accFinancialSubjectVOS)) {
            log.warn("\u5e94\u4ea4\u7a0e\u91d1-\u5e94\u4ea4\u589e\u503c\u7a0e-\u8fdb\u9879\u7a0e\u7f16\u7801\u672a\u5728\u7cfb\u7edf\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8fdb\u9879\u7a0e\u7f16\u7801\u4fe1\u606f\u7684\u7ef4\u62a4\uff01code is {}", (Object)this.taxAccCode);
            throw TwException.error("", "\u5e94\u4ea4\u7a0e\u91d1-\u5e94\u4ea4\u589e\u503c\u7a0e-\u8fdb\u9879\u7a0e\u7f16\u7801\u672a\u5728\u7cfb\u7edf\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8fdb\u9879\u7a0e\u7f16\u7801\u4fe1\u606f\u7684\u7ef4\u62a4\uff01");
        }
        Long taxAccId = ((AccFinancialSubjectVO)accFinancialSubjectVOS.get(0)).getId();
        taxPayload.setFinAccSubjId(taxAccId);
        taxPayload.setTaxAmt(dtl.getTaxAmt());
        taxPayload.setTaxRate(dtl.getTaxRate());
        taxPayloadList.add(taxPayload);
    }

    private void buildInvDocRef(Long reimId, Long reimDtlId, List<Long> invIdList, List<InvInvoicePayload> invInvoicePayloads) {
        invIdList.forEach(invId -> {
            InvInvoicePayload payload = new InvInvoicePayload();
            payload.setId(invId);
            payload.setReimId(reimId);
            payload.setReimDId(reimDtlId);
            payload.setInvReimStatus(InvoiceReimStatusEnum.OCCUPY.getCode());
            invInvoicePayloads.add(payload);
        });
    }

    private void relateDocHandle(AccReimPayload payload) {
        if (!ObjectUtils.isEmpty((Object)payload.getRelatedDocId())) {
            Long relateDocId = payload.getRelatedDocId();
            if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(payload.getReimDocType())) {
                AdmBusitripApplyPayload busitripApplyPayload = new AdmBusitripApplyPayload();
                busitripApplyPayload.setId(relateDocId);
                busitripApplyPayload.setReimId(payload.getId());
                this.busitripApplyService.updateByKeyDynamic(busitripApplyPayload);
            }
            if (AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(payload.getReimDocType())) {
                AdmFeeApplyPayload feeApplyPayload = new AdmFeeApplyPayload();
                feeApplyPayload.setId(relateDocId);
                feeApplyPayload.setReimId(payload.getId());
                this.feeApplyService.updateByKeyDynamic(feeApplyPayload);
            }
        }
        if (Boolean.FALSE.equals(payload.getUpdateFlag()) && !ObjectUtils.isEmpty((Object)payload.getTripTicketIds()) && AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            payload.getTripTicketIds().forEach(ticketId -> {
                AdmTripTicketPayload tripTicketPayload = new AdmTripTicketPayload();
                tripTicketPayload.setId(ticketId);
                tripTicketPayload.setReimId(payload.getId());
                tripTicketPayload.setReimbursementStatus(AccReimDocStatusEnum.APPLYING.getCode());
                this.admTripTicketService.updateByKeyDynamic(tripTicketPayload);
            });
        }
        if (Boolean.FALSE.equals(payload.getUpdateFlag()) && !ObjectUtils.isEmpty((Object)payload.getEpibolyCostDtlIds()) && AccReimDocTypeEnum.ACC_OTHERS_SD.getCode().equals(payload.getReimDocType())) {
            ConEpibolyCostConDQuery costConDQuery = new ConEpibolyCostConDQuery();
            costConDQuery.setIdList(payload.getEpibolyCostDtlIds());
            costConDQuery.setAuthAll(Boolean.valueOf(true));
            costConDQuery.setQueryDtlFlag(Boolean.valueOf(true));
            List conEpibolyCostConDVOS = this.conEpibolyCostConDService.queryListDynamic(costConDQuery);
            for (ConEpibolyCostConDVO conDVO : conEpibolyCostConDVOS) {
                if (!ObjectUtils.isEmpty((Object)conDVO.getDocType()) || !ObjectUtils.isEmpty((Object)conDVO.getDocumentNumber())) {
                    throw TwException.error("", "\u5f53\u671f\u5916\u5305\u8d39\u7528\u786e\u8ba4\u5355\u660e\u7ec6\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u518d\u6b21\u53d1\u8d77\u62a5\u9500\uff01id\u662f\uff1a" + conDVO.getId());
                }
                ConEpibolyCostConDPayload costConDPayload = new ConEpibolyCostConDPayload();
                costConDPayload.setId(conDVO.getId());
                costConDPayload.setDocType(AccReimDocTypeEnum.ACC_OTHERS_SD.getDesc());
                costConDPayload.setDocumentNumber(payload.getReimNo());
                this.conEpibolyCostConDService.updateByKeyDynamic(costConDPayload);
            }
        }
    }

    private void relateDocRelease(AccReimVO vo) {
        if (!ObjectUtils.isEmpty((Object)vo.getRelatedDocId())) {
            Long relateDocId = vo.getRelatedDocId();
            if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(vo.getReimDocType())) {
                AdmBusitripApplyPayload busitripApplyPayload = new AdmBusitripApplyPayload();
                busitripApplyPayload.setId(relateDocId);
                busitripApplyPayload.setReimDefaultFlag(Integer.valueOf(1));
                this.busitripApplyService.updateByKeyDynamic(busitripApplyPayload);
            }
            if (AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(vo.getReimDocType())) {
                AdmFeeApplyPayload feeApplyPayload = new AdmFeeApplyPayload();
                feeApplyPayload.setId(relateDocId);
                feeApplyPayload.setReimDefaultFlag(Integer.valueOf(1));
                this.feeApplyService.updateByKeyDynamic(feeApplyPayload);
            }
        }
        if (Boolean.TRUE.equals(vo.getDelFlag()) && AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(vo.getReimDocType())) {
            String unreimStatus = "UNREIM";
            AdmTripTicketQuery query = new AdmTripTicketQuery();
            query.setReimId(vo.getId());
            List admTripTicketVOS = this.admTripTicketService.queryListDynamic(query);
            if (ObjectUtils.isEmpty((Object)admTripTicketVOS)) {
                return;
            }
            List<Long> ticketIds = admTripTicketVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            ticketIds.forEach(ticketId -> {
                AdmTripTicketPayload payload = new AdmTripTicketPayload();
                payload.setId(ticketId);
                payload.setReimbursementStatus("UNREIM");
                ArrayList<String> nullFields = new ArrayList<String>();
                nullFields.add("reimId");
                payload.setNullFields(nullFields);
                this.admTripTicketService.updateByKeyDynamic(payload);
            });
        }
        if (Boolean.TRUE.equals(vo.getDelFlag()) && AccReimDocTypeEnum.ACC_OTHERS_SD.getCode().equals(vo.getReimDocType())) {
            ConEpibolyCostConDQuery costConDQuery = new ConEpibolyCostConDQuery();
            costConDQuery.setDocumentNumber(vo.getReimNo());
            costConDQuery.setAuthAll(Boolean.valueOf(true));
            costConDQuery.setQueryDtlFlag(Boolean.valueOf(true));
            List conEpibolyCostConDVOS = this.conEpibolyCostConDService.queryListDynamic(costConDQuery);
            if (ObjectUtils.isEmpty((Object)conEpibolyCostConDVOS)) {
                return;
            }
            ConEpibolyCostConDVO conDVO = (ConEpibolyCostConDVO)conEpibolyCostConDVOS.get(0);
            ConEpibolyCostConDPayload costConDPayload = new ConEpibolyCostConDPayload();
            costConDPayload.setId(conDVO.getId());
            ArrayList<String> nullFields = new ArrayList<String>();
            nullFields.add("docType");
            nullFields.add("documentNumber");
            costConDPayload.setNullFields(nullFields);
            this.conEpibolyCostConDService.updateByKeyDynamic(costConDPayload);
        }
    }

    private AccReimSourceRecordPayload buildSourceRecord(Long masId, Long dtlId, AccReimSourcePayload sourcePayload) {
        AccReimSourceRecordPayload payload = new AccReimSourceRecordPayload();
        payload.setReimId(masId);
        payload.setReimDtlId(dtlId);
        payload.setSource(sourcePayload);
        return payload;
    }

    private void checkDuplicateData(Long[] ids) {
        HashSet<Long> uniqueSet = new HashSet<Long>();
        boolean hasDuplicates = false;
        for (Long element : ids) {
            if (uniqueSet.add(element)) continue;
            hasDuplicates = true;
            break;
        }
        if (hasDuplicates) {
            throw TwException.error("", "\u5b58\u5728\u91cd\u590d\u7684\u5f85\u4ed8\u6b3e\u62a5\u9500\u5355\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\uff01");
        }
    }

    private void payBackCheck(AccReimVO reimVO) {
        String reimNo = reimVO.getReimNo();
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(reimVO.getReimDocType())) {
            throw TwException.error("", "\u62a5\u9500\u5355\u4e3a\u884c\u653f\u8ba2\u7968\u7c7b\u578b\uff0c\u65e0\u987b\u8fdb\u884c\u7f51\u94f6\u63d0\u4ea4\uff01\u62a5\u9500\u5355\u53f7\u662f\uff1a" + reimNo);
        }
        if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(reimVO.getPayStatus())) {
            throw TwException.error("", "\u62a5\u9500\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\u4e0d\u5141\u8bb8\u91cd\u590d\u652f\u4ed8\uff0c\u62a5\u9500\u5355\u53f7\u662f\uff1a" + reimNo);
        }
        if (!AccReimPayModeEnum.PAY_MODE_1.getCode().equals(reimVO.getPayMode())) {
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u4e0d\u662f\u7f51\u94f6\u652f\u4ed8\u65b9\u5f0f\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\uff01\u62a5\u9500\u5355\u53f7\u662f\uff1a" + reimNo);
        }
        if (!AccReimDocStatusEnum.PENDING_PAYMENT.getCode().equals(reimVO.getReimStatus())) {
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u4e0d\u662f\u5df2\u901a\u8fc7\u5f85\u4ed8\u6b3e\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01\u62a5\u9500\u5355\u53f7\u662f\uff1a" + reimNo);
        }
        if (ObjectUtils.isEmpty((Object)reimVO.getReimTotalAmt()) && reimVO.getReimTotalAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u5355\u62a5\u9500\u91d1\u989d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01\u62a5\u9500\u5355\u53f7\u662f\uff1a" + reimNo);
        }
        if (ObjectUtils.isEmpty((Object)reimVO.getAccountNo()) || ObjectUtils.isEmpty((Object)reimVO.getHolderName())) {
            throw TwException.error("", "\u6536\u6b3e\u8d26\u6237\u6216\u6237\u540d\u4e3a\u7a7a");
        }
    }

    private void buildPaymentDetail(AccReimVO accReimVO, BookAccountVO bookAccountVO, PayPayload payload, BigDecimal currentTotalAmt, int currentTotal) {
        payload.setDocId(accReimVO.getId().toString());
        payload.setDocNo(accReimVO.getReimNo());
        payload.setDocType(PurchasePaymentEnum.BankDocType.REIM.getCode());
        String reimNo = accReimVO.getReimNo();
        payload.setYurref(accReimVO.getId().toString() + "RR" + reimNo.substring(reimNo.length() - 4));
        payload.setAccnam(accReimVO.getHolderName());
        payload.setAccnamBankName(accReimVO.getBankName());
        payload.setAccnbr(accReimVO.getAccountNo());
        payload.setCrtbnk(bookAccountVO.getDepositBankOutlet());
        payload.setCrtadr("");
        payload.setPayaccnam(bookAccountVO.getAccountName());
        payload.setPayaccnbr(bookAccountVO.getAccountNo());
        payload.setTrsamt(accReimVO.getAdjustAmt() == null ? accReimVO.getReimTotalAmt() : accReimVO.getAdjustAmt());
        payload.setNusage(PurchasePaymentEnum.PayNusage.NUSAGE1.getDesc());
        payload.setUsrId(accReimVO.getReimUserId().toString());
        payload.setUsrName(this.cacheUtil.getUserName(accReimVO.getReimUserId()));
        payload.setCcynbr(Integer.valueOf(10));
        payload.setBnkflg(PurchasePaymentEnum.PaySystemEnum.YES.getCode());
        if (StringUtils.hasText((String)accReimVO.getBankName()) && !accReimVO.getBankName().contains("\u62db\u5546")) {
            payload.setBnkflg(PurchasePaymentEnum.PaySystemEnum.NO.getCode());
        }
        payload.setOrderType(PurchasePaymentEnum.OrderTypeEnum.REIM.getCode());
        payload.setTtlamt(currentTotalAmt);
        payload.setTtlcnt(Integer.valueOf(currentTotal));
        payload.setTtlnum(Integer.valueOf(currentTotal));
        payload.setCuramt(currentTotalAmt);
        payload.setCurcnt(Integer.valueOf(currentTotal));
        if (currentTotalAmt.compareTo(new BigDecimal(1000000)) > 0) {
            payload.setChlflg(PurchasePaymentEnum.PaySystemEnum.NO.getCode());
        } else {
            payload.setChlflg(PurchasePaymentEnum.PaySystemEnum.YES.getCode());
        }
    }

    private BkPayDetailRecordPayload buildPayDetailRecord(BkPayDetailVO payDetailVO) {
        BkPayDetailRecordPayload payload = new BkPayDetailRecordPayload();
        payload.setBatchFlag(payDetailVO.getBatchFlag());
        payload.setBkPayDetailId(payDetailVO.getId());
        payload.setBthnbr(payDetailVO.getBthnbr());
        payload.setYurref(payDetailVO.getYurref());
        payload.setTrxseq(payDetailVO.getTrxseq());
        payload.setPayStatus(Integer.valueOf(PurchasePaymentEnum.PayStatusDetailEnum.SEND.getCode()));
        payload.setOrderType(payDetailVO.getOrderType());
        payload.setTrsamt(payDetailVO.getTrsamt());
        return payload;
    }

    private TDocHistPayload buildDocHistory(AccReimVO reimVO, String hisType, String hisDtl) {
        TDocHistPayload tDocHistPayload = new TDocHistPayload();
        tDocHistPayload.setDocId(reimVO.getId());
        tDocHistPayload.setDocNo(reimVO.getReimNo());
        tDocHistPayload.setHistTime(LocalDateTime.now());
        tDocHistPayload.setOwnerId(reimVO.getReimUserId());
        tDocHistPayload.setCreateUserId(reimVO.getCreateUserId());
        tDocHistPayload.setDocType(PurchasePaymentEnum.PayDocType.REIM.getCode());
        tDocHistPayload.setHistType(hisType);
        tDocHistPayload.setHistDtl(hisDtl);
        return tDocHistPayload;
    }

    private void tripTicketRelease(AccReimVO vo, String batchType) {
        if (!AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(vo.getReimDocType())) {
            return;
        }
        if (AccPayBatchTypeEnum.CASHIER.getCode().equals(batchType)) {
            return;
        }
        String reimedStatus = "REIMED";
        AdmTripTicketQuery query = new AdmTripTicketQuery();
        query.setReimId(vo.getId());
        List admTripTicketVOS = this.admTripTicketService.queryListDynamic(query);
        if (ObjectUtils.isEmpty((Object)admTripTicketVOS)) {
            return;
        }
        List<Long> ticketIds = admTripTicketVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        ticketIds.forEach(ticketId -> {
            AdmTripTicketPayload payload = new AdmTripTicketPayload();
            payload.setId(ticketId);
            payload.setReimbursementStatus("REIMED");
            this.admTripTicketService.updateByKeyDynamic(payload);
        });
    }

    private void queyDetailExtraHandle(AccReimVO accReimVO) {
        BudgetVO budgetVO;
        PrdSystemFinPeriodVO prdSystemFinPeriodVO;
        PmsProjectVO pmsProjectVO;
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(accReimVO.getReimDocType())) {
            AdmTripTicketQuery tripTicketQuery = new AdmTripTicketQuery();
            tripTicketQuery.setReimId(accReimVO.getId());
            List admTripTicketVOS = this.admTripTicketService.queryListDynamic(tripTicketQuery);
            if (!ObjectUtils.isEmpty((Object)admTripTicketVOS)) {
                List ticketIds = admTripTicketVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                accReimVO.setTripTicketIds(ticketIds);
            }
        }
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(accReimVO.getReasonType()) && !ObjectUtils.isEmpty((Object)(pmsProjectVO = this.projectService.queryByKey(accReimVO.getReasonId())))) {
            StringBuilder sb = new StringBuilder();
            sb.append(accReimVO.getReasonName()).append("/");
            sb.append(pmsProjectVO.getReferCode());
            accReimVO.setRelateProjAndConNO(sb.toString());
            accReimVO.setConSignOuName(pmsProjectVO.getOuName());
        }
        if (!ObjectUtils.isEmpty((Object)accReimVO.getFinPeriodId()) && !ObjectUtils.isEmpty((Object)(prdSystemFinPeriodVO = this.finPeriodService.queryByKey(accReimVO.getFinPeriodId())))) {
            accReimVO.setFinPeriodName(prdSystemFinPeriodVO.getPeriodName());
        }
        if (!ObjectUtils.isEmpty((Object)accReimVO.getRelatedBudgetId()) && !ObjectUtils.isEmpty((Object)(budgetVO = this.budgetService.queryByKey(accReimVO.getRelatedBudgetId())))) {
            accReimVO.setRelatedBudgetName(budgetVO.getBudgetName());
        }
        if (!ObjectUtils.isEmpty((Object)accReimVO.getFileCode())) {
            Object fileData = this.fileUtil.getFileDatas(accReimVO.getFileCode());
            accReimVO.setFileData(fileData);
        }
    }

    public void chargeExportDataHandle(List<AccReimExportVO> mainData, Map<Long, List<BusinessPartnerVO>> bookIdMap, Map<Long, List<PrdOrgOrganizationVO>> orgIdMap, Map<Long, List<PrdOrgEmployeeVO>> userIdMap, Map<Long, List<PmsProjectVO>> reasonIdMap, String batchNo) {
        List bookIds = mainData.stream().map(AccReimExportVO::getExpenseCompany).collect(Collectors.toList());
        List businessPartnerVOS = this.businessPartnerService.queryByBookIdsAndType(bookIds, BusinessInsideOrOutSideEnum.INSIDE.getCode());
        if (ObjectUtils.isEmpty((Object)businessPartnerVOS)) {
            log.warn("\u5f53\u524d\u6279\u6b21\u5bf9\u5e94\u7684\u62a5\u9500\u5355\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4fe1\u606f\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff01\u6279\u6b21\u53f7\u662f {}", (Object)batchNo);
            throw TwException.error("", "\u5f53\u524d\u6279\u6b21\u5bf9\u5e94\u7684\u62a5\u9500\u5355\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4fe1\u606f\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff01");
        }
        bookIdMap.clear();
        bookIdMap.putAll(businessPartnerVOS.stream().collect(Collectors.groupingBy(BusinessPartnerVO::getBookId)));
        Set orgIdList = mainData.stream().map(AccReimExportVO::getExpenseOrgId).collect(Collectors.toSet());
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setOrgIdList(new ArrayList(orgIdList));
        List prdOrgOrganizationVOS = this.orgOrganizationService.queryAllByQuery(orgQuery);
        if (ObjectUtils.isEmpty((Object)prdOrgOrganizationVOS)) {
            log.warn("\u5f53\u524d\u6279\u6b21\u5bf9\u5e94\u7684\u62a5\u9500\u5355\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4fe1\u606f\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff01\u6279\u6b21\u53f7\u662f {}", (Object)batchNo);
            throw TwException.error("", "\u5f53\u524d\u6279\u6b21\u5bf9\u5e94\u7684\u62a5\u9500\u5355\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4fe1\u606f\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff01");
        }
        orgIdMap.clear();
        orgIdMap.putAll(prdOrgOrganizationVOS.stream().collect(Collectors.groupingBy(BaseViewModel::getId)));
        Set userIdList = mainData.stream().map(AccReimExportVO::getReimUserId).collect(Collectors.toSet());
        PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
        employeeQuery.setUserIdList(userIdList);
        List prdOrgEmployeeVOS = this.employeeService.queryList(employeeQuery);
        if (ObjectUtils.isEmpty((Object)prdOrgEmployeeVOS)) {
            log.warn("\u5f53\u524d\u6279\u6b21\u5bf9\u5e94\u7684\u62a5\u9500\u5355\u5458\u5de5\u4fe1\u606f\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff01\u6279\u6b21\u53f7\u662f {}", (Object)batchNo);
            throw TwException.error("", "\u5f53\u524d\u6279\u6b21\u5bf9\u5e94\u7684\u62a5\u9500\u5355\u5458\u5de5\u4fe1\u606f\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff01");
        }
        userIdMap.clear();
        userIdMap.putAll(prdOrgEmployeeVOS.stream().collect(Collectors.groupingBy(PrdOrgEmployeeVO::getUserId)));
        Set reasonIdList = mainData.stream().map(AccReimExportVO::getReasonId).collect(Collectors.toSet());
        List pmsProjectVOS = this.projectService.queryListByReasonIdList(new ArrayList(reasonIdList));
        if (ObjectUtils.isEmpty((Object)pmsProjectVOS)) {
            log.warn("\u5f53\u524d\u6279\u6b21\u5bf9\u5e94\u7684\u62a5\u9500\u5355\u9879\u76ee\u4fe1\u606f\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff01\u6279\u6b21\u53f7\u662f {}", (Object)batchNo);
        }
        reasonIdMap.clear();
        reasonIdMap.putAll(pmsProjectVOS.stream().collect(Collectors.groupingBy(PmsProjectVO::getId)));
    }

    public AccReimPrintVO queryPrintPayData(List<Long> batchIdList) {
        AccReimPayBatchQuery query = new AccReimPayBatchQuery();
        query.setIds(batchIdList);
        List accReimPayBatchVOList = this.reimPayBatchService.queryListDynamic(query);
        if (CollectionUtils.isEmpty((Collection)accReimPayBatchVOList)) {
            throw TwException.error("", "\u5f53\u524d\u8bb0\u8d26\u6279\u6b21\u4e0d\u5b58\u5728");
        }
        Long userId = GlobalUtil.getLoginUserId();
        String userName = this.cacheUtil.getUserName(userId);
        AccReimQuery accReimQuery = new AccReimQuery();
        Set collect = accReimPayBatchVOList.stream().filter(accReimPayBatchVO -> !ObjectUtils.isEmpty((Object)accReimPayBatchVO.getBatchNo())).map(p -> p.getBatchNo()).collect(Collectors.toSet());
        accReimQuery.setBatchNoList(new ArrayList(collect));
        List<AccReimVO> accReimVOS = this.dao.queryListDynamic(accReimQuery);
        AccReimPrintVO accReimPrintVO = new AccReimPrintVO();
        if (!CollectionUtils.isEmpty(accReimVOS)) {
            StringBuilder stringBuilder = new StringBuilder();
            accReimPayBatchVOList.stream().forEach(p -> stringBuilder.append("\u6279\u6b21\u53f7:" + p.getBatchNo() + " \u62a5\u9500\u603b\u91d1\u989d:" + p.getBatchAmt() + "\u5143 \n"));
            accReimPrintVO.setBatchNoAndAmt(stringBuilder.toString());
            Long loginUserId = GlobalUtil.getLoginUserId();
            PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(loginUserId);
            Long orgId = this.cacheUtil.getDefaultOrgIdByUserId(loginUserId);
            PrdOrgOrganizationVO org = this.cacheUtil.getOrg(orgId);
            accReimPrintVO.setEmployeeNo(employee.getEmployeeNo());
            accReimPrintVO.setBuName(org.getOrgName());
            if (org != null) {
                accReimPrintVO.setOrgCode(org.getOrgCode());
            }
            accReimPrintVO.setApplyName(employee.getEmployeeName());
            accReimPrintVO.setAccountSubjectName(ACCOUNT_SUBJECT_NAME);
            accReimPrintVO.setBankSubjectName(BANK_SUBJECT_NAME);
            accReimPrintVO.setExpenseProofDigest(accReimVOS.get(0).getExpenseProofDigest());
            BigDecimal totalAmt = BigDecimal.ZERO;
            ArrayList<AccReimPrintDetailVO> accReimPrintDetailVOList = new ArrayList<AccReimPrintDetailVO>();
            for (AccReimVO vo : accReimVOS) {
                AccReimPrintDetailVO accReimPrintDetailVO = new AccReimPrintDetailVO();
                accReimPrintDetailVO.setBatchNo(vo.getBatchNo());
                accReimPrintDetailVO.setReimNo(vo.getReimNo());
                accReimPrintDetailVO.setReimName(this.cacheUtil.getUserName(vo.getReimUserId()));
                accReimPrintDetailVO.setReimAmt(vo.getReimTotalAmt());
                accReimPrintDetailVO.setAccountNo(vo.getAccountNo());
                accReimPrintDetailVO.setExportName(userName);
                accReimPrintDetailVO.setReimTime(TimeUtil.datetime2String(((AccReimPayBatchVO)accReimPayBatchVOList.get(0)).getBatchTime()));
                accReimPrintDetailVOList.add(accReimPrintDetailVO);
                totalAmt = totalAmt.add(vo.getReimTotalAmt());
            }
            accReimPrintVO.setTotalAmt(totalAmt);
            accReimPrintVO.setCredit(totalAmt);
            accReimPrintVO.setDebit(totalAmt);
            accReimPrintVO.setAccReimPrintDetailVOList(accReimPrintDetailVOList);
        }
        return accReimPrintVO;
    }

    private Long getFinPeriod() {
        PrdSystemFinPeriodQuery query = new PrdSystemFinPeriodQuery();
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String periodName = now.format(formatter);
        query.setPeriodName(periodName);
        List prdSystemFinPeriodVOS = this.finPeriodService.queryListDynamic(query);
        if (ObjectUtils.isEmpty((Object)prdSystemFinPeriodVOS)) {
            throw TwException.error("", "\u5f53\u524d\u65e5\u671f\u7684\u8d22\u52a1\u671f\u95f4\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458!");
        }
        PrdSystemFinPeriodVO prdSystemFinPeriodVO = (PrdSystemFinPeriodVO)prdSystemFinPeriodVOS.get(0);
        return prdSystemFinPeriodVO.getId();
    }

    public List<AccReimExportVO> getExportChargeData(String batchNo) {
        return this.dao.getExportChargeData(batchNo);
    }

    public List<AccReimExportVO> getExportChargeDataByKeys(List<Long> keys) {
        return this.dao.getExportChargeDataByKeys(keys);
    }

    @Transactional
    public void updateAccountDigestAndStatusByKeys(List<Long> keys, String expenseProofDigest, String expenseProofNo, String expenseProofStatus, String expenseProofFailReason) {
        this.dao.updateAccountDigestAndStatusByKeys(keys, expenseProofDigest, expenseProofNo, expenseProofStatus, expenseProofFailReason);
    }

    @Transactional
    public void updatePayDigestAndStatusByKeys(List<Long> keys, String payProofDigest, String payProofNo, String payProofStatus, String payProofFailReason) {
        this.dao.updatePayDigestAndStatusByKeys(keys, payProofDigest, payProofNo, payProofStatus, payProofFailReason);
    }

    @Transactional
    public void batchPayCharge(List<Long> keys, String payProofDigest) {
        AccReimQuery accReimQuery = new AccReimQuery();
        accReimQuery.setIdList(keys);
        List<AccReimVO> accReimVOS = this.dao.queryListDynamic(accReimQuery);
        this.dao.updatePayDigestAndStatusByKeys(keys, null, null, null, null);
    }

    public AccReimServiceImpl(AccReimRepo repo, AccReimDAO dao, AccReimDetailDAO detailDAO, BudgetService budgetService, CacheUtil cacheUtil, WorkflowUtil workflowUtil, PmsProjectService projectService, BuProjectService buProjectService, CrmOpportunityService opportunityService, AccReimPayBatchService reimPayBatchService, AccReimSourceConfigService reimSourceConfigService, PrdOrgEmployeeService employeeService, AccReimTripStdService accReimTripStdService, AccReimTaxService accReimTaxService, InvInvoiceService invInvoiceService, TransactionUtilService transactionUtilService, ExcelUtil excelUtil, AdmBusitripApplyService busitripApplyService, AdmFeeApplyService feeApplyService, AccReimSourceRecordService reimSourceRecordService, BudgetCommonService budgetCommonService, AdmTripTicketService admTripTicketService, ConEpibolyCostConDService conEpibolyCostConDService, TDocHistService tDocHistService, PrdSystemRoleService roleService, BookAccountService bookAccountService, BusinessPartnerService businessPartnerService, BkPayDetailRecordService bkPayDetailRecordService, PrdOrgOrganizationService orgOrganizationService, PrdSystemFinPeriodService finPeriodService, AccReimRuleService reimRuleService, AccFinancialSubjectService accFinancialSubjectService, FileUtil fileUtil, AccReimSettingOverdueService accReimSettingOverdueService, AccReimSettingContinuousService accReimSettingContinuousService, AccReimSettingTitleService accReimSettingTitleService, AccReimSettingLimitService accReimSettingLimitService, AccReimDetailMealService accReimDetailMealService) {
        this.repo = repo;
        this.dao = dao;
        this.detailDAO = detailDAO;
        this.budgetService = budgetService;
        this.cacheUtil = cacheUtil;
        this.workflowUtil = workflowUtil;
        this.projectService = projectService;
        this.buProjectService = buProjectService;
        this.opportunityService = opportunityService;
        this.reimPayBatchService = reimPayBatchService;
        this.reimSourceConfigService = reimSourceConfigService;
        this.employeeService = employeeService;
        this.accReimTripStdService = accReimTripStdService;
        this.accReimTaxService = accReimTaxService;
        this.invInvoiceService = invInvoiceService;
        this.transactionUtilService = transactionUtilService;
        this.excelUtil = excelUtil;
        this.busitripApplyService = busitripApplyService;
        this.feeApplyService = feeApplyService;
        this.reimSourceRecordService = reimSourceRecordService;
        this.budgetCommonService = budgetCommonService;
        this.admTripTicketService = admTripTicketService;
        this.conEpibolyCostConDService = conEpibolyCostConDService;
        this.tDocHistService = tDocHistService;
        this.roleService = roleService;
        this.bookAccountService = bookAccountService;
        this.businessPartnerService = businessPartnerService;
        this.bkPayDetailRecordService = bkPayDetailRecordService;
        this.orgOrganizationService = orgOrganizationService;
        this.finPeriodService = finPeriodService;
        this.reimRuleService = reimRuleService;
        this.accFinancialSubjectService = accFinancialSubjectService;
        this.fileUtil = fileUtil;
        this.accReimSettingOverdueService = accReimSettingOverdueService;
        this.accReimSettingContinuousService = accReimSettingContinuousService;
        this.accReimSettingTitleService = accReimSettingTitleService;
        this.accReimSettingLimitService = accReimSettingLimitService;
        this.accReimDetailMealService = accReimDetailMealService;
    }
}

