/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingContinuousPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingContinuousQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingContinuousService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingContinuousVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingContinuousConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingContinuousDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingContinuousDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingContinuousRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AccReimSettingContinuousServiceImpl
extends BaseServiceImpl
implements AccReimSettingContinuousService {
    private static final Logger log = LoggerFactory.getLogger(AccReimSettingContinuousServiceImpl.class);
    private final AccReimSettingContinuousRepo accReimSettingContinuousRepo;
    private final AccReimSettingContinuousDAO accReimSettingContinuousDAO;
    private final AccReimSettingService accReimSettingService;
    private final AccReimSettingRepo accReimSettingRepo;
    private final CacheUtil cacheUtil;
    private final InvInvoiceService invInvoiceService;

    public PagingVO<AccReimSettingContinuousVO> queryPaging(AccReimSettingContinuousQuery query) {
        return this.accReimSettingContinuousDAO.queryPaging(query);
    }

    public List<AccReimSettingContinuousVO> queryListDynamic(AccReimSettingContinuousQuery query) {
        return this.accReimSettingContinuousDAO.queryListDynamic(query);
    }

    public AccReimSettingContinuousVO queryByKey(Long key) {
        AccReimSettingContinuousDO entity = this.accReimSettingContinuousRepo.findById(key).orElseGet(AccReimSettingContinuousDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingContinuousVO vo = AccReimSettingContinuousConvert.INSTANCE.toVo(entity);
        AccReimSettingQuery accReimSettingQuery = new AccReimSettingQuery();
        accReimSettingQuery.setSpecificReimSettingId(key);
        accReimSettingQuery.setReimSettingType(AccReimSettingTypeEnum.SERIATE.getCode());
        List accReimSettingVOS = this.accReimSettingService.queryListDynamic(accReimSettingQuery);
        if (!CollectionUtils.isEmpty((Collection)accReimSettingVOS)) {
            vo.setAccReimSettingVO((AccReimSettingVO)accReimSettingVOS.get(0));
        }
        this.translateList(Collections.singletonList(vo));
        return vo;
    }

    private void translateList(List<AccReimSettingContinuousVO> voList) {
        for (AccReimSettingContinuousVO vo : voList) {
            if (!StringUtils.hasText((String)vo.getInvoiceType())) continue;
            ArrayList<String> invoiceTypes = new ArrayList<String>();
            for (String reimDocType : vo.getInvoiceType().split(",")) {
                String reimDocTypeName = this.cacheUtil.transferSystemSelection("INV:INPUT_INV_TYPE", reimDocType);
                invoiceTypes.add(reimDocTypeName);
            }
            String invoiceTypeDesc = String.join((CharSequence)",", invoiceTypes);
            vo.setInvoiceTypeDesc(invoiceTypeDesc);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingContinuousVO insert(AccReimSettingContinuousPayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        AccReimSettingContinuousDO entityDo = AccReimSettingContinuousConvert.INSTANCE.toDo(payload);
        AccReimSettingContinuousVO accReimSettingContinuousVO = AccReimSettingContinuousConvert.INSTANCE.toVo((AccReimSettingContinuousDO)this.accReimSettingContinuousRepo.save(entityDo));
        Long id = accReimSettingContinuousVO.getId();
        accReimSettingPayload.setSpecificReimSettingId(id);
        accReimSettingPayload.setReimSettingType(AccReimSettingTypeEnum.SERIATE.getCode());
        this.accReimSettingService.checkRepeat(accReimSettingPayload);
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(accReimSettingDO));
        accReimSettingContinuousVO.setAccReimSettingVO(accReimSettingVO);
        return accReimSettingContinuousVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingContinuousVO update(AccReimSettingContinuousPayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        this.accReimSettingService.checkRepeat(accReimSettingPayload);
        AccReimSettingContinuousDO entity = this.accReimSettingContinuousRepo.findById(payload.getId()).orElseGet(AccReimSettingContinuousDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingContinuousDO entityDo = AccReimSettingContinuousConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        AccReimSettingContinuousVO accReimSettingContinuousVO = AccReimSettingContinuousConvert.INSTANCE.toVo((AccReimSettingContinuousDO)this.accReimSettingContinuousRepo.save(entity));
        AccReimSettingDO accReimSettingEntity = this.accReimSettingRepo.findById(accReimSettingPayload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull((Object)accReimSettingEntity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        accReimSettingEntity.copy(accReimSettingDO);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(accReimSettingEntity));
        accReimSettingContinuousVO.setAccReimSettingVO(accReimSettingVO);
        return accReimSettingContinuousVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccReimSettingContinuousPayload payload) {
        AccReimSettingContinuousDO entity = this.accReimSettingContinuousRepo.findById(payload.getId()).orElseGet(AccReimSettingContinuousDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.accReimSettingContinuousDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accReimSettingContinuousDAO.deleteSoft(keys);
        }
    }

    public AccReimSettingContinuousVO ruleCheck(Long key, List<InvInvoiceVO> invInvoiceVOS, Long reimUserId) {
        List idList;
        AccReimSettingContinuousVO accReimSettingContinuousVO = this.queryByKey(key);
        String invoiceType = accReimSettingContinuousVO.getInvoiceType();
        List invoiceTypeList = Arrays.stream(invoiceType.split(",")).collect(Collectors.toList());
        AccReimSettingVO accReimSettingVO = accReimSettingContinuousVO.getAccReimSettingVO();
        String whiteList = accReimSettingVO.getWhiteList();
        if (StringUtils.hasText((String)whiteList) && (idList = Arrays.stream(whiteList.split(",")).map(Long::parseLong).collect(Collectors.toList())).contains(reimUserId)) {
            return accReimSettingContinuousVO;
        }
        Object continuousInvoiceNosStr = "";
        Object remindText = "";
        Object errorText = "";
        for (InvInvoiceVO invInvoiceVO : invInvoiceVOS) {
            List invInvoiceVOS1;
            String invNo = invInvoiceVO.getInvoiceNo();
            if (!invoiceTypeList.contains(invInvoiceVO.getInvType())) continue;
            InvInvoiceQuery invInvoiceQuery1 = new InvInvoiceQuery();
            invInvoiceQuery1.setInvoiceDateGt(LocalDate.now().minusDays(accReimSettingContinuousVO.getCheckDays().intValue()));
            invInvoiceQuery1.setInvType(invInvoiceVO.getInvType());
            ArrayList<CallSite> invoiceNos = new ArrayList<CallSite>();
            String tailChar = invNo.substring(invNo.length() - 3);
            String headChar = invNo.substring(0, invNo.length() - 3);
            Integer checkStep = accReimSettingContinuousVO.getCheckStep();
            try {
                Integer tailInt = Integer.parseInt(tailChar);
                for (int i = 1; i < checkStep + 1; ++i) {
                    int tailAdd = tailInt + i;
                    int tailSubtract = tailInt - i;
                    String tailAddStr = AccReimSettingContinuousServiceImpl.padZero(tailAdd);
                    String tailSubtractStr = AccReimSettingContinuousServiceImpl.padZero(tailSubtract);
                    String invoiceNoAdd = headChar + tailAddStr;
                    String invoiceNoSubtract = headChar + tailSubtractStr;
                    invoiceNos.add((CallSite)((Object)invoiceNoAdd));
                    invoiceNos.add((CallSite)((Object)invoiceNoSubtract));
                }
            }
            catch (Exception e2) {
                return accReimSettingContinuousVO;
            }
            invInvoiceQuery1.setInvoiceNoIn(invoiceNos);
            String checkRange = accReimSettingContinuousVO.getCheckRange();
            if (checkRange.equals("OWN")) {
                invInvoiceQuery1.setInvOwnerId(invInvoiceVO.getInvOwnerId());
            }
            if (CollectionUtils.isEmpty((Collection)(invInvoiceVOS1 = this.invInvoiceService.queryListDynamic(invInvoiceQuery1)))) continue;
            String continuousInvoiceNos = invInvoiceVOS1.stream().map(e -> e.getInvoiceNo()).collect(Collectors.joining(","));
            Object object = continuousInvoiceNosStr = ((String)continuousInvoiceNosStr).length() < 1 ? (String)continuousInvoiceNosStr + continuousInvoiceNos : (String)continuousInvoiceNosStr + "," + continuousInvoiceNos;
            if (accReimSettingVO.getRemindText() != null) {
                String remindTextCopy = accReimSettingVO.getRemindText();
                remindTextCopy = remindTextCopy.replace("#{1}", invNo).replace("#{2}", continuousInvoiceNos);
                Object object2 = remindText = ((String)remindText).length() < 1 ? (String)remindText + remindTextCopy : (String)remindText + "," + remindTextCopy;
            }
            if (accReimSettingVO.getErrorText() == null) continue;
            String errorTextCopy = accReimSettingVO.getErrorText();
            errorTextCopy = errorTextCopy.replace("#{1}", invNo).replace("#{2}", continuousInvoiceNos);
            errorText = ((String)errorText).length() < 1 ? (String)errorText + errorTextCopy : (String)errorText + "," + errorTextCopy;
        }
        accReimSettingContinuousVO.setContinuousInvoiceNos((String)continuousInvoiceNosStr);
        accReimSettingVO.setRemindText((String)remindText);
        accReimSettingVO.setErrorText((String)errorText);
        return accReimSettingContinuousVO;
    }

    public static String padZero(int number) {
        Object numberStr = String.valueOf(number);
        while (((String)numberStr).length() < 3) {
            numberStr = "0" + (String)numberStr;
        }
        return numberStr;
    }

    public AccReimSettingContinuousServiceImpl(AccReimSettingContinuousRepo accReimSettingContinuousRepo, AccReimSettingContinuousDAO accReimSettingContinuousDAO, AccReimSettingService accReimSettingService, AccReimSettingRepo accReimSettingRepo, CacheUtil cacheUtil, InvInvoiceService invInvoiceService) {
        this.accReimSettingContinuousRepo = accReimSettingContinuousRepo;
        this.accReimSettingContinuousDAO = accReimSettingContinuousDAO;
        this.accReimSettingService = accReimSettingService;
        this.accReimSettingRepo = accReimSettingRepo;
        this.cacheUtil = cacheUtil;
        this.invInvoiceService = invInvoiceService;
    }
}

