/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdOrgResQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonResVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeGradePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeEqvaRatioQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeBSVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeEqvaRatioVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u6e90\u5e93\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/org"})
@PermissionDomain(domain=PermissionDomainEnum.PRD_ORG_RES)
public class PersonResController {
    private static final Logger log = LoggerFactory.getLogger(PersonResController.class);
    private final PersonResService personResService;
    private final PrdOrgEmployeeEqvaRatioService eqvaRatioServicer;

    @ApiOperation(value="id\u67e5\u8be2")
    @GetMapping(value={"/res/{id}"})
    @UdcNameClass
    public TwOutputUtil<PersonResVO> findById(@PathVariable Long id) {
        return TwOutputUtil.ok(this.personResService.queryById(id));
    }

    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    @GetMapping(value={"/res/paging"})
    public TwOutputUtil<PagingVO<PrdOrgEmployeeVO>> queryPaging(PrdOrgEmployeeQuery query) {
        PagingVO paging = this.personResService.page(query);
        return TwOutputUtil.ok(paging);
    }

    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.PRD_ORG_RES, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2-\u5e26\u6743\u9650\u67e5\u8be2")
    @PostMapping(value={"/permission/res/paging"})
    @UdcNameClass
    public TwOutputUtil<PagingVO<PrdOrgEmployeeBSVO>> permissionPaging(@RequestBody PrdOrgResQuery query) {
        PagingVO paging = this.personResService.permissionPaging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation(value="\u83b7\u53d6\u5458\u5de5\u5185\u63a8\u4eba")
    @GetMapping(value={"/res/getInternalRecommUser/{userId}"})
    public TwOutputUtil getJobInternalRecommId(@PathVariable Long userId) {
        return TwOutputUtil.ok(this.personResService.getJobInternalRecommUserId(userId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5458\u5de5\u8303\u56f4\u5185\u5f53\u91cf\u7cfb\u6570\u5217\u8868")
    @GetMapping(value={"/res/getEqvaRatioList"})
    public TwOutputUtil<List<PrdOrgEmployeeEqvaRatioVO>> getEqvaRatioList(PrdOrgEmployeeEqvaRatioQuery query) {
        return TwOutputUtil.ok(this.eqvaRatioServicer.getEqvaRatioListByDate(query));
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5458\u5de5\u804c\u7ea7\u3001\u5f53\u91cf\u7cfb\u6570")
    @PostMapping(value={"/res/grade/batchUpsert"})
    public TwOutputUtil batchUpsert(@RequestBody PrdOrgEmployeeGradePayload payload) {
        this.eqvaRatioServicer.batchUpsert(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fdd\u5b58\u5f53\u91cf\u7cfb\u6570\u8bb0\u5f55")
    @PostMapping(value={"/res/grade/upsertEqvaRatio"})
    public TwOutputUtil upsertEqvaRatio(PrdOrgEmployeeEqvaRatioPayload payload) {
        this.eqvaRatioServicer.upsertEqvaRatio(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5458\u5de5\u4e00\u952e\u79bb\u804c")
    @GetMapping(value={"/res/depart"})
    public TwOutputUtil depart(Long id, String date) {
        LocalDate localDateDate = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        this.personResService.depart(id, localDateDate);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="userId\u67e5\u8be2")
    @GetMapping(value={"/res/queryByUserId/{userId}"})
    @UdcNameClass
    public TwOutputUtil<PersonResVO> findByUserId(@PathVariable Long userId) {
        return TwOutputUtil.ok(this.personResService.queryByUserId(userId));
    }

    public PersonResController(PersonResService personResService, PrdOrgEmployeeEqvaRatioService eqvaRatioServicer) {
        this.personResService = personResService;
        this.eqvaRatioServicer = eqvaRatioServicer;
    }
}

