/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.WorkOrderApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.WorkOrderApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.WorkOrderApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.WorkOrderApplyVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.convert.WorkOrderApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.WorkOrderApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.WorkOrderApplyDO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WorkOrderApplyServiceImpl
extends BaseServiceImpl
implements WorkOrderApplyService {
    private static final Logger log = LoggerFactory.getLogger(WorkOrderApplyServiceImpl.class);
    private final WorkOrderApplyDAO workOrderApplyDAO;
    private final WorkflowUtil workflowUtil;
    private final PmsProjectService pmsProjectService;
    private final CrmOpportunityService crmOpportunityService;
    private final PrdOrgOrganizationService orgOrganizationService;
    private final PrdSystemRoleService prdSystemRoleService;
    private final CacheUtil cacheUtil;
    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final FileUtil fileUtil;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;

    public void submit(WorkOrderApplyPayload payload) {
        WorkOrderApplyDO payDO = WorkOrderApplyConvert.INSTANCE.payloadToDo(payload);
        if (payload.getId() == null) {
            Long manageId;
            PrdOrgOrganizationVO orgOrganizationVO;
            String applyNo = this.generateSeqNum("WORK_ORDER_APPLY_NO", new String[0]);
            payDO.setApplyNo(applyNo);
            WorkOrderApplyDO workOrderApplyDO = this.workOrderApplyDAO.save(payDO);
            ProcessInfo processInfo = new ProcessInfo();
            String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            HashMap<String, List> variables = new HashMap<String, List>();
            if (payload.getReasonType().equals("PROJ")) {
                PmsProjectVO projectVO = this.pmsProjectService.queryByKey(payload.getReasonId());
                Long pmUserId = projectVO.getPmResId();
                Long deliBuId = projectVO.getDeliBuId();
                orgOrganizationVO = this.cacheUtil.getOrg(deliBuId);
                manageId = orgOrganizationVO.getManageId();
                variables.put("Activity_1w250t6", CollUtil.newArrayList((Object[])new Long[]{pmUserId}));
                variables.put("Activity_1um2jla", CollUtil.newArrayList((Object[])new Long[]{manageId}));
            }
            if (payload.getReasonType().equals("OPPO")) {
                CrmOpportunityVO crmOpportunityVO = this.crmOpportunityService.queryByKey(payload.getReasonId());
                Long preSaleUserId = crmOpportunityVO.getPreSaleUserId();
                Long preSaleOrgId = crmOpportunityVO.getPreSaleOrgId();
                orgOrganizationVO = this.cacheUtil.getOrg(preSaleOrgId);
                manageId = orgOrganizationVO.getManageId();
                variables.put("Activity_1w250t6", CollUtil.newArrayList((Object[])new Long[]{preSaleUserId}));
                variables.put("Activity_1um2jla", CollUtil.newArrayList((Object[])new Long[]{manageId}));
            }
            List resDirectors = this.prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode());
            variables.put("Activity_1iqm80n", resDirectors);
            List finLeaderIds = this.prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_PIC.getCode());
            variables.put("Activity_0691hsv", finLeaderIds);
            List extResManageId = this.prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode());
            variables.put("Activity_1mzy17m", extResManageId);
            variables.put("Activity_0xokibz", extResManageId);
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.WORK_ORDER_APPLY.name(), (String)("\u6d3e\u5de5\u5355\u7533\u8bf7-" + payload.getConsultantName()), (String)("" + workOrderApplyDO.getId()), variables), new Long[0]);
            payload.setId(workOrderApplyDO.getId());
            payload.setProcInstId(processInfo.getProcInstId());
            payload.setProcInstStatus(processInfo.getProcInstStatus());
            this.workOrderApplyDAO.updateProcData(payload);
            String userName = GlobalUtil.getLoginUserName();
            String title = "\u6d3e\u5de5\u5355\u7533\u8bf7";
            String content = userName + "\uff0c\u53d1\u8d77\u4e86\u6d3e\u5de5\u5355\u7533\u8bf7\uff0c \u8bf7\u76f8\u5173\u8d1f\u8d23\u4eba\u53ca\u65f6\u67e5\u770b";
            this.sendMessage(workOrderApplyDO.getId(), title, content);
        } else {
            this.workOrderApplyDAO.save(payDO);
        }
    }

    public WorkOrderApplyVO queryByProcId(String procId) {
        WorkOrderApplyDO workOrderApplyDO = this.workOrderApplyDAO.findByProcId(procId);
        if (workOrderApplyDO != null) {
            WorkOrderApplyVO workOrderApplyVO = WorkOrderApplyConvert.INSTANCE.doToVo(workOrderApplyDO);
            workOrderApplyVO.setOrderDatas(this.fileUtil.getFileDatas(workOrderApplyVO.getOrderCodes()));
            workOrderApplyVO.setResumeDatas(this.fileUtil.getFileDatas(workOrderApplyVO.getResumeCodes()));
            return workOrderApplyVO;
        }
        return null;
    }

    public WorkOrderApplyVO queryByKey(Long id) {
        WorkOrderApplyDO workOrderApplyDO = this.workOrderApplyDAO.queryByKey(id);
        if (workOrderApplyDO != null) {
            WorkOrderApplyVO workOrderApplyVO = WorkOrderApplyConvert.INSTANCE.doToVo(workOrderApplyDO);
            workOrderApplyVO.setOrderDatas(this.fileUtil.getFileDatas(workOrderApplyVO.getOrderCodes()));
            workOrderApplyVO.setResumeDatas(this.fileUtil.getFileDatas(workOrderApplyVO.getResumeCodes()));
            return workOrderApplyVO;
        }
        return null;
    }

    public PagingVO<WorkOrderApplyVO> queryPaging(WorkOrderApplyQuery query) {
        return this.workOrderApplyDAO.queryPaging(query);
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(Integer.valueOf(2));
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(Integer.valueOf(0));
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(Integer.valueOf(3));
        ado.setMessageContent(content);
        ArrayList list = new ArrayList();
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            this.messageConfigService.insert(ado);
        }
    }

    public WorkOrderApplyServiceImpl(WorkOrderApplyDAO workOrderApplyDAO, WorkflowUtil workflowUtil, PmsProjectService pmsProjectService, CrmOpportunityService crmOpportunityService, PrdOrgOrganizationService orgOrganizationService, PrdSystemRoleService prdSystemRoleService, CacheUtil cacheUtil, PrdCompositeAbilityService prdCompositeAbilityService, FileUtil fileUtil, PrdMessageConfigService messageConfigService, PrdSystemRoleService roleService) {
        this.workOrderApplyDAO = workOrderApplyDAO;
        this.workflowUtil = workflowUtil;
        this.pmsProjectService = pmsProjectService;
        this.crmOpportunityService = crmOpportunityService;
        this.orgOrganizationService = orgOrganizationService;
        this.prdSystemRoleService = prdSystemRoleService;
        this.cacheUtil = cacheUtil;
        this.prdCompositeAbilityService = prdCompositeAbilityService;
        this.fileUtil = fileUtil;
        this.messageConfigService = messageConfigService;
        this.roleService = roleService;
    }
}

