/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.inv.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemCatPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemCatQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemCatVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvItemCatDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.QInvItemCatDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvItemCatRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class InvItemCatDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final InvItemCatRepo repo;
    private final QInvItemCatDO qdo = QInvItemCatDO.invItemCatDO;

    private JPAQuery<InvItemCatVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(InvItemCatVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.province, this.qdo.goodsCode, this.qdo.goodsCodeName})).from((EntityPath)this.qdo);
    }

    private JPAQuery<InvItemCatVO> getJpaQueryWhere(InvItemCatQuery query) {
        JPAQuery<InvItemCatVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(InvItemCatQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(InvItemCatQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProvince())) {
            list.add(this.qdo.province.eq((Object)query.getProvince()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsCode())) {
            list.add(this.qdo.goodsCode.eq((Object)query.getGoodsCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsCodeName())) {
            list.add(this.qdo.goodsCodeName.like(SqlUtil.toSqlLikeString(query.getGoodsCodeName())));
        }
        return ExpressionUtils.allOf(list);
    }

    public InvItemCatVO queryByKey(Long id) {
        JPAQuery<InvItemCatVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (InvItemCatVO)jpaQuery.fetchFirst();
    }

    public List<InvItemCatVO> queryListDynamic(InvItemCatQuery query) {
        JPAQuery<InvItemCatVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<InvItemCatVO> queryPaging(InvItemCatQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<InvItemCatVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public InvItemCatDO save(InvItemCatDO ado) {
        return (InvItemCatDO)this.repo.save(ado);
    }

    public List<InvItemCatDO> saveAll(List<InvItemCatDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(InvItemCatPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getProvince() != null) {
            update.set((Path)this.qdo.province, (Object)payload.getProvince());
        }
        if (payload.getGoodsCode() != null) {
            update.set((Path)this.qdo.goodsCode, (Object)payload.getGoodsCode());
        }
        if (payload.getGoodsCodeName() != null) {
            update.set((Path)this.qdo.goodsCodeName, (Object)payload.getGoodsCodeName());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("province")) {
                update.setNull((Path)this.qdo.province);
            }
            if (nullFields.contains("goodsCode")) {
                update.setNull((Path)this.qdo.goodsCode);
            }
            if (nullFields.contains("goodsCodeName")) {
                update.setNull((Path)this.qdo.goodsCodeName);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public InvItemCatDAO(JPAQueryFactory jpaQueryFactory, InvItemCatRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

