/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.inv.service;

import com.baiwang.bop.client.BopException;
import com.baiwang.open.entity.request.OutputProductcodeQueryRequest;
import com.baiwang.open.entity.response.OutputProductcodeQueryResponse;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvItemService;
import com.elitesland.tw.tw5.api.prd.inv.service.TwInvoiceSendMsgService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemVO;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvItemConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvItemDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvItemCatDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvItemDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvItemCatRepo;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvItemRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class InvItemServiceImpl
extends BaseServiceImpl
implements InvItemService {
    private static final Logger log = LoggerFactory.getLogger(InvItemServiceImpl.class);
    private final InvItemRepo invItemRepo;
    private final InvItemDAO invItemDAO;
    private final InvItemCatRepo invItemCatRepo;
    private final TwInvoiceSendMsgService invoiceSendMsgService;

    public PagingVO<InvItemVO> queryPaging(InvItemQuery query) {
        return this.invItemDAO.queryPaging(query);
    }

    public List<InvItemVO> queryListDynamic(InvItemQuery query) {
        List<InvItemVO> invItemVOS = this.invItemDAO.queryListDynamic(query);
        Map<String, List<InvItemVO>> collect = invItemVOS.stream().collect(Collectors.groupingBy(v -> v.getTwGoodsCode() + "&" + v.getTwGoodsCodeName()));
        ArrayList<InvItemVO> result = new ArrayList<InvItemVO>(collect.size());
        for (String group : collect.keySet()) {
            List<InvItemVO> detailViews = collect.get(group);
            String[] values = group.split("&");
            InvItemVO view = new InvItemVO();
            view.setTwGoodsCode(values[0]);
            view.setTwGoodsCodeName(values[1]);
            view.setChildren(detailViews);
            view.setGoodsNo(values[0]);
            view.setGoodsName(values[1]);
            result.add(view);
        }
        return result;
    }

    public InvItemVO queryByKey(Long key) {
        InvItemDO entity = this.invItemRepo.findById(key).orElseGet(InvItemDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        InvItemVO vo = InvItemConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public InvItemVO insert(InvItemPayload payload) {
        InvItemDO entityDo = InvItemConvert.INSTANCE.toDo(payload);
        return InvItemConvert.INSTANCE.toVo((InvItemDO)this.invItemRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public InvItemVO update(InvItemPayload payload) {
        InvItemDO entity = this.invItemRepo.findById(payload.getId()).orElseGet(InvItemDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        InvItemDO entityDo = InvItemConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvItemConvert.INSTANCE.toVo((InvItemDO)this.invItemRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(InvItemPayload payload) {
        InvItemDO entity = this.invItemRepo.findById(payload.getId()).orElseGet(InvItemDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.invItemDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.invItemDAO.deleteSoft(keys);
        }
    }

    public int getInvoiceItemFromBaiwang() {
        List cats = this.invItemCatRepo.findAll();
        for (InvItemCatDO cat : cats) {
            OutputProductcodeQueryRequest request = new OutputProductcodeQueryRequest(){};
            try {
                OutputProductcodeQueryResponse response = this.invoiceSendMsgService.invoiceProductCodeQuery(request);
                log.info("[\u4ece\u767e\u671b\u83b7\u53d6\u53d1\u7968\u5546\u54c1\u4fe1\u606f\u6210\u529f],\u7701\u5e02\uff1a{};\u7a0e\u5c40\u5546\u54c1\u5206\u7c7b\uff1a{};\u7a0e\u5c40\u5546\u54c1\u7f16\u7801\uff1a{}", new Object[]{cat.getProvince(), cat.getGoodsCodeName(), cat.getGoodsCode()});
            }
            catch (BopException e) {
                log.error("[\u4ece\u767e\u671b\u83b7\u53d6\u53d1\u7968\u5546\u54c1\u4fe1\u606f\u5931\u8d25],\u7701\u5e02\uff1a{};\u7a0e\u5c40\u5546\u54c1\u5206\u7c7b:{};\u7a0e\u5c40\u5546\u54c1\u7f16\u7801:{}", new Object[]{cat.getProvince(), cat.getGoodsCodeName(), cat.getGoodsCode(), e});
            }
        }
        return 0;
    }

    public InvItemServiceImpl(InvItemRepo invItemRepo, InvItemDAO invItemDAO, InvItemCatRepo invItemCatRepo, TwInvoiceSendMsgService invoiceSendMsgService) {
        this.invItemRepo = invItemRepo;
        this.invItemDAO = invItemDAO;
        this.invItemCatRepo = invItemCatRepo;
        this.invoiceSendMsgService = invoiceSendMsgService;
    }
}

