/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.ProjectPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjShQuery;
import com.elitesland.tw.tw5.api.prd.my.query.ProjectQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ProjShService;
import com.elitesland.tw.tw5.api.prd.my.service.ProjectService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.ProjectEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/my/project"})
@Deprecated
public class ProjectController {
    private static final Logger log = LoggerFactory.getLogger(ProjectController.class);
    private final ProjectService projectService;
    private final ProjShService projShService;
    private final CacheUtil cacheUtil;

    @PostMapping
    public TwOutputUtil insert(@RequestBody ProjectPayload payload) {
        return TwOutputUtil.ok(this.projectService.insert(payload));
    }

    @PutMapping
    public TwOutputUtil update(@RequestBody ProjectPayload payload) {
        return TwOutputUtil.ok(this.projectService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.projectService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    public TwOutputUtil paging(ProjectQuery query) {
        return TwOutputUtil.ok(this.projectService.paging(query));
    }

    @GetMapping(value={"/listAll"})
    public TwOutputUtil queryListAll(ProjectQuery query) {
        query.setIsPermission(Boolean.valueOf(true));
        return this.queryList(query);
    }

    @GetMapping(value={"/list"})
    public TwOutputUtil queryList(ProjectQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        ProjectQuery projectQuery = new ProjectQuery();
        projectQuery.setProjIdV4(Long.valueOf(0L));
        List resultList = this.projectService.queryList(projectQuery);
        Long defaultOrgIdByUserId = this.cacheUtil.getDefaultOrgIdByUserId(loginUserId);
        ProjectQuery projectOperQuery = new ProjectQuery();
        projectOperQuery.setExt2("" + defaultOrgIdByUserId);
        projectOperQuery.setExt1(ProjectEnum.OPER.getCode());
        List projectOperList = this.projectService.queryList(projectOperQuery);
        resultList.addAll(projectOperList);
        if (query.getIsPermission().booleanValue()) {
            ProjShQuery projShQuery = new ProjShQuery();
            projShQuery.setUserId(loginUserId);
            List projShVOS = this.projShService.queryList(projShQuery);
            if (CollectionUtils.isEmpty((Collection)projShVOS)) {
                return TwOutputUtil.ok(resultList);
            }
            List projIdList = projShVOS.stream().map(projShVO -> projShVO.getProjId()).collect(Collectors.toList());
            query.setProjIdV4List(projIdList);
        }
        if (!StringUtils.hasText((String)query.getProjStatus())) {
            query.setProjStatus("ACTIVE");
        }
        List list = this.projectService.queryList(query);
        resultList.addAll(list);
        return TwOutputUtil.ok(resultList);
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.projectService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public ProjectController(ProjectService projectService, ProjShService projShService, CacheUtil cacheUtil) {
        this.projectService = projectService;
        this.projShService = projShService;
        this.cacheUtil = cacheUtil;
    }
}

