/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.product.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductClassPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductClassQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductClassService;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductClassVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.product.convert.PrdProductClassConvert;
import com.elitesland.tw.tw5.server.prd.product.dao.PrdProductClassDAO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PrdProductClassServiceImpl
extends BaseServiceImpl
implements PrdProductClassService {
    private static final Logger log = LoggerFactory.getLogger(PrdProductClassServiceImpl.class);
    private final PrdProductClassRepo prdProductClassRepo;
    private final PrdProductClassDAO prdProductClassDAO;

    public PagingVO<PrdProductClassVO> queryPaging(PrdProductClassQuery query) {
        return this.prdProductClassDAO.queryPaging(query);
    }

    public List<PrdProductClassVO> queryListDynamic(PrdProductClassQuery query) {
        return this.prdProductClassDAO.queryListDynamic(query);
    }

    public PrdProductClassVO queryByKey(Long key) {
        PrdProductClassDO entity = this.prdProductClassRepo.findById(key).orElseGet(PrdProductClassDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdProductClassVO vo = PrdProductClassConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdProductClassVO insert(PrdProductClassPayload payload) {
        Object classCode = "";
        if (payload.getClassType().equals("0")) {
            Long seniorId = payload.getSeniorId();
            PrdProductClassVO prdProductClassVO = this.queryByKey(seniorId);
            List<PrdProductClassDO> subClasses = this.prdProductClassRepo.findBySeniorId(seniorId);
            classCode = prdProductClassVO.getClassCode() + String.format("%02d", subClasses.size() + 1);
        } else {
            classCode = this.generateSeqNum("PRODUCT_CLASS_NO", new String[0]);
        }
        payload.setClassCode((String)classCode);
        PrdProductClassDO entityDo = PrdProductClassConvert.INSTANCE.toDo(payload);
        return PrdProductClassConvert.INSTANCE.toVo((PrdProductClassDO)this.prdProductClassRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdProductClassVO update(PrdProductClassPayload payload) {
        PrdProductClassDO entity = this.prdProductClassRepo.findById(payload.getId()).orElseGet(PrdProductClassDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdProductClassDO entityDo = PrdProductClassConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdProductClassConvert.INSTANCE.toVo((PrdProductClassDO)this.prdProductClassRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.prdProductClassRepo.findById(id);
                if (!optional.isEmpty()) {
                    PrdProductClassDO entity = (PrdProductClassDO)optional.get();
                    List<PrdProductClassDO> bySeniorId = this.prdProductClassRepo.findBySeniorIdAndDeleteFlag((Long)id, 0);
                    if (bySeniorId.size() > 0) {
                        throw TwException.error("", "\u5206\u7c7b" + entity.getClassName() + " \u6709\u4e0b\u7ea7\uff0c\u4e0d\u80fd\u76f4\u63a5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u5206\u7c7b");
                    }
                }
            });
            this.prdProductClassDAO.deleteSoft(keys);
        }
    }

    public List<PrdProductClassVO> querySubClassBySeniorId(Long seniorId) {
        PrdProductClassQuery query = new PrdProductClassQuery();
        query.setSeniorId(seniorId);
        query.setClassType("0");
        query.setSize(Integer.valueOf(Integer.MAX_VALUE));
        PagingVO<PrdProductClassVO> pagingVO = this.prdProductClassDAO.queryPaging(query);
        return pagingVO.getRecords();
    }

    public List<PrdProductClassVO> getClassTrees(Long pId) {
        ArrayList<PrdProductClassVO> rootTrees = new ArrayList<PrdProductClassVO>();
        PrdProductClassQuery query = new PrdProductClassQuery();
        if (pId != null && pId > 0L) {
            query.setSeniorId(pId);
        }
        List<PrdProductClassVO> trees = this.prdProductClassDAO.queryListDynamic(query);
        for (PrdProductClassVO tree : trees) {
            if (tree.getSeniorId() == -1L || tree.getSeniorId().equals(pId)) {
                rootTrees.add(tree);
            }
            for (PrdProductClassVO t : trees) {
                if (t.getSeniorId() == null || !t.getSeniorId().equals(tree.getId())) continue;
                if (tree.getChild() == null) {
                    ArrayList<PrdProductClassVO> myChildrens = new ArrayList<PrdProductClassVO>();
                    myChildrens.add(t);
                    tree.setChild(myChildrens);
                    continue;
                }
                tree.getChild().add(t);
            }
        }
        return rootTrees;
    }

    public PrdProductClassServiceImpl(PrdProductClassRepo prdProductClassRepo, PrdProductClassDAO prdProductClassDAO) {
        this.prdProductClassRepo = prdProductClassRepo;
        this.prdProductClassDAO = prdProductClassDAO;
    }
}

