/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.TPurchaseContractOverPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.TPurchaseContractOverQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.TPurchaseContractOverService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.TPurchaseContractOverVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.TPurchaseContractOverConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractManagerDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.TPurchaseContractOverDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.TPurchaseContractOverDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractStatusEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.TPurchaseContractOverRepo;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class TPurchaseContractOverServiceImpl
extends BaseServiceImpl
implements TPurchaseContractOverService {
    private static final Logger log = LoggerFactory.getLogger(TPurchaseContractOverServiceImpl.class);
    private final TPurchaseContractOverRepo tPurchaseContractOverRepo;
    private final TPurchaseContractOverDAO tPurchaseContractOverDAO;
    private final WorkflowUtil workflowUtil;
    private final PurchaseContractManagerDAO purchaseContractManagerDAO;
    private final PrdOrgOrganizationDAO daoOrg;
    private final SaleConContractDAO saleConContractDAO;
    private final PmsProjectDAO pmsProjectDAO;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    @Value(value="${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final TransactionUtilService transactionUtilService;

    public PagingVO<TPurchaseContractOverVO> queryPaging(TPurchaseContractOverQuery query) {
        return this.tPurchaseContractOverDAO.queryPaging(query);
    }

    public List<TPurchaseContractOverVO> queryListDynamic(TPurchaseContractOverQuery query) {
        return this.tPurchaseContractOverDAO.queryListDynamic(query);
    }

    public TPurchaseContractOverVO queryByKey(Long key) {
        TPurchaseContractOverDO entity = this.tPurchaseContractOverRepo.findById(key).orElseGet(TPurchaseContractOverDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TPurchaseContractOverVO vo = TPurchaseContractOverConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TPurchaseContractOverVO insert(TPurchaseContractOverPayload payload) {
        payload.setOverTime(LocalDate.now());
        TPurchaseContractOverDO entityDo = TPurchaseContractOverConvert.INSTANCE.toDo(payload);
        TPurchaseContractOverDO save = (TPurchaseContractOverDO)this.tPurchaseContractOverRepo.save(entityDo);
        if (payload.getSubmit().booleanValue()) {
            this.purchaseContractOverProc(save);
        }
        return TPurchaseContractOverConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public TPurchaseContractOverVO update(TPurchaseContractOverPayload payload) {
        TPurchaseContractOverDO entity = this.tPurchaseContractOverRepo.findById(payload.getId()).orElseGet(TPurchaseContractOverDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TPurchaseContractOverDO entityDo = TPurchaseContractOverConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TPurchaseContractOverConvert.INSTANCE.toVo((TPurchaseContractOverDO)this.tPurchaseContractOverRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TPurchaseContractOverPayload payload) {
        TPurchaseContractOverDO entity = this.tPurchaseContractOverRepo.findById(payload.getId()).orElseGet(TPurchaseContractOverDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tPurchaseContractOverDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tPurchaseContractOverDAO.deleteSoft(keys);
        }
    }

    private void purchaseContractOverProc(TPurchaseContractOverDO contractOverDO) {
        Long purchaseContractId = contractOverDO.getContractId();
        PurchaseContractManagerVO purchaseContractManagerVO = this.purchaseContractManagerDAO.queryByKey(purchaseContractId);
        Long relatedSalesContract = purchaseContractManagerVO.getRelatedSalesContract();
        Long relatedProjectId = purchaseContractManagerVO.getRelatedProjectId();
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            String businessType = purchaseContractManagerVO.getBusinessType();
            String purchaseContractType = purchaseContractManagerVO.getPurchaseContractType();
            variables.put("businessType", businessType);
            variables.put("purchaseContractType", purchaseContractType);
            PrdOrgRoleVO resBuManager = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.RES_BU_MANAGER.getCode());
            if (ObjectUtils.isEmpty((Object)resBuManager)) {
                throw TwException.error("", "\u8d44\u6e90\u7ba1\u7406Bu\u8d1f\u8d23\u4eba\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            String[] splitByResBuManager = resBuManager.getRoleEmployees().split(",");
            variables.put("Activity_138ljdk", Arrays.asList(splitByResBuManager));
            variables.put("Activity_1o07m1g", Arrays.asList(splitByResBuManager));
            PrdOrgRoleVO generalManager = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_MANAGER.getCode());
            if (ObjectUtils.isEmpty((Object)generalManager)) {
                throw TwException.error("", "\u603b\u7ecf\u7406\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            String[] splitByGeneralManager = generalManager.getRoleEmployees().split(",");
            variables.put("Activity_09e07og", Arrays.asList(splitByGeneralManager));
            PrdOrgRoleVO generalResponsiblePerson = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
            if (ObjectUtils.isEmpty((Object)generalResponsiblePerson)) {
                throw TwException.error("", "\u5e73\u53f0\u603b\u4f53\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
            }
            String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
            variables.put("Activity_0p1j24y", Arrays.asList(splitByGeneralResponsiblePerson));
            if (ObjectUtils.isEmpty((Object)relatedProjectId)) {
                Long purchaseBuId = purchaseContractManagerVO.getPurchaseBuId();
                Long purchaseBuManageUserId = this.daoOrg.queryManageIdById(purchaseBuId);
                variables.put("Activity_05ghdlz", purchaseBuManageUserId);
                variables.put("Activity_1fg7xlt", 0);
            } else {
                PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(relatedProjectId);
                Long deliUserId = pmsProjectVO.getDeliUserId();
                variables.put("Activity_05ghdlz", deliUserId);
                variables.put("Activity_1fg7xlt", deliUserId);
            }
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.PUR_CON_OVER.name(), (String)(purchaseContractManagerVO.getPurchaseContractName() + "-\u91c7\u8d2d\u5408\u540c\u7ec8\u6b62"), (String)("" + contractOverDO.getId()), variables), new Long[0]);
        }
        TPurchaseContractOverPayload payload = new TPurchaseContractOverPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(contractOverDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setOverStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> {
            this.tPurchaseContractOverDAO.updateByKeyDynamic(payload);
            this.purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.APPROVING.getCode());
        });
    }

    public TPurchaseContractOverServiceImpl(TPurchaseContractOverRepo tPurchaseContractOverRepo, TPurchaseContractOverDAO tPurchaseContractOverDAO, WorkflowUtil workflowUtil, PurchaseContractManagerDAO purchaseContractManagerDAO, PrdOrgOrganizationDAO daoOrg, SaleConContractDAO saleConContractDAO, PmsProjectDAO pmsProjectDAO, TransactionUtilService transactionUtilService) {
        this.tPurchaseContractOverRepo = tPurchaseContractOverRepo;
        this.tPurchaseContractOverDAO = tPurchaseContractOverDAO;
        this.workflowUtil = workflowUtil;
        this.purchaseContractManagerDAO = purchaseContractManagerDAO;
        this.daoOrg = daoOrg;
        this.saleConContractDAO = saleConContractDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.transactionUtilService = transactionUtilService;
    }
}

