/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchieveDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConAchieveDService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveDVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConAchieveDConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConAchieveDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConAchieveDDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConAchieveDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConAchieveRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ConAchieveDServiceImpl
extends BaseServiceImpl
implements ConAchieveDService {
    private static final Logger log = LoggerFactory.getLogger(ConAchieveDServiceImpl.class);
    private final ConAchieveDRepo conAchieveDRepo;
    private final ConAchieveRepo conAchieveRepo;
    private final ConAchieveDDAO conAchieveDDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgOrganizationService orgService;

    public PagingVO<ConAchieveDVO> queryPaging(ConAchieveDQuery query) {
        this.getPermissionParams(query);
        return this.conAchieveDDAO.queryPaging(query);
    }

    private void getPermissionParams(ConAchieveDQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<String> userSystemRoleCodes = this.cacheUtil.getSystemRoleCodes(loginUserId);
        List<String> roles = Arrays.asList("SYS", "PLAT_FINANCIAL_PERFORMANCE_STATISTICS");
        if (!CollectionUtils.isEmpty(userSystemRoleCodes) && CollectionUtils.containsAny(userSystemRoleCodes, roles)) {
            return;
        }
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setManageId(loginUserId);
        orgQuery.setSize(Integer.valueOf(Integer.MAX_VALUE));
        PagingVO paging = this.orgService.paging(orgQuery);
        List records = paging.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List orgIds = records.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            query.setOrgIdsByPermission(orgIds);
        } else {
            query.setOrgIdsByPermission(new ArrayList());
        }
        query.setUserIdsByPermission(Collections.singletonList(loginUserId));
    }

    public List<ConAchieveDVO> queryListDynamic(ConAchieveDQuery query) {
        return this.conAchieveDDAO.queryListDynamic(query);
    }

    public ConAchieveDVO queryByKey(Long key) {
        ConAchieveDDO entity = this.conAchieveDRepo.findById(key).orElseGet(ConAchieveDDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConAchieveDVO vo = ConAchieveDConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConAchieveDVO insert(ConAchieveDPayload payload) {
        ConAchieveDDO entityDo = ConAchieveDConvert.INSTANCE.toDo(payload);
        this.conAchieveRepo.updateRemark(entityDo.getAchieveId());
        return ConAchieveDConvert.INSTANCE.toVo((ConAchieveDDO)this.conAchieveDRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConAchieveDVO update(ConAchieveDPayload payload) {
        ConAchieveDDO entity = this.conAchieveDRepo.findById(payload.getId()).orElseGet(ConAchieveDDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConAchieveDDO entityDo = ConAchieveDConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        this.conAchieveRepo.updateRemark(entity.getAchieveId());
        return ConAchieveDConvert.INSTANCE.toVo((ConAchieveDDO)this.conAchieveDRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conAchieveDDAO.deleteSoft(keys);
        }
    }

    public ConAchieveDServiceImpl(ConAchieveDRepo conAchieveDRepo, ConAchieveRepo conAchieveRepo, ConAchieveDDAO conAchieveDDAO, CacheUtil cacheUtil, PrdOrgOrganizationService orgService) {
        this.conAchieveDRepo = conAchieveDRepo;
        this.conAchieveRepo = conAchieveRepo;
        this.conAchieveDDAO = conAchieveDDAO;
        this.cacheUtil = cacheUtil;
        this.orgService = orgService;
    }
}

