/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionDataPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionDataQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionDataVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionDataDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFunctionDataDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFunctionDataRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdSystemFunctionDataDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemFunctionDataRepo repo;
    private final QPrdSystemFunctionDataDO qdo = QPrdSystemFunctionDataDO.prdSystemFunctionDataDO;

    public PrdSystemFunctionDataDO save(PrdSystemFunctionDataDO ado) {
        return (PrdSystemFunctionDataDO)this.repo.save(ado);
    }

    private JPAQuery<PrdSystemFunctionDataVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemFunctionDataVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.functionId, this.qdo.functionDataName, this.qdo.functionDataRoles, this.qdo.functionPermissionType, this.qdo.functionFieldName, this.qdo.functionDataType, this.qdo.createUserId, this.qdo.createTime})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PrdSystemFunctionDataVO> getJpaQueryWhere(PrdSystemFunctionDataQuery query) {
        JPAQuery<PrdSystemFunctionDataVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getFunctionId())) {
            jpaQuery.where((Predicate)this.qdo.functionId.eq((Object)query.getFunctionId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFunctionDataName())) {
            jpaQuery.where((Predicate)this.qdo.functionDataName.like(SqlUtil.toSqlLikeString(query.getFunctionDataName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            jpaQuery.where((Predicate)this.qdo.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            jpaQuery.where((Predicate)this.qdo.id.ne((Object)query.getId()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public List<PrdSystemFunctionDataVO> queryListDynamic(PrdSystemFunctionDataQuery query) {
        JPAQuery<PrdSystemFunctionDataVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public long updateByKeyDynamic(PrdSystemFunctionDataPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getFunctionId() != null) {
            update.set(this.qdo.functionId, (Object)payload.getFunctionId());
        }
        if (payload.getFunctionPermissionType() != null) {
            update.set(this.qdo.functionPermissionType, (Object)payload.getFunctionPermissionType());
        }
        if (payload.getFunctionFieldName() != null) {
            update.set((Path)this.qdo.functionFieldName, (Object)payload.getFunctionFieldName());
        }
        if (payload.getFunctionDataName() != null) {
            update.set((Path)this.qdo.functionDataName, (Object)payload.getFunctionDataName());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if (payload.getFunctionDataRoles() != null) {
            update.set((Path)this.qdo.functionDataRoles, (Object)payload.getFunctionDataRoles());
        }
        if (payload.getFunctionDataType() != null) {
            update.set(this.qdo.functionDataType, (Object)payload.getFunctionDataType());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("remark")) {
            update.setNull((Path)this.qdo.remark);
        }
        return update.execute();
    }

    public long delete(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        return delete.execute();
    }

    public long deleteSoft(Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    public PrdSystemFunctionDataVO queryByKey(Long id) {
        JPAQuery<PrdSystemFunctionDataVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemFunctionDataVO)jpaQuery.fetchFirst();
    }

    public PagingVO<PrdSystemFunctionDataVO> queryPaging(PrdSystemFunctionDataQuery query) {
        JPAQuery<PrdSystemFunctionDataVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public PrdSystemFunctionDataDAO(JPAQueryFactory jpaQueryFactory, PrdSystemFunctionDataRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

