/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdTemporaryStoragePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdTemporaryStorageQuery;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdTemporaryStorageDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdTemporaryStorageRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdTemporaryStorageDAO {
    private final PrdTemporaryStorageRepo repo;

    public PrdTemporaryStorageDO save(PrdTemporaryStorageDO ado) {
        return (PrdTemporaryStorageDO)((Object)this.repo.save((Object)ado));
    }

    public List<PrdTemporaryStorageDO> saveAll(List<PrdTemporaryStorageDO> dos) {
        return this.repo.saveAll(dos);
    }

    public Specification<PrdTemporaryStorageDO> getSpec(PrdTemporaryStorageQuery query) {
        Specification & Serializable querySpecifi = (Specification & Serializable)(root, criteriaQuery, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (!StringUtils.isEmpty((CharSequence)query.getRemark())) {
                predicates.add(cb.like(root.get("remark").as(String.class), SqlUtil.toSqlLikeString(query.getRemark())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getStorageUrl())) {
                predicates.add(cb.like(root.get("storageUrl").as(String.class), SqlUtil.toSqlLikeString(query.getStorageUrl())));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getStorageContent())) {
                predicates.add(cb.like(root.get("storageContent").as(String.class), SqlUtil.toSqlLikeString(query.getStorageContent())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
                predicates.add(cb.equal(root.get("createUserId").as(String.class), (Object)query.getCreateUserId()));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        return querySpecifi;
    }

    public List<PrdTemporaryStorageDO> findAll(Specification<PrdTemporaryStorageDO> spec) {
        return this.repo.findAll(spec);
    }

    public Page<PrdTemporaryStorageDO> findAll(Specification<PrdTemporaryStorageDO> spec, Pageable pageable) {
        pageable = PageUtil.defaultSort(pageable);
        return this.repo.findAll(spec, pageable);
    }

    public PrdTemporaryStorageDO queryById(Long id) {
        return this.repo.findById(id).orElse(null);
    }

    public void updateByKeyDynamic(PrdTemporaryStoragePayload payload) {
        PrdTemporaryStorageDO storageDO = this.repo.findById(payload.getId()).orElse(null);
        if (storageDO != null) {
            if (payload.getStorageUrl() != null) {
                storageDO.setStorageUrl(payload.getStorageUrl());
            }
            if (payload.getStorageContent() != null) {
                storageDO.setStorageContent(payload.getStorageContent());
            }
            if (payload.getRemark() != null) {
                storageDO.setRemark(payload.getRemark());
            }
            if (payload.getDeleteFlag() != null) {
                storageDO.setDeleteFlag(payload.getDeleteFlag());
            }
            this.repo.save((Object)storageDO);
        }
    }

    public void deleteSoft(List<Long> keys) {
        for (Long key : keys) {
            PrdTemporaryStoragePayload payload = new PrdTemporaryStoragePayload();
            payload.setId(key);
            payload.setDeleteFlag(Integer.valueOf(1));
            this.updateByKeyDynamic(payload);
        }
    }

    public PrdTemporaryStorageDAO(PrdTemporaryStorageRepo repo) {
        this.repo = repo;
    }
}

