/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.task.entity.QTaskInfoDO;
import com.elitesland.tw.tw5.server.prd.task.entity.QTaskPackageDO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskInfoDO;
import com.elitesland.tw.tw5.server.prd.task.repo.TaskInfoRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class TaskInfoDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final TaskInfoRepo repo;
    private final QTaskInfoDO qdo = QTaskInfoDO.taskInfoDO;
    private final QTaskPackageDO packageQdo = QTaskPackageDO.taskPackageDO;

    private JPAQuery<TaskInfoVO> getJpaQuerySelect0() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskInfoVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.taskPackageId, this.qdo.taskName, this.qdo.disterResId, this.qdo.taskResId, this.qdo.assId, this.qdo.sourceType, this.qdo.sourceId, this.qdo.relatedActId, this.qdo.planStartDate, this.qdo.planEndDate, this.qdo.taskType, this.qdo.taskDes, this.qdo.accepCriteria, this.qdo.priority, this.qdo.totalEqva, this.qdo.settledEqva, this.qdo.planEqva, this.qdo.originalEqva, this.qdo.additionEqva, this.qdo.splitEqva, this.qdo.usedEqva, this.qdo.validEqva, this.qdo.evaluationflag, this.qdo.taskProgress, this.qdo.taskStatus, this.qdo.taskParentId, this.qdo.taskParentName, this.qdo.taskApplyFlag, this.qdo.taskApplyProcessId, this.qdo.releaseEqva, this.qdo.approvedEqva, this.qdo.taskNo, this.qdo.bw8Flag})).from((EntityPath)this.qdo);
    }

    private JPAQuery<TaskInfoVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskInfoVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.taskPackageId, this.qdo.taskName, this.qdo.taskResId, this.qdo.assId, this.qdo.sourceType, this.qdo.sourceId, this.qdo.relatedActId, this.qdo.relatedAct, this.qdo.planStartDate, this.qdo.planEndDate, this.qdo.taskType, this.qdo.taskDes, this.qdo.accepCriteria, this.qdo.priority, this.qdo.taskNo, this.qdo.totalEqva, this.qdo.settledEqva, this.qdo.approvedEqva, this.qdo.planEqva, this.qdo.originalEqva, this.qdo.additionEqva, this.qdo.splitEqva, this.qdo.usedEqva, this.qdo.validEqva, this.qdo.evaluationflag, this.qdo.taskProgress, this.qdo.taskStatus, this.qdo.taskParentId, this.qdo.taskParentName, this.qdo.taskApplyFlag, this.qdo.taskApplyProcessId, this.qdo.actualStartDate, this.qdo.actualEndDate, this.qdo.disterResId, this.packageQdo.reasonId, this.packageQdo.reasonName, this.packageQdo.reasonType, this.packageQdo.taskPackageName, this.packageQdo.disterResId.as("disterPackegeResId"), this.packageQdo.receiverResId, this.packageQdo.receiverBuId, this.packageQdo.compositeAbilityId, this.packageQdo.startDate, this.packageQdo.endDate, this.packageQdo.taskPackageStatus, this.packageQdo.taskPackageType, this.packageQdo.taskPackageDes, this.packageQdo.acceptorId, this.packageQdo.acceptMethod, this.packageQdo.pricingMethod, this.packageQdo.autoSettleFlag, this.packageQdo.guaranteeRate, this.packageQdo.settlePrice, this.packageQdo.incomePrice, this.packageQdo.jobType1, this.packageQdo.jobType2, this.packageQdo.taskPackageNo, this.packageQdo.eqvaRatio})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.packageQdo)).on((Predicate)this.qdo.taskPackageId.eq(this.packageQdo.id));
    }

    private JPAQuery<TaskInfoVO> getJpaQueryWhere(TaskInfoQuery query) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(TaskInfoQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.packageQdo)).on((Predicate)this.qdo.taskPackageId.eq(this.packageQdo.id));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(TaskInfoQuery query) {
        Integer initiatorFlag;
        Integer receiverFlag;
        Integer overdue;
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIdList())) {
            list.add(this.qdo.id.in(query.getIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskPackageId())) {
            list.add(this.qdo.taskPackageId.eq((Object)query.getTaskPackageId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskNo())) {
            list.add(this.qdo.taskNo.like(SqlUtil.toSqlLikeString(query.getTaskNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskName())) {
            list.add(this.qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskResId())) {
            list.add(this.qdo.taskResId.eq((Object)query.getTaskResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAssId())) {
            list.add(this.qdo.assId.eq((Object)query.getAssId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedActId())) {
            list.add(this.qdo.relatedActId.eq((Object)query.getRelatedActId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedAct())) {
            list.add(this.qdo.relatedAct.eq((Object)query.getRelatedAct()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanStartDate())) {
            list.add(this.qdo.planStartDate.eq((Object)query.getPlanStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanEndDate())) {
            list.add(this.qdo.planEndDate.eq((Object)query.getPlanEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)(overdue = query.getOverdue()))) {
            if (overdue == 1) {
                list.add(this.qdo.planEndDate.before((Comparable)LocalDate.now()));
            } else {
                list.add(this.qdo.planEndDate.after((Comparable)LocalDate.now()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskType())) {
            list.add(this.qdo.taskType.eq((Object)query.getTaskType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskDes())) {
            list.add(this.qdo.taskDes.eq((Object)query.getTaskDes()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccepCriteria())) {
            list.add(this.qdo.accepCriteria.eq((Object)query.getAccepCriteria()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPriority())) {
            list.add(this.qdo.priority.eq((Object)query.getPriority()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalEqva())) {
            list.add(this.qdo.totalEqva.eq((Object)query.getTotalEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettledEqva())) {
            list.add(this.qdo.settledEqva.eq((Object)query.getSettledEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanEqva())) {
            list.add(this.qdo.planEqva.eq((Object)query.getPlanEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAdditionEqva())) {
            list.add(this.qdo.additionEqva.eq((Object)query.getAdditionEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSplitEqva())) {
            list.add(this.qdo.splitEqva.eq((Object)query.getSplitEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUsedEqva())) {
            list.add(this.qdo.usedEqva.eq((Object)query.getUsedEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getValidEqva())) {
            list.add(this.qdo.validEqva.eq((Object)query.getValidEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEvaluationflag())) {
            list.add(this.qdo.evaluationflag.eq((Object)query.getEvaluationflag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskProgress())) {
            list.add(this.qdo.taskProgress.eq((Object)query.getTaskProgress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskStatus())) {
            list.add(this.qdo.taskStatus.eq((Object)query.getTaskStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            list.add(this.qdo.sourceType.eq((Object)query.getSourceType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceId())) {
            list.add(this.qdo.sourceId.eq((Object)query.getSourceId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskStatuss())) {
            if (query.getTaskStatusFlag() != null && query.getTaskStatusFlag() == 0) {
                list.add(this.qdo.taskStatus.notIn((Collection)query.getTaskStatuss()));
            } else {
                list.add(this.qdo.taskStatus.in((Collection)query.getTaskStatuss()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)(receiverFlag = query.getReceiverFlag())) && receiverFlag == 1) {
            query.setTaskResId(GlobalUtil.getLoginUserId());
        }
        if (!ObjectUtils.isEmpty((Object)(initiatorFlag = query.getInitiatorFlag())) && initiatorFlag == 1) {
            query.setCreateUserId(GlobalUtil.getLoginUserId());
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskApplyFlag())) {
            list.add(this.qdo.taskApplyFlag.eq((Object)query.getTaskApplyFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskProgress())) {
            list.add(this.qdo.taskProgress.eq((Object)query.getTaskProgress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDisterResId())) {
            list.add(this.qdo.disterResId.eq((Object)query.getDisterResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonType())) {
            list.add(this.packageQdo.reasonType.eq((Object)query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonId())) {
            list.add(this.packageQdo.reasonId.eq((Object)query.getReasonId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonName())) {
            list.add(this.packageQdo.reasonName.like(SqlUtil.toSqlLikeString(query.getReasonName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskPackageName())) {
            list.add(this.packageQdo.taskPackageName.like(SqlUtil.toSqlLikeString(query.getTaskPackageName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAcceptorId())) {
            list.add(this.packageQdo.acceptorId.eq((Object)query.getAcceptorId()));
        }
        if (query.getPermissionFlag().booleanValue()) {
            BooleanExpression orExpression = this.qdo.disterResId.eq((Object)query.getLoginUserId()).or((Predicate)this.qdo.taskResId.eq((Object)query.getLoginUserId()));
            if (!ObjectUtils.isEmpty((Object)query.getPmsProjIds())) {
                orExpression = orExpression.or((Predicate)this.packageQdo.reasonType.eq((Object)PmsReasonTypeEnum.PROJ_CONTRACT.getCode()).and((Predicate)this.packageQdo.reasonId.in((Collection)query.getPmsProjIds())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getBuProjIds())) {
                orExpression = orExpression.or((Predicate)this.packageQdo.reasonType.eq((Object)PmsReasonTypeEnum.PROJ_BU.getCode()).and((Predicate)this.packageQdo.reasonId.in((Collection)query.getBuProjIds())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getOppProjIds())) {
                orExpression = orExpression.or((Predicate)this.packageQdo.reasonType.eq((Object)PmsReasonTypeEnum.PROJ_OPPO.getCode()).and((Predicate)this.packageQdo.reasonId.in((Collection)query.getOppProjIds())));
            }
            list.add(orExpression);
        }
        return ExpressionUtils.allOf(list);
    }

    public TaskInfoVO queryByKey0(Long id) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQuerySelect0();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (TaskInfoVO)jpaQuery.fetchFirst();
    }

    public TaskInfoVO queryByKey(Long id) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (TaskInfoVO)jpaQuery.fetchFirst();
    }

    public TaskInfoVO queryByTaskNo(String taskNo) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQuerySelect0();
        jpaQuery.where((Predicate)this.qdo.taskNo.eq((Object)taskNo));
        return (TaskInfoVO)jpaQuery.fetchFirst();
    }

    public List<TaskInfoVO> queryByTaskPackageId(Long taskPackageId) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.taskPackageId.eq((Object)taskPackageId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public BigDecimal queryTotalEqvaByTaskPackageId(Long taskPackageId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.totalEqva.sum()).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.taskPackageId.eq((Object)taskPackageId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BigDecimal)jpaQuery.fetchOne();
    }

    public List<TaskInfoVO> queryByTaskPackageIds(List<Long> taskPackageIds) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.taskPackageId.in(taskPackageIds));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<TaskInfoVO> queryByKeys(List<Long> ids) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<TaskInfoVO> queryListDynamic(TaskInfoQuery query) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<TaskInfoVO> queryPaging(TaskInfoQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public TaskInfoDO save(TaskInfoDO ado) {
        return (TaskInfoDO)this.repo.save(ado);
    }

    public List<TaskInfoDO> saveAll(List<TaskInfoDO> dos) {
        return this.repo.saveAll(dos);
    }

    public List<TaskInfoVO> queryTaskByReason(String reasonType, Long reasonId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskInfoVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.relatedActId, this.qdo.totalEqva, this.qdo.settledEqva, this.qdo.planEqva, this.qdo.disterResId, this.qdo.originalEqva, this.qdo.additionEqva, this.qdo.splitEqva, this.qdo.usedEqva, this.qdo.validEqva, this.qdo.taskProgress, this.qdo.taskStatus})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.packageQdo)).on((Predicate)this.qdo.taskPackageId.eq(this.packageQdo.id))).where((Predicate)this.packageQdo.reasonType.eq((Object)reasonType))).where((Predicate)this.packageQdo.reasonId.eq((Object)reasonId))).where((Predicate)this.packageQdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.taskStatus.ne((Object)TaskStatusEnum.CREATE.getCode()));
        return jpaQuery.fetch();
    }

    public List<TaskInfoVO> queryTaskByReasons(List<String> reasonTypes, List<Long> reasonIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskInfoVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.relatedActId, this.qdo.totalEqva, this.qdo.settledEqva, this.qdo.planEqva, this.qdo.originalEqva, this.qdo.additionEqva, this.qdo.splitEqva, this.qdo.usedEqva, this.qdo.validEqva, this.qdo.taskProgress, this.qdo.taskStatus, this.packageQdo.reasonType, this.packageQdo.reasonId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.packageQdo)).on((Predicate)this.qdo.taskPackageId.eq(this.packageQdo.id))).where((Predicate)this.packageQdo.reasonType.in(reasonTypes))).where((Predicate)this.packageQdo.reasonId.in(reasonIds))).where((Predicate)this.packageQdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.taskStatus.ne((Object)TaskStatusEnum.CREATE.getCode()));
        return jpaQuery.fetch();
    }

    @Transactional
    public long updateByKeyDynamic(TaskInfoPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getTaskPackageId() != null) {
            update.set(this.qdo.taskPackageId, (Object)payload.getTaskPackageId());
        }
        if (payload.getTaskName() != null) {
            update.set((Path)this.qdo.taskName, (Object)payload.getTaskName());
        }
        if (payload.getTaskResId() != null) {
            update.set(this.qdo.taskResId, (Object)payload.getTaskResId());
        }
        if (payload.getAssId() != null) {
            update.set(this.qdo.assId, (Object)payload.getAssId());
        }
        if (payload.getRelatedActId() != null) {
            update.set(this.qdo.relatedActId, (Object)payload.getRelatedActId());
        }
        if (payload.getRelatedAct() != null) {
            update.set((Path)this.qdo.relatedAct, (Object)payload.getRelatedAct());
        }
        if (payload.getPlanStartDate() != null) {
            update.set(this.qdo.planStartDate, (Object)payload.getPlanStartDate());
        }
        if (payload.getPlanEndDate() != null) {
            update.set(this.qdo.planEndDate, (Object)payload.getPlanEndDate());
        }
        if (payload.getTaskType() != null) {
            update.set((Path)this.qdo.taskType, (Object)payload.getTaskType());
        }
        if (payload.getTaskDes() != null) {
            update.set((Path)this.qdo.taskDes, (Object)payload.getTaskDes());
        }
        if (payload.getAccepCriteria() != null) {
            update.set((Path)this.qdo.accepCriteria, (Object)payload.getAccepCriteria());
        }
        if (payload.getPriority() != null) {
            update.set(this.qdo.priority, (Object)payload.getPriority());
        }
        if (payload.getTotalEqva() != null) {
            update.set(this.qdo.totalEqva, (Object)payload.getTotalEqva());
        }
        if (payload.getSettledEqva() != null) {
            update.set(this.qdo.settledEqva, (Object)payload.getSettledEqva());
        }
        if (payload.getPlanEqva() != null) {
            update.set(this.qdo.planEqva, (Object)payload.getPlanEqva());
        }
        if (payload.getOriginalEqva() != null) {
            update.set(this.qdo.originalEqva, (Object)payload.getOriginalEqva());
        }
        if (payload.getAdditionEqva() != null) {
            update.set(this.qdo.additionEqva, (Object)payload.getAdditionEqva());
        }
        if (payload.getSplitEqva() != null) {
            update.set(this.qdo.splitEqva, (Object)payload.getSplitEqva());
        }
        if (payload.getUsedEqva() != null) {
            update.set(this.qdo.usedEqva, (Object)payload.getUsedEqva());
        }
        if (payload.getValidEqva() != null) {
            update.set(this.qdo.validEqva, (Object)payload.getValidEqva());
        }
        if (payload.getEvaluationflag() != null) {
            update.set(this.qdo.evaluationflag, (Object)payload.getEvaluationflag());
        }
        if (payload.getTaskProgress() != null) {
            update.set(this.qdo.taskProgress, (Object)payload.getTaskProgress());
        }
        if (payload.getTaskStatus() != null) {
            update.set((Path)this.qdo.taskStatus, (Object)payload.getTaskStatus());
        }
        if (payload.getTaskApplyFlag() != null) {
            update.set(this.qdo.taskApplyFlag, (Object)payload.getTaskApplyFlag());
        }
        if (payload.getTaskApplyProcessId() != null) {
            update.set((Path)this.qdo.taskApplyProcessId, (Object)payload.getTaskApplyProcessId());
        }
        if (payload.getActualStartDate() != null) {
            update.set(this.qdo.actualStartDate, (Object)payload.getActualStartDate());
        }
        if (payload.getActualEndDate() != null) {
            update.set(this.qdo.actualEndDate, (Object)payload.getActualEndDate());
        }
        if (payload.getReleaseEqva() != null) {
            update.set(this.qdo.releaseEqva, (Object)payload.getReleaseEqva());
        }
        if (payload.getApprovedEqva() != null) {
            update.set(this.qdo.approvedEqva, (Object)payload.getApprovedEqva());
        }
        if (payload.getDisterResId() != null) {
            update.set(this.qdo.disterResId, (Object)payload.getDisterResId());
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    @Transactional
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByPackageIds(List<Long> packageIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.taskPackageId.in(packageIds)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    @Transactional
    public long updateStatusByTaskPackageId(Long taskPackageId, String taskStatus, Long taskResId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.taskStatus, (Object)taskStatus).set(this.qdo.taskResId, (Object)taskResId).where(new Predicate[]{this.qdo.taskPackageId.eq((Object)taskPackageId)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    @Transactional
    public long updateStatus(Long key, String taskStatus, Long taskResId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        update.set((Path)this.qdo.taskStatus, (Object)taskStatus);
        if (taskResId != null) {
            update.set(this.qdo.taskResId, (Object)taskResId);
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    @Transactional
    public long updateTaskProgress(List<Long> keys, BigDecimal taskProgress) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.taskProgress, (Object)taskProgress).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<TaskInfoVO> queryTaskSettleList(TaskInfoQuery taskInfoQuery) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQuerySelect0();
        if (!ObjectUtils.isEmpty((Object)taskInfoQuery.getTaskStatus())) {
            jpaQuery.where((Predicate)this.qdo.taskStatus.eq((Object)taskInfoQuery.getTaskStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)taskInfoQuery.getSourceType())) {
            jpaQuery.where((Predicate)this.qdo.sourceType.eq((Object)taskInfoQuery.getSourceType()));
        }
        if (taskInfoQuery.getSourceId() != null) {
            jpaQuery.where((Predicate)this.qdo.sourceId.eq((Object)taskInfoQuery.getSourceId()));
        }
        if (!ObjectUtils.isEmpty((Object)taskInfoQuery.getTaskStatuss())) {
            jpaQuery.where((Predicate)this.qdo.taskStatus.in((Collection)taskInfoQuery.getTaskStatuss()));
        }
        if (!ObjectUtils.isEmpty((Object)taskInfoQuery.getTaskResIds())) {
            jpaQuery.where((Predicate)this.qdo.taskResId.in((Collection)taskInfoQuery.getTaskResIds()));
        }
        jpaQuery.where((Predicate)this.qdo.totalEqva.subtract(this.qdo.settledEqva).gt((Number)0).and((Predicate)this.qdo.approvedEqva.subtract(this.qdo.settledEqva).gt((Number)0)));
        return jpaQuery.fetch();
    }

    public List<TaskInfoVO> queryTaskSimpleList(TaskInfoQuery taskInfoQuery) {
        JPAQuery<TaskInfoVO> jpaQuery = this.getJpaQuerySelect0();
        if (!ObjectUtils.isEmpty((Object)taskInfoQuery.getTaskStatus())) {
            jpaQuery.where((Predicate)this.qdo.taskStatus.eq((Object)taskInfoQuery.getTaskStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)taskInfoQuery.getSourceType())) {
            jpaQuery.where((Predicate)this.qdo.sourceType.eq((Object)taskInfoQuery.getSourceType()));
        }
        if (taskInfoQuery.getSourceId() != null) {
            jpaQuery.where((Predicate)this.qdo.sourceId.eq((Object)taskInfoQuery.getSourceId()));
        }
        if (!ObjectUtils.isEmpty((Object)taskInfoQuery.getTaskStatuss())) {
            jpaQuery.where((Predicate)this.qdo.taskStatus.in((Collection)taskInfoQuery.getTaskStatuss()));
        }
        if (!ObjectUtils.isEmpty((Object)taskInfoQuery.getTaskResIds())) {
            jpaQuery.where((Predicate)this.qdo.taskResId.in((Collection)taskInfoQuery.getTaskResIds()));
        }
        return jpaQuery.fetch();
    }

    public TaskInfoDAO(JPAQueryFactory jpaQueryFactory, TaskInfoRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

