/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.permission;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemBusinessObjectPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemNewFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFieldPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFunctionObjectPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemBusinessObjectService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemNewFunctionService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionFunctionObjectService;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionFieldType;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionMappingFieldEnum;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

@Component
@Order
public class PermissionApplicationAware
implements ApplicationContextAware,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(PermissionApplicationAware.class);
    private ApplicationContext applicationContext;
    private final PrdSystemBusinessObjectService businessObjectService;
    private final PrdSystemNewFunctionService prdSystemNewFunctionService;
    private final PrdSystemPermissionFunctionObjectService prdSystemPermissionFunctionObjectService;
    private final StringRedisTemplate stringRedisTemplate;
    private static final String DEL_KEYS = "*sys:permission*";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void parsePermissionDomain() {
        this.clearCache();
        Map permissionBeanMap = this.applicationContext.getBeansWithAnnotation(PermissionDomain.class);
        HashMap functionMap = new HashMap();
        HashMap businessObjectMap = new HashMap();
        HashMap functionObjectMap = new HashMap();
        permissionBeanMap.forEach((key, value) -> {
            Method[] declaredMethods;
            Class<?> clazz;
            try {
                clazz = Class.forName(key);
            }
            catch (ClassNotFoundException e) {
                log.error("\u83b7\u53d6\u7c7b\u5bf9\u8c61\u3010" + key + "\u3011\u5931\u8d25", (Throwable)e);
                return;
            }
            if (!clazz.isAnnotationPresent(RestController.class)) {
                return;
            }
            PermissionDomain permissionDomain = clazz.getAnnotation(PermissionDomain.class);
            PermissionDomainEnum domainEnum = permissionDomain.domain();
            if (!businessObjectMap.containsKey(domainEnum.name())) {
                PrdSystemBusinessObjectPayload businessObject = new PrdSystemBusinessObjectPayload();
                businessObject.setObjectCode(domainEnum.name());
                businessObject.setObjectName(domainEnum.getDesc());
                businessObjectMap.put(domainEnum.name(), businessObject);
            }
            for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                ArrayList<PrdSystemPermissionFunctionObjectPayload> functionObjectPayloadList = new ArrayList<PrdSystemPermissionFunctionObjectPayload>();
                List<PrdSystemNewFunctionPayload> functionPayload = this.parseFunctionInfo(clazz.getSimpleName(), method, functionObjectPayloadList);
                functionMap.computeIfAbsent(domainEnum.name(), t -> new ArrayList()).addAll(functionPayload);
                functionObjectMap.computeIfAbsent(domainEnum.name(), t -> new ArrayList()).addAll(functionObjectPayloadList);
            }
        });
        if (!CollectionUtils.isEmpty(businessObjectMap)) {
            this.businessObjectService.autoCreate(businessObjectMap);
        }
        if (!CollectionUtils.isEmpty(functionMap)) {
            this.prdSystemNewFunctionService.autoCreate(functionMap);
        }
        if (!CollectionUtils.isEmpty(functionObjectMap)) {
            this.prdSystemPermissionFunctionObjectService.autoCreate(functionObjectMap);
        }
    }

    private List<PrdSystemNewFunctionPayload> parseFunctionInfo(String className, Method method, List<PrdSystemPermissionFunctionObjectPayload> functionObjectPayloadList) {
        if (!method.isAnnotationPresent(PermissionFunction.class)) {
            return new ArrayList<PrdSystemNewFunctionPayload>();
        }
        PermissionFunction permissionFunction = method.getAnnotation(PermissionFunction.class);
        FunctionDetail[] functions = permissionFunction.functions();
        ArrayList<String> functionCodes = new ArrayList<String>();
        ArrayList<PrdSystemNewFunctionPayload> funcPayloads = new ArrayList<PrdSystemNewFunctionPayload>();
        for (int i = 0; i < functions.length; ++i) {
            PrdSystemNewFunctionPayload funcPayload = new PrdSystemNewFunctionPayload();
            funcPayload.setFunctionCode(functions[i].functionCode().name());
            funcPayload.setFunctionName(!"".equals(functions[i].name()) ? functions[i].name() : functions[i].functionCode().getDesc());
            funcPayload.setFunctionType(functions[i].type().name());
            funcPayload.setFunctionStatus(Integer.valueOf(0));
            funcPayload.setClientType(functions[i].clientType().name());
            if (functions[i].referDomain() != null && functions[i].referDomain().length != 0) {
                List<String> referDomainCodes = Arrays.stream(functions[i].referDomain()).map(Enum::name).toList();
                funcPayload.setReferDomainCodes(referDomainCodes);
                String functionCode = functions[i].functionCode().name();
                List<String> referFunctionCodes = referDomainCodes.stream().map(item -> item + "/" + functionCode).toList();
                functionCodes.addAll(referFunctionCodes);
            }
            funcPayloads.add(funcPayload);
            functionCodes.add(functions[i].functionCode().name());
        }
        if (permissionFunction.fieldPermission()) {
            Field[] declaredFields;
            Type genericReturnType = method.getGenericReturnType();
            Class<?> baseClass = this.getBaseClass(genericReturnType);
            PrdSystemPermissionFunctionObjectPayload functionObjectPayload = new PrdSystemPermissionFunctionObjectPayload();
            functionObjectPayload.setClassName(baseClass.getName());
            functionObjectPayload.setFunctionCodes(functionCodes);
            functionObjectPayload.setPermissionType(permissionFunction.permissionType().getName());
            ArrayList<PrdSystemPermissionFieldPayload> fieldPayloadList = new ArrayList<PrdSystemPermissionFieldPayload>();
            for (Field field : declaredFields = baseClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ApiModelProperty.class)) continue;
                PrdSystemPermissionFieldPayload fieldPayload = new PrdSystemPermissionFieldPayload();
                String fieldDesc = field.getAnnotation(ApiModelProperty.class).value();
                fieldPayload.setField(field.getName());
                fieldPayload.setFieldName(fieldDesc);
                String fieldType = PermissionFieldType.NORMAL.getName();
                if (field.getName().toLowerCase().contains("userid") || field.getName().toLowerCase().contains("resid")) {
                    fieldType = PermissionFieldType.BUSINESS_USER.getName();
                } else if (field.getName().toLowerCase().contains("orgid") || field.getName().toLowerCase().contains("buid")) {
                    fieldType = PermissionFieldType.BUSINESS_DEPT.getName();
                }
                this.getMappingField(fieldPayload, field);
                fieldPayload.setFieldType(fieldType);
                fieldPayloadList.add(fieldPayload);
            }
            functionObjectPayload.setFields(fieldPayloadList);
            functionObjectPayloadList.add(functionObjectPayload);
        }
        return funcPayloads;
    }

    private void getMappingField(PrdSystemPermissionFieldPayload fieldPayload, Field field) {
        Class<?> type = field.getType();
        String mappingField = "";
        if (String.class.isAssignableFrom(type)) {
            mappingField = PermissionMappingFieldEnum.VARCAHR.name();
        } else if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            mappingField = PermissionMappingFieldEnum.INT.name();
        } else if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            mappingField = PermissionMappingFieldEnum.BIGINT.name();
        } else if (BigDecimal.class.isAssignableFrom(type)) {
            mappingField = PermissionMappingFieldEnum.DECIMAL.name();
        } else if (Temporal.class.isAssignableFrom(field.getType()) || Date.class.isAssignableFrom(field.getType())) {
            mappingField = PermissionMappingFieldEnum.DATETIME.name();
        }
        fieldPayload.setMappingField(mappingField);
    }

    private Class<?> getBaseClass(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.getBaseClass(parameterizedType.getActualTypeArguments()[0]);
        }
        return (Class)type;
    }

    public void run(ApplicationArguments args) {
        this.parsePermissionDomain();
    }

    private void clearCache() {
        Set keys = this.stringRedisTemplate.keys((Object)DEL_KEYS);
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.stringRedisTemplate.delete((Collection)keys);
        }
    }

    public PermissionApplicationAware(PrdSystemBusinessObjectService businessObjectService, PrdSystemNewFunctionService prdSystemNewFunctionService, PrdSystemPermissionFunctionObjectService prdSystemPermissionFunctionObjectService, StringRedisTemplate stringRedisTemplate) {
        this.businessObjectService = businessObjectService;
        this.prdSystemNewFunctionService = prdSystemNewFunctionService;
        this.prdSystemPermissionFunctionObjectService = prdSystemPermissionFunctionObjectService;
        this.stringRedisTemplate = stringRedisTemplate;
    }
}

