/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusinessFollowServiceImpl {
    private final CacheUtil cacheUtil;
    private final TransferUtilDAO dao;
    private final CrmLeadsService leadService;
    private final CrmOpportunityService opportunityService;
    private final HttpUtil httpUtil;
    private final UdcUtil udcUtil;
    private final SaleConContractRepo saleConContractRepo;
    private final SaleConContractDAO saleConContractDAO;
    private final PrdOrgOrganizationService orgService;
    private final BusinessPartnerService businessPartnerService;

    public PagingVO<CrmLeadsListVO> queryLeadsFollow(TwQueryParam query, Long customerId) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setCurrent(query.getCurrent());
        leadsQuery.setSize(query.getSize());
        leadsQuery.setFormalCustomerId(customerId);
        return this.leadService.paging(leadsQuery);
    }

    public PagingVO<CrmOpportunityVO> queryOppoFollow(TwQueryParam query, Long customerId) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
        CrmOpportunityQuery oppoQuery = new CrmOpportunityQuery();
        oppoQuery.setCurrent(query.getCurrent());
        oppoQuery.setSize(query.getSize());
        oppoQuery.setFormalCustomerId(customerId);
        return this.opportunityService.paging(oppoQuery);
    }

    public Map<String, Object> queryContractFollow(TwQueryParam query, Long customerId) {
        BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(customerId);
        SaleConContractQuery saleConContractQuery = new SaleConContractQuery();
        saleConContractQuery.setMainType("SUB");
        saleConContractQuery.setCustId(businessPartnerVO.getBookId());
        this.getPermissionParams(saleConContractQuery);
        PagingVO<SaleConContractVO> saleConContractVOPagingVO = this.saleConContractDAO.queryPaging(saleConContractQuery);
        List records = saleConContractVOPagingVO.getRecords();
        records = this.udcUtil.translateList(records);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("total", saleConContractVOPagingVO.getTotal());
        resultMap.put("records", records);
        return resultMap;
    }

    private void getPermissionParams(SaleConContractQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<String> userSystemRoleCodes = this.cacheUtil.getSystemRoleCodes(loginUserId);
        List<String> roles = Arrays.asList("SALES_VP", "SALES_CONTRACT_ADMIN", "SYS", "FIN_PIC", "BUSINESS_MANAGER", "CONTRACT_FILING", "PLAT_FIN_PIC", "OPERATION_PRESIDENT", "FIN_CHECK_PIC", "PLAT_FINANCIAL_PERFORMANCE_STATISTICS");
        if (!CollectionUtils.isEmpty(userSystemRoleCodes) && CollectionUtils.containsAny(userSystemRoleCodes, roles)) {
            return;
        }
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setManageId(loginUserId);
        orgQuery.setSize(Integer.valueOf(Integer.MAX_VALUE));
        PagingVO paging = this.orgService.paging(orgQuery);
        List records = paging.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List orgIds = records.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            query.setOrgIdsByPermission(orgIds);
        } else {
            query.setOrgIdsByPermission(new ArrayList());
        }
        query.setUserIdsByPermission(Collections.singletonList(loginUserId));
    }

    public BusinessFollowServiceImpl(CacheUtil cacheUtil, TransferUtilDAO dao, CrmLeadsService leadService, CrmOpportunityService opportunityService, HttpUtil httpUtil, UdcUtil udcUtil, SaleConContractRepo saleConContractRepo, SaleConContractDAO saleConContractDAO, PrdOrgOrganizationService orgService, BusinessPartnerService businessPartnerService) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.leadService = leadService;
        this.opportunityService = opportunityService;
        this.httpUtil = httpUtil;
        this.udcUtil = udcUtil;
        this.saleConContractRepo = saleConContractRepo;
        this.saleConContractDAO = saleConContractDAO;
        this.orgService = orgService;
        this.businessPartnerService = businessPartnerService;
    }
}

