/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.config;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemConfigVO;
import com.elitesland.tw.tw5.server.common.FilterInteceptor;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class FilterConfig
implements WebMvcConfigurer {
    private final FilterInteceptor filterInteceptor;
    private final CacheUtil cacheUtil;

    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)this.filterInteceptor);
        registration.addPathPatterns(new String[]{"/api/**"});
        PrdSystemConfigVO pvo = this.cacheUtil.getSystemConfig("CONFIG_PATH");
        if (pvo != null) {
            registration.excludePathPatterns(new String[]{pvo.getConfigValue()});
        }
    }

    public FilterConfig(FilterInteceptor filterInteceptor, CacheUtil cacheUtil) {
        this.filterInteceptor = filterInteceptor;
        this.cacheUtil = cacheUtil;
    }
}

