/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.openapi.sso;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.elp.config.TwElpSpiProperties;
import com.elitesland.tw.tw5.server.elp.util.ElpSigner;
import com.elitesland.tw.tw5.server.elp.util.ElpUrlGenerator;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="e-learning\u5b66\u4e60\u5e73\u53f0SSO")
@RestController
@RequestMapping(value={"/api/elp"})
public class ElpSsoController {
    private static final Logger log = LoggerFactory.getLogger(ElpSsoController.class);
    private final TwElpSpiProperties elpSpiProperties;

    @GetMapping(value={"/sso/url"})
    public TwOutputUtil ssoUrl() {
        try {
            SysUserDTO loginUser = GlobalUtil.getLoginUser();
            String email = loginUser.getEmail();
            String sign = ElpSigner.calculateSign("sso", this.elpSpiProperties.getAppSecret(), this.elpSpiProperties.getCorpCode(), email, System.currentTimeMillis());
            return TwOutputUtil.ok(ElpUrlGenerator.generateSSOURL(email, this.elpSpiProperties.getCorpCode(), sign));
        }
        catch (Exception te) {
            te.printStackTrace();
            return TwOutputUtil.error("\u672a\u6388\u6743\uff0c\u4e0d\u53ef\u4ee5\u8bbf\u95ee");
        }
    }

    public ElpSsoController(TwElpSpiProperties elpSpiProperties) {
        this.elpSpiProperties = elpSpiProperties;
    }
}

