/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountTurnoverPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountTurnoverQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountTurnoverVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalAccountTurnoverDO;
import com.elitesland.tw.tw5.server.prd.cal.entity.QCalAccountTurnoverDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalAccountTurnoverRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CalAccountTurnoverDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CalAccountTurnoverRepo repo;
    private final QCalAccountTurnoverDO qdo = QCalAccountTurnoverDO.calAccountTurnoverDO;

    private JPAQuery<CalAccountTurnoverVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CalAccountTurnoverVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.accId, this.qdo.accName, this.qdo.finYear, this.qdo.finPeriod, this.qdo.ioDate, this.qdo.ioTime, this.qdo.sourceType, this.qdo.sourceId, this.qdo.sourceName, this.qdo.turnoverQty, this.qdo.eqvaPrice, this.qdo.beforeQty, this.qdo.afterQty, this.qdo.beforeAmt, this.qdo.afterAmt})).from((EntityPath)this.qdo);
    }

    private JPAQuery<CalAccountTurnoverVO> getJpaQueryWhere(CalAccountTurnoverQuery query) {
        JPAQuery<CalAccountTurnoverVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(CalAccountTurnoverQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(CalAccountTurnoverQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccId())) {
            list.add(this.qdo.accId.eq((Object)query.getAccId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccName())) {
            list.add(this.qdo.accName.like(SqlUtil.toSqlLikeString(query.getAccName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinYear())) {
            list.add(this.qdo.finYear.eq((Object)query.getFinYear()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinPeriod())) {
            list.add(this.qdo.finPeriod.eq((Object)query.getFinPeriod()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIoDate())) {
            list.add(this.qdo.ioDate.eq((Object)query.getIoDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIoStartDate())) {
            list.add(this.qdo.ioDate.goe((Comparable)query.getIoStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIoEndDate())) {
            list.add(this.qdo.ioDate.loe((Comparable)query.getIoEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIoTime())) {
            list.add(this.qdo.ioTime.eq((Object)query.getIoTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            list.add(this.qdo.sourceType.eq((Object)query.getSourceType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceId())) {
            list.add(this.qdo.sourceId.eq((Object)query.getSourceId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceName())) {
            list.add(this.qdo.sourceName.like(SqlUtil.toSqlLikeString(query.getSourceName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTurnoverQty())) {
            list.add(this.qdo.turnoverQty.eq((Object)query.getTurnoverQty()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEqvaPrice())) {
            list.add(this.qdo.eqvaPrice.eq((Object)query.getEqvaPrice()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBeforeQty())) {
            list.add(this.qdo.beforeQty.eq((Object)query.getBeforeQty()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAfterQty())) {
            list.add(this.qdo.afterQty.eq((Object)query.getAfterQty()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBeforeAmt())) {
            list.add(this.qdo.beforeAmt.eq((Object)query.getBeforeAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAfterAmt())) {
            list.add(this.qdo.afterAmt.eq((Object)query.getAfterAmt()));
        }
        return ExpressionUtils.allOf(list);
    }

    public CalAccountTurnoverVO queryByKey(Long id) {
        JPAQuery<CalAccountTurnoverVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CalAccountTurnoverVO)jpaQuery.fetchFirst();
    }

    public List<CalAccountTurnoverVO> queryListDynamic(CalAccountTurnoverQuery query) {
        JPAQuery<CalAccountTurnoverVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<CalAccountTurnoverVO> queryPaging(CalAccountTurnoverQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<CalAccountTurnoverVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public CalAccountTurnoverDO save(CalAccountTurnoverDO ado) {
        return (CalAccountTurnoverDO)this.repo.save(ado);
    }

    public List<CalAccountTurnoverDO> saveAll(List<CalAccountTurnoverDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(CalAccountTurnoverPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getAccId() != null) {
            update.set(this.qdo.accId, (Object)payload.getAccId());
        }
        if (payload.getAccName() != null) {
            update.set((Path)this.qdo.accName, (Object)payload.getAccName());
        }
        if (payload.getFinYear() != null) {
            update.set(this.qdo.finYear, (Object)payload.getFinYear());
        }
        if (payload.getFinPeriod() != null) {
            update.set(this.qdo.finPeriod, (Object)payload.getFinPeriod());
        }
        if (payload.getIoDate() != null) {
            update.set(this.qdo.ioDate, (Object)payload.getIoDate());
        }
        if (payload.getIoTime() != null) {
            update.set(this.qdo.ioTime, (Object)payload.getIoTime());
        }
        if (payload.getSourceType() != null) {
            update.set((Path)this.qdo.sourceType, (Object)payload.getSourceType());
        }
        if (payload.getSourceId() != null) {
            update.set(this.qdo.sourceId, (Object)payload.getSourceId());
        }
        if (payload.getSourceName() != null) {
            update.set((Path)this.qdo.sourceName, (Object)payload.getSourceName());
        }
        if (payload.getTurnoverQty() != null) {
            update.set(this.qdo.turnoverQty, (Object)payload.getTurnoverQty());
        }
        if (payload.getEqvaPrice() != null) {
            update.set(this.qdo.eqvaPrice, (Object)payload.getEqvaPrice());
        }
        if (payload.getBeforeQty() != null) {
            update.set(this.qdo.beforeQty, (Object)payload.getBeforeQty());
        }
        if (payload.getAfterQty() != null) {
            update.set(this.qdo.afterQty, (Object)payload.getAfterQty());
        }
        if (payload.getBeforeAmt() != null) {
            update.set(this.qdo.beforeAmt, (Object)payload.getBeforeAmt());
        }
        if (payload.getAfterAmt() != null) {
            update.set(this.qdo.afterAmt, (Object)payload.getAfterAmt());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("accId")) {
                update.setNull(this.qdo.accId);
            }
            if (nullFields.contains("accName")) {
                update.setNull((Path)this.qdo.accName);
            }
            if (nullFields.contains("finYear")) {
                update.setNull(this.qdo.finYear);
            }
            if (nullFields.contains("finPeriod")) {
                update.setNull(this.qdo.finPeriod);
            }
            if (nullFields.contains("ioDate")) {
                update.setNull(this.qdo.ioDate);
            }
            if (nullFields.contains("ioTime")) {
                update.setNull(this.qdo.ioTime);
            }
            if (nullFields.contains("sourceType")) {
                update.setNull((Path)this.qdo.sourceType);
            }
            if (nullFields.contains("sourceId")) {
                update.setNull(this.qdo.sourceId);
            }
            if (nullFields.contains("sourceName")) {
                update.setNull((Path)this.qdo.sourceName);
            }
            if (nullFields.contains("turnoverQty")) {
                update.setNull(this.qdo.turnoverQty);
            }
            if (nullFields.contains("eqvaPrice")) {
                update.setNull(this.qdo.eqvaPrice);
            }
            if (nullFields.contains("beforeQty")) {
                update.setNull(this.qdo.beforeQty);
            }
            if (nullFields.contains("afterQty")) {
                update.setNull(this.qdo.afterQty);
            }
            if (nullFields.contains("beforeAmt")) {
                update.setNull(this.qdo.beforeAmt);
            }
            if (nullFields.contains("afterAmt")) {
                update.setNull(this.qdo.afterAmt);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public CalAccountTurnoverDAO(JPAQueryFactory jpaQueryFactory, CalAccountTurnoverRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

