/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalAccountConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalAccountDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalAccountDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalAccountRepo;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class CalAccountServiceImpl
extends BaseServiceImpl
implements CalAccountService {
    private static final Logger log = LoggerFactory.getLogger(CalAccountServiceImpl.class);
    private final TransactionUtilService transactionUtilService;
    private final CalAccountRepo calAccountRepo;
    private final CalAccountDAO calAccountDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final PrdOrgOrganizationDAO orgDao;
    private final PrdOrgEmployeeDAO daoEmployee;
    private final CrmOpportunityDAO daoOpportunity;

    public PagingVO<CalAccountVO> queryPaging(CalAccountQuery query) {
        PagingVO<CalAccountVO> calAccountVOPagingVO = this.calAccountDAO.queryPaging(query);
        return calAccountVOPagingVO;
    }

    public List<CalAccountVO> queryListDynamic(CalAccountQuery query) {
        List<CalAccountVO> calAccountVOS = this.calAccountDAO.queryListDynamic(query);
        return calAccountVOS;
    }

    public CalAccountVO queryByKey(Long key) {
        CalAccountVO vo = this.calAccountDAO.queryByKey(key);
        return vo;
    }

    public List<CalAccountVO> queryByKeys(List<Long> keys) {
        return this.calAccountDAO.queryByKeys(keys);
    }

    @Transactional(rollbackFor={Exception.class})
    public CalAccountVO insert(CalAccountPayload payload) {
        this.checkData(payload);
        CalAccountVO calAccountVO = this.calAccountDAO.queryByAuTypeAndAuId(payload.getAuType(), payload.getAuId());
        if (calAccountVO != null) {
            throw TwException.error("", "\u8d26\u53f7\u4e0d\u53ef\u91cd\u590d\u521b\u5efa");
        }
        CalAccountDO entityDo = CalAccountConvert.INSTANCE.toDo(payload);
        return CalAccountConvert.INSTANCE.toVo((CalAccountDO)this.calAccountRepo.save(entityDo));
    }

    void checkData(CalAccountPayload payload) {
        if (!StringUtils.hasText((String)payload.getAuType())) {
            throw TwException.error("", "\u8d26\u6237\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getAuId() == null) {
            throw TwException.error("", "\u5f52\u5c5e\u4e3b\u9898\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)payload.getLedgerNo())) {
            throw TwException.error("", "\u5f52\u5c5e\u4e3b\u9898\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)payload.getLedgerName())) {
            throw TwException.error("", "\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        String ledgerNo = payload.getAuType() + "-" + payload.getLedgerNo();
        payload.setLedgerNo(ledgerNo);
        payload.setLedgerStatus(Integer.valueOf(1));
        payload.setLedgerYear(Integer.valueOf(LocalDate.now().getYear()));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CalAccountPayload payload) {
        long result = this.calAccountDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.calAccountDAO.deleteSoft(keys);
        }
    }

    public CalAccountVO queryByAuTypeAndAuId(String auType, Long auId) {
        CalAccountVO calAccountVO = this.calAccountDAO.queryByAuTypeAndAuId(auType, auId);
        if (calAccountVO == null) {
            String name = "";
            if (auType.equals(CalAccTypeEnum.PROJ.getCode())) {
                name = CalAccTypeEnum.PROJ.getDesc();
            }
            if (auType.equals(CalAccTypeEnum.BU.getCode())) {
                name = CalAccTypeEnum.BU.getDesc();
            }
            if (auType.equals(CalAccTypeEnum.RES.getCode())) {
                name = CalAccTypeEnum.RES.getDesc();
            }
            if (auType.equals(CalAccTypeEnum.OPP.getCode())) {
                name = CalAccTypeEnum.OPP.getDesc();
            }
            if (auType.equals(CalAccTypeEnum.BU_PROJ.getCode())) {
                name = CalAccTypeEnum.BU_PROJ.getDesc();
            }
            log.error(name + "\u8d26\u6237\u4e0d\u5b58\u5728,auId:" + auId);
            throw TwException.error("", name + "\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
        }
        return calAccountVO;
    }

    public List<CalAccountVO> queryByAuTypeAndAuIds(String auType, List<Long> auIds) {
        return this.calAccountDAO.queryByAuTypeAndAuIds(auType, auIds);
    }

    public List<CalAccountVO> queryByAuTypesAndAuIds(List<String> auTypes, List<Long> auIds) {
        return this.calAccountDAO.queryByAuTypesAndAuIds(auTypes, auIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void initAccount() {
        ArrayList accounts = new ArrayList();
        int year1 = LocalDate.now().getYear();
    }

    public void closeAccount(Long key) {
        CalAccountPayload payload = new CalAccountPayload();
        payload.setId(key);
        payload.setLedgerStatus(Integer.valueOf(0));
        this.calAccountDAO.updateByKeyDynamic(payload);
    }

    public CalAccountServiceImpl(TransactionUtilService transactionUtilService, CalAccountRepo calAccountRepo, CalAccountDAO calAccountDAO, PmsProjectDAO pmsProjectDAO, PrdOrgOrganizationDAO orgDao, PrdOrgEmployeeDAO daoEmployee, CrmOpportunityDAO daoOpportunity) {
        this.transactionUtilService = transactionUtilService;
        this.calAccountRepo = calAccountRepo;
        this.calAccountDAO = calAccountDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.orgDao = orgDao;
        this.daoEmployee = daoEmployee;
        this.daoOpportunity = daoOpportunity;
    }
}

