/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunitySalesPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunitySalesService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunitySalesVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunitySalesDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunitySalesDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunitySalesRepo;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmOpportunitySalesController {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunitySalesController.class);
    private final CrmOpportunitySalesService service;
    private final CrmOpportunitySalesDAO dao;
    private final CrmOpportunitySalesRepo repo;

    @PostMapping(value={"/oppo/sales/insert"})
    public TwOutputUtil insert(CrmOpportunitySalesPayload payload) {
        CrmOpportunitySalesVO vo = this.service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/oppo/sales/update"})
    public TwOutputUtil update(CrmOpportunitySalesPayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/sales/updateFromV4"})
    public TwOutputUtil updateFromV4(CrmOpportunitySalesPayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/sales/queryList"})
    public TwOutputUtil queryList(Long oppoId) {
        return TwOutputUtil.ok(this.service.queryList(oppoId));
    }

    @DeleteMapping(value={"/oppo/sales/deleteSoft"})
    public TwOutputUtil deleteSoft(Long oppoId, Long[] keys) {
        this.service.deleteSoft(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/sales/deleteV4"})
    public TwOutputUtil delete(Long[] keysV4) {
        ArrayList<Long> keys = new ArrayList<Long>();
        for (Long keyV4 : keysV4) {
            keys.add(this.dao.getIdByV4(keyV4));
        }
        if (keys != null && !keys.isEmpty()) {
            CrmOpportunitySalesDO crmOpportunitySalesDO = this.repo.findById((Long)keys.get(0)).orElse(null);
            this.service.deleteSoft(crmOpportunitySalesDO.getOppoId(), keys);
        }
        return TwOutputUtil.ok();
    }

    public CrmOpportunitySalesController(CrmOpportunitySalesService service, CrmOpportunitySalesDAO dao, CrmOpportunitySalesRepo repo) {
        this.service = service;
        this.dao = dao;
        this.repo = repo;
    }
}

