/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityMeasureDPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityMeasurePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityMeasureDService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityMeasureService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMeasureDVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMeasureVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityMeasureConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityMeasureDConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityMeasureDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityMeasureDDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityMeasureDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityMeasureDRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityMeasureRepo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CrmOpportunityMeasureServiceImpl
extends BaseServiceImpl
implements CrmOpportunityMeasureService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityMeasureServiceImpl.class);
    private final CrmOpportunityMeasureDService crmOpportunityMeasureDService;
    private final CrmOpportunityMeasureDAO crmOpportunityMeasureDAO;
    private final CrmOpportunityMeasureRepo crmOpportunityMeasureRepo;
    private final CrmOpportunityMeasureDRepo crmOpportunityMeasureDRepo;

    @Transactional(rollbackFor={Exception.class})
    public List<CrmOpportunityMeasureVO> insertOrUpdate(List<CrmOpportunityMeasurePayload> payloads) {
        ArrayList crmOpportunityMeasureDDOList = new ArrayList();
        BigDecimal[] totalWeight = new BigDecimal[]{BigDecimal.ZERO};
        HashSet dataSourceFieldsIdsSet = new HashSet(payloads.size());
        payloads.forEach(crmOpportunityMeasurePayload -> {
            if (!dataSourceFieldsIdsSet.add(crmOpportunityMeasurePayload.getDataSourceFieldsId())) {
                throw TwException.error("", "\u8ba1\u7b97\u6307\u6807-\u6570\u636e\u6e90\u5b57\u6bb5\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5");
            }
            BigDecimal weights = crmOpportunityMeasurePayload.getWeights() == null ? BigDecimal.ZERO : crmOpportunityMeasurePayload.getWeights();
            totalWeight[0] = totalWeight[0].add(weights);
            CrmOpportunityMeasureDO crmOpportunityMeasureDO = CrmOpportunityMeasureConvert.INSTANCE.toDo((CrmOpportunityMeasurePayload)crmOpportunityMeasurePayload);
            CrmOpportunityMeasureDO save = (CrmOpportunityMeasureDO)this.crmOpportunityMeasureRepo.save(crmOpportunityMeasureDO);
            List crmOpportunityMeasureDPayloads = crmOpportunityMeasurePayload.getCrmOpportunityMeasureDPayloads();
            ArrayList<BigDecimal[]> numericalValueInterval = new ArrayList<BigDecimal[]>(crmOpportunityMeasureDPayloads.size());
            crmOpportunityMeasureDPayloads.forEach(crmOpportunityMeasureDPayload -> {
                BigDecimal score;
                CrmOpportunityMeasureDDO crmOpportunityMeasureDDO = CrmOpportunityMeasureDConvert.INSTANCE.toDo((CrmOpportunityMeasureDPayload)crmOpportunityMeasureDPayload);
                if ("\u6570\u503c\u7c7b\u578b".equals(crmOpportunityMeasureDDO.getIndicatorType())) {
                    BigDecimal numericalValueMin = crmOpportunityMeasureDDO.getNumericalValueMin();
                    BigDecimal numericalValueMax = crmOpportunityMeasureDDO.getNumericalValueMax();
                    if (numericalValueMin == null || numericalValueMax == null) {
                        throw TwException.error("", "\u6570\u636e\u6e90\u5b57\u6bb5\u3010" + crmOpportunityMeasurePayload.getOppoTableFieldsName() + "\u3011\u5b58\u5728\u6570\u503c\u533a\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
                    }
                    if (numericalValueMin.compareTo(numericalValueMax) >= 0) {
                        throw TwException.error("", "\u6570\u636e\u6e90\u5b57\u6bb5\u3010" + crmOpportunityMeasurePayload.getOppoTableFieldsName() + "\u3011\u5b58\u5728\u6570\u503c\u533a\u95f4\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5");
                    }
                    numericalValueInterval.add(new BigDecimal[]{numericalValueMin, numericalValueMax});
                }
                BigDecimal bigDecimal = score = crmOpportunityMeasureDDO.getScore() == null ? BigDecimal.ZERO : crmOpportunityMeasureDDO.getScore();
                if (score.compareTo(BigDecimal.ZERO) < 0 || score.compareTo(new BigDecimal(100)) > 0) {
                    throw TwException.error("", "\u6570\u636e\u6e90\u5b57\u6bb5\u3010" + crmOpportunityMeasurePayload.getOppoTableFieldsName() + "\u3011\u914d\u7f6e\u7684\u9009\u9879\u5206\u503c\u5e94\u4e3a0~100\uff0c\u8bf7\u68c0\u67e5");
                }
                crmOpportunityMeasureDDO.setMeasureId(save.getId());
                crmOpportunityMeasureDDOList.add(crmOpportunityMeasureDDO);
            });
            numericalValueInterval.sort(Comparator.comparing(a -> a[0]));
            for (int i = 0; i < numericalValueInterval.size() - 1; ++i) {
                BigDecimal[] interval2;
                BigDecimal[] interval1 = (BigDecimal[])numericalValueInterval.get(i);
                if (interval1[0].compareTo((interval2 = (BigDecimal[])numericalValueInterval.get(i + 1))[1]) >= 0 || interval2[0].compareTo(interval1[1]) >= 0) continue;
                throw TwException.error("", "\u6570\u636e\u6e90\u5b57\u6bb5\u3010" + crmOpportunityMeasurePayload.getOppoTableFieldsName() + "\u3011\u5b58\u5728\u4ea4\u53c9\u7684\u6570\u503c\u533a\u95f4\uff0c\u8bf7\u68c0\u67e5");
            }
        });
        if (totalWeight[0].compareTo(new BigDecimal(100)) != 0) {
            throw TwException.error("", "\u8ba1\u7b97\u6307\u6807\u7684\u603b\u6743\u91cd\u5e94\u4e3a100\uff0c\u8bf7\u68c0\u67e5");
        }
        this.crmOpportunityMeasureDRepo.deleteAll();
        this.crmOpportunityMeasureDRepo.saveAll(crmOpportunityMeasureDDOList);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long deleteSoft(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        this.crmOpportunityMeasureDService.deleteSoftByMeasureId(ids);
        return this.crmOpportunityMeasureDAO.deleteSoft(ids);
    }

    public List<CrmOpportunityMeasureVO> queryAll() {
        List<CrmOpportunityMeasureVO> crmOpportunityMeasureVOS = this.crmOpportunityMeasureDAO.queryAll();
        List crmOpportunityMeasureDVOS = this.crmOpportunityMeasureDService.queryAll();
        Map<Long, List<CrmOpportunityMeasureDVO>> map = crmOpportunityMeasureDVOS.stream().collect(Collectors.groupingBy(CrmOpportunityMeasureDVO::getMeasureId));
        crmOpportunityMeasureVOS.forEach(crmOpportunityMeasureVO -> crmOpportunityMeasureVO.setCrmOpportunityMeasureDVOS((List)map.get(crmOpportunityMeasureVO.getId())));
        return crmOpportunityMeasureVOS;
    }

    public CrmOpportunityMeasureServiceImpl(CrmOpportunityMeasureDService crmOpportunityMeasureDService, CrmOpportunityMeasureDAO crmOpportunityMeasureDAO, CrmOpportunityMeasureRepo crmOpportunityMeasureRepo, CrmOpportunityMeasureDRepo crmOpportunityMeasureDRepo) {
        this.crmOpportunityMeasureDService = crmOpportunityMeasureDService;
        this.crmOpportunityMeasureDAO = crmOpportunityMeasureDAO;
        this.crmOpportunityMeasureRepo = crmOpportunityMeasureRepo;
        this.crmOpportunityMeasureDRepo = crmOpportunityMeasureDRepo;
    }
}

