/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.ability.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdAbilityLevelPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityStructPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityStructQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityStructService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.dao.PrdCompositeAbilityDao;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdCompositeAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.repo.PrdCompositeAbilityRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdCompositeAbilityConvert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdCompositeAbilityServiceImpl
implements PrdCompositeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PrdCompositeAbilityServiceImpl.class);
    private final PrdCompositeAbilityDao prdCompositeAbilityDao;
    private final PrdCompositeAbilityRepo prdCompositeAbilityRepo;
    private final PrdAbilityLevelService prdAbilityLevelService;
    private final PrdCompositeAbilityStructService prdCompositeAbilityStructService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor={Exception.class})
    public PrdCompositeAbilityVO save(PrdCompositeAbilityPayload prdCompositeAbilityPayload) {
        this.checkData(prdCompositeAbilityPayload);
        if (null == prdCompositeAbilityPayload.getId()) {
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setJobType1(prdCompositeAbilityPayload.getJobType1());
            prdCompositeAbilityQuery.setJobType2(prdCompositeAbilityPayload.getJobType2());
            Long jobTypeCount = this.prdCompositeAbilityDao.count(prdCompositeAbilityQuery);
            if (jobTypeCount > 0L) {
                throw new BusinessException("\u8be5\u5de5\u79cd\u4e0b\u5df2\u7ecf\u5b58\u5728\u590d\u5408\u80fd\u529b");
            }
            PrdCompositeAbilityQuery prdCompositeAbilityQuery1 = new PrdCompositeAbilityQuery();
            if (StringUtils.isNotBlank((CharSequence)prdCompositeAbilityQuery.getDocNo())) {
                prdCompositeAbilityQuery1.setDocNo(prdCompositeAbilityPayload.getDocNo());
                Long count = this.prdCompositeAbilityDao.count(prdCompositeAbilityQuery1);
                if (count > 0L) {
                    throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5");
                }
            }
        }
        if (CollUtil.isNotEmpty((Collection)prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList())) {
            List levelList = prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList().stream().map(x -> x.getLevelDtlId()).collect(Collectors.toList());
            HashSet levelSet = new HashSet(levelList);
            if (levelList.size() != levelSet.size()) {
                throw new BusinessException("\u7ea7\u522b\u5b9a\u4e49\u660e\u7ec6\u4e0d\u80fd\u91cd\u590d");
            }
        }
        PrdCompositeAbilityDO prdCompositeAbilityDO = new PrdCompositeAbilityDO();
        prdCompositeAbilityDO = PrdCompositeAbilityConvert.INSTANCE.p2d(prdCompositeAbilityPayload);
        String jobType1Desc = this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", prdCompositeAbilityPayload.getJobType1());
        String jobType2Desc = this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", prdCompositeAbilityPayload.getJobType2());
        prdCompositeAbilityDO.setName(jobType1Desc + "-" + jobType2Desc);
        PrdCompositeAbilityDO res = (PrdCompositeAbilityDO)((Object)this.prdCompositeAbilityRepo.save((Object)prdCompositeAbilityDO));
        if (CollUtil.isNotEmpty((Collection)prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList())) {
            for (PrdAbilityLevelPayload prdAbilityLevelPayload : prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList()) {
                prdAbilityLevelPayload.setAbilityId(res.getId());
                prdAbilityLevelPayload.setType(Integer.valueOf(2));
                PrdAbilityLevelVO prdAbilityLevelVO = this.prdAbilityLevelService.save(prdAbilityLevelPayload);
            }
        }
        if (CollUtil.isNotEmpty((Collection)prdCompositeAbilityPayload.getPrdCompositeAbilityStructPayloadList())) {
            for (PrdCompositeAbilityStructPayload prdCompositeAbilityStructPayload : prdCompositeAbilityPayload.getPrdCompositeAbilityStructPayloadList()) {
                prdCompositeAbilityStructPayload.setAbilityId(res.getId());
                this.prdCompositeAbilityStructService.save(prdCompositeAbilityStructPayload);
            }
        }
        return PrdCompositeAbilityConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdCompositeAbilityVO update(PrdCompositeAbilityPayload prdCompositeAbilityPayload) {
        Assert.notNull((Object)prdCompositeAbilityPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        this.prdAbilityLevelService.delByAbilitId(prdCompositeAbilityPayload.getId());
        this.prdCompositeAbilityStructService.delByAbilitId(prdCompositeAbilityPayload.getId());
        PrdCompositeAbilityVO res = this.save(prdCompositeAbilityPayload);
        return res;
    }

    public PrdCompositeAbilityVO get(Long id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PrdCompositeAbilityVO res = this.prdCompositeAbilityDao.get(id);
        if (null == res) {
            return null;
        }
        res.setLevelFlag(Boolean.valueOf(null != res.getLevelId()));
        PrdAbilityLevelQuery prdAbilityLevelQuery = new PrdAbilityLevelQuery();
        prdAbilityLevelQuery.setType(Integer.valueOf(2));
        prdAbilityLevelQuery.setAbilityId(id);
        List levelDtl = this.prdAbilityLevelService.getList(prdAbilityLevelQuery);
        res.setPrdAbilityLevelVOList(levelDtl);
        PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery = new PrdCompositeAbilityStructQuery();
        prdCompositeAbilityStructQuery.setAbilityId(id);
        List structVOList = this.prdCompositeAbilityStructService.getList(prdCompositeAbilityStructQuery);
        res.setPrdCompositeAbilityStructVOList(structVOList);
        return res;
    }

    public PagingVO<PrdCompositeAbilityVO> page(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {
        PagingVO<PrdCompositeAbilityVO> res = this.prdCompositeAbilityDao.page(prdCompositeAbilityQuery);
        res.getRecords().forEach(x -> {
            x.setJobType1Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType1()));
            x.setJobType2Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType2()));
            StringBuilder stringBuilder = new StringBuilder(x.getJobType1Desc());
            stringBuilder.append("-");
            stringBuilder.append(x.getJobType2Desc());
            x.setJobName(stringBuilder.toString());
        });
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdCompositeAbilityDao.del(ids);
        return res;
    }

    public List<PrdCompositeAbilityVO> getList(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {
        List<PrdCompositeAbilityVO> res = this.prdCompositeAbilityDao.getList(prdCompositeAbilityQuery);
        res.forEach(x -> {
            x.setJobType1Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType1()));
            x.setJobType2Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType2()));
            StringBuilder stringBuilder = new StringBuilder(x.getJobType1Desc());
            stringBuilder.append("-");
            stringBuilder.append(x.getJobType2Desc());
            x.setJobName(stringBuilder.toString());
        });
        return res;
    }

    @Transactional
    public Long updateState(PrdCompositeAbilityPayload prdCompositeAbilityPayload) {
        Assert.notNull((Object)prdCompositeAbilityPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)prdCompositeAbilityPayload.getState(), (String)"state\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdCompositeAbilityDao.updateState(prdCompositeAbilityPayload);
        return res;
    }

    public PagingVO<PrdCompositeAbilityVO> levelPage(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {
        prdCompositeAbilityQuery.setState(Integer.valueOf(1));
        PagingVO<PrdCompositeAbilityVO> res = this.prdCompositeAbilityDao.levelPage(prdCompositeAbilityQuery);
        res.getRecords().forEach(x -> {
            x.setJobType1Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType1()));
            x.setJobType2Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType2()));
        });
        return res;
    }

    private void checkData(PrdCompositeAbilityPayload prdCompositeAbilityPayload) {
        List<String> resTemList = prdCompositeAbilityPayload.getPrdCompositeAbilityStructPayloadList().stream().map(x -> x.getLevelDtlId()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        ArrayList resList = new ArrayList(resTemList);
        resTemList.forEach(x -> {
            if (x.contains(",")) {
                List list = Stream.of(x.split(",")).collect(Collectors.toList());
                resList.addAll(list);
            }
        });
        if (CollUtil.isNotEmpty((Collection)prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList())) {
            prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList().forEach(x -> {
                if (!resList.contains(x.getLevelDtlId().toString())) {
                    throw new BusinessException("\u5404\u7ea7\u522b\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u80fd\u529b\u6784\u6210");
                }
            });
        }
    }

    public List<PrdCompositeAbilityVO> levelList(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {
        prdCompositeAbilityQuery.setState(Integer.valueOf(1));
        List<PrdCompositeAbilityVO> res = this.prdCompositeAbilityDao.levelList(prdCompositeAbilityQuery);
        res.forEach(x -> {
            x.setJobType1Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType1()));
            x.setJobType2Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType2()));
        });
        return res;
    }

    public PrdCompositeAbilityVO findByAbilityLevelId(Long abilityLevelId) {
        PrdCompositeAbilityVO prdCompositeAbilityVO = this.prdCompositeAbilityDao.findByAbilityLevelId(abilityLevelId);
        prdCompositeAbilityVO.setJobType1Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", prdCompositeAbilityVO.getJobType1()));
        prdCompositeAbilityVO.setJobType2Desc(this.cacheUtil.transferSystemSelection("org:employee:multiCapacity", prdCompositeAbilityVO.getJobType2()));
        return prdCompositeAbilityVO;
    }

    @Transactional
    public Boolean changeName(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {
        List<PrdCompositeAbilityVO> list = this.getList(new PrdCompositeAbilityQuery());
        for (PrdCompositeAbilityVO prdCompositeAbilityVO : list) {
            prdCompositeAbilityVO.setName(prdCompositeAbilityVO.getJobName());
            this.prdCompositeAbilityDao.updateByName(prdCompositeAbilityVO);
        }
        return null;
    }

    public PrdCompositeAbilityServiceImpl(PrdCompositeAbilityDao prdCompositeAbilityDao, PrdCompositeAbilityRepo prdCompositeAbilityRepo, PrdAbilityLevelService prdAbilityLevelService, PrdCompositeAbilityStructService prdCompositeAbilityStructService, CacheUtil cacheUtil) {
        this.prdCompositeAbilityDao = prdCompositeAbilityDao;
        this.prdCompositeAbilityRepo = prdCompositeAbilityRepo;
        this.prdAbilityLevelService = prdAbilityLevelService;
        this.prdCompositeAbilityStructService = prdCompositeAbilityStructService;
        this.cacheUtil = cacheUtil;
    }
}

