/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempGradeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempGradeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempPointVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdExamTempConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdExamTempDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdExamTempDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdExamTempRepo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdExamTempServiceImpl
implements PrdExamTempService {
    private static final Logger log = LoggerFactory.getLogger(PrdExamTempServiceImpl.class);
    private final PrdExamTempDao prdExamTempDao;
    private final PrdExamTempRepo prdExamTempRepo;
    private final PrdExamTempGradeService prdExamTempGradeService;
    private final PrdExamTempPointService prdExamTempPointService;

    @Transactional(rollbackFor={Exception.class})
    public PrdExamTempVO save(PrdExamTempPayload prdExamTempPayload) {
        this.checkData(prdExamTempPayload);
        PrdExamTempDO prdExamTempDO = new PrdExamTempDO();
        prdExamTempDO = PrdExamTempConvert.INSTANCE.p2d(prdExamTempPayload);
        PrdExamTempDO res = (PrdExamTempDO)((Object)this.prdExamTempRepo.save((Object)prdExamTempDO));
        prdExamTempPayload.getPrdExamTempGradePayloadList().forEach(x -> {
            x.setTempId(res.getId());
            PrdExamTempGradeVO save = this.prdExamTempGradeService.save(x);
        });
        prdExamTempPayload.getPrdExamTempPointPayloadList().forEach(x -> {
            x.setTempId(res.getId());
            PrdExamTempPointVO save = this.prdExamTempPointService.save(x);
        });
        return PrdExamTempConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdExamTempVO update(PrdExamTempPayload prdExamTempPayload) {
        Assert.notNull((Object)prdExamTempPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        this.prdExamTempGradeService.delByTempId(prdExamTempPayload.getId());
        this.prdExamTempPointService.delByTempId(prdExamTempPayload.getId());
        PrdExamTempVO res = this.save(prdExamTempPayload);
        return res;
    }

    public PrdExamTempVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdExamTempVO res = this.prdExamTempDao.get(id);
        PrdExamTempGradeQuery prdExamTempGradeQuery = new PrdExamTempGradeQuery();
        prdExamTempGradeQuery.setTempId(id);
        List gradeVOList = this.prdExamTempGradeService.getList(prdExamTempGradeQuery);
        res.setPrdExamTempGradeVOList(gradeVOList);
        PrdExamTempPointQuery prdExamTempPointQuery = new PrdExamTempPointQuery();
        prdExamTempPointQuery.setTempId(id);
        List pointVOList = this.prdExamTempPointService.getList(prdExamTempPointQuery);
        res.setPrdExamTempPointVOList(pointVOList);
        return res;
    }

    public PagingVO<PrdExamTempVO> page(PrdExamTempQuery prdExamTempQuery) {
        PagingVO<PrdExamTempVO> res = this.prdExamTempDao.page(prdExamTempQuery);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdExamTempDao.del(ids);
        ids.forEach(x -> {
            this.prdExamTempGradeService.delByTempId(x);
            this.prdExamTempPointService.delByTempId(x);
        });
        return res;
    }

    public List<PrdExamTempVO> getList(PrdExamTempQuery prdExamTempQuery) {
        List<PrdExamTempVO> res = this.prdExamTempDao.getList(prdExamTempQuery);
        return res;
    }

    private void checkData(PrdExamTempPayload prdExamTempPayload) {
        if (StringUtils.isBlank((CharSequence)prdExamTempPayload.getName())) {
            throw new BusinessException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdExamTempPayload.getScoreMin()) {
            throw new BusinessException("\u5206\u6570\u4e0b\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdExamTempPayload.getScoreMax()) {
            throw new BusinessException("\u5206\u6570\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == prdExamTempPayload.getEnableFlag()) {
            throw new BusinessException("\u662f\u5426\u542f\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByCondition(PrdExamTempPayload prdExamTempPayload) {
        Assert.notNull((Object)prdExamTempPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdExamTempDao.update(prdExamTempPayload);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateState(PrdExamTempPayload prdExamTempPayload) {
        Long res = this.prdExamTempDao.updateState(prdExamTempPayload);
        return res;
    }

    public PrdExamTempServiceImpl(PrdExamTempDao prdExamTempDao, PrdExamTempRepo prdExamTempRepo, PrdExamTempGradeService prdExamTempGradeService, PrdExamTempPointService prdExamTempPointService) {
        this.prdExamTempDao = prdExamTempDao;
        this.prdExamTempRepo = prdExamTempRepo;
        this.prdExamTempGradeService = prdExamTempGradeService;
        this.prdExamTempPointService = prdExamTempPointService;
    }
}

