/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.resource.callback;

import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyPayload;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalTaskSettleDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResWithdrawApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResWithdrawApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDetailDO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/RES_WITHDRAW_APPLY/callBack"})
@Transactional
public class ResWithdrawApplyWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(ResWithdrawApplyWorkflowCallBackController.class);
    private final ResWithdrawApplyDAO resWithdrawApplyDAO;
    private final ResWithdrawApplyDetailDAO detailDAO;
    private final CalTaskSettleDAO calTaskSettleDAO;
    private final CalTaskSettleService calTaskSettleService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ResWithdrawApplyPayload applyPayload = new ResWithdrawApplyPayload();
        Long applyId = Long.valueOf(payload.getBusinessKey());
        applyPayload.setId(applyId);
        List<ResWithdrawApplyDetailDO> withdrawApplyDetailDOS = this.detailDAO.findAllByApplyId(applyId);
        Object approve_status = null;
        switch (procInstStatus) {
            case NOTSUBMIT: {
                applyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                break;
            }
            case INTERRUPT: 
            case INVALID: {
                applyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                applyPayload.setDeleteFlag(Integer.valueOf(1));
                if (CollectionUtils.isEmpty(withdrawApplyDetailDOS)) break;
                List<Long> settleIds = withdrawApplyDetailDOS.stream().map(e -> e.getSettleId()).collect(Collectors.toList());
                this.calTaskSettleDAO.updateSettleOperate(settleIds, 0);
                break;
            }
            case REJECTED: {
                applyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                if (CollectionUtils.isEmpty(withdrawApplyDetailDOS)) break;
                List<Long> settleIds = withdrawApplyDetailDOS.stream().map(e -> e.getSettleId()).collect(Collectors.toList());
                this.calTaskSettleDAO.updateSettleOperate(settleIds, 0);
                break;
            }
            case APPROVED: {
                applyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                applyPayload.setApprovedTime(LocalDateTime.now());
                ResWithdrawApplyDO withdrawApplyDO = this.resWithdrawApplyDAO.findById(applyId);
                List<ResWithdrawApplyDetailDO> detailDOList = this.detailDAO.findAllByApplyId(applyId);
                List<Long> settleIds = detailDOList.stream().map(ResWithdrawApplyDetailDO::getSettleId).toList();
                CalTaskSettleWithdrawPayload calTaskSettleWithdrawPayload = new CalTaskSettleWithdrawPayload();
                calTaskSettleWithdrawPayload.setWithdrawId(withdrawApplyDO.getId());
                calTaskSettleWithdrawPayload.setWithdrawNo(withdrawApplyDO.getWithdrawNo());
                calTaskSettleWithdrawPayload.setWithdrawResId(withdrawApplyDO.getApplyUserId());
                calTaskSettleWithdrawPayload.setWithdrawStatus("2");
                calTaskSettleWithdrawPayload.setSettleIds(settleIds);
                calTaskSettleWithdrawPayload.setWithdrawQty(withdrawApplyDO.getWithdrawEqva());
                calTaskSettleWithdrawPayload.setWithdrawAmt(withdrawApplyDO.getWithdrawAmt());
                this.calTaskSettleService.taskSettleWithdraw(calTaskSettleWithdrawPayload);
                break;
            }
            case APPROVING: {
                applyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            }
        }
        this.resWithdrawApplyDAO.updatePrco(applyPayload);
        return WorkflowResult.success(null);
    }

    public ResWithdrawApplyWorkflowCallBackController(ResWithdrawApplyDAO resWithdrawApplyDAO, ResWithdrawApplyDetailDAO detailDAO, CalTaskSettleDAO calTaskSettleDAO, CalTaskSettleService calTaskSettleService) {
        this.resWithdrawApplyDAO = resWithdrawApplyDAO;
        this.detailDAO = detailDAO;
        this.calTaskSettleDAO = calTaskSettleDAO;
        this.calTaskSettleService = calTaskSettleService;
    }
}

