/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResSearchQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResSearchVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonProjectExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonWorkExperienceDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Collection;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class ResSearchDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdOrgEmployeeDO qdo = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");
    private final QPrdOrgPersonDO qdoPerson = QPrdOrgPersonDO.prdOrgPersonDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPersonProjectExperienceDO qPersonProjectExperienceDO = QPersonProjectExperienceDO.personProjectExperienceDO;
    private final QPersonWorkExperienceDO qPersonWorkExperienceDO = QPersonWorkExperienceDO.personWorkExperienceDO;

    private JPAQuery<ResSearchVO> getJpaQueryResSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ResSearchVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.userId, this.qdo.employeeNo, this.qdo.resNo, this.qdo.extString5, this.qdo.resourceStatus, this.qdo.userId, this.qdo.eqvaRatio, this.qdo.resNo, this.qdoPerson.foreignName, this.qdoPerson.mobile, this.qdoPerson.email, this.qdoPerson.personName.as("employeeName"), this.qdoRef.orgId, this.qdoRef.isDefault, this.qdoOrg.orgName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoPerson)).on((Predicate)this.qdo.personId.longValue().eq((Expression)this.qdoPerson.id.longValue()))).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.qdo.userId.longValue().eq((Expression)this.qdoRef.userId.longValue()).and((Predicate)this.qdoRef.isDefault.eq((Object)0)).and((Predicate)this.qdoRef.isCopy.eq((Object)0)).and((Predicate)this.qdoRef.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()).and((Predicate)this.qdoOrg.isCopy.eq((Object)0)));
    }

    private JPAQuery<ResSearchVO> getJpaQueryResWhere(ResSearchQuery query) {
        JPAQuery<ResSearchVO> jpaQuery = this.getJpaQueryResSelect();
        jpaQuery.where((Predicate)this.qdo.resourceStatus.in((Collection)query.getResourceStatusList()));
        if (!(ObjectUtils.isEmpty((Object)query.getProjExperienceName()) && ObjectUtils.isEmpty((Object)query.getProjExperienceProduct()) && ObjectUtils.isEmpty((Object)query.getProjExperienceOt()))) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qPersonProjectExperienceDO)).on((Predicate)this.qPersonProjectExperienceDO.personId.eq(this.qdoPerson.id));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjExperienceName())) {
            jpaQuery.where((Predicate)this.qPersonProjectExperienceDO.projName.like(SqlUtil.toSqlLikeString(query.getProjExperienceName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjExperienceProduct())) {
            jpaQuery.where((Predicate)this.qPersonProjectExperienceDO.product.like(SqlUtil.toSqlLikeString(query.getProjExperienceProduct())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjExperienceOt())) {
            jpaQuery.where((Predicate)this.qPersonProjectExperienceDO.company.like(SqlUtil.toSqlLikeString(query.getProjExperienceOt())).or((Predicate)this.qPersonProjectExperienceDO.industry.like(SqlUtil.toSqlLikeString(query.getProjExperienceOt())).or((Predicate)this.qPersonProjectExperienceDO.projRole.like(SqlUtil.toSqlLikeString(query.getProjExperienceOt())))));
        }
        if (!(ObjectUtils.isEmpty((Object)query.getWorkExperienceCompany()) && ObjectUtils.isEmpty((Object)query.getWorkExperienceJob()) && ObjectUtils.isEmpty((Object)query.getWorkExperienceIndustry()))) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qPersonWorkExperienceDO)).on((Predicate)this.qPersonWorkExperienceDO.personId.eq(this.qdoPerson.id));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkExperienceCompany())) {
            jpaQuery.where((Predicate)this.qPersonWorkExperienceDO.companyName.like(SqlUtil.toSqlLikeString(query.getWorkExperienceCompany())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkExperienceJob())) {
            jpaQuery.where((Predicate)this.qPersonWorkExperienceDO.jobtitle.like(SqlUtil.toSqlLikeString(query.getWorkExperienceJob())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkExperienceIndustry())) {
            jpaQuery.where((Predicate)this.qPersonWorkExperienceDO.industry.like(SqlUtil.toSqlLikeString(query.getWorkExperienceIndustry())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEqvaRatioMax())) {
            jpaQuery.where((Predicate)this.qdo.eqvaRatio.loe((Number)query.getEqvaRatioMax()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEqvaRatioMin())) {
            jpaQuery.where((Predicate)this.qdo.eqvaRatio.goe((Number)query.getEqvaRatioMin()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEmployeeName())) {
            jpaQuery.where((Predicate)this.qdoPerson.personName.like(SqlUtil.toSqlLikeString(query.getEmployeeName())).or((Predicate)this.qdoPerson.foreignName.like(SqlUtil.toSqlLikeString(query.getEmployeeName()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEmployeeNo())) {
            jpaQuery.where((Predicate)this.qdo.employeeNo.eq((Object)query.getEmployeeNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMobile())) {
            jpaQuery.where((Predicate)this.qdoPerson.mobile.eq((Object)query.getMobile()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEmail())) {
            jpaQuery.where((Predicate)this.qdoPerson.email.eq((Object)query.getEmail()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString5())) {
            jpaQuery.where((Predicate)this.qdo.extString5.like(SqlUtil.toSqlLikeString(query.getExtString5())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            jpaQuery.where((Predicate)this.qdoRef.orgId.eq((Object)query.getOrgId()));
            jpaQuery.where((Predicate)this.qdoRef.deleteFlag.eq((Object)0));
            jpaQuery.where((Predicate)this.qdoOrg.deleteFlag.eq((Object)0));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        jpaQuery.groupBy(this.qdo.personId);
        return jpaQuery;
    }

    public PagingVO<ResSearchVO> queryPaging(ResSearchQuery query) {
        JPAQuery<ResSearchVO> jpaQuery = this.getJpaQueryResWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public ResSearchDAO(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

