/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.inv.service;

import com.baiwang.open.entity.request.ImageInvoicesQueryRequest;
import com.baiwang.open.entity.response.ImageInvoicesQueryResponse;
import com.baiwang.open.entity.response.node.ImageInvoicesQuery;
import com.baiwang.open.entity.response.node.ImageInvoicesQueryMediaInvoiceAttachedISP;
import com.baiwang.open.entity.response.node.ImageInvoicesQueryMediaInvoiceDetailISP;
import com.baiwang.open.entity.response.node.ImageInvoicesQueryMediaInvoiceTravelISP;
import com.baiwang.open.exception.BWOpenException;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoicePayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.service.TwInvoiceSendMsgService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.inv.common.InvoiceStateEnum;
import com.elitesland.tw.tw5.server.prd.inv.common.InvoiceTypeEnum;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvInvoiceAttachedConvert;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvInvoiceConvert;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvInvoiceDetailConvert;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvInvoiceTravelItineraryConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvInvoiceAttachedDAO;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvInvoiceDAO;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvInvoiceDetailDAO;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvInvoiceTravelItineraryDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceAttachedDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceDetailDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceTravelItineraryDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvInvoiceRepo;
import com.querydsl.core.Tuple;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class InvInvoiceServiceImpl
extends BaseServiceImpl
implements InvInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(InvInvoiceServiceImpl.class);
    private final InvInvoiceRepo invInvoiceRepo;
    private final InvInvoiceDAO invInvoiceDAO;
    private final InvInvoiceDetailDAO invInvoiceDetailDAO;
    private final InvInvoiceAttachedDAO invInvoiceAttachedDAO;
    private final InvInvoiceTravelItineraryDAO invInvoiceTravelItineraryDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService employeeService;
    @Autowired
    private TwInvoiceSendMsgService invoiceSendMsgService;

    public PagingVO<InvInvoiceVO> queryPaging(InvInvoiceQuery query) {
        PagingVO<InvInvoiceVO> invInvoiceVOPagingVO = this.invInvoiceDAO.queryPaging(query);
        List records = invInvoiceVOPagingVO.getRecords();
        for (InvInvoiceVO record : records) {
            if (record.getInspectionStatus() != 0 || !record.getInspectionErrorDesc().equals("\u6682\u4e0d\u652f\u6301\u67e5\u9a8c")) continue;
            record.setInspectionStatus(Integer.valueOf(1));
        }
        return invInvoiceVOPagingVO;
    }

    private void handlePermission(InvInvoiceQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        if (query.getPersonalInv() != null && query.getPersonalInv() == 1) {
            query.setInvOwnerId(userId);
            query.setCreateUserId(userId);
            query.setInvStateNot("INVALID");
        } else {
            Boolean isPermission = query.getIsPermission();
            if (isPermission.booleanValue()) {
                Boolean rolePermission = false;
                rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode()));
                if (!rolePermission.booleanValue()) {
                    query.setInvOwnerId(userId);
                }
            }
        }
    }

    public List<InvInvoiceVO> queryListDynamic(InvInvoiceQuery query) {
        List<InvInvoiceVO> invInvoiceVOS = this.invInvoiceDAO.queryListDynamic(query);
        for (InvInvoiceVO record : invInvoiceVOS) {
            if (record.getInspectionStatus() == null || record.getInspectionStatus() != 0 || record.getInspectionErrorDesc() == null || !record.getInspectionErrorDesc().equals("\u6682\u4e0d\u652f\u6301\u67e5\u9a8c")) continue;
            record.setInspectionStatus(Integer.valueOf(1));
        }
        return invInvoiceVOS;
    }

    public InvInvoiceVO queryByKey(Long key) {
        InvInvoiceDO entity = this.invInvoiceRepo.findById(key).orElseGet(InvInvoiceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        InvInvoiceVO vo = InvInvoiceConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public InvInvoiceVO insert(InvInvoicePayload payload) {
        InvInvoiceDO entityDo = InvInvoiceConvert.INSTANCE.toDo(payload);
        return InvInvoiceConvert.INSTANCE.toVo((InvInvoiceDO)this.invInvoiceRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public InvInvoiceVO update(InvInvoicePayload payload) {
        InvInvoiceDO entity = this.invInvoiceRepo.findById(payload.getId()).orElseGet(InvInvoiceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        InvInvoiceDO entityDo = InvInvoiceConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvInvoiceConvert.INSTANCE.toVo((InvInvoiceDO)this.invInvoiceRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(InvInvoicePayload payload) {
        InvInvoiceDO entity = this.invInvoiceRepo.findById(payload.getId()).orElseGet(InvInvoiceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.invInvoiceDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.invInvoiceDAO.deleteSoft(keys);
        }
    }

    public void getInvoicesFromBaiwang(Long userId) {
        String userAccount;
        String scanUserAccount;
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        PrdOrgEmployeeVO employeeVO = this.employeeService.queryByUserId(loginUser.getId());
        String string = scanUserAccount = employeeVO.getBaiwangMobile() == null ? employeeVO.getMobile() : employeeVO.getBaiwangMobile();
        if (!StringUtils.hasText((String)scanUserAccount)) {
            throw TwException.error("", "\u767b\u9646\u4eba\u624b\u673a\u53f7\u4e3a\u7a7a,\u62c9\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25!");
        }
        if (ObjectUtils.isEmpty((Object)employeeVO)) {
            throw TwException.error("", "\u65e0\u6cd5\u67e5\u8be2\u5230\u53d1\u7968\u6240\u6709\u4eba\u7684\u7528\u6237\u4fe1\u606f,\u62c9\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25!");
        }
        String string2 = userAccount = employeeVO.getBaiwangMobile() == null ? employeeVO.getMobile() : employeeVO.getBaiwangMobile();
        if (!StringUtils.hasText((String)userAccount)) {
            throw TwException.error("", "\u53d1\u7968\u6240\u6709\u4eba\u624b\u673a\u53f7\u4e3a\u7a7a,\u62c9\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25!");
        }
        this.getInvoicesFromBaiwang("EL" + scanUserAccount, "EL" + userAccount, userId);
    }

    @Transactional
    public void addRelateReimByIds(List<InvInvoicePayload> payloads) {
        if (ObjectUtils.isEmpty(payloads)) {
            log.warn("\u62a5\u9500\u5355\u4e0e\u53d1\u7968\u5f85\u5173\u8054\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        payloads.forEach(this.invInvoiceDAO::updateByKeyDynamic);
    }

    @Transactional
    public void updateReimStatusByReimId(Long reimId, String reimStatus) {
        this.invInvoiceDAO.updateReimStatusByReimId(reimId, reimStatus);
    }

    public Map<String, BigDecimal> findDeductTaxDeviceAmountTaxByNoIn(List<String> invoiceNos) {
        List<Tuple> tuples = this.invInvoiceDAO.findDeductTaxDeviceAmountTaxByNoIn(invoiceNos);
        if (CollectionUtils.isEmpty(tuples)) {
            return Collections.emptyMap();
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(tuples.size());
        tuples.forEach(tuple -> {
            String invoiceCode = tuple.get(1, String.class) == null ? "" : (String)tuple.get(1, String.class);
            String key = (String)tuple.get(0, String.class) + "-" + invoiceCode;
            BigDecimal value = (BigDecimal)tuple.get(2, BigDecimal.class);
            value = value != null ? value : BigDecimal.ZERO;
            resultMap.put(key, value);
        });
        return resultMap;
    }

    public void updateWrittenOffAmtByNo(Map<String, BigDecimal> newTheAmtMap, Map<String, BigDecimal> oldTheAmtMap) {
        HashMap<String, BigDecimal> resultTheAmtMap = new HashMap<String, BigDecimal>();
        Map<String, BigDecimal> deleteTheAmtMap = oldTheAmtMap.entrySet().stream().filter(entry -> !newTheAmtMap.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        newTheAmtMap.forEach((key, value) -> {
            value = value == null ? BigDecimal.ZERO : value;
            BigDecimal subTheAmt = oldTheAmtMap.get(key) == null ? BigDecimal.ZERO : (BigDecimal)oldTheAmtMap.get(key);
            resultTheAmtMap.put((String)key, value.subtract(subTheAmt));
        });
        if (!deleteTheAmtMap.isEmpty()) {
            deleteTheAmtMap.forEach((key, value) -> {
                value = value == null ? BigDecimal.ZERO : value;
                resultTheAmtMap.put((String)key, BigDecimal.ZERO.subtract((BigDecimal)value));
            });
        }
        resultTheAmtMap.forEach(this.invInvoiceDAO::addWrittenOffAmtByInvoiceNo);
    }

    public void subtractWrittenOffAmt(String invoiceNoAndCode, BigDecimal subTheAmt) {
        this.invInvoiceDAO.subWrittenOffAmtByInvoiceNo(invoiceNoAndCode, subTheAmt);
    }

    @Transactional(rollbackFor={Exception.class})
    int getInvoicesFromBaiwang(String scanUserAccount, String userAccount, Long userId) {
        ImageInvoicesQueryRequest request = new ImageInvoicesQueryRequest();
        request.setScanUserAccount(scanUserAccount);
        request.setUserAccount(userAccount);
        request.setIsDel(Integer.valueOf(0));
        LocalDateTime searchTime = LocalDateTime.now().minusDays(15L);
        LocalDateTime lastCreateTime = this.invInvoiceRepo.getLastCreateTime(userId);
        LocalDateTime firstCheckFailTime = this.invInvoiceRepo.getFirstCheckFailTime(userId);
        if (firstCheckFailTime != null) {
            if (lastCreateTime.isBefore(searchTime)) {
                searchTime = lastCreateTime;
            } else if (!firstCheckFailTime.isBefore(searchTime)) {
                searchTime = firstCheckFailTime.minusMinutes(1L);
            }
        } else {
            searchTime = lastCreateTime;
        }
        if (searchTime != null) {
            request.setCreateTimeStart(searchTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        try {
            List reInvs;
            ImageInvoicesQueryResponse response = this.invoiceSendMsgService.imageInvoicesQuery(request);
            if (response != null && !CollectionUtils.isEmpty((Collection)(reInvs = response.getResponse()))) {
                for (ImageInvoicesQuery mainInfo : reInvs) {
                    List invoiceTravelList;
                    ImageInvoicesQueryMediaInvoiceAttachedISP invoiceAttached;
                    DoubleStream distinct;
                    List<InvInvoiceVO> invInvoiceVOS;
                    mainInfo.setCreateTime(null);
                    InvInvoiceDO invoiceDO = InvInvoiceConvert.INSTANCE.baiwangDoToDo(mainInfo);
                    InvInvoiceQuery invInvoiceQuery = new InvInvoiceQuery();
                    invInvoiceQuery.setInvoiceNo(mainInfo.getInvoiceNo());
                    if (mainInfo.getInvoiceCode() != null) {
                        invInvoiceQuery.setInvoiceCode(mainInfo.getInvoiceCode());
                    }
                    if (mainInfo.getInvoiceType() != null) {
                        invInvoiceQuery.setInvType(mainInfo.getInvoiceType());
                    }
                    if (!CollectionUtils.isEmpty(invInvoiceVOS = this.invInvoiceDAO.queryListDynamic(invInvoiceQuery))) {
                        InvInvoiceVO invInvoiceVO = invInvoiceVOS.get(0);
                        if (invInvoiceVO.getInspectionStatus() != 2 || !invInvoiceVO.getInvReimStatus().equals("NEW") || invInvoiceVO.getWrittenOffAmt() != null || invInvoiceVO.getReimDId() != null) continue;
                        invoiceDO.setId(invInvoiceVO.getId());
                        invoiceDO.setReimId(invInvoiceVO.getReimDId());
                        invoiceDO.setWrittenOffAmt(invInvoiceVO.getWrittenOffAmt());
                    }
                    invoiceDO.setBaiwangCreateTime(mainInfo.getCreateTime());
                    invoiceDO.setBaiwangUpdateTime(mainInfo.getUpdateTime());
                    String invType = mainInfo.getInvoiceType();
                    InvoiceTypeEnum it = InvoiceTypeEnum.of(invType);
                    if (it != null && !it.getNeedInspect().booleanValue()) {
                        invoiceDO.setInspectionStatus(5);
                    }
                    invoiceDO.setInvType(invType);
                    this.setInvoiceType(invoiceDO, mainInfo.getInvoiceType());
                    this.setInvState(invoiceDO, mainInfo.getInvoiceState());
                    invoiceDO.setInvReimStatus("NEW");
                    invoiceDO.setInvOwnerId(userId);
                    invoiceDO.setImgContent(mainInfo.getFileAddress());
                    List invoiceDetailList = mainInfo.getInvoiceDetailList();
                    if (invoiceDetailList != null && (distinct = invoiceDetailList.stream().filter(i -> i.getTaxRate() != null).mapToDouble(i -> i.getTaxRate().doubleValue()).distinct()).count() > 0L) {
                        Double max;
                        Double min = invoiceDetailList.stream().filter(i -> i.getTaxRate() != null).mapToDouble(i -> i.getTaxRate().doubleValue()).distinct().min().getAsDouble();
                        if (min.compareTo(max = Double.valueOf(invoiceDetailList.stream().filter(i -> i.getTaxRate() != null).mapToDouble(i -> i.getTaxRate().doubleValue()).distinct().max().getAsDouble())) == 0) {
                            invoiceDO.setTaxRate(String.valueOf((int)(min * 100.0) + "%"));
                        } else {
                            invoiceDO.setTaxRate(String.valueOf((int)(min * 100.0) + "%~" + (int)(max * 100.0) + "%"));
                        }
                    }
                    InvInvoiceDO save = this.invInvoiceDAO.save(invoiceDO);
                    if (invoiceDetailList != null) {
                        for (ImageInvoicesQueryMediaInvoiceDetailISP invoiceDetail : invoiceDetailList) {
                            InvInvoiceDetailDO invInvoiceDetailDO = InvInvoiceDetailConvert.INSTANCE.baiwangDoToDo(invoiceDetail);
                            invInvoiceDetailDO.setInvId(save.getId());
                            invInvoiceDetailDO.setBaiwangId(invoiceDetail.getId());
                            invInvoiceDetailDO.setBaiwangInvId(mainInfo.getId());
                            this.invInvoiceDetailDAO.save(invInvoiceDetailDO);
                        }
                    }
                    if ((invoiceAttached = mainInfo.getInvoiceAttached()) != null) {
                        InvInvoiceAttachedDO invoiceAttachedDO = InvInvoiceAttachedConvert.INSTANCE.baiwangDoToDo(invoiceAttached);
                        invoiceAttachedDO.setInvId(save.getId());
                        invoiceAttachedDO.setBaiwangId(invoiceAttached.getId());
                        invoiceAttachedDO.setBaiwangInvId(mainInfo.getId());
                        this.invInvoiceAttachedDAO.save(invoiceAttachedDO);
                    }
                    if ((invoiceTravelList = mainInfo.getInvoiceTravelList()) == null) continue;
                    for (ImageInvoicesQueryMediaInvoiceTravelISP flightEntity : invoiceTravelList) {
                        InvInvoiceTravelItineraryDO invoiceAttachedDO = InvInvoiceTravelItineraryConvert.INSTANCE.baiwangDoToDo(flightEntity);
                        invoiceAttachedDO.setInvId(save.getId());
                        invoiceAttachedDO.setBaiwangId(flightEntity.getId());
                        invoiceAttachedDO.setBaiwangInvId(mainInfo.getId());
                        this.invInvoiceTravelItineraryDAO.save(invoiceAttachedDO);
                    }
                }
            }
        }
        catch (BWOpenException e) {
            log.error("[\u4ece\u767e\u671b\u83b7\u53d6\u5f71\u50cf-\u7968\u636e\u5217\u8868\u4fe1\u606f\u5931\u8d25(\u5165\u53d1\u7968\u6c60)],\u8d26\u53f7:", new Object[]{scanUserAccount, ",\u65f6\u95f4\uff1a", searchTime, ",response=", e});
            if (e.getSubCode().equals("9999")) {
                throw TwException.error("", e.getSubMessage() + ",\u8bf7\u68c0\u67e5\u7528\u6237\u624b\u673a\u53f7\u662f\u5426\u4e0e\u767e\u65fa\u8d26\u53f7\u4e00\u81f4\uff01");
            }
            throw TwException.error("", e.getSubMessage());
        }
        return 0;
    }

    private void setInvoiceType(InvInvoiceDO entity, String invoiceType) {
        InvoiceTypeEnum[] values;
        String text = null;
        for (InvoiceTypeEnum invoiceTypeEnum : values = InvoiceTypeEnum.values()) {
            if (!invoiceTypeEnum.getCode().equals(invoiceType)) continue;
            text = invoiceTypeEnum.getDesc();
        }
        entity.setInvoiceType(text);
    }

    private void setInvState(InvInvoiceDO entity, Integer getInvoiceState) {
        InvoiceStateEnum[] values;
        String text = null;
        for (InvoiceStateEnum invoiceStateEnum : values = InvoiceStateEnum.values()) {
            if (!invoiceStateEnum.getCode().equals("" + getInvoiceState)) continue;
            text = invoiceStateEnum.getUdcValue();
        }
        entity.setInvState(text);
    }

    public List<InvInvoiceVO> queryInvoiceNoByKey(String invocieNo) {
        return this.invInvoiceDAO.queryInvoiceNoByKey(invocieNo);
    }

    public InvInvoiceServiceImpl(InvInvoiceRepo invInvoiceRepo, InvInvoiceDAO invInvoiceDAO, InvInvoiceDetailDAO invInvoiceDetailDAO, InvInvoiceAttachedDAO invInvoiceAttachedDAO, InvInvoiceTravelItineraryDAO invInvoiceTravelItineraryDAO, CacheUtil cacheUtil, PrdOrgEmployeeService employeeService) {
        this.invInvoiceRepo = invInvoiceRepo;
        this.invInvoiceDAO = invInvoiceDAO;
        this.invInvoiceDetailDAO = invInvoiceDetailDAO;
        this.invInvoiceAttachedDAO = invInvoiceAttachedDAO;
        this.invInvoiceTravelItineraryDAO = invInvoiceTravelItineraryDAO;
        this.cacheUtil = cacheUtil;
        this.employeeService = employeeService;
    }
}

