/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.my.payload.PwdForgotPayload;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u4e2a\u4eba\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/my"})
public class PrdUserController {
    private static final Logger log = LoggerFactory.getLogger(PrdUserController.class);
    private final PrdUserService service;
    private final PrdOrgEmployeeEqvaRatioService eqvaRatioService;
    private static final String PC_TYPE = "v5_pc_";

    @GetMapping(value={"/user/queryMenus"})
    public TwOutputUtil queryMenus() {
        return TwOutputUtil.ok(this.service.queryMenus());
    }

    @PutMapping(value={"/user/queryDetail"})
    @UdcNameClass
    public TwOutputUtil queryDetail() {
        return TwOutputUtil.ok(this.service.queryUserDetail());
    }

    @PutMapping(value={"/user/eqvaRatio"})
    public TwOutputUtil queryeqvaRatio(Long userId, String date) {
        LocalDate date1 = null;
        try {
            date1 = LocalDate.parse(date);
        }
        catch (Exception e) {
            throw TwException.error("", "\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return TwOutputUtil.ok(this.eqvaRatioService.getEqvaRatio(userId, date1));
    }

    @ApiOperation(value="")
    @PostMapping(value={"/user/updatePassword"})
    public TwOutputUtil updatePassword(@RequestBody Map<String, Object> oldAndNewPassword) {
        String oldPassword = "" + oldAndNewPassword.get("oldPassword");
        String newPassword = "" + oldAndNewPassword.get("newPassword");
        this.service.updatePassword(oldPassword, newPassword);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/user/updateShortcut"})
    public TwOutputUtil updateShortcut(String shortcutIds) {
        this.service.updateShortcut(shortcutIds);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/user/findMyWork"})
    public TwOutputUtil findMyWork() {
        return TwOutputUtil.ok(this.service.findMyWork());
    }

    @GetMapping(value={"/user/findMyRemind"})
    public TwOutputUtil findMyRemind() {
        return TwOutputUtil.ok(this.service.findMyRemind());
    }

    @GetMapping(value={"/user/updateMyRemind"})
    public TwOutputUtil updateMyRemind(String remindType) {
        this.service.updateMyRemind(remindType);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/user/queryOrgList"})
    public TwOutputUtil queryOrgList() {
        return TwOutputUtil.ok(this.service.queryOrgList());
    }

    @GetMapping(value={"/user/queryLowList"})
    public TwOutputUtil queryLowList(Long orgId) {
        return TwOutputUtil.ok(this.service.queryLowListByKey(orgId));
    }

    @PostMapping(value={"/user/queryUserByTicket"})
    public void queryUserByTicket(HttpServletRequest request, HttpServletResponse response) {
        this.service.queryUserByTicket(request, response);
    }

    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801-\u53d1\u9001\u81f3\u90ae\u7bb1")
    @PostMapping(value={"/captcha/toEmail"})
    public TwOutputUtil captcha2Email(@RequestParam String email) {
        try {
            this.service.captcha2Email(email, PC_TYPE);
        }
        catch (Exception exception) {
            log.error("\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25\uff0c\u539f\u56e0 is {}", (Object)exception.getMessage());
            return TwOutputUtil.error("COM-ERROR", "\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25", null);
        }
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5fd8\u8bb0\u5bc6\u7801")
    @PostMapping(value={"/pwd/forgot"})
    public TwOutputUtil forgotPwd(@RequestBody PwdForgotPayload payload) {
        try {
            this.service.forgotPwd(payload, PC_TYPE);
        }
        catch (IllegalArgumentException illArgException) {
            log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff0c\u539f\u56e0 is {}", (Object)illArgException.getMessage());
            return TwOutputUtil.error("COM-ERROR", illArgException.getMessage(), null);
        }
        catch (BusinessException businessException) {
            log.error("\u90ae\u7bb1/\u9a8c\u8bc1\u7801/\u5bc6\u7801\u6821\u9a8c\u5931\u8d25\uff0c\u539f\u56e0 is {}", (Object)businessException.getMessage());
            return TwOutputUtil.error("COM-ERROR", businessException.getMessage(), null);
        }
        return TwOutputUtil.ok();
    }

    public PrdUserController(PrdUserService service, PrdOrgEmployeeEqvaRatioService eqvaRatioService) {
        this.service = service;
        this.eqvaRatioService = eqvaRatioService;
    }
}

