/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.office.controller;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiCodeEnums;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.file.payload.PrdFilePayload;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.file.config.FileProperties;
import com.elitesland.tw.tw5.server.prd.file.entity.PrdFileVersionDO;
import com.elitesland.tw.tw5.server.prd.file.service.PrdFileVersionService;
import com.elitesland.tw.tw5.server.prd.office.entities.Permission;
import com.elitesland.tw.tw5.server.prd.office.entities.User;
import com.elitesland.tw.tw5.server.prd.office.models.callback.ChangesHistory;
import com.elitesland.tw.tw5.server.prd.office.models.callback.Track;
import com.elitesland.tw.tw5.server.prd.office.models.enums.Action;
import com.elitesland.tw.tw5.server.prd.office.models.enums.Language;
import com.elitesland.tw.tw5.server.prd.office.models.enums.Mode;
import com.elitesland.tw.tw5.server.prd.office.models.enums.Type;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.Document;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.EditorConfig;
import com.elitesland.tw.tw5.server.prd.office.models.filemodel.FileModel;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.FileConfigurer;
import com.elitesland.tw.tw5.server.prd.office.service.configurers.wrappers.DefaultFileWrapper;
import com.elitesland.tw.tw5.server.prd.office.storage.FileStorageMutator;
import com.elitesland.tw.tw5.server.prd.office.storage.FileStoragePathBuilder;
import com.elitesland.tw.tw5.server.prd.office.util.file.FileUtility;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="office\u5728\u7ebf\u7f16\u8f91")
@Controller
@RequestMapping(value={"/api/office/"})
public class TwOfficeController {
    private static final Logger log = LoggerFactory.getLogger(TwOfficeController.class);
    @Value(value="${office.files.docservice.url.site:http://192.168.118.33:9006/}")
    private String docserviceSite;
    @Value(value="${office.files.docservice.url.api:web-apps/apps/api/documents/api.js}")
    private String docserviceApiUrl;
    @Value(value="${office.files.callback.url.site:https://tw5-demo.tw.elitesland.com/ju1}")
    private String callBackUrl;
    @Autowired
    private FileConfigurer<DefaultFileWrapper> fileConfigurer;
    private final FileService fileService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private PrdFileService prdFileService;
    @Autowired
    private PrdFileVersionService prdFileVersionService;
    @Autowired
    private FileProperties fileProperties;
    @Autowired
    private FileStorageMutator storageMutator;
    @Autowired
    private FileStoragePathBuilder fileStoragePathBuilder;
    private final ObjectMapper objectMapper;
    private final String historyPostfix = "-hist";
    @Autowired
    private SysUserRpcService sysUserService;

    @PostMapping(value={"/react/edit"})
    @ResponseBody
    public TwOutputUtil editDocFileReact(@RequestParam(value="fileId") Long fileId, @RequestParam(value="action", required=false) String actionParam, @RequestParam(value="actionLink", required=false) String actionLink, @RequestParam(value="userId", required=false) Long userId) {
        SysUserDTO sysUserDTO = GlobalUtil.getLoginUser();
        if (sysUserDTO == null) {
            log.error("\u7528\u6237\u672a\u767b\u5f55");
            throw TwException.error("", "\u7528\u6237\u672a\u767b\u5f55");
        }
        Action action = Action.edit;
        Type type = Type.desktop;
        Language language = Language.zh;
        if (actionParam != null) {
            action = Action.valueOf(actionParam);
        }
        PrdFileVO prdFileVO = this.prdFileService.queryByKey(fileId);
        String fileName = prdFileVO.getFileName();
        Long versionId = prdFileVO.getVersionId();
        String key = versionId != null ? "" + versionId : "" + prdFileVO.getId();
        User user = new User();
        user.setName(sysUserDTO.getUsername());
        Permission permission = new Permission();
        user.setPermissions(permission);
        user.setId(sysUserDTO.getId());
        DefaultFileWrapper wrapper = DefaultFileWrapper.builder().fileName(fileName).type(type).lang(language).action(action).user(user).actionData(actionLink).build();
        FileModel fileModel = this.fileConfigurer.getFileModel(wrapper);
        Document document = fileModel.getDocument();
        document.setTitle(fileName);
        String downUrl = this.callBackUrl + "/api/file/file/download/" + key;
        document.setUrl(downUrl);
        document.setUrlUser(downUrl);
        document.setFileType(this.fileUtility.getFileExtension(fileName).replace(".", ""));
        document.setKey(key);
        EditorConfig config = fileModel.getEditorConfig();
        config.setCallbackUrl(this.callBackUrl + "/api/office/callBackPro?fileId=" + key + "&oldFileId=" + fileId);
        config.setLang(wrapper.getLang());
        Boolean canEdit = wrapper.getCanEdit();
        Action action2 = wrapper.getAction();
        com.elitesland.tw.tw5.server.prd.office.models.filemodel.User fileModelUser = new com.elitesland.tw.tw5.server.prd.office.models.filemodel.User();
        fileModelUser.setId("" + user.getId());
        fileModelUser.setName(user.getName());
        config.setUser(fileModelUser);
        config.setMode(canEdit != false && !action2.equals((Object)Action.view) ? Mode.edit : Mode.view);
        Map history = this.getHistory(document, prdFileVO, key);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("config", fileModel);
        result.put("docserviceApiUrl", this.docserviceSite + this.docserviceApiUrl);
        result.put("fileHistoryArr", history);
        return TwOutputUtil.ok(result);
    }

    public Map getHistory(Document document, PrdFileVO prdFileVO, String documentKey) {
        HashMap result = new HashMap();
        String filePathPreStr = prdFileVO.getServerPath();
        Path histDirPath = Paths.get(this.fileStoragePathBuilder.getHistoryDir(filePathPreStr), new String[0]);
        String histDirStr = histDirPath.toAbsolutePath().toString();
        Integer curVer = this.fileStoragePathBuilder.getFileVersion(histDirStr, false);
        if (curVer > 0) {
            ArrayList hist = new ArrayList();
            HashMap histData = new HashMap();
            Integer i = 1;
            while (i <= curVer) {
                HashMap<String, Object> obj = new HashMap<String, Object>();
                HashMap<String, Object> dataObj = new HashMap<String, Object>();
                String verDir = this.versionDir(histDirStr, i, true);
                String key = i.equals(curVer) ? documentKey : TwOfficeController.readFileToEnd(new File(verDir + File.separator + "key.txt"));
                obj.put("key", key);
                obj.put("version", i);
                if (i == 1) {
                    obj.put("created", prdFileVO.getCreateTime());
                    HashMap<String, Object> user = new HashMap<String, Object>();
                    user.put("id", prdFileVO.getCreateUserId());
                    user.put("name", prdFileVO.getCreator());
                    obj.put("user", user);
                }
                dataObj.put("fileType", prdFileVO.getSuffix());
                dataObj.put("key", key);
                String serverPath = this.callBackUrl + "/api/office/";
                String filePathPrev = serverPath + "downloadhistory?fileId=" + prdFileVO.getId() + "&ver=" + i + "&file=prev." + prdFileVO.getSuffix();
                dataObj.put("url", i.equals(curVer) ? document.getUrl() : filePathPrev);
                dataObj.put("version", i);
                if (i > 1) {
                    JSONObject changes = JSONUtil.parseObj((String)TwOfficeController.readFileToEnd(new File(this.versionDir(histDirStr, i - 1, true) + File.separator + "changes.json")));
                    JSONObject change = (JSONObject)((JSONArray)changes.get((Object)"changes")).get(0);
                    obj.put("changes", changes.get((Object)"changes"));
                    obj.put("serverVersion", changes.get((Object)"serverVersion"));
                    obj.put("created", change.get((Object)"created"));
                    obj.put("user", change.get((Object)"user"));
                    Map prev = (Map)histData.get(Integer.toString(i - 2));
                    HashMap prevInfo = new HashMap();
                    prevInfo.put("fileType", prev.get("fileType"));
                    prevInfo.put("key", prev.get("key"));
                    prevInfo.put("url", prev.get("url"));
                    dataObj.put("previous", prevInfo);
                    Integer verdiff = i - 1;
                    String filePathDiff = serverPath + "downloadhistory?fileId=" + prdFileVO.getId() + "&ver=" + verdiff + "&file=diff.zip";
                    dataObj.put("changesUrl", filePathDiff);
                }
                hist.add(obj);
                histData.put(Integer.toString(i - 1), dataObj);
                Integer n = i;
                i = i + 1;
            }
            HashMap<String, Serializable> histObj = new HashMap<String, Serializable>();
            histObj.put("currentVersion", curVer);
            histObj.put("history", hist);
            result.put("hist", histObj);
            result.put("histData", histData);
            return result;
        }
        return result;
    }

    public static String readFileToEnd(File file) {
        Object output = "";
        try (FileInputStream is = new FileInputStream(file);){
            Scanner scanner = new Scanner(is);
            scanner.useDelimiter("\\A");
            while (scanner.hasNext()) {
                output = (String)output + scanner.next();
            }
            scanner.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    @GetMapping(value={"/downloadhistory"})
    public ResponseEntity<Resource> downloadHistory(HttpServletRequest request, @RequestParam(value="fileId") String fileId, @RequestParam(value="ver") String version, @RequestParam(value="file") String file) {
        try {
            PrdFileVO prdFileVO = this.prdFileService.queryByKey(Long.valueOf(fileId));
            String filePathPreStr = prdFileVO.getServerPath();
            return this.downloadFileHistory(filePathPreStr, version, file);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ResponseEntity<Resource> downloadFileHistory(String filePathPreStr, String version, String file) {
        Resource resource = this.loadFileAsResourceHistory(filePathPreStr, version, file);
        String contentType = "application/octet-stream";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + resource.getFilename() + "\""})).body((Object)resource);
    }

    public Resource loadFileAsResourceHistory(String filePathPreStr, String version, String file) {
        String fileLocation = filePathPreStr + "-hist" + File.separator + version + File.separator + file;
        try {
            Path filePath = Paths.get(fileLocation, new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            if (resource.exists()) {
                return resource;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @GetMapping(value={"/editPro"})
    public String editDocFilePro(@RequestParam(value="fileId") Long fileId, @RequestParam(value="action", required=false) String actionParam, @RequestParam(value="actionLink", required=false) String actionLink, Long userId, Model model) {
        SysUserDTO sysUserDTO = this.sysUserService.getById(userId);
        if (sysUserDTO == null) {
            log.error("\u7528\u6237\u672a\u767b\u5f55");
            return "index";
        }
        Action action = Action.edit;
        Type type = Type.desktop;
        Language language = Language.zh;
        if (actionParam != null) {
            action = Action.valueOf(actionParam);
        }
        PrdFileVO prdFileVO = this.prdFileService.queryByKey(fileId);
        String fileName = prdFileVO.getFileName();
        Long versionId = prdFileVO.getVersionId();
        User user = new User();
        user.setName(sysUserDTO.getUsername());
        Permission permission = new Permission();
        user.setPermissions(permission);
        user.setId(sysUserDTO.getId());
        String key = versionId != null ? "" + versionId : "" + prdFileVO.getId();
        DefaultFileWrapper wrapper = DefaultFileWrapper.builder().fileName(fileName).type(type).lang(language).action(action).user(user).actionData(actionLink).build();
        FileModel fileModel = this.fileConfigurer.getFileModel(wrapper);
        Document document = fileModel.getDocument();
        document.setTitle(fileName);
        String downUrl = this.callBackUrl + "/api/file/file/download/" + key;
        document.setUrl(downUrl);
        document.setUrlUser(downUrl);
        document.setFileType(this.fileUtility.getFileExtension(fileName).replace(".", ""));
        document.setKey(key);
        EditorConfig config = fileModel.getEditorConfig();
        config.setCallbackUrl(this.callBackUrl + "/api/office/callBackPro?fileId=" + key + "&oldFileId=" + fileId);
        config.setLang(wrapper.getLang());
        Boolean canEdit = wrapper.getCanEdit();
        Action action2 = wrapper.getAction();
        com.elitesland.tw.tw5.server.prd.office.models.filemodel.User fileModelUser = new com.elitesland.tw.tw5.server.prd.office.models.filemodel.User();
        BeanUtils.copyProperties((Object)user, (Object)fileModelUser);
        config.setUser(fileModelUser);
        config.setMode(canEdit != false && !action2.equals((Object)Action.view) ? Mode.edit : Mode.view);
        model.addAttribute("docserviceApiUrl", (Object)(this.docserviceSite + this.docserviceApiUrl));
        model.addAttribute("model", (Object)fileModel);
        model.addAttribute("apiUri", (Object)this.callBackUrl);
        return "editor";
    }

    @RequestMapping(value={"/callBackPro"})
    public void callBackPro(@RequestBody Track body, HttpServletRequest request, HttpServletResponse response, Long fileId, Long oldFileId) {
        PrintWriter writer = response.getWriter();
        log.info("[office info] callback status:{}", (Object)body.getStatus());
        if (body.getStatus() == 2) {
            log.info("[office info] callback status ==2 ;json:{}", (Object)body);
            PrdFileVO prdFileVO = this.prdFileService.queryByKey(fileId);
            PrdFileVO oldPrdFileVO = this.prdFileService.queryByKey(oldFileId);
            String realName = prdFileVO.getRealName();
            String fileName = prdFileVO.getFileName();
            String suffix = FileUtil.getExtensionName(realName);
            String downloadUri = body.getUrl();
            String changesUri = body.getChangesurl();
            String key = body.getKey();
            Path lastVersion = Paths.get(prdFileVO.getServerPath(), new String[0]);
            if (lastVersion.toFile().exists()) {
                Path histDir = Paths.get(this.fileStoragePathBuilder.getHistoryDir(oldPrdFileVO.getServerPath()), new String[0]);
                this.storageMutator.createDirectory(histDir);
                int fileVersion = this.fileStoragePathBuilder.getFileVersion(histDir.toAbsolutePath().toString(), false);
                String versionDir = this.versionDir(histDir.toAbsolutePath().toString(), fileVersion, true);
                log.info("[office info] versionDir:=========={}", (Object)versionDir);
                Path ver = Paths.get(versionDir, new String[0]);
                String filePath = this.prdFileService.getFilePath(prdFileVO.getFileTypeDesc());
                String changeFileName = FileUtil.generateFileNameAndCheckPath(fileName, filePath);
                String changeFilePathStr = filePath + changeFileName;
                log.info("[office info] ver======{}", (Object)ver);
                this.storageMutator.createDirectory(ver);
                this.storageMutator.copyFile(lastVersion, Paths.get(versionDir + File.separator + "prev." + suffix, new String[0]));
                this.downloadToFile(changesUri, Path.of(versionDir + File.separator + "diff.zip", new String[0]));
                Path changeFilePath = Paths.get(changeFilePathStr, new String[0]);
                log.info("[office info] changeFilePath:=========={}", (Object)changeFilePath);
                this.downloadToFile(downloadUri, changeFilePath);
                com.alibaba.fastjson.JSONObject jsonChanges = new com.alibaba.fastjson.JSONObject();
                List<ChangesHistory> changes = body.getHistory().getChanges();
                String changeUserName = "";
                String changeUserId = "0";
                if (!CollectionUtils.isEmpty(changes)) {
                    String createdTime = changes.get(0).getCreated();
                    log.info("[office info] createdTime:=========={}", (Object)createdTime);
                    changeUserId = changes.get(0).getUser().getId();
                    log.info("[office info] changeUserId:=========={}", (Object)changeUserId);
                    changeUserName = changes.get(0).getUser().getName();
                }
                jsonChanges.put("changes", changes);
                jsonChanges.put("serverVersion", (Object)body.getHistory().getServerVersion());
                String history = this.objectMapper.writeValueAsString((Object)jsonChanges);
                if (history == null && body.getHistory() != null) {
                    history = this.objectMapper.writeValueAsString((Object)body.getHistory());
                }
                if (history != null && !history.isEmpty()) {
                    this.storageMutator.writeToFile(versionDir + File.separator + "changes.json", history);
                }
                this.storageMutator.writeToFile(versionDir + File.separator + "key.txt", key);
                long length = changeFilePath.toFile().length();
                PrdFilePayload changeFile = PrdFilePayload.builder().name(prdFileVO.getName()).folderId(prdFileVO.getFolderId()).fileName(fileName).realName(changeFileName).serverPath(changeFilePathStr).fileType(prdFileVO.getFileType()).fileTypeDesc(prdFileVO.getFileTypeDesc()).fileSize(Long.valueOf(length)).fileSizeDesc(FileUtil.getSize(length)).versionFlag(Integer.valueOf(1)).build();
                PrdFileVO changeFileReturn = this.prdFileService.insert(changeFile);
                PrdFilePayload update = PrdFilePayload.builder().versionId(changeFileReturn.getId()).versionNo("" + fileVersion).build();
                update.setId(oldFileId);
                this.prdFileService.update(update);
                PrdFileVersionDO fileVersionDO = new PrdFileVersionDO();
                fileVersionDO.setFileId(prdFileVO.getId());
                fileVersionDO.setVersionNo("" + fileVersion);
                fileVersionDO.setFileId(oldFileId);
                fileVersionDO.setOldFileId(fileId);
                fileVersionDO.setNewFileId(changeFileReturn.getId());
                Long createUserId = Long.valueOf(changeUserId);
                fileVersionDO.setCreateUserId(createUserId);
                fileVersionDO.setCreator(changeUserName);
                fileVersionDO.setModifyUserId(createUserId);
                fileVersionDO.setUpdater(changeUserName);
                this.prdFileVersionService.insert(fileVersionDO);
            }
        }
        writer.write("{\"error\":0}");
    }

    @GetMapping(value={"/edit"})
    public String editDocFile(@RequestParam(value="fileCode") String fileCode, @RequestParam(value="action", required=false) String actionParam, @RequestParam(value="actionLink", required=false) String actionLink, Long userId, Model model) {
        SysUserDTO sysUserDTO = this.sysUserService.getById(userId);
        if (sysUserDTO == null) {
            log.error("\u7528\u6237\u672a\u767b\u5f55");
            return "index";
        }
        Action action = Action.edit;
        Type type = Type.desktop;
        Language language = Language.zh;
        if (actionParam != null) {
            action = Action.valueOf(actionParam);
        }
        String fileName = "\u6587\u4ef6\u4e0d\u5b58\u5728";
        ApiResult apiResult = this.fileService.get(fileCode);
        if (apiResult.getCode() == ApiCodeEnums.SUCCESS.getCode()) {
            FileObjRespVO data = (FileObjRespVO)apiResult.getData();
            fileName = data.getOriginalName();
        }
        User user = new User();
        user.setName(sysUserDTO.getUsername());
        Permission permission = new Permission();
        user.setPermissions(permission);
        user.setId(sysUserDTO.getId());
        DefaultFileWrapper wrapper = DefaultFileWrapper.builder().fileName(fileName).type(type).lang(language).action(action).user(user).actionData(actionLink).build();
        FileModel fileModel = this.fileConfigurer.getFileModel(wrapper);
        Document document = fileModel.getDocument();
        document.setTitle(fileName);
        String downUrl = this.callBackUrl + "/com/file/v1/" + fileCode + "/download";
        document.setUrl(downUrl);
        document.setUrlUser(downUrl);
        document.setFileType(this.fileUtility.getFileExtension(fileName).replace(".", ""));
        document.setKey(fileCode);
        EditorConfig config = fileModel.getEditorConfig();
        config.setCallbackUrl(this.callBackUrl + "/api/office/callBack?fileCode=" + fileCode);
        config.setLang(wrapper.getLang());
        Boolean canEdit = wrapper.getCanEdit();
        Action action2 = wrapper.getAction();
        com.elitesland.tw.tw5.server.prd.office.models.filemodel.User fileModelUser = new com.elitesland.tw.tw5.server.prd.office.models.filemodel.User();
        fileModelUser.setId("" + user.getId());
        fileModelUser.setName(user.getName());
        fileModelUser.setGroup("EL-GROUP");
        config.setUser(fileModelUser);
        config.setMode(canEdit != false && !action2.equals((Object)Action.view) ? Mode.edit : Mode.view);
        model.addAttribute("docserviceApiUrl", (Object)(this.docserviceSite + this.docserviceApiUrl));
        model.addAttribute("model", (Object)fileModel);
        model.addAttribute("apiUri", (Object)this.callBackUrl);
        return "editor";
    }

    @RequestMapping(value={"/callBack"})
    public void callBack(HttpServletRequest request, HttpServletResponse response, String fileCode) throws IOException {
        PrintWriter writer = response.getWriter();
        Scanner scanner = new Scanner((InputStream)request.getInputStream()).useDelimiter("\\A");
        String body = scanner.hasNext() ? scanner.next() : "";
        com.alibaba.fastjson.JSONObject jsonObj = com.alibaba.fastjson.JSONObject.parseObject((String)body);
        log.info("[office info] callback status:{}", (Object)jsonObj.get((Object)"status").toString());
        if ((Integer)jsonObj.get((Object)"status") == 2) {
            log.info("[office info] callback status ==2 ;json:{}", (Object)body);
            String downloadUri = (String)jsonObj.get((Object)"url");
            URL url = new URL(downloadUri);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            InputStream stream = connection.getInputStream();
            File savedFile = new File("/User/duwh/temp4");
            try (FileOutputStream out = new FileOutputStream(savedFile);){
                int read;
                byte[] bytes = new byte[1024];
                while ((read = stream.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                out.flush();
            }
            connection.disconnect();
        }
        writer.write("{\"error\":0}");
    }

    @GetMapping(value={"/index"})
    public String test(Model model) {
        System.out.println("index");
        return "index";
    }

    public String getServerUrl() {
        return this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getContextPath();
    }

    private void downloadToFile(String url, Path path) throws Exception {
        if (url == null || url.isEmpty()) {
            throw new RuntimeException("Url argument is not specified");
        }
        if (path == null) {
            throw new RuntimeException("Path argument is not specified");
        }
        URL uri = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        InputStream stream = connection.getInputStream();
        if (stream == null) {
            connection.disconnect();
            throw new RuntimeException("Input stream is null");
        }
        this.storageMutator.createOrUpdateFile(path, stream);
    }

    public String generateRevisionId(String expectedKey) {
        if (expectedKey.length() > 20) {
            expectedKey = Integer.toString(expectedKey.hashCode());
        }
        String key = expectedKey.replace("[^0-9-.a-zA-Z_=]", "_");
        return key.substring(0, Math.min(key.length(), 20));
    }

    public String versionDir(String path, Integer version, boolean historyPath) {
        if (!historyPath) {
            return this.fileStoragePathBuilder.getHistoryDir(this.fileStoragePathBuilder.getFileLocation(path)) + version;
        }
        return path + File.separator + version;
    }

    public TwOfficeController(FileService fileService, ObjectMapper objectMapper) {
        this.fileService = fileService;
        this.objectMapper = objectMapper;
    }
}

